/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.mutex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.mutex.DataMutex;

public class CtMutexforUpLk {
    private static final String BOS_MSERVICE_OPERATION = "bos-mservice-ctbotp";
    private Object lockMutex = new Object();
    public Set<String> requeireSuccessIds;
    public static final String MUTEX_GROUP_UPDATEBILLLK_DELSTATUS = "updatebilllkdelstatus";
    private static final String MUTEX_OP_KEY_UPDATEBILLLKDELSTATUS = "updatebilllkdelstatus";

    public void requireMutex(String entityKey, Set<String> billIds, boolean hasFailThrowEx) {
        ArrayList<Map<String, Object>> mutexRequireList = new ArrayList<Map<String, Object>>(billIds.size());
        for (String objId : billIds) {
            Map<String, Object> requireParam = this.createDataMutexParam(objId, entityKey);
            mutexRequireList.add(requireParam);
        }
        HashSet<String> failIds = new HashSet<String>();
        HashSet<String> successIds = new HashSet<String>();
        try (TXHandle h = TX.notSupported();){
            try (DataMutex dataMutex = DataMutex.create();){
                Map mutexResult = dataMutex.batchrequire(mutexRequireList);
                for (Map.Entry mutexItem : mutexResult.entrySet()) {
                    String objId = (String)mutexItem.getKey();
                    Boolean ret = (Boolean)mutexItem.getValue();
                    if (ret.booleanValue()) {
                        successIds.add(objId);
                        continue;
                    }
                    failIds.add(objId);
                }
                this.requeireSuccessIds = successIds;
                if (!failIds.isEmpty() && hasFailThrowEx) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519;err:%s", (String)"CtMutexforUpLk_1", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), ""));
                }
            }
            catch (IOException e) {
                ErrorCode ec = new ErrorCode("MUTEX_REQUIRE_ERROR_CTBOTP", String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519;err:%s", (String)"CtMutexforUpLk_1", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), e.getMessage()));
                throw new KDException((Throwable)e, ec, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doReleaseDataMutex(String entityKey, Set<String> billIds) {
        if (billIds.isEmpty()) {
            return true;
        }
        ArrayList<Map<String, Object>> mutexRequireList = new ArrayList<Map<String, Object>>(billIds.size());
        for (String billId : billIds) {
            Map<String, Object> requireParam = this.createDataMutexParam(billId, entityKey);
            mutexRequireList.add(requireParam);
        }
        try (DataMutex dataMutex = DataMutex.create();){
            dataMutex.batchRelease(mutexRequireList);
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseDataMutex(String entityKey, Set<String> billIds) {
        Object object = this.lockMutex;
        synchronized (object) {
            return this.doReleaseDataMutex(entityKey, billIds);
        }
    }

    private Map<String, Object> createDataMutexParam(String billId, String entityKey) {
        HashMap<String, Object> requireParam = new HashMap<String, Object>();
        requireParam.put("dataObjId", billId);
        requireParam.put("groupId", "updatebilllkdelstatus");
        requireParam.put("entityKey", entityKey);
        requireParam.put("operationKey", "updatebilllkdelstatus");
        requireParam.put("isStrict", true);
        requireParam.put("isOpenIntentLocks", false);
        return requireParam;
    }
}

