/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.openapi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.TreeEntryType;
import kd.bos.entity.ctbotp.CtBizAppTreeBuilder;
import kd.bos.entity.ctbotp.CtTrackDataEntity;
import kd.bos.entity.ctbotp.CtTrackEntityField;
import kd.bos.entity.ctbotp.dto.CtBotpEntityDto;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiGetMapping;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

@ApiController(value="bos", desc="\u79df\u6237\u6570\u636e\u83b7\u53d6")
@ApiMapping(value="/openapi/ctbotp")
public class CTBotpOpenApiUtils
implements Serializable {
    private static final String BOS_MSERVICE_CTBOTP = "bos-mservice-ctbotp";
    private static final long serialVersionUID = 255449131436879641L;
    private static Log log = LogFactory.getLog(CTBotpOpenApiUtils.class);

    @ApiGetMapping(value="/getEntityObject", desc="\u83b7\u53d6\u6240\u6709\u4e1a\u52a1\u5bf9\u8c61\u4fe1\u606f")
    public CustomApiResult<List<CtBotpEntityDto>> getEntityObject() {
        DynamicObject[] entityObjects;
        ArrayList<CtBotpEntityDto> list = new ArrayList<CtBotpEntityDto>(16);
        String selectPropStr = "id,number,name,bizappid,appid";
        HashSet<String> modelTypes = new HashSet<String>(2);
        modelTypes.add("BillFormModel");
        modelTypes.add("BaseFormModel");
        HashSet<QFilter> qFilters = new HashSet<QFilter>();
        qFilters.add(new QFilter("botp", "=", (Object)"1"));
        qFilters.add(new QFilter("modeltype", "in", modelTypes));
        qFilters.add(new QFilter("dentityid", "is not null", null));
        for (DynamicObject dynamicObject : entityObjects = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)selectPropStr, (QFilter[])qFilters.toArray(new QFilter[0]))) {
            CtBotpEntityDto dto = new CtBotpEntityDto();
            if (dynamicObject == null) continue;
            dto.setId(dynamicObject.getString("id"));
            dto.setNumber(dynamicObject.getString("number"));
            dto.setName(((OrmLocaleValue)dynamicObject.get("name")).getLocaleValue());
            DynamicObject object = (DynamicObject)dynamicObject.get("bizappid");
            if (object != null) {
                dto.setBizAppId(String.valueOf(object.getPkValue()));
                dto.setBizAppIdName(object.getString("name"));
                dto.setBizcloudNumber(object.getString("bizcloud.number"));
                dto.setBizcloudName(object.getString("bizcloud.name"));
            }
            list.add(dto);
        }
        if (list.size() > 0) {
            return CustomApiResult.success(list);
        }
        return CustomApiResult.fail((String)"10000", (String)ResManager.loadKDString((String)"\u83b7\u53d6\u8de8\u79df\u6237BOTP\u4e1a\u52a1\u5bf9\u8c61\u5931\u8d25\u3002", (String)"CTBotpOpenApiUtils_0", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]));
    }

    @ApiGetMapping(value="/getTreeNode", desc="\u83b7\u53d6\u6240\u6709\u4e91\u5e94\u7528")
    public CustomApiResult<CtBizAppTreeBuilder> getTreeNode(@NotNull @ApiParam(value="\u79df\u6237", required=true) @NotNull @ApiParam(value="\u79df\u6237", required=true) String tenant, @NotNull @ApiParam(value="\u5f53\u524d\u8d26\u5957", required=true) @NotNull @ApiParam(value="\u5f53\u524d\u8d26\u5957", required=true) String accountId) {
        CtBizAppTreeBuilder rootNode = this.buildTreeNodes(tenant);
        if (rootNode != null) {
            return CustomApiResult.success((Object)rootNode);
        }
        return CustomApiResult.fail((String)"10000", (String)ResManager.loadKDString((String)"\u83b7\u53d6\u6240\u6709\u4e91\u5e94\u7528\u5931\u8d25\u3002", (String)"CTBotpOpenApiUtils_1", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]));
    }

    @ApiPostMapping(value="/getBillData", desc="\u83b7\u53d6\u8868\u5355\u6570\u636e")
    public CustomApiResult<String> getBillData(@ApiParam(value="\u8868\u5355\u6807\u8bc6") @ApiParam(value="\u8868\u5355\u6807\u8bc6") String entityNumber, @ApiParam(value="\u5355\u636eid") @ApiParam(value="\u5355\u636eid") Long id) {
        DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)id, (String)entityNumber);
        if (data == null) {
            return CustomApiResult.fail((String)"10001", (String)ResManager.loadKDString((String)"\u83b7\u53d6\u8868\u5355\u6570\u636e\u5931\u8d25\u3002", (String)"CTBotpOpenApiUtils_2", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]));
        }
        BillEntityType datatype = (BillEntityType)data.getDynamicObjectType();
        CtTrackDataEntity ctTrackDataEntity = this.buildCtTrackDataEntity(data, (EntityType)datatype);
        Map allEntities = datatype.getAllEntities();
        HashMap ctTrackDataEntrys = new HashMap(allEntities.size());
        for (Map.Entry entity : allEntities.entrySet()) {
            EntityType entityType = (EntityType)entity.getValue();
            if (this.isNotEntryType(entityType)) continue;
            String entryKey = (String)entity.getKey();
            LinkedList<CtTrackDataEntity> ctTrackDataEntryList = new LinkedList<CtTrackDataEntity>();
            DynamicObjectCollection entryDyns = (DynamicObjectCollection)data.get(entryKey);
            for (DynamicObject entryDyn : entryDyns) {
                CtTrackDataEntity ctTrackDataEntry = this.buildCtTrackDataEntity(entryDyn, entityType);
                ctTrackDataEntryList.add(ctTrackDataEntry);
            }
            ctTrackDataEntrys.put(entryKey, ctTrackDataEntryList);
        }
        ctTrackDataEntity.setEntityEntrys(ctTrackDataEntrys);
        return CustomApiResult.success((Object)SerializationUtils.toJsonString((Object)ctTrackDataEntity));
    }

    private CtTrackDataEntity buildCtTrackDataEntity(DynamicObject data, EntityType datatype) {
        CtTrackDataEntity ctTrackDataEntity = new CtTrackDataEntity();
        ctTrackDataEntity.setEntityKey(datatype.getName());
        ctTrackDataEntity.setEntityName(datatype.getDisplayName() == null ? "" : datatype.getDisplayName().getLocaleValue());
        LinkedList<CtTrackEntityField> ctTrackEntityFieldList = new LinkedList<CtTrackEntityField>();
        for (Map.Entry field : datatype.getFields().entrySet()) {
            String fieldKey = (String)field.getKey();
            IDataEntityProperty prop = (IDataEntityProperty)field.getValue();
            CtTrackEntityField ctTrackEntityField = new CtTrackEntityField();
            ctTrackEntityField.setFieldKey(fieldKey);
            ctTrackEntityField.setName(prop.getDisplayName().getLocaleValue());
            String value = this.getFieldValue(data, prop, fieldKey);
            ctTrackEntityField.setValue(value);
            ctTrackEntityFieldList.add(ctTrackEntityField);
        }
        ctTrackDataEntity.setFieldList(ctTrackEntityFieldList);
        return ctTrackDataEntity;
    }

    private String getFieldValue(DynamicObject data, IDataEntityProperty property, String fieldKey) {
        String value = "";
        if (property instanceof EntryProp || property instanceof PictureProp || property instanceof AttachmentProp) {
            return value;
        }
        if (property instanceof BasedataProp) {
            DynamicObject basedata = (DynamicObject)data.get(fieldKey);
            value = this.getBaseDataName(basedata);
        } else if (property instanceof MulBasedataProp) {
            MulBasedataDynamicObjectCollection MBDCollection = (MulBasedataDynamicObjectCollection)data.get(fieldKey);
            StringBuilder str = new StringBuilder();
            for (DynamicObject dyn : MBDCollection) {
                DynamicObject basedata = (DynamicObject)dyn.get("fbasedataid");
                str.append(this.getBaseDataName(basedata)).append(";");
            }
            value = str.toString();
        } else {
            String localeValue;
            value = property instanceof MuliLangTextProp ? ((localeValue = ((OrmLocaleValue)data.get(fieldKey)).getLocaleValue()) == null ? "" : localeValue) : data.getString(fieldKey);
        }
        return value;
    }

    private String getBaseDataName(DynamicObject basedata) {
        ILocaleString localeName = null;
        if (basedata == null) {
            return "";
        }
        try {
            localeName = basedata.getLocaleString("name");
        }
        catch (Exception error) {
            log.error((Throwable)error);
        }
        return localeName != null ? localeName.getLocaleValue() : basedata.getString("id");
    }

    private boolean isNotEntryType(EntityType entityType) {
        return entityType instanceof BillEntityType || entityType instanceof SubEntryType || entityType instanceof LinkEntryType || entityType instanceof TreeEntryType;
    }

    private CtBizAppTreeBuilder buildTreeNodes(String tenant) {
        String data = tenant;
        CtBizAppTreeBuilder bizAppTreeBuilder = new CtBizAppTreeBuilder();
        bizAppTreeBuilder.setRuntime(true);
        TreeNode root = bizAppTreeBuilder.buildTree();
        root.setId("rootNode");
        String text = ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91", (String)"CTBotpOpenApiUtils_3", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]);
        text = text + "(" + data + ")";
        root.setText(text);
        root.setParentid("");
        root.setIsOpened(true);
        bizAppTreeBuilder.setRootNode(root);
        return bizAppTreeBuilder;
    }
}

