/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.save.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ctbotp.constants.SyncTypeEnum;
import kd.bos.entity.ctbotp.plugin.save.args.AfterTargetBillOperationEventArgs;
import kd.bos.entity.ctbotp.runtime.CtReportManager;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.util.DynamicObjectUtil;
import kd.bos.service.ctbotp.helper.CtAttachmentConvertHelper;
import kd.bos.service.ctbotp.save.CtSaveContext;
import kd.bos.service.ctbotp.save.CtSaveResultManager;
import kd.bos.service.ctbotp.save.actions.AbstractCtSaveAction;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class CtSaveAction
extends AbstractCtSaveAction {
    private static final Log log = LogFactory.getLog(CtSaveAction.class);
    private static final String BOS_MSERVICE_OPERATION = "bos-mservice-ctbotp";
    private static final String OP_TYPE_SAVE = "save";
    private static final String OP_TYPE_SUBMIT = "submit";
    private static final String OP_TYPE_AUDIT = "audit";
    String targetBill;
    BillEntityType targetMainType;
    Operations targetOperations;
    Map<String, Object> submitOp;
    Map<String, Object> auditOp;

    public CtSaveAction(CtSaveContext context, CtSaveResultManager ctSaveResultManager) {
        super(context, ctSaveResultManager);
    }

    @Override
    protected void doAction() {
        super.doAction();
        this.targetBill = this.context.getCtSaveArgs().gettEntityKey();
        this.doSaveOperate(this.resultManager.getTargetDataObjects(), this.resultManager);
        this.merageResult(this.resultManager.getTargetDataObjects());
    }

    private void merageResult(List<DynamicObject> dynamicObjects) {
        CtReportManager targetReporter = this.resultManager.getTargetReporter();
        CtReportManager ctReportManager = this.resultManager.getReporter();
        if (SyncTypeEnum.REVERSE.getValue().equals(this.context.getCtSaveArgs().getSyncType())) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                Long id = (Long)dynamicObject.getPkValue();
                targetReporter.getSuccessIds().add(id);
            }
        }
        if (targetReporter != null && MapUtils.isNotEmpty((Map)targetReporter.getFailIds())) {
            for (Map.Entry entry : targetReporter.getFailIds().entrySet()) {
                Set<Long> sIds = this.context.getBillIdMaps().get(entry.getKey());
                for (Long id : sIds) {
                    String errorMsg = (String)entry.getValue();
                    ctReportManager.getFailIds().put(id, errorMsg);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)targetReporter.getSuccessIds())) {
                ctReportManager.addSuccessIds((Collection)targetReporter.getSuccessIds());
            }
        } else if (targetReporter != null && CollectionUtils.isNotEmpty((Collection)targetReporter.getSuccessIds())) {
            ctReportManager.addSuccessIds((Collection)targetReporter.getSuccessIds());
        }
    }

    private void doSaveOperate(List<DynamicObject> dynamicObjects, CtSaveResultManager ctSaveResultManager) {
        if (CollectionUtils.isEmpty(dynamicObjects)) {
            return;
        }
        if (SyncTypeEnum.REVERSE.getValue().equals(this.context.getCtSaveArgs().getSyncType())) {
            SaveServiceHelper.update((DynamicObject[])dynamicObjects.toArray(new DynamicObject[dynamicObjects.size()]));
        } else {
            String strTure = String.valueOf(true);
            OperateOption saveOption = OperateOption.create();
            saveOption.setVariableValue("ignorewarn", strTure);
            saveOption.setVariableValue("ignoreinteraction", strTure);
            saveOption.setVariableValue("botptag_of_datasource", String.valueOf(true));
            if (this.context.getCtSaveArgs().isBatchPush()) {
                saveOption.setVariableValue("bos_save_appendentryrows", strTure);
            }
            saveOption.setVariableValue("ishasright", String.valueOf(!this.context.getRule().getCtOptionPolicy().isChecknewright()));
            if (CollectionUtils.isNotEmpty(ctSaveResultManager.getCtBillLks())) {
                String ctBillLkStr = SerializationUtils.toJsonString(ctSaveResultManager.getCtBillLks());
                saveOption.setVariableValue("opt_ctbotp_billlks", ctBillLkStr);
            }
            saveOption.setVariableValue("opt_ctbotp_isctbotp", "true");
            if (CollectionUtils.isNotEmpty(ctSaveResultManager.getTcLks())) {
                String ctBillLkTcStr = SerializationUtils.toJsonString(ctSaveResultManager.getTcLks());
                saveOption.setVariableValue("opt_ctbotp_billlks_tc", ctBillLkTcStr);
            }
            saveOption.setVariableValue("showscene", "");
            DynamicObject[] saveDynObjs = dynamicObjects.toArray(new DynamicObject[dynamicObjects.size()]);
            OperationResult saveResult = SaveServiceHelper.saveOperate((String)this.context.getTargetMainType().getName(), (DynamicObject[])saveDynObjs, (OperateOption)saveOption);
            log.info("SaveServiceHelper.saveOperate saveDynObjs is " + DynamicObjectUtil.serializeToListMap((DynamicObject[])saveDynObjs));
            List<Object> successPkIds = new ArrayList(0);
            if (saveResult != null && saveResult.getSuccessPkIds() != null && !saveResult.getSuccessPkIds().isEmpty()) {
                successPkIds = saveResult.getSuccessPkIds();
            }
            this.resultManager.getTargetReporter().addSuccessIds((Collection)successPkIds.stream().map(a -> Long.parseLong(a.toString())).collect(Collectors.toList()));
            if (successPkIds.size() > 0 && dynamicObjects.size() == successPkIds.size()) {
                this.resultManager.getTargetReporter().setSuccess(true);
            }
            HashSet<Object> billIdLists = new HashSet<Object>(16);
            for (DynamicObject dynamicObject : dynamicObjects) {
                billIdLists.add(dynamicObject.getPkValue());
            }
            CtAttachmentConvertHelper.batchSaveAttachmentPanelData(this.context, successPkIds);
            this.outFailMessage(billIdLists, saveResult, OP_TYPE_SAVE);
            String targetBillOp = this.context.getCtSaveArgs().getTargetBillOp();
            if (StringUtils.isBlank((CharSequence)targetBillOp) || saveResult == null || saveResult.getSuccessPkIds() == null || saveResult.getSuccessPkIds().isEmpty()) {
                return;
            }
            if (this.isSubmit(targetBillOp)) {
                OperationResult auditResult;
                OperationResult submitResult = this.doSubmit(billIdLists, saveResult);
                if (submitResult == null || submitResult.getSuccessPkIds() == null || submitResult.getSuccessPkIds().isEmpty()) {
                    log.info("\u4e0b\u63a8\u6210\u529f\u4f46\u63d0\u4ea4\u5931\u8d25\u3002");
                } else if (this.isAudit(targetBillOp) && ((auditResult = this.doAudit(billIdLists, submitResult)) == null || auditResult.getSuccessPkIds() == null || auditResult.getSuccessPkIds().isEmpty())) {
                    log.info("\u4e0b\u63a8\u6210\u529f\u4f46\u5ba1\u6838\u5931\u8d25\u3002");
                }
            }
        }
        AfterTargetBillOperationEventArgs afterTargetBillOperationEventArgs = this.buildAfterTargetBillOperationEventArgs();
        this.context.getPlugInProxy().fireAfterTargetBillOperation(afterTargetBillOperationEventArgs);
    }

    private void outFailMessage(Set<Object> pkIds, OperationResult saveResult, String targetBillOp) {
        ArrayList<IOperateInfo> opFailInfos = new ArrayList<IOperateInfo>(0);
        HashMap<Object, List<IOperateInfo>> billErrors = new HashMap<Object, List<IOperateInfo>>(0);
        this.splitErrorInfoByBill(pkIds, saveResult, opFailInfos, billErrors, targetBillOp);
        StringBuilder failMessage = new StringBuilder();
        for (IOperateInfo info : opFailInfos) {
            failMessage.append(info.getMessage()).append("  \r\n");
        }
        String errMsgHead = "";
        if (OP_TYPE_SAVE.equals(targetBillOp)) {
            errMsgHead = ResManager.loadKDString((String)"\u4e0b\u63a8\u6210\u529f\u4f46\u4fdd\u5b58\u5931\u8d25\uff1a\r\n", (String)"CtSaveAction_1", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]);
        } else if (OP_TYPE_SUBMIT.equals(targetBillOp)) {
            errMsgHead = ResManager.loadKDString((String)"\u4e0b\u63a8\u6210\u529f\u4f46\u63d0\u4ea4\u5931\u8d25\uff1a\r\n", (String)"CtSaveAction_2", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]);
        } else if (OP_TYPE_AUDIT.equals(targetBillOp)) {
            errMsgHead = ResManager.loadKDString((String)"\u4e0b\u63a8\u6210\u529f\u4f46\u5ba1\u6838\u5931\u8d25\uff1a\r\n", (String)"CtSaveAction_3", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]);
        }
        for (Object pkid : pkIds) {
            Long id = Long.parseLong(pkid.toString());
            if (!this.isFailById(id, targetBillOp)) continue;
            if (!billErrors.containsKey(id)) {
                this.resultManager.getTargetReporter().addFailId(id, failMessage.toString());
                continue;
            }
            StringBuilder errBuilder = new StringBuilder();
            errBuilder.append(errMsgHead);
            int i = 0;
            for (IOperateInfo info : (List)billErrors.get(id)) {
                if (i >= 3) {
                    errBuilder.append(info.getMessage()).append("  ...");
                    break;
                }
                errBuilder.append(info.getMessage()).append("  \r\n");
                ++i;
            }
            this.resultManager.getTargetReporter().addFailId(id, errBuilder.toString());
        }
    }

    private void splitErrorInfoByBill(Set<Object> pkIds, OperationResult saveResult, List<IOperateInfo> opFailInfos, Map<Object, List<IOperateInfo>> billErrors, String targetBillOp) {
        OperateErrorInfo errInfo;
        if (saveResult.getSuccessPkIds() != null && saveResult.getSuccessPkIds().isEmpty() && StringUtils.isNotBlank((CharSequence)saveResult.getMessage())) {
            errInfo = new OperateErrorInfo("", ErrorLevel.Error, null);
            errInfo.setMessage(saveResult.getMessage());
            opFailInfos.add((IOperateInfo)errInfo);
        }
        for (IOperateInfo info : saveResult.getAllErrorOrValidateInfo()) {
            Object pkValue = info.getPkValue();
            if (!pkIds.contains(pkValue)) {
                opFailInfos.add(info);
                continue;
            }
            if (!billErrors.containsKey(pkValue)) {
                billErrors.put(pkValue, new ArrayList());
            }
            billErrors.get(pkValue).add(info);
        }
        if (opFailInfos.isEmpty()) {
            errInfo = new OperateErrorInfo("", ErrorLevel.Error, null);
            if (OP_TYPE_SAVE.equals(targetBillOp)) {
                errInfo.setMessage(ResManager.loadKDString((String)"\u672a\u77e5\u539f\u56e0\u5bfc\u81f4\u7684\u4fdd\u5b58\u5931\u8d25\u3002", (String)"CtSaveAction_4", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
            } else if (OP_TYPE_SUBMIT.equals(targetBillOp)) {
                errInfo.setMessage(ResManager.loadKDString((String)"\u672a\u77e5\u539f\u56e0\u5bfc\u81f4\u7684\u63d0\u4ea4\u5931\u8d25\u3002", (String)"CtSaveAction_5", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
            } else if (OP_TYPE_AUDIT.equals(targetBillOp)) {
                errInfo.setMessage(ResManager.loadKDString((String)"\u672a\u77e5\u539f\u56e0\u5bfc\u81f4\u7684\u5ba1\u6838\u5931\u8d25\u3002", (String)"CtSaveAction_6", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
            }
            opFailInfos.add((IOperateInfo)errInfo);
        }
    }

    private boolean isFailById(Long id, String targetBillOp) {
        Set successIds = this.resultManager.getTargetReporter().getSuccessIds();
        Set submitSuccessIds = this.resultManager.getTargetReporter().getSubmitSuccessIds();
        Set auditSuccessIds = this.resultManager.getTargetReporter().getAuditSuccessIds();
        if (OP_TYPE_SAVE.equals(targetBillOp)) {
            return !successIds.contains(id);
        }
        if (OP_TYPE_SUBMIT.equals(targetBillOp)) {
            return successIds.contains(id) && !submitSuccessIds.contains(id);
        }
        if (OP_TYPE_AUDIT.equals(targetBillOp)) {
            return submitSuccessIds.contains(id) && !auditSuccessIds.contains(id);
        }
        return true;
    }

    private boolean isSubmit(String afterOperation) {
        return StringUtils.equalsIgnoreCase((CharSequence)afterOperation, (CharSequence)OP_TYPE_SUBMIT) || StringUtils.equalsIgnoreCase((CharSequence)afterOperation, (CharSequence)OP_TYPE_AUDIT);
    }

    private boolean isAudit(String afterOperation) {
        return StringUtils.equalsIgnoreCase((CharSequence)afterOperation, (CharSequence)OP_TYPE_AUDIT);
    }

    private Map<String, Object> getSubmitOpMeta() {
        if (this.submitOp != null) {
            return this.submitOp;
        }
        Operations ops = this.getTargetOperations();
        String opKey = OP_TYPE_SUBMIT;
        if (StringUtils.isNotBlank((CharSequence)ops.getSubmit())) {
            opKey = ops.getSubmit();
        }
        this.submitOp = this.getTargetOpMeta(opKey);
        return this.submitOp;
    }

    private Map<String, Object> getAuditOpMeta() {
        if (this.auditOp != null) {
            return this.auditOp;
        }
        Operations ops = this.getTargetOperations();
        String opKey = OP_TYPE_AUDIT;
        if (StringUtils.isNotBlank((CharSequence)ops.getAudit())) {
            opKey = ops.getAudit();
        }
        this.auditOp = this.getTargetOpMeta(opKey);
        return this.auditOp;
    }

    public Operations getTargetOperations() {
        if (this.targetOperations == null) {
            this.targetOperations = EntityMetadataCache.getDataEntityOperations((String)this.targetBill);
        }
        return this.targetOperations;
    }

    private Map<String, Object> getTargetOpMeta(String opKey) {
        return EntityMetadataCache.getDataEntityOperate((String)this.targetBill, (String)opKey);
    }

    private OperationResult doOperation(String operationKey, String entityNumber, Object[] pkValues, OperateOption option) {
        log.info("OperateOption:{}", (Object)SerializationUtils.toJsonString((Object)option));
        return OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])pkValues, (OperateOption)option);
    }

    private OperationResult doSubmit(Set<Object> billIdLists, OperationResult saveResult) {
        Map<String, Object> curSubmitOp = this.getSubmitOpMeta();
        if (curSubmitOp == null) {
            this.resultManager.getTargetReporter().setErrorMsg(ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u4fdd\u5b58\u6210\u529f\uff0c\u672a\u7ed1\u5b9a\u63d0\u4ea4\u64cd\u4f5c\uff0c\u672a\u63d0\u4ea4", (String)"CtPushAndSaveExecuter_2", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
            return null;
        }
        String submitOpKey = (String)curSubmitOp.get("key");
        Object[] targetBillIds = saveResult.getSuccessPkIds().toArray();
        String strTure = String.valueOf(true);
        OperateOption submitOption = OperateOption.create();
        submitOption.setVariableValue("ignorewarn", strTure);
        submitOption.setVariableValue("botptag_of_datasource", String.valueOf(true));
        submitOption.setVariableValue("ignoreinteraction", strTure);
        submitOption.setVariableValue("opt_ctbotp_isctbotp", "true");
        submitOption.setVariableValue("ishasright", String.valueOf(!this.context.getRule().getCtOptionPolicy().isChecksubmitright()));
        OperationResult submitResult = this.doOperation(submitOpKey, this.targetBill, targetBillIds, submitOption);
        List submitSuccessPkIds = new ArrayList(0);
        if (submitResult != null && submitResult.getSuccessPkIds() != null && !submitResult.getSuccessPkIds().isEmpty()) {
            submitSuccessPkIds = submitResult.getSuccessPkIds();
        }
        this.resultManager.getTargetReporter().addSubmitSuccessIds((Collection)submitSuccessPkIds.stream().map(a -> Long.parseLong(a.toString())).collect(Collectors.toList()));
        this.outFailMessage(billIdLists, submitResult, OP_TYPE_SUBMIT);
        return submitResult;
    }

    private OperationResult doAudit(Set<Object> billIdLists, OperationResult submitResult) {
        Map<String, Object> curAuditOp = this.getAuditOpMeta();
        if (curAuditOp == null) {
            this.resultManager.getTargetReporter().setErrorMsg(ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u63d0\u4ea4\u6210\u529f\uff0c\u672a\u7ed1\u5b9a\u5ba1\u6838\u64cd\u4f5c\uff0c\u672a\u5ba1\u6838", (String)"CtPushAndSaveExecuter_4", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
            return null;
        }
        String auditOpKey = (String)curAuditOp.get("key");
        String strTure = String.valueOf(true);
        OperateOption auditOption = OperateOption.create();
        auditOption.setVariableValue("ignorewarn", strTure);
        auditOption.setVariableValue("WF", String.valueOf(false));
        auditOption.setVariableValue("ignoreinteraction", strTure);
        auditOption.setVariableValue("botptag_of_datasource", String.valueOf(true));
        auditOption.setVariableValue("opt_ctbotp_isctbotp", "true");
        auditOption.setVariableValue("ishasright", String.valueOf(!this.context.getRule().getCtOptionPolicy().isCheckauditright()));
        OperationResult auditResult = this.doOperation(auditOpKey, this.targetBill, submitResult.getSuccessPkIds().toArray(), auditOption);
        List auditSuccessPkIds = new ArrayList(0);
        if (auditResult != null && auditResult.getSuccessPkIds() != null && !auditResult.getSuccessPkIds().isEmpty()) {
            auditSuccessPkIds = auditResult.getSuccessPkIds();
        }
        this.resultManager.getTargetReporter().addAuditSuccessIds((Collection)auditSuccessPkIds.stream().map(a -> Long.parseLong(a.toString())).collect(Collectors.toList()));
        this.outFailMessage(billIdLists, auditResult, OP_TYPE_AUDIT);
        return auditResult;
    }

    private AfterTargetBillOperationEventArgs buildAfterTargetBillOperationEventArgs() {
        AfterTargetBillOperationEventArgs args = new AfterTargetBillOperationEventArgs();
        args.setSaveSuccessIds(this.resultManager.getTargetReporter().getSuccessIds());
        args.setSubmitSuccessIds(this.resultManager.getTargetReporter().getSubmitSuccessIds());
        args.setAuditSuccessIds(this.resultManager.getTargetReporter().getAuditSuccessIds());
        args.setFailIds(this.resultManager.getTargetReporter().getFailIds());
        args.setCtBillLks(this.resultManager.getCtBillLks());
        return args;
    }
}

