/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.save.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.ctbotp.link.CtBillLinkService;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ctbotp.constants.SyncStatusEnum;
import kd.bos.entity.ctbotp.link.CtBillLk;
import kd.bos.entity.ctbotp.link.CtLkDownQueryArgs;
import kd.bos.entity.ctbotp.sync.SyncLog;
import kd.bos.entity.ctbotp.sync.SyncQueryArgs;
import kd.bos.service.ctbotp.save.CtSaveContext;
import kd.bos.service.ctbotp.save.CtSaveResultManager;
import kd.bos.service.ctbotp.save.actions.AbstractCtSaveAction;
import kd.bos.servicehelper.CtSyncLogServiceHelper;

public class CtSaveAgainCheckAction
extends AbstractCtSaveAction {
    private void initVar() {
    }

    public CtSaveAgainCheckAction(CtSaveContext context, CtSaveResultManager ctSaveResultManager) {
        super(context, ctSaveResultManager);
    }

    @Override
    protected void doAction() {
        super.doAction();
        List<Long> srcBillIds = this.context.getDataMutexBillids();
        Set<Long> noPushBillIds = this.findNoPushBills(srcBillIds);
        this.context.setNoPushSrcIds(noPushBillIds.stream().collect(Collectors.toList()));
        if (noPushBillIds.isEmpty()) {
            this.context.setSkipNextAction(true);
        }
    }

    private Set<Long> findNoPushBills(List<Long> srcBillIds) {
        CtLkDownQueryArgs ctLkDownQueryArgs = new CtLkDownQueryArgs();
        ctLkDownQueryArgs.setsTenantCode(this.context.getCtSaveArgs().getsTenantCode());
        ctLkDownQueryArgs.setsAccountId(this.context.getCtSaveArgs().getsAccountId());
        ctLkDownQueryArgs.setsEntityKey(this.context.getCtSaveArgs().getsEntityKey());
        ctLkDownQueryArgs.setsBillIds(new ArrayList<Long>(srcBillIds));
        List ctBillLks = CtBillLinkService.getCtDirtBillLkDown((CtLkDownQueryArgs)ctLkDownQueryArgs);
        ArrayList<Long> hasBillLkSids = new ArrayList<Long>(16);
        for (CtBillLk ctBillLk : ctBillLks) {
            hasBillLkSids.add(ctBillLk.getSBillId());
        }
        SyncQueryArgs syncQueryArgs = SyncQueryArgs.create().addSTenantCode(this.context.getCtSaveArgs().getsTenantCode()).addSAccountId(this.context.getCtSaveArgs().getsAccountId());
        syncQueryArgs.addSEntityKey(this.context.getCtSaveArgs().getsEntityKey()).addSBillIds(srcBillIds);
        syncQueryArgs.addTTenantCode(this.context.getCtSaveArgs().gettTenantCode()).addTAccountId(this.context.getCtSaveArgs().gettAccountId()).addTEntityKey(this.context.getCtSaveArgs().gettEntityKey());
        syncQueryArgs.setSyncType(this.context.getCtSaveArgs().getSyncType());
        Map sSyncLogMaps = CtSyncLogServiceHelper.getTSyncLogMaps((SyncQueryArgs)syncQueryArgs);
        String failMessage = String.format(ResManager.loadKDString((String)"\u5df2\u6709\u4e0b\u6e38\u3010%s\u3011\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u4e0b\u63a8", (String)"PushAgainCheckAction_0", (String)"bos-mservice-botp", (Object[])new Object[0]), this.context.getCtSaveArgs().gettEntityKey());
        String pushIngMsg = ResManager.loadKDString((String)"\u6b63\u5728\u4e0b\u63a8\u4e2d\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"CtSaveAgainCheckAction_0", (String)"bos-mservice-ctbotp", (Object[])new Object[0]);
        HashSet<Long> noPushBillIds = new HashSet<Long>(srcBillIds.size());
        for (Long srcBillId : srcBillIds) {
            SyncLog sSyncLog = (SyncLog)sSyncLogMaps.get(srcBillId);
            if (sSyncLog != null) {
                if (sSyncLog.getStatus().equals(SyncStatusEnum.A.getStatus())) {
                    this.getResultManager().getReporter().addFailId(srcBillId, pushIngMsg);
                    continue;
                }
                if (hasBillLkSids.contains(srcBillId)) {
                    this.getResultManager().getReporter().addFailId(srcBillId, failMessage);
                    continue;
                }
                noPushBillIds.add(srcBillId);
                continue;
            }
            noPushBillIds.add(srcBillId);
        }
        return noPushBillIds;
    }
}

