/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.save.actions;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.entity.ctbotp.constants.SyncTypeEnum;
import kd.bos.entity.ctbotp.link.CtBillLk;
import kd.bos.entity.ctbotp.link.CtBillSyncRoute;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.save.CtSaveContext;
import kd.bos.service.ctbotp.save.CtSaveResultManager;
import kd.bos.service.ctbotp.save.actions.AbstractCtSaveAction;
import kd.bos.service.ctbotp.save.lk.CtBotpRouteManage;
import kd.bos.util.CollectionUtils;

public class CtSaveBillRouteAction
extends AbstractCtSaveAction {
    private static final Log log = LogFactory.getLog(CtSaveBillRouteAction.class);
    private static final String BOS_MSERVICE_OPERATION = "bos-mservice-ctbotp";

    public CtSaveBillRouteAction(CtSaveContext context, CtSaveResultManager ctSaveResultManager) {
        super(context, ctSaveResultManager);
    }

    @Override
    protected void doAction() {
        super.doAction();
        if (!this.context.getCtSaveArgs().getSyncType().equals(SyncTypeEnum.FORWARD.getValue())) {
            return;
        }
        ArrayList<CtBillLk> ctBillLks = new ArrayList<CtBillLk>(this.resultManager.getCtBillLks());
        ArrayList<CtBillSyncRoute> ctBillSyncRoutes = new ArrayList<CtBillSyncRoute>(16);
        if (CollectionUtils.isNotEmpty(ctBillLks)) {
            for (CtBillLk ctBillLk : ctBillLks) {
                CtBillSyncRoute ctBillSyncRoute = new CtBillSyncRoute();
                ctBillSyncRoute.setId(Long.valueOf(ID.genLongId()));
                ctBillSyncRoute.setsTenantCode(ctBillLk.getsTenantCode());
                ctBillSyncRoute.setsAccountId(ctBillLk.getsAccountId());
                ctBillSyncRoute.setsEntityKey(ctBillLk.getsEntityKey());
                ctBillSyncRoute.setSBillId(ctBillLk.getSBillId());
                ctBillSyncRoute.settTenantCode(ctBillLk.gettTenantCode());
                ctBillSyncRoute.settAccountId(ctBillLk.gettAccountId());
                ctBillSyncRoute.settEntityKey(ctBillLk.gettEntityKey());
                ctBillSyncRoute.setTBillId(ctBillLk.getTBillId());
                ctBillSyncRoute.setCreateTime(new Date());
                ctBillSyncRoutes.add(ctBillSyncRoute);
            }
        }
        CtBotpRouteManage.addBotpBillRoute(ctBillSyncRoutes);
    }
}

