/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.save.batchactions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.ctbotp.CtDataEntity;
import kd.bos.entity.ctbotp.CtDataEntityField;
import kd.bos.entity.ctbotp.save.CtSaveBacthContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.service.ctbotp.save.CtSaveContext;
import kd.bos.service.ctbotp.save.CtSaveResultManager;
import kd.bos.service.ctbotp.save.actions.AbstractCtSaveAction;
import kd.bos.util.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class CtBatchInitAction
extends AbstractCtSaveAction {
    private static final Log log = LogFactory.getLog(CtBatchInitAction.class);
    private static final String BOS_MSERVICE_OPERATION = "bos-mservice-ctbotp";

    public CtBatchInitAction(CtSaveContext context, CtSaveResultManager ctSaveResultManager) {
        super(context, ctSaveResultManager);
    }

    @Override
    protected void doAction() {
        super.doAction();
        List ctDataEntities = this.context.getCtSaveArgs().getData();
        CtSaveBacthContext ctSaveBacthContext = new CtSaveBacthContext();
        this.context.setCtSaveBacthContext(ctSaveBacthContext);
        HashMap<Long, List<Long>> firstMap = new HashMap<Long, List<Long>>();
        HashMap<Long, List<Long>> lastMap = new HashMap<Long, List<Long>>();
        HashMap<Long, List<Long>> notFirstMap = new HashMap<Long, List<Long>>();
        for (CtDataEntity ctDataEntity : ctDataEntities) {
            List<Long> sBillIds = this.getSBillIds(ctDataEntity);
            this.context.getBillIdMaps().put(ctDataEntity.getId(), new HashSet<Long>(sBillIds));
            if (ctDataEntity.isFirstBatch()) {
                firstMap.put(ctDataEntity.getId(), sBillIds);
            } else {
                notFirstMap.put(ctDataEntity.getId(), sBillIds);
            }
            if (ctDataEntity.isExistNextBatch()) continue;
            lastMap.put(ctDataEntity.getId(), sBillIds);
        }
        ctSaveBacthContext.setFirstMap(firstMap);
        ctSaveBacthContext.setLastMap(lastMap);
        if (MapUtils.isNotEmpty(notFirstMap)) {
            Map<Object, DynamicObject> headOb = this.loadHead(notFirstMap.keySet().toArray(new Object[0]));
            ctSaveBacthContext.setHeadOb(headOb);
        }
    }

    private Map<Object, DynamicObject> loadHead(Object[] pkIds) {
        IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)this.getContext().getTargetMainType());
        dataManager.setSelectHeadOnly(true);
        Object[] objs = dataManager.read(pkIds);
        if (objs == null || objs.length == 0) {
            return new HashMap<Object, DynamicObject>(0);
        }
        CachedLoadReferenceObjectManager manager = new CachedLoadReferenceObjectManager((IDataEntityType)this.getContext().getTargetMainType(), false);
        manager.Load(objs);
        HashMap<Object, DynamicObject> map = new HashMap<Object, DynamicObject>(objs.length);
        for (Object obj : objs) {
            DynamicObject o = (DynamicObject)obj;
            map.put(o.getPkValue(), o);
        }
        return map;
    }

    private List<Long> getSBillIds(CtDataEntity ctDataEntity) {
        List ctDataEntities = ctDataEntity.getChildEntity("billhead_lk");
        ArrayList<Long> billIds = new ArrayList<Long>();
        for (CtDataEntity ctLink : ctDataEntities) {
            if (CollectionUtils.isEmpty((Collection)ctLink.getFields())) continue;
            for (CtDataEntityField ctDataEntityField : ctLink.getFields()) {
                if (!"sBillId".equals(ctDataEntityField.getName())) continue;
                Long sBillId = Long.valueOf(ctDataEntityField.getValue().getValue());
                billIds.add(sBillId);
            }
        }
        return billIds;
    }
}

