/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.save.batchrequest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.ctbotp.CtDataEntityField;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.helper.CtAttachmentConvertHelper;
import kd.bos.service.ctbotp.save.CtSaveContext;
import kd.bos.service.ctbotp.save.CtSaveResultManager;
import kd.bos.service.ctbotp.save.batchrequest.CtSaveAttachmentFieldSetValueRequest;

public class CtSaveBatchAttachmentFieldSetValue {
    private static final String BOS_MSERVICE_CTBOTP = "bos-mservice-ctbotp";
    private static final Log logger = LogFactory.getLog(CtSaveBatchAttachmentFieldSetValue.class);
    private BillEntityType sourceMainType;
    private CtSaveContext ctSaveContext;
    private List<CtSaveAttachmentFieldSetValueRequest> requests = new ArrayList<CtSaveAttachmentFieldSetValueRequest>();
    private CtSaveResultManager ctSaveResultManager;

    public CtSaveBatchAttachmentFieldSetValue(CtSaveContext ctSaveContext, CtSaveResultManager ctSaveResultManager) {
        this.ctSaveContext = ctSaveContext;
        this.ctSaveResultManager = ctSaveResultManager;
    }

    public List<CtSaveAttachmentFieldSetValueRequest> getRequests() {
        return this.requests;
    }

    public CtSaveContext getCtSaveContext() {
        return this.ctSaveContext;
    }

    public void batchDo() {
        CtAttachmentConvertHelper.batchSaveAttachmentFieldData(this.requests, this.ctSaveContext);
    }

    private Map<String, List<CtSaveAttachmentFieldSetValueRequest>> groupRequest(List<CtSaveAttachmentFieldSetValueRequest> lists) {
        HashMap<String, List<CtSaveAttachmentFieldSetValueRequest>> groupMap = new HashMap<String, List<CtSaveAttachmentFieldSetValueRequest>>();
        for (CtSaveAttachmentFieldSetValueRequest request : lists) {
            CtDataEntityField ctDataEntityField = request.getCtDataEntityField();
            String key = ctDataEntityField.getEntityKeys() + ctDataEntityField.getName();
            if (!groupMap.containsKey(key)) {
                ArrayList requests = new ArrayList(16);
                groupMap.put(key, requests);
            }
            ((List)groupMap.get(key)).add(request);
        }
        return groupMap;
    }

    private Map<String, Map<Object, DynamicObject>> loadSourceEntityRows() {
        HashSet<String> allPropNames = new HashSet<String>(4);
        HashMap<String, HashSet<String>> srcAttachmentPropNames = new HashMap<String, HashSet<String>>(4);
        HashMap<String, HashSet<Object>> srcRowIds = new HashMap<String, HashSet<Object>>(4);
        for (CtSaveAttachmentFieldSetValueRequest request : this.requests) {
            String entityKey = request.getSrcAttachmentProp().getParent().getName();
            allPropNames.add(request.getSrcAttachmentProp().getName());
            HashSet<String> propNames = (HashSet<String>)srcAttachmentPropNames.get(entityKey);
            if (propNames == null) {
                propNames = new HashSet<String>(4);
                srcAttachmentPropNames.put(entityKey, propNames);
            }
            propNames.add(request.getSrcAttachmentProp().getName());
            HashSet<Object> rowIds = (HashSet<Object>)srcRowIds.get(entityKey);
            if (rowIds == null) {
                rowIds = new HashSet<Object>(this.requests.size());
                srcRowIds.put(entityKey, rowIds);
            }
            rowIds.addAll(request.getSrcRowIds());
        }
        HashMap<String, Map<Object, DynamicObject>> srcAllDataEntities = new HashMap<String, Map<Object, DynamicObject>>(4);
        BillEntityType subMainType = (BillEntityType)EntityMetadataCache.getSubDataEntityType((String)this.sourceMainType.getName(), allPropNames);
        Map<String, EntityType> localEntityTypes = this.buildSingleSubMainType(subMainType, allPropNames);
        for (Map.Entry entry : srcAttachmentPropNames.entrySet()) {
            Object[] rowObjs;
            EntityType entityType = localEntityTypes.get(entry.getKey());
            Set rowIds = (Set)srcRowIds.get(entry.getKey());
            if (rowIds == null || entityType == null) continue;
            HashMap<Object, DynamicObject> srcRows = new HashMap<Object, DynamicObject>(rowIds.size());
            srcAllDataEntities.put((String)entry.getKey(), (Map<Object, DynamicObject>)srcRows);
            for (Object rowObj : rowObjs = BusinessDataReader.load((Object[])rowIds.toArray(), (IDataEntityType)entityType)) {
                Object rowId = ((DynamicObject)rowObj).getPkValue();
                srcRows.put(rowId, (DynamicObject)rowObj);
            }
        }
        return srcAllDataEntities;
    }

    private Map<String, EntityType> buildSingleSubMainType(BillEntityType subMainType, Set<String> allPropNames) {
        BillEntityType localSubMainType = null;
        try {
            localSubMainType = (BillEntityType)subMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("", exp.getMessage()), new Object[0]);
        }
        HashMap<String, EntityType> entityTypes = new HashMap<String, EntityType>(4);
        for (EntityType entityType : localSubMainType.getAllEntities().values()) {
            HashSet<String> propNames = new HashSet<String>(entityType.getProperties().size());
            ArrayList<IDataEntityProperty> subEntryProps = new ArrayList<IDataEntityProperty>(1);
            for (IDataEntityProperty prop : entityType.getProperties()) {
                if (prop instanceof EntryProp) {
                    subEntryProps.add(prop);
                    continue;
                }
                if (!allPropNames.contains(prop.getName())) continue;
                propNames.add(prop.getName());
            }
            if (propNames.isEmpty()) continue;
            if (!subEntryProps.isEmpty()) {
                EntityType subEntityType = entityType.getSubEntityType(propNames);
                entityTypes.put(entityType.getName(), subEntityType);
                continue;
            }
            entityTypes.put(entityType.getName(), entityType);
        }
        return entityTypes;
    }
}

