/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.save.batchrequest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.CtFieldMapItem;
import kd.bos.entity.ctbotp.CtFieldSumType;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.service.ctbotp.convert.CtSingleRuleContext;
import kd.bos.service.ctbotp.save.batchrequest.CtSaveMultiLangFieldSetValueRequest;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;

public class CtSaveBatchMultiLangFieldSetValue {
    private BillEntityType sourceMainType;
    private List<CtSaveMultiLangFieldSetValueRequest> requests = new ArrayList<CtSaveMultiLangFieldSetValueRequest>();
    private final boolean useSharding;

    public CtSaveBatchMultiLangFieldSetValue(CtSingleRuleContext ruleContext) {
        this.sourceMainType = ruleContext.getContext().getSourceMainType();
        this.useSharding = ShardingHinter.isSharding((String)this.sourceMainType.getAlias());
    }

    public List<CtSaveMultiLangFieldSetValueRequest> getRequests() {
        return this.requests;
    }

    public void batchDo() {
        if (this.getRequests() == null || this.getRequests().isEmpty()) {
            return;
        }
        ArrayList<CtSaveMultiLangFieldSetValueRequest> srcMultiLangRequests = new ArrayList<CtSaveMultiLangFieldSetValueRequest>(this.getRequests().size());
        ArrayList<CtSaveMultiLangFieldSetValueRequest> srcBDRefPorpRequests = new ArrayList<CtSaveMultiLangFieldSetValueRequest>(this.getRequests().size());
        for (CtSaveMultiLangFieldSetValueRequest request : this.getRequests()) {
            if (request.getSrcMuliLangTextProp() != null) {
                srcMultiLangRequests.add(request);
                continue;
            }
            if (request.getSrcBDProp() == null) continue;
            srcBDRefPorpRequests.add(request);
        }
        if (!srcBDRefPorpRequests.isEmpty()) {
            this.takeBDMultiLangPropValue(srcBDRefPorpRequests);
        }
        if (!srcMultiLangRequests.isEmpty()) {
            this.takeSrcMultiLangPropValue(srcMultiLangRequests);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takeSrcMultiLangPropValue(List<CtSaveMultiLangFieldSetValueRequest> srcMultiLangRequests) {
        HashMap<String, HashSet<String>> srcMultiLangPropNames = new HashMap<String, HashSet<String>>(4);
        HashMap<String, HashSet<Object>> srcRowIds = new HashMap<String, HashSet<Object>>(4);
        HashSet<String> allPropNames = new HashSet<String>(4);
        HashMap<Object, Object> rowParentIdMap = null;
        if (this.useSharding) {
            rowParentIdMap = new HashMap<Object, Object>();
        }
        for (CtSaveMultiLangFieldSetValueRequest request : srcMultiLangRequests) {
            String entityKey = request.getSrcMuliLangTextProp().getParent().getName();
            allPropNames.add(request.getSrcMuliLangTextProp().getName());
            HashSet<String> propNames = (HashSet<String>)srcMultiLangPropNames.get(entityKey);
            if (propNames == null) {
                propNames = new HashSet<String>(4);
                srcMultiLangPropNames.put(entityKey, propNames);
            }
            propNames.add(request.getSrcMuliLangTextProp().getName());
            HashSet<Object> rowIds = (HashSet<Object>)srcRowIds.get(entityKey);
            if (rowIds == null) {
                rowIds = new HashSet<Object>(32);
                srcRowIds.put(entityKey, rowIds);
            }
            rowIds.addAll(request.getSrcRowIds());
            if (!this.useSharding) continue;
            rowParentIdMap.put(request.getSrcRowId(), request.getSrcBillId());
        }
        HashMap srcRowDataEntities = new HashMap(4);
        BillEntityType subMainType = (BillEntityType)EntityMetadataCache.getSubDataEntityType((String)this.sourceMainType.getName(), allPropNames);
        Map<String, EntityType> localEntityTypes = this.buildSingleSubMainType(subMainType, allPropNames);
        for (Map.Entry entry : srcMultiLangPropNames.entrySet()) {
            Object[] rowObjs;
            EntityType entityType = localEntityTypes.get(entry.getKey());
            Set rowIds = (Set)srcRowIds.get(entry.getKey());
            if (rowIds == null || entityType == null) continue;
            HashMap<Object, DynamicObject> srcRows = new HashMap<Object, DynamicObject>(rowIds.size());
            srcRowDataEntities.put(entry.getKey(), srcRows);
            ShardingHintContext ctx = null;
            if (this.useSharding && rowParentIdMap != null) {
                Object[] parentIds = new HashSet(rowParentIdMap.size());
                for (Object rowId : rowIds) {
                    parentIds.add(rowParentIdMap.get(rowId));
                }
                ctx = ShardingHinter.tryHint((IDataEntityType)this.sourceMainType, (Object[])parentIds.toArray());
            }
            if (ctx != null) {
                ctx.set();
                try {
                    rowObjs = BusinessDataReader.load((Object[])rowIds.toArray(), (IDataEntityType)entityType);
                }
                finally {
                    ctx.close();
                }
            } else {
                rowObjs = BusinessDataReader.load((Object[])rowIds.toArray(), (IDataEntityType)entityType);
            }
            for (Object rowObj : rowObjs) {
                Object rowId = ((DynamicObject)rowObj).getPkValue();
                srcRows.put(rowId, (DynamicObject)rowObj);
            }
        }
        for (CtSaveMultiLangFieldSetValueRequest request : srcMultiLangRequests) {
            Object srcRowId = request.getSrcRowId();
            String srcPropName = request.getSrcMuliLangTextProp().getName();
            String entityName = request.getSrcMuliLangTextProp().getParent().getName();
            CtFieldMapItem fieldMapItem = request.getFieldMapItem();
            Map srcRows = (Map)srcRowDataEntities.get(entityName);
            if (srcRowIds == null) continue;
            ArrayList<String> joinValues = new ArrayList<String>(10);
            if (CtFieldSumType.Join.getValue() == fieldMapItem.getCtFieldSumType().getValue() && srcRows.size() > 1) {
                for (Map.Entry objectDynamicObjectEntry : srcRows.entrySet()) {
                    String value = ((DynamicObject)objectDynamicObjectEntry.getValue()).get(srcPropName).toString();
                    if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                    joinValues.add(value);
                }
            }
            if (!CollectionUtils.isEmpty(joinValues)) {
                request.setNewValue(StringUtils.join((Object[])joinValues.toArray(), (String)","));
                request.setValue();
                continue;
            }
            DynamicObject srcRowDataEntity = (DynamicObject)srcRows.get(srcRowId);
            if (srcRowDataEntity == null) continue;
            Object propValue = srcRowDataEntity.get(srcPropName);
            request.setNewValue(propValue);
            request.setValue();
        }
    }

    private Map<String, EntityType> buildSingleSubMainType(BillEntityType subMainType, Set<String> allPropNames) {
        BillEntityType localSubMainType = null;
        try {
            localSubMainType = (BillEntityType)subMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("", exp.getMessage()), new Object[0]);
        }
        HashMap<String, EntityType> entityTypes = new HashMap<String, EntityType>(4);
        for (EntityType entityType : localSubMainType.getAllEntities().values()) {
            HashSet<String> propNames = new HashSet<String>(entityType.getProperties().size());
            ArrayList<IDataEntityProperty> subEntryProps = new ArrayList<IDataEntityProperty>(1);
            for (IDataEntityProperty prop : entityType.getProperties()) {
                if (prop instanceof EntryProp) {
                    subEntryProps.add(prop);
                    continue;
                }
                if (!allPropNames.contains(prop.getName())) continue;
                propNames.add(prop.getName());
            }
            if (propNames.isEmpty()) continue;
            if (!subEntryProps.isEmpty()) {
                EntityType subEntityType = entityType.getSubEntityType(propNames);
                entityTypes.put(entityType.getName(), subEntityType);
                continue;
            }
            entityTypes.put(entityType.getName(), entityType);
        }
        return entityTypes;
    }

    private void takeBDMultiLangPropValue(List<CtSaveMultiLangFieldSetValueRequest> srcBDRefPorpRequests) {
        HashMap<BasedataProp, List> requestsByBDProp = new HashMap<BasedataProp, List>();
        for (CtSaveMultiLangFieldSetValueRequest ctSaveMultiLangFieldSetValueRequest : srcBDRefPorpRequests) {
            if (ctSaveMultiLangFieldSetValueRequest.getSrcBDProp() == null) continue;
            requestsByBDProp.computeIfAbsent(ctSaveMultiLangFieldSetValueRequest.getSrcBDProp(), s -> new ArrayList()).add(ctSaveMultiLangFieldSetValueRequest);
        }
        for (Map.Entry entry : requestsByBDProp.entrySet()) {
            BasedataProp bdProp = (BasedataProp)entry.getKey();
            List currBDPropRequests = (List)entry.getValue();
            MainEntityType bdType = (MainEntityType)bdProp.getComplexType();
            HashSet<Object> srcBDIds = new HashSet<Object>(currBDPropRequests.size());
            for (CtSaveMultiLangFieldSetValueRequest request : currBDPropRequests) {
                if (request.getSrcBDId() == null || bdProp.getValueComparator().compareValue(request.getSrcBDId())) continue;
                srcBDIds.add(request.getSrcBDId());
            }
            if (srcBDIds.isEmpty()) continue;
            Map bdObjs = BusinessDataServiceHelper.loadFromCache((Object[])srcBDIds.toArray(), (DynamicObjectType)bdType);
            for (CtSaveMultiLangFieldSetValueRequest request : currBDPropRequests) {
                DynamicObject bdObj;
                Object bdId = request.getSrcBDId();
                if (bdId == null || (bdObj = (DynamicObject)bdObjs.get(bdId)) == null) continue;
                Object propValue = this.getRefMultiLangPropValue(bdObj, request.getSrcRefBDProps());
                request.setNewValue(propValue);
                request.setValue();
            }
        }
    }

    private Object getRefMultiLangPropValue(DynamicObject bdObj, String[] refPropNames) {
        Object refPropValue = bdObj;
        for (String refPropName : refPropNames) {
            if (!((refPropValue = refPropValue instanceof DynamicObject && refPropValue.getDataEntityType().getProperties().containsKey((Object)refPropName) ? refPropValue.get(refPropName) : null) instanceof DynamicObjectCollection)) continue;
            DynamicObjectCollection rows = (DynamicObjectCollection)refPropValue;
            refPropValue = !rows.isEmpty() ? rows.get(0) : null;
        }
        return refPropValue;
    }
}

