/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.service;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.ctbotp.CtBusinessFlowDataService;
import kd.bos.ctbotp.link.CtBillLinkService;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.apiparam.CtGetEntityInfoReq;
import kd.bos.entity.ctbotp.apiparam.CtLkDownQueryReq;
import kd.bos.entity.ctbotp.apiresponse.CtBillLkDownRes;
import kd.bos.entity.ctbotp.apiresponse.CtBillLkUpRes;
import kd.bos.entity.ctbotp.apiresponse.CtEntityInfo;
import kd.bos.entity.ctbotp.apiresponse.CtGetEntityInfoRes;
import kd.bos.entity.ctbotp.apiresponse.CtTableInfoRes;
import kd.bos.entity.ctbotp.constants.CtApiUrlEnum;
import kd.bos.entity.ctbotp.link.CtBillLk;
import kd.bos.entity.ctbotp.link.CtLkDownQueryArgs;
import kd.bos.entity.ctbotp.link.CtLkUpQueryArgs;
import kd.bos.entity.ctbotp.runtime.CtBFRow;
import kd.bos.entity.ctbotp.runtime.CtBFRowId;
import kd.bos.entity.ctbotp.runtime.CtBFTable;
import kd.bos.entity.ctbotp.sync.SyncRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.save.lk.CtBotpRouteManage;
import kd.bos.service.ctbotp.utils.CtBotpApiUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class CtBillLkQueryService {
    private static Log log = LogFactory.getLog(CtBillLkQueryService.class);

    public static List<CtBFRow> loadBillLinkDownRowsFull(String sTenantCode, String sAccountId, String entityNumber, Long[] billIds) {
        CtBusinessFlowDataService service = new CtBusinessFlowDataService();
        List allRows = service.loadCtBillLinkDownRows(sTenantCode, sAccountId, entityNumber, billIds, false);
        try {
            log.info("\u79df\u6237\u5185\u4e0b\u67e5\u8fd4\u56de\u7ed3\u679c\uff1a" + SerializationUtils.toJsonString((Object)allRows));
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        HashMap<CtBFTable, List<Long>> ctBfRowMap = new HashMap<CtBFTable, List<Long>>();
        HashMap<CtBFTable, String> ctTableNameMap = new HashMap<CtBFTable, String>();
        CtBFTable ctBFTable = new CtBFTable(sTenantCode, sAccountId, entityNumber);
        ctBfRowMap.put(ctBFTable, new ArrayList<Long>(Arrays.asList(billIds)));
        for (Object ctBFRow : allRows) {
            List<Long> idList;
            CtBFTable tCtBFTable = new CtBFTable(ctBFRow.getId().getTenantId(), ctBFRow.getId().getAccountId(), ctBFRow.getId().getMainEntityKey());
            CtBFTable sCtBFTable = new CtBFTable(ctBFRow.getSId().getTenantId(), ctBFRow.getSId().getAccountId(), ctBFRow.getSId().getMainEntityKey());
            if (ctBfRowMap.containsKey(tCtBFTable)) {
                idList = (List)ctBfRowMap.get(tCtBFTable);
                if (!idList.contains(ctBFRow.getId().getBillId())) {
                    idList.add(ctBFRow.getId().getBillId());
                    ctBfRowMap.put(tCtBFTable, idList);
                }
            } else {
                idList = new ArrayList();
                idList.add(ctBFRow.getId().getBillId());
                ctBfRowMap.put(tCtBFTable, idList);
            }
            if (ctBfRowMap.containsKey(sCtBFTable)) {
                idList = (List)ctBfRowMap.get(sCtBFTable);
                if (idList.contains(ctBFRow.getSId().getBillId())) continue;
                idList.add(ctBFRow.getSId().getBillId());
                ctBfRowMap.put(sCtBFTable, idList);
                continue;
            }
            idList = new ArrayList();
            idList.add(ctBFRow.getSId().getBillId());
            ctBfRowMap.put(sCtBFTable, idList);
        }
        if (MapUtils.isEmpty(ctBfRowMap)) {
            log.info("ctBfRowMap\u4e3a\u7a7a");
        }
        if (MapUtils.isNotEmpty(ctBfRowMap)) {
            Object ctBFRow;
            List<SyncRoute> syncRoutes = CtBotpRouteManage.getBillSyncRouteDownBatch(ctBfRowMap);
            ctBFRow = syncRoutes.iterator();
            while (ctBFRow.hasNext()) {
                CtBFTable tCtBFTable;
                List ids;
                SyncRoute syncRoute = (SyncRoute)ctBFRow.next();
                if (syncRoute.getStenantCode().equals(syncRoute.getTtenantCode()) && syncRoute.getsAccountId().equals(syncRoute.gettAccountId()) || CollectionUtils.isEmpty((Collection)(ids = (List)ctBfRowMap.get(tCtBFTable = new CtBFTable(syncRoute.getStenantCode(), syncRoute.getsAccountId(), syncRoute.getsEntityKey()))))) continue;
                CtLkDownQueryReq ctLkDownQueryReq = new CtLkDownQueryReq();
                ctLkDownQueryReq.setsTenantCode(syncRoute.getStenantCode());
                ctLkDownQueryReq.setsAccountId(syncRoute.getsAccountId());
                ctLkDownQueryReq.setsEntityKey(syncRoute.getsEntityKey());
                ctLkDownQueryReq.setsBillIds(ids);
                ctLkDownQueryReq.setOnlyDirtTarget(Boolean.FALSE);
                String result = CtBotpApiUtils.post(syncRoute.getTtenantCode(), syncRoute.gettAccountId(), CtApiUrlEnum.GETCTBILLLKDOWN, SerializationUtils.toJsonString((Object)ctLkDownQueryReq));
                if (StringUtils.isBlank((CharSequence)result)) {
                    try {
                        log.info("\u6267\u884c\u4e0b\u67e5OpenApi\u65f6\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4e0b\u6e38\u79df\u6237\u7cfb\u7edf\u662f\u5426\u5f02\u5e38\u3002");
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                    }
                    continue;
                }
                Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
                CtBillLkDownRes ctBillLkDownRes = (CtBillLkDownRes)JSON.parseObject((String)JSON.toJSONString(openApiResult.get("data")), CtBillLkDownRes.class);
                List ctBFRows = ctBillLkDownRes.getCtBFRowList();
                try {
                    log.info("api\u8fd4\u56de\u7ed3\u679callRows:" + SerializationUtils.toJsonString((Object)ctBFRows));
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
                if (CollectionUtils.isNotEmpty((Collection)ctBillLkDownRes.getCtTableInfos())) {
                    for (CtTableInfoRes ctTableInfoRes : ctBillLkDownRes.getCtTableInfos()) {
                        CtBFTable ctTable = new CtBFTable(ctTableInfoRes.getTenantId(), ctTableInfoRes.getAccountId(), ctTableInfoRes.getMainEntityKey());
                        ctTableNameMap.put(ctTable, ctTableInfoRes.getName());
                    }
                }
                if (!CollectionUtils.isNotEmpty((Collection)ctBFRows)) continue;
                allRows.addAll(ctBFRows);
            }
        }
        for (Object ctBFRow : allRows) {
            String name;
            MainEntityType mainEntityType;
            CtBFTable ctTable = new CtBFTable(ctBFRow.getId().getTenantId(), ctBFRow.getId().getAccountId(), ctBFRow.getId().getMainEntityKey());
            if (MapUtils.isNotEmpty(ctTableNameMap) && ctTableNameMap.containsKey(ctBFTable)) {
                ctBFRow.getId().setMainEntityName((String)ctTableNameMap.get(ctTable));
            }
            if (StringUtils.isBlank((CharSequence)ctBFRow.getId().getMainEntityName()) && ctBFRow.getId().getTenantId().equals(RequestContext.get().getTenantId()) && ctBFRow.getId().getAccountId().equals(RequestContext.get().getAccountId())) {
                mainEntityType = EntityMetadataCache.getDataEntityType((String)ctBFRow.getId().getMainEntityKey());
                name = mainEntityType.getDisplayName().getLocaleValue();
                ctBFRow.getId().setMainEntityName(name);
            }
            if (!StringUtils.isBlank((CharSequence)ctBFRow.getSId().getMainEntityName()) || !ctBFRow.getSId().getTenantId().equals(RequestContext.get().getTenantId()) || !ctBFRow.getSId().getAccountId().equals(RequestContext.get().getAccountId())) continue;
            mainEntityType = EntityMetadataCache.getDataEntityType((String)ctBFRow.getSId().getMainEntityKey());
            name = mainEntityType.getDisplayName().getLocaleValue();
            ctBFRow.getSId().setMainEntityName(name);
        }
        try {
            log.info("allRows:" + SerializationUtils.toJsonString((Object)allRows));
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return allRows;
    }

    public static List<CtBFRow> loadBillLinkDownDirt(String sTenantCode, String sAccountId, String entityNumber, Long[] billIds) {
        List ctRows;
        CtBusinessFlowDataService service = new CtBusinessFlowDataService();
        ArrayList<CtBFRow> allRows = new ArrayList<CtBFRow>();
        List rows = service.loadBillLinkDown(sTenantCode, sAccountId, entityNumber, billIds, true);
        if (CollectionUtils.isNotEmpty((Collection)rows)) {
            allRows.addAll(rows);
        }
        if (CollectionUtils.isNotEmpty((Collection)(ctRows = service.getTenantDirtBillLkDown(sTenantCode, sAccountId, entityNumber, Arrays.asList(billIds))))) {
            allRows.addAll(ctRows);
        }
        HashMap<CtBFTable, List<Long>> ctBfRowMap = new HashMap<CtBFTable, List<Long>>();
        HashMap<CtBFTable, String> ctTableNameMap = new HashMap<CtBFTable, String>();
        CtBFTable ctBFTable = new CtBFTable(sTenantCode, sAccountId, entityNumber);
        ctBfRowMap.put(ctBFTable, new ArrayList<Long>(Arrays.asList(billIds)));
        if (MapUtils.isEmpty(ctBfRowMap)) {
            log.info("ctBfRowMap\u4e3a\u7a7a");
        }
        if (MapUtils.isNotEmpty(ctBfRowMap)) {
            List<SyncRoute> syncRoutes = CtBotpRouteManage.getBillSyncRouteDownBatch(ctBfRowMap);
            Iterator iterator = syncRoutes.iterator();
            while (iterator.hasNext()) {
                CtBFTable tCtBFTable;
                List ids;
                SyncRoute syncRoute = (SyncRoute)iterator.next();
                if (syncRoute.getStenantCode().equals(syncRoute.getTtenantCode()) && syncRoute.getsAccountId().equals(syncRoute.gettAccountId()) || CollectionUtils.isEmpty((Collection)(ids = (List)ctBfRowMap.get(tCtBFTable = new CtBFTable(syncRoute.getStenantCode(), syncRoute.getsAccountId(), syncRoute.getsEntityKey()))))) continue;
                CtLkDownQueryReq ctLkDownQueryReq = new CtLkDownQueryReq();
                ctLkDownQueryReq.setsTenantCode(syncRoute.getStenantCode());
                ctLkDownQueryReq.setsAccountId(syncRoute.getsAccountId());
                ctLkDownQueryReq.setsEntityKey(syncRoute.getsEntityKey());
                ctLkDownQueryReq.setsBillIds(ids);
                ctLkDownQueryReq.setOnlyDirtTarget(Boolean.TRUE);
                String result = CtBotpApiUtils.post(syncRoute.getTtenantCode(), syncRoute.gettAccountId(), CtApiUrlEnum.GETCTBILLLKDOWN, SerializationUtils.toJsonString((Object)ctLkDownQueryReq));
                if (StringUtils.isBlank((CharSequence)result)) {
                    try {
                        log.info("\u6267\u884c\u4e0b\u67e5OpenApi\u65f6\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4e0b\u6e38\u79df\u6237\u7cfb\u7edf\u662f\u5426\u5f02\u5e38\u3002");
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                    }
                    continue;
                }
                Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
                CtBillLkDownRes ctBillLkDownRes = (CtBillLkDownRes)JSON.parseObject((String)JSON.toJSONString(openApiResult.get("data")), CtBillLkDownRes.class);
                List ctBFRows = ctBillLkDownRes.getCtBFRowList();
                try {
                    log.info("api\u8fd4\u56de\u7ed3\u679callRows:" + SerializationUtils.toJsonString((Object)ctBFRows));
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
                if (CollectionUtils.isNotEmpty((Collection)ctBillLkDownRes.getCtTableInfos())) {
                    for (CtTableInfoRes ctTableInfoRes : ctBillLkDownRes.getCtTableInfos()) {
                        CtBFTable ctTable = new CtBFTable(ctTableInfoRes.getTenantId(), ctTableInfoRes.getAccountId(), ctTableInfoRes.getMainEntityKey());
                        ctTableNameMap.put(ctTable, ctTableInfoRes.getName());
                    }
                }
                if (!CollectionUtils.isNotEmpty((Collection)ctBFRows)) continue;
                allRows.addAll(ctBFRows);
            }
        }
        for (CtBFRow ctBFRow : allRows) {
            String name;
            MainEntityType mainEntityType;
            CtBFTable ctTable = new CtBFTable(ctBFRow.getId().getTenantId(), ctBFRow.getId().getAccountId(), ctBFRow.getId().getMainEntityKey());
            if (MapUtils.isNotEmpty(ctTableNameMap) && ctTableNameMap.containsKey(ctBFTable)) {
                ctBFRow.getId().setMainEntityName((String)ctTableNameMap.get(ctTable));
            }
            if (StringUtils.isBlank((CharSequence)ctBFRow.getId().getMainEntityName()) && ctBFRow.getId().getTenantId().equals(RequestContext.get().getTenantId()) && ctBFRow.getId().getAccountId().equals(RequestContext.get().getAccountId())) {
                mainEntityType = EntityMetadataCache.getDataEntityType((String)ctBFRow.getId().getMainEntityKey());
                name = mainEntityType.getDisplayName().getLocaleValue();
                ctBFRow.getId().setMainEntityName(name);
            }
            if (!StringUtils.isBlank((CharSequence)ctBFRow.getSId().getMainEntityName()) || !ctBFRow.getSId().getTenantId().equals(RequestContext.get().getTenantId()) || !ctBFRow.getSId().getAccountId().equals(RequestContext.get().getAccountId())) continue;
            mainEntityType = EntityMetadataCache.getDataEntityType((String)ctBFRow.getSId().getMainEntityKey());
            name = mainEntityType.getDisplayName().getLocaleValue();
            ctBFRow.getSId().setMainEntityName(name);
        }
        try {
            log.info("allRows:" + SerializationUtils.toJsonString(allRows));
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return allRows;
    }

    private static List<CtBFRow> getCtBillLkDownDirtForApi(String sTenantCode, String sAccountId, String entityNumber, Long[] billIds) {
        ArrayList<CtBFRow> ctBFRows = new ArrayList<CtBFRow>(8);
        CtLkDownQueryArgs args = new CtLkDownQueryArgs();
        args.setsTenantCode(sTenantCode);
        args.setsAccountId(sAccountId);
        args.setsEntityKey(entityNumber);
        args.setsBillIds(Arrays.asList(billIds));
        List ctBillLkList = CtBillLinkService.getCtDirtBillLkDown((CtLkDownQueryArgs)args);
        if (CollectionUtils.isEmpty((Collection)ctBillLkList)) {
            return ctBFRows;
        }
        for (CtBillLk ctBillLk : ctBillLkList) {
            CtBFRowId sRowId = new CtBFRowId(ctBillLk.getsTenantCode(), ctBillLk.getsAccountId(), ctBillLk.getSTableId(), ctBillLk.getSBillId(), ctBillLk.getSTableId(), ctBillLk.getSBillId());
            sRowId.setMainEntityKey(ctBillLk.getsEntityKey());
            if (sRowId.getTenantId().equals(RequestContext.get().getTenantId()) && sRowId.getAccountId().equals(RequestContext.get().getAccountId())) {
                sRowId.setMainEntityName(EntityMetadataCache.getDataEntityType((String)ctBillLk.getsEntityKey()).getDisplayName().getLocaleValue());
            }
            CtBFRowId rowId = new CtBFRowId(ctBillLk.gettTenantCode(), ctBillLk.gettAccountId(), ctBillLk.getTTableId(), ctBillLk.getTBillId(), ctBillLk.getTTableId(), ctBillLk.getTBillId());
            rowId.setMainEntityKey(ctBillLk.gettEntityKey());
            if (rowId.getTenantId().equals(RequestContext.get().getTenantId()) && rowId.getAccountId().equals(RequestContext.get().getAccountId())) {
                rowId.setMainEntityName(EntityMetadataCache.getDataEntityType((String)ctBillLk.gettEntityKey()).getDisplayName().getLocaleValue());
            }
            CtBFRow bfRow = new CtBFRow();
            bfRow.setSId(sRowId);
            bfRow.setId(rowId);
            ctBFRows.add(bfRow);
        }
        return ctBFRows;
    }

    public static CtBillLkDownRes loadBillLinkDownForApi(String sTenantCode, String sAccountId, String entityNumber, Long[] billIds, boolean onlyDirtTarget) {
        CtBillLkDownRes ctBillLkDownRes = new CtBillLkDownRes();
        List<CtBFRow> ctBFRows = null;
        ctBFRows = onlyDirtTarget ? CtBillLkQueryService.getCtBillLkDownDirtForApi(sTenantCode, sAccountId, entityNumber, billIds) : CtBillLkQueryService.loadBillLinkDownRowsFull(sTenantCode, sAccountId, entityNumber, billIds);
        ctBillLkDownRes.setCtBFRowList(ctBFRows);
        ArrayList<CtTableInfoRes> ctTableInfoResList = new ArrayList<CtTableInfoRes>(16);
        CtBillLkQueryService.addCtTableInfo(sTenantCode, sAccountId, entityNumber, ctTableInfoResList);
        HashMap<String, String> nameMap = new HashMap<String, String>(16);
        for (CtBFRow ctBFRow : ctBFRows) {
            if (MapUtils.isNotEmpty(nameMap)) break;
            if (!ctBFRow.getId().getTenantId().equals(RequestContext.get().getTenantId()) || !ctBFRow.getId().getAccountId().equals(RequestContext.get().getAccountId())) continue;
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)ctBFRow.getId().getMainEntityKey());
            String name = mainEntityType.getDisplayName().getLocaleValue();
            nameMap.put(entityNumber, name);
            CtTableInfoRes ctTableInfoRes = new CtTableInfoRes();
            ctTableInfoRes.setTenantId(ctBFRow.getId().getTenantId());
            ctTableInfoRes.setAccountId(ctBFRow.getId().getAccountId());
            ctTableInfoRes.setMainEntityKey(ctBFRow.getId().getMainEntityKey());
            ctTableInfoRes.setName(name);
            ctTableInfoResList.add(ctTableInfoRes);
        }
        ctBillLkDownRes.setCtTableInfos(ctTableInfoResList);
        return ctBillLkDownRes;
    }

    public static CtBillLkUpRes loadBillLinkUpFullForApi(String tTenantCode, String tAccountId, String entityNumber, Long[] billIds) {
        CtBillLkUpRes ctBillLkUpRes = new CtBillLkUpRes();
        List<CtBFRow> ctBFRows = CtBillLkQueryService.loadBillLinkUpRowsFull(tTenantCode, tAccountId, entityNumber, billIds);
        ctBillLkUpRes.setCtBFRowList(ctBFRows);
        ArrayList<CtTableInfoRes> ctTableInfoResList = new ArrayList<CtTableInfoRes>(16);
        CtBillLkQueryService.addCtTableInfo(tTenantCode, tAccountId, entityNumber, ctTableInfoResList);
        HashMap<String, String> nameMap = new HashMap<String, String>(16);
        for (CtBFRow ctBFRow : ctBFRows) {
            if (MapUtils.isNotEmpty(nameMap)) break;
            if (!ctBFRow.getId().getTenantId().equals(RequestContext.get().getTenantId()) || !ctBFRow.getId().getAccountId().equals(RequestContext.get().getAccountId()) || !ctBFRow.getId().getMainEntityKey().equals(entityNumber)) continue;
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)ctBFRow.getId().getMainEntityKey());
            String name = mainEntityType.getDisplayName().getLocaleValue();
            nameMap.put(entityNumber, name);
            CtTableInfoRes ctTableInfoRes = new CtTableInfoRes();
            ctTableInfoRes.setTenantId(ctBFRow.getId().getTenantId());
            ctTableInfoRes.setAccountId(ctBFRow.getId().getAccountId());
            ctTableInfoRes.setMainEntityKey(ctBFRow.getId().getMainEntityKey());
            ctTableInfoRes.setName(name);
            ctTableInfoResList.add(ctTableInfoRes);
        }
        ctBillLkUpRes.setCtTableInfos(ctTableInfoResList);
        return ctBillLkUpRes;
    }

    public static CtBillLkUpRes getEntityNameForApi(String tTenantCode, String tAccountId, String entityNumber) {
        CtBillLkUpRes ctBillLkUpRes = new CtBillLkUpRes();
        ArrayList<CtTableInfoRes> ctTableInfoResList = new ArrayList<CtTableInfoRes>(16);
        CtBillLkQueryService.addCtTableInfo(tTenantCode, tAccountId, entityNumber, ctTableInfoResList);
        ctBillLkUpRes.setCtTableInfos(ctTableInfoResList);
        return ctBillLkUpRes;
    }

    public static List<CtBFRow> loadBillLinkUpRowsFull(String tTenantCode, String tAccountId, String entityNumber, Long[] billIds) {
        CtBusinessFlowDataService service = new CtBusinessFlowDataService();
        List allRows = service.loadCtBillLinkUpRows(tTenantCode, tAccountId, entityNumber, billIds, false);
        HashMap<CtBFTable, List<Long>> ctBfRowMap = new HashMap<CtBFTable, List<Long>>();
        CtBFTable ctBFTable = new CtBFTable(tTenantCode, tAccountId, entityNumber);
        HashMap<CtBFTable, String> ctTableNameMap = new HashMap<CtBFTable, String>();
        ctBfRowMap.put(ctBFTable, new ArrayList<Long>(Arrays.asList(billIds)));
        for (Object ctBFRow : allRows) {
            List<Long> idList;
            CtBFTable tCtBFTable = new CtBFTable(ctBFRow.getId().getTenantId(), ctBFRow.getId().getAccountId(), ctBFRow.getId().getMainEntityKey());
            CtBFTable sCtBFTable = new CtBFTable(ctBFRow.getSId().getTenantId(), ctBFRow.getSId().getAccountId(), ctBFRow.getSId().getMainEntityKey());
            if (ctBfRowMap.containsKey(tCtBFTable)) {
                idList = (List)ctBfRowMap.get(tCtBFTable);
                if (!idList.contains(ctBFRow.getId().getBillId())) {
                    idList.add(ctBFRow.getId().getBillId());
                    ctBfRowMap.put(tCtBFTable, idList);
                }
            } else {
                idList = new ArrayList();
                idList.add(ctBFRow.getId().getBillId());
                ctBfRowMap.put(tCtBFTable, idList);
            }
            if (ctBfRowMap.containsKey(sCtBFTable)) {
                idList = (List)ctBfRowMap.get(sCtBFTable);
                if (idList.contains(ctBFRow.getSId().getBillId())) continue;
                idList.add(ctBFRow.getSId().getBillId());
                ctBfRowMap.put(sCtBFTable, idList);
                continue;
            }
            idList = new ArrayList();
            idList.add(ctBFRow.getSId().getBillId());
            ctBfRowMap.put(sCtBFTable, idList);
        }
        if (MapUtils.isNotEmpty(ctBfRowMap)) {
            List<SyncRoute> syncRoutes = CtBotpRouteManage.getBillSyncRouteUpBatch(ctBfRowMap);
            for (SyncRoute syncRoute : syncRoutes) {
                CtBFTable tCtBFTable;
                List ids;
                if (syncRoute.getStenantCode().equals(syncRoute.getTtenantCode()) && syncRoute.getsAccountId().equals(syncRoute.gettAccountId()) || CollectionUtils.isEmpty((Collection)(ids = (List)ctBfRowMap.get(tCtBFTable = new CtBFTable(syncRoute.getStenantCode(), syncRoute.getsAccountId(), syncRoute.getsEntityKey()))))) continue;
                CtLkUpQueryArgs ctLkUpQueryArgs = new CtLkUpQueryArgs();
                ctLkUpQueryArgs.settTenantCode(syncRoute.getStenantCode());
                ctLkUpQueryArgs.settAccountId(syncRoute.getsAccountId());
                ctLkUpQueryArgs.settEntityKey(syncRoute.getsEntityKey());
                ctLkUpQueryArgs.settBillIds(ids);
                String result = CtBotpApiUtils.post(syncRoute.getStenantCode(), syncRoute.getsAccountId(), CtApiUrlEnum.GETCTBILLLKUP, SerializationUtils.toJsonString((Object)ctLkUpQueryArgs));
                Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
                CtBillLkUpRes ctBillLkUpRes = (CtBillLkUpRes)JSON.parseObject((String)JSON.toJSONString(openApiResult.get("data")), CtBillLkUpRes.class);
                List ctBFRows = ctBillLkUpRes.getCtBFRowList();
                if (CollectionUtils.isNotEmpty((Collection)ctBillLkUpRes.getCtTableInfos())) {
                    for (CtTableInfoRes ctTableInfoRes : ctBillLkUpRes.getCtTableInfos()) {
                        CtBFTable ctTable = new CtBFTable(ctTableInfoRes.getTenantId(), ctTableInfoRes.getAccountId(), ctTableInfoRes.getMainEntityKey());
                        ctTableNameMap.put(ctTable, ctTableInfoRes.getName());
                    }
                }
                if (!CollectionUtils.isNotEmpty((Collection)ctBFRows)) continue;
                allRows.addAll(ctBFRows);
            }
        }
        try {
            log.info("\u4e0a\u67e5\u8fd4\u56de\u5b9e\u4f53\u4fe1\u606f\uff1a" + SerializationUtils.toJsonString(ctTableNameMap));
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        for (Object ctBFRow : allRows) {
            String name;
            MainEntityType mainEntityType;
            CtBFTable ctTable = new CtBFTable(ctBFRow.getSId().getTenantId(), ctBFRow.getSId().getAccountId(), ctBFRow.getSId().getMainEntityKey());
            try {
                log.info("\u4e0a\u67e5\u8fd4\u56dectTable\u4fe1\u606f\uff1a" + SerializationUtils.toJsonString((Object)ctTable));
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
            if (MapUtils.isNotEmpty(ctTableNameMap) && ctTableNameMap.containsKey(ctTable)) {
                ctBFRow.getSId().setMainEntityName((String)ctTableNameMap.get(ctTable));
            }
            if (StringUtils.isBlank((CharSequence)ctBFRow.getId().getMainEntityName()) && ctBFRow.getId().getTenantId().equals(RequestContext.get().getTenantId()) && ctBFRow.getId().getAccountId().equals(RequestContext.get().getAccountId())) {
                mainEntityType = EntityMetadataCache.getDataEntityType((String)ctBFRow.getId().getMainEntityKey());
                name = mainEntityType.getDisplayName().getLocaleValue();
                ctBFRow.getId().setMainEntityName(name);
            }
            if (!StringUtils.isBlank((CharSequence)ctBFRow.getSId().getMainEntityName()) || !ctBFRow.getSId().getTenantId().equals(RequestContext.get().getTenantId()) || !ctBFRow.getSId().getAccountId().equals(RequestContext.get().getAccountId())) continue;
            mainEntityType = EntityMetadataCache.getDataEntityType((String)ctBFRow.getSId().getMainEntityKey());
            name = mainEntityType.getDisplayName().getLocaleValue();
            ctBFRow.getSId().setMainEntityName(name);
        }
        return allRows;
    }

    public static List<CtBFRow> loadBillLinkUpRowsDirt(String tTenantCode, String tAccountId, String entityNumber, Long[] billIds) {
        CtBusinessFlowDataService service = new CtBusinessFlowDataService();
        List allRows = service.loadCtBillLinkUpDirt(tTenantCode, tAccountId, entityNumber, billIds);
        HashMap<CtBFTable, List<Long>> ctBfRowMap = new HashMap<CtBFTable, List<Long>>();
        CtBFTable ctBFTable = new CtBFTable(tTenantCode, tAccountId, entityNumber);
        HashMap<CtBFTable, String> ctTableNameMap = new HashMap<CtBFTable, String>();
        ctBfRowMap.put(ctBFTable, new ArrayList<Long>(Arrays.asList(billIds)));
        for (Object ctBFRow : allRows) {
            List<Long> idList;
            CtBFTable tCtBFTable = new CtBFTable(ctBFRow.getId().getTenantId(), ctBFRow.getId().getAccountId(), ctBFRow.getId().getMainEntityKey());
            CtBFTable sCtBFTable = new CtBFTable(ctBFRow.getSId().getTenantId(), ctBFRow.getSId().getAccountId(), ctBFRow.getSId().getMainEntityKey());
            if (ctBfRowMap.containsKey(tCtBFTable)) {
                idList = (List)ctBfRowMap.get(tCtBFTable);
                if (!idList.contains(ctBFRow.getId().getBillId())) {
                    idList.add(ctBFRow.getId().getBillId());
                    ctBfRowMap.put(tCtBFTable, idList);
                }
            } else {
                idList = new ArrayList();
                idList.add(ctBFRow.getId().getBillId());
                ctBfRowMap.put(tCtBFTable, idList);
            }
            if (ctBfRowMap.containsKey(sCtBFTable)) {
                idList = (List)ctBfRowMap.get(sCtBFTable);
                if (idList.contains(ctBFRow.getSId().getBillId())) continue;
                idList.add(ctBFRow.getSId().getBillId());
                ctBfRowMap.put(sCtBFTable, idList);
                continue;
            }
            idList = new ArrayList();
            idList.add(ctBFRow.getSId().getBillId());
            ctBfRowMap.put(sCtBFTable, idList);
        }
        if (MapUtils.isNotEmpty(ctBfRowMap)) {
            List<SyncRoute> syncRoutes = CtBotpRouteManage.getBillSyncRouteUpBatch(ctBfRowMap);
            for (SyncRoute syncRoute : syncRoutes) {
                CtBFTable tCtBFTable;
                List ids;
                if (syncRoute.getStenantCode().equals(syncRoute.getTtenantCode()) && syncRoute.getsAccountId().equals(syncRoute.gettAccountId()) || CollectionUtils.isEmpty((Collection)(ids = (List)ctBfRowMap.get(tCtBFTable = new CtBFTable(syncRoute.getStenantCode(), syncRoute.getsAccountId(), syncRoute.getsEntityKey()))))) continue;
                CtGetEntityInfoReq ctGetEntityInfoReq = new CtGetEntityInfoReq();
                ArrayList<String> entityNumbers = new ArrayList<String>(1);
                entityNumbers.add(syncRoute.getsEntityKey());
                ctGetEntityInfoReq.setEntityNumbers(entityNumbers);
                String result = CtBotpApiUtils.post(syncRoute.getStenantCode(), syncRoute.getsAccountId(), CtApiUrlEnum.GETENTITYINFOS, SerializationUtils.toJsonString((Object)ctGetEntityInfoReq));
                Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
                CtGetEntityInfoRes ctGetEntityInfoRes = (CtGetEntityInfoRes)JSON.parseObject((String)JSON.toJSONString(openApiResult.get("data")), CtGetEntityInfoRes.class);
                if (ctGetEntityInfoRes == null || !CollectionUtils.isNotEmpty((Collection)ctGetEntityInfoRes.getCtEntityInfos())) continue;
                for (CtEntityInfo ctEntityInfo : ctGetEntityInfoRes.getCtEntityInfos()) {
                    CtBFTable ctTable = new CtBFTable(syncRoute.getStenantCode(), syncRoute.getsAccountId(), ctEntityInfo.getEntityNumber());
                    ctTableNameMap.put(ctTable, ctEntityInfo.getEntityName());
                }
            }
        }
        try {
            log.info("\u4e0a\u67e5\u8fd4\u56de\u5b9e\u4f53\u4fe1\u606f\uff1a" + SerializationUtils.toJsonString(ctTableNameMap));
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        for (Object ctBFRow : allRows) {
            String name;
            MainEntityType mainEntityType;
            CtBFTable ctTable = new CtBFTable(ctBFRow.getSId().getTenantId(), ctBFRow.getSId().getAccountId(), ctBFRow.getSId().getMainEntityKey());
            try {
                log.info("\u4e0a\u67e5\u8fd4\u56dectTable\u4fe1\u606f\uff1a" + SerializationUtils.toJsonString((Object)ctTable));
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
            if (MapUtils.isNotEmpty(ctTableNameMap) && ctTableNameMap.containsKey(ctTable)) {
                ctBFRow.getSId().setMainEntityName((String)ctTableNameMap.get(ctTable));
            }
            if (StringUtils.isBlank((CharSequence)ctBFRow.getId().getMainEntityName()) && ctBFRow.getId().getTenantId().equals(RequestContext.get().getTenantId()) && ctBFRow.getId().getAccountId().equals(RequestContext.get().getAccountId())) {
                mainEntityType = EntityMetadataCache.getDataEntityType((String)ctBFRow.getId().getMainEntityKey());
                name = mainEntityType.getDisplayName().getLocaleValue();
                ctBFRow.getId().setMainEntityName(name);
            }
            if (!StringUtils.isBlank((CharSequence)ctBFRow.getSId().getMainEntityName()) || !ctBFRow.getSId().getTenantId().equals(RequestContext.get().getTenantId()) || !ctBFRow.getSId().getAccountId().equals(RequestContext.get().getAccountId())) continue;
            mainEntityType = EntityMetadataCache.getDataEntityType((String)ctBFRow.getSId().getMainEntityKey());
            name = mainEntityType.getDisplayName().getLocaleValue();
            ctBFRow.getSId().setMainEntityName(name);
        }
        return allRows;
    }

    private static void addCtTableInfo(String tenantCode, String accountId, String entityNumber, List<CtTableInfoRes> ctTableInfoResList) {
        CtTableInfoRes ctTableInfoRes = new CtTableInfoRes();
        ctTableInfoRes.setTenantId(tenantCode);
        ctTableInfoRes.setAccountId(accountId);
        ctTableInfoRes.setMainEntityKey(entityNumber);
        if (tenantCode.equals(RequestContext.get().getTenantId()) && accountId.equals(RequestContext.get().getAccountId())) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            ctTableInfoRes.setName(mainEntityType.getDisplayName().getLocaleValue());
            ctTableInfoResList.add(ctTableInfoRes);
        }
    }
}

