/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.service;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.ctbotp.CtBusinessFlowEntryDataService;
import kd.bos.ctbotp.link.CtBillLinkService;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.apiparam.CtEntityEntryInfo;
import kd.bos.entity.ctbotp.apiparam.CtEntryLkDownReq;
import kd.bos.entity.ctbotp.apiparam.CtEntryLkUpReq;
import kd.bos.entity.ctbotp.apiresponse.CtBillLkDownRes;
import kd.bos.entity.ctbotp.apiresponse.CtBillLkUpRes;
import kd.bos.entity.ctbotp.apiresponse.CtEntryLkDownRes;
import kd.bos.entity.ctbotp.apiresponse.CtEntryLkUpRes;
import kd.bos.entity.ctbotp.apiresponse.CtTableInfoRes;
import kd.bos.entity.ctbotp.constants.CtApiUrlEnum;
import kd.bos.entity.ctbotp.link.CtBillLk;
import kd.bos.entity.ctbotp.link.CtEntryLkDownQueryArgs;
import kd.bos.entity.ctbotp.link.CtEntryLkUpQueryArgs;
import kd.bos.entity.ctbotp.link.CtLkDownQueryArgs;
import kd.bos.entity.ctbotp.runtime.CtBFRow;
import kd.bos.entity.ctbotp.runtime.CtBFRowId;
import kd.bos.entity.ctbotp.runtime.CtBFTable;
import kd.bos.entity.ctbotp.runtime.CtBillEntryInfo;
import kd.bos.entity.ctbotp.sync.SyncRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.save.lk.CtBotpRouteManage;
import kd.bos.service.ctbotp.utils.CtBotpApiUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class CtEntryLkQueryService {
    private static Log log = LogFactory.getLog((String)"CtEntryLkQueryService");

    public static List<CtBFRow> loadEntryLinkDownRowsFull(CtEntryLkDownQueryArgs ctEntryLkDownQueryArgs) {
        CtBusinessFlowEntryDataService service = new CtBusinessFlowEntryDataService();
        List allRows = service.loadCtEntryLinkDownRows(ctEntryLkDownQueryArgs);
        HashMap<CtBFTable, Map<String, CtBillEntryInfo>> ctBfRowMap = new HashMap<CtBFTable, Map<String, CtBillEntryInfo>>();
        CtEntryLkQueryService.collectcurrTenantBill(ctBfRowMap, ctEntryLkDownQueryArgs);
        for (CtBFRow ctBFRow : allRows) {
            CtEntryLkQueryService.collectTenantBill(ctBfRowMap, ctBFRow.getSId());
            CtEntryLkQueryService.collectTenantBill(ctBfRowMap, ctBFRow.getId());
        }
        if (MapUtils.isNotEmpty(ctBfRowMap)) {
            List<SyncRoute> syncRoutes = CtBotpRouteManage.getEntrySyncRouteDownBatch(ctBfRowMap);
            for (SyncRoute syncRoute : syncRoutes) {
                CtBFTable tCtBFTable;
                Map ctBillEntryInfoMap;
                if (syncRoute.getStenantCode().equals(syncRoute.getTtenantCode()) && syncRoute.getsAccountId().equals(syncRoute.gettAccountId()) || MapUtils.isEmpty((Map)(ctBillEntryInfoMap = (Map)ctBfRowMap.get(tCtBFTable = new CtBFTable(syncRoute.getStenantCode(), syncRoute.getsAccountId(), syncRoute.getsEntityKey()))))) continue;
                CtEntryLkDownReq ctLkDownQueryReq = new CtEntryLkDownReq();
                ctLkDownQueryReq.setsTenantCode(syncRoute.getStenantCode());
                ctLkDownQueryReq.setsAccountId(syncRoute.getsAccountId());
                ArrayList<CtBillEntryInfo> ctBillEntryInfos = new ArrayList<CtBillEntryInfo>(ctBillEntryInfoMap.values());
                ctLkDownQueryReq.setCtEntityEntryInfos(CtEntryLkQueryService.getCtEntityEntryInfos(ctBillEntryInfos));
                String result = CtBotpApiUtils.post(syncRoute.getTtenantCode(), syncRoute.gettAccountId(), CtApiUrlEnum.GETCTENTRYLKDOWN, SerializationUtils.toJsonString((Object)ctLkDownQueryReq));
                if (StringUtils.isBlank((CharSequence)result)) {
                    log.debug("\u6267\u884c\u4e0b\u67e5OpenApi\u65f6\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4e0b\u6e38\u79df\u6237\u7cfb\u7edf\u662f\u5426\u5f02\u5e38\u3002");
                    continue;
                }
                Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
                CtEntryLkDownRes ctBillLkDownRes = (CtEntryLkDownRes)JSON.parseObject((String)JSON.toJSONString(openApiResult.get("data")), CtEntryLkDownRes.class);
                List ctBFRows = ctBillLkDownRes.getCtBFRowList();
                if (!CollectionUtils.isNotEmpty((Collection)ctBFRows)) continue;
                allRows.addAll(ctBFRows);
            }
        }
        return allRows;
    }

    private static List<CtEntityEntryInfo> getCtEntityEntryInfos(List<CtBillEntryInfo> ctBillEntryInfos) {
        ArrayList<CtEntityEntryInfo> ctEntityEntryInfos = new ArrayList<CtEntityEntryInfo>(16);
        if (CollectionUtils.isEmpty(ctBillEntryInfos)) {
            return ctEntityEntryInfos;
        }
        for (CtBillEntryInfo ctBillEntryInfo : ctBillEntryInfos) {
            CtEntityEntryInfo ctEntityEntryInfo = new CtEntityEntryInfo();
            ctEntityEntryInfo.setMainEntityKey(ctBillEntryInfo.getMainEntityKey());
            ctEntityEntryInfo.setEntryKey(ctBillEntryInfo.getEntryKey());
            ctEntityEntryInfo.setBillIds(ctBillEntryInfo.getBillIds());
            ctEntityEntryInfo.setEntryIds(ctBillEntryInfo.getEntryIds());
            ctEntityEntryInfos.add(ctEntityEntryInfo);
        }
        return ctEntityEntryInfos;
    }

    public static CtEntryLkDownRes loadEntryLinkDownRowsFullForApi(CtEntryLkDownReq ctEntryLkDownReq) {
        CtBusinessFlowEntryDataService service = new CtBusinessFlowEntryDataService();
        ArrayList allRows = new ArrayList();
        HashMap<CtBFTable, Map<String, CtBillEntryInfo>> ctBfRowMap = new HashMap<CtBFTable, Map<String, CtBillEntryInfo>>();
        for (CtEntityEntryInfo ctEntityEntryInfo : ctEntryLkDownReq.getCtEntityEntryInfos()) {
            CtEntryLkDownQueryArgs ctEntryLkDownQueryArgs = new CtEntryLkDownQueryArgs();
            ctEntryLkDownQueryArgs.setsTenantCode(ctEntryLkDownReq.getsTenantCode());
            ctEntryLkDownQueryArgs.setsAccountId(ctEntryLkDownReq.getsAccountId());
            ctEntryLkDownQueryArgs.setsMainEntityKey(ctEntityEntryInfo.getMainEntityKey());
            ctEntryLkDownQueryArgs.setsEntryKey(ctEntityEntryInfo.getEntryKey());
            ctEntryLkDownQueryArgs.setsBillIds(ctEntityEntryInfo.getBillIds());
            ctEntryLkDownQueryArgs.setsEntryIds(ctEntityEntryInfo.getEntryIds());
            List ctBFRows = service.loadCtEntryLinkDownRows(ctEntryLkDownQueryArgs);
            allRows.addAll(ctBFRows);
            CtEntryLkQueryService.collectcurrTenantBill(ctBfRowMap, ctEntryLkDownQueryArgs);
            for (CtBFRow ctBFRow : allRows) {
                CtEntryLkQueryService.collectTenantBill(ctBfRowMap, ctBFRow.getSId());
                CtEntryLkQueryService.collectTenantBill(ctBfRowMap, ctBFRow.getId());
            }
        }
        if (MapUtils.isNotEmpty(ctBfRowMap)) {
            List<SyncRoute> syncRoutes = CtBotpRouteManage.getEntrySyncRouteDownBatch(ctBfRowMap);
            for (SyncRoute syncRoute : syncRoutes) {
                CtBFTable tCtBFTable;
                Map ctBillEntryInfoMap;
                if (syncRoute.getStenantCode().equals(syncRoute.getTtenantCode()) && syncRoute.getsAccountId().equals(syncRoute.gettAccountId()) || MapUtils.isEmpty((Map)(ctBillEntryInfoMap = (Map)ctBfRowMap.get(tCtBFTable = new CtBFTable(syncRoute.getStenantCode(), syncRoute.getsAccountId(), syncRoute.getsEntityKey()))))) continue;
                CtEntryLkDownReq ctLkDownQueryReq = new CtEntryLkDownReq();
                ctLkDownQueryReq.setsTenantCode(syncRoute.getStenantCode());
                ctLkDownQueryReq.setsAccountId(syncRoute.getsAccountId());
                ArrayList<CtBillEntryInfo> ctBillEntryInfos = new ArrayList<CtBillEntryInfo>(ctBillEntryInfoMap.values());
                ctLkDownQueryReq.setCtEntityEntryInfos(CtEntryLkQueryService.getCtEntityEntryInfos(ctBillEntryInfos));
                String result = CtBotpApiUtils.post(syncRoute.getTtenantCode(), syncRoute.gettAccountId(), CtApiUrlEnum.GETCTENTRYLKDOWN, SerializationUtils.toJsonString((Object)ctLkDownQueryReq));
                if (StringUtils.isBlank((CharSequence)result)) {
                    log.debug("\u6267\u884c\u4e0b\u67e5OpenApi\u65f6\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4e0b\u6e38\u79df\u6237\u7cfb\u7edf\u662f\u5426\u5f02\u5e38\u3002");
                    continue;
                }
                Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
                CtEntryLkDownRes ctBillLkDownRes = (CtEntryLkDownRes)JSON.parseObject((String)JSON.toJSONString(openApiResult.get("data")), CtEntryLkDownRes.class);
                List ctBFRows = ctBillLkDownRes.getCtBFRowList();
                if (!CollectionUtils.isNotEmpty((Collection)ctBFRows)) continue;
                allRows.addAll(ctBFRows);
            }
        }
        CtEntryLkDownRes ctBillLkDownRes = new CtEntryLkDownRes();
        ctBillLkDownRes.setCtBFRowList(allRows);
        return ctBillLkDownRes;
    }

    public static CtEntryLkDownRes loadEntryLinkDownRowsDirtForApi(CtEntryLkDownReq ctEntryLkDownReq) {
        CtBusinessFlowEntryDataService service = new CtBusinessFlowEntryDataService();
        ArrayList<CtBFRow> allRows = new ArrayList<CtBFRow>();
        for (CtEntityEntryInfo ctEntityEntryInfo : ctEntryLkDownReq.getCtEntityEntryInfos()) {
            CtEntryLkDownQueryArgs ctEntryLkDownQueryArgs = new CtEntryLkDownQueryArgs();
            ctEntryLkDownQueryArgs.setsTenantCode(ctEntryLkDownReq.getsTenantCode());
            ctEntryLkDownQueryArgs.setsAccountId(ctEntryLkDownReq.getsAccountId());
            ctEntryLkDownQueryArgs.setsMainEntityKey(ctEntityEntryInfo.getMainEntityKey());
            ctEntryLkDownQueryArgs.setsEntryKey(ctEntityEntryInfo.getEntryKey());
            ctEntryLkDownQueryArgs.setsBillIds(ctEntityEntryInfo.getBillIds());
            ctEntryLkDownQueryArgs.setsEntryIds(ctEntityEntryInfo.getEntryIds());
            List ctBFRows = service.getTenantDirtEntryLkDown(ctEntryLkDownQueryArgs);
            if (!CollectionUtils.isNotEmpty((Collection)ctBFRows)) continue;
            for (CtBFRow ctBFRow : ctBFRows) {
                if (!ctBFRow.getSId().getEntityKey().equals(ctEntityEntryInfo.getEntryKey()) || !ctEntityEntryInfo.getEntryIds().contains(ctBFRow.getSId().getEntryId())) continue;
                allRows.add(ctBFRow);
            }
        }
        CtEntryLkDownRes ctBillLkDownRes = new CtEntryLkDownRes();
        ctBillLkDownRes.setCtBFRowList(allRows);
        return ctBillLkDownRes;
    }

    private static void collectTenantBill(Map<CtBFTable, Map<String, CtBillEntryInfo>> currTenantBillIdMap, CtBFRowId ctBFRowId) {
        CtBFTable ctBFTable = new CtBFTable(ctBFRowId.getTenantId(), ctBFRowId.getAccountId(), ctBFRowId.getMainEntityKey());
        if (currTenantBillIdMap.containsKey(ctBFTable)) {
            Map<String, CtBillEntryInfo> ctBillEntryInfoMap = currTenantBillIdMap.get(ctBFTable);
            if (ctBillEntryInfoMap.containsKey(ctBFRowId.getEntityKey())) {
                CtBillEntryInfo ctBillEntryInfo = ctBillEntryInfoMap.get(ctBFRowId.getEntityKey());
                ctBillEntryInfo.getBillIds().add(ctBFRowId.getBillId());
                ctBillEntryInfo.getEntryIds().add(ctBFRowId.getEntryId());
            } else {
                CtBillEntryInfo ctBillEntryInfo = new CtBillEntryInfo();
                ctBillEntryInfo.setMainEntityKey(ctBFRowId.getMainEntityKey());
                ctBillEntryInfo.setEntryKey(ctBFRowId.getEntityKey());
                ctBillEntryInfo.getBillIds().add(ctBFRowId.getBillId());
                ctBillEntryInfo.getEntryIds().add(ctBFRowId.getEntryId());
                ctBillEntryInfoMap.put(ctBFRowId.getEntityKey(), ctBillEntryInfo);
            }
        } else {
            CtBillEntryInfo ctBillEntryInfo = new CtBillEntryInfo();
            ctBillEntryInfo.setMainEntityKey(ctBFRowId.getMainEntityKey());
            ctBillEntryInfo.setEntryKey(ctBFRowId.getEntityKey());
            ctBillEntryInfo.getBillIds().add(ctBFRowId.getBillId());
            ctBillEntryInfo.getEntryIds().add(ctBFRowId.getEntryId());
            HashMap<String, CtBillEntryInfo> ctBillEntryInfoMap = new HashMap<String, CtBillEntryInfo>();
            ctBillEntryInfoMap.put(ctBFRowId.getEntityKey(), ctBillEntryInfo);
            currTenantBillIdMap.putIfAbsent(ctBFTable, ctBillEntryInfoMap);
        }
    }

    private static void collectcurrTenantBill(Map<CtBFTable, Map<String, CtBillEntryInfo>> currTenantBillIdMap, CtEntryLkDownQueryArgs ctEntryLkDownQueryArgs) {
        CtBFTable ctBFTable = new CtBFTable(ctEntryLkDownQueryArgs.getsTenantCode(), ctEntryLkDownQueryArgs.getsAccountId(), ctEntryLkDownQueryArgs.getsMainEntityKey());
        if (currTenantBillIdMap.containsKey(ctBFTable)) {
            Map<String, CtBillEntryInfo> ctBillEntryInfoMap = currTenantBillIdMap.get(ctBFTable);
            if (ctBillEntryInfoMap.containsKey(ctEntryLkDownQueryArgs.getsEntryKey())) {
                CtBillEntryInfo ctBillEntryInfo = ctBillEntryInfoMap.get(ctEntryLkDownQueryArgs.getsEntryKey());
                ctBillEntryInfo.getBillIds().addAll(ctEntryLkDownQueryArgs.getsBillIds());
                ctBillEntryInfo.getEntryIds().addAll(ctEntryLkDownQueryArgs.getsEntryIds());
            } else {
                CtBillEntryInfo ctBillEntryInfo = new CtBillEntryInfo(ctEntryLkDownQueryArgs.getsMainEntityKey(), ctEntryLkDownQueryArgs.getsEntryKey(), ctEntryLkDownQueryArgs.getsBillIds(), ctEntryLkDownQueryArgs.getsEntryIds());
                ctBillEntryInfoMap.put(ctEntryLkDownQueryArgs.getsEntryKey(), ctBillEntryInfo);
            }
        } else {
            CtBillEntryInfo ctBillEntryInfo = new CtBillEntryInfo(ctEntryLkDownQueryArgs.getsMainEntityKey(), ctEntryLkDownQueryArgs.getsEntryKey(), ctEntryLkDownQueryArgs.getsBillIds(), ctEntryLkDownQueryArgs.getsEntryIds());
            HashMap<String, CtBillEntryInfo> ctBillEntryInfoMap = new HashMap<String, CtBillEntryInfo>();
            ctBillEntryInfoMap.put(ctEntryLkDownQueryArgs.getsEntryKey(), ctBillEntryInfo);
            currTenantBillIdMap.putIfAbsent(ctBFTable, ctBillEntryInfoMap);
        }
    }

    private static void collectcurrTenantBill(Map<CtBFTable, Map<String, CtBillEntryInfo>> currTenantBillIdMap, CtEntryLkUpQueryArgs ctEntryLkUpQueryArgs) {
        CtBFTable ctBFTable = new CtBFTable(ctEntryLkUpQueryArgs.gettTenantCode(), ctEntryLkUpQueryArgs.gettAccountId(), ctEntryLkUpQueryArgs.gettMainEntityKey());
        if (currTenantBillIdMap.containsKey(ctBFTable)) {
            Map<String, CtBillEntryInfo> ctBillEntryInfoMap = currTenantBillIdMap.get(ctBFTable);
            if (ctBillEntryInfoMap.containsKey(ctEntryLkUpQueryArgs.gettEntryKey())) {
                CtBillEntryInfo ctBillEntryInfo = ctBillEntryInfoMap.get(ctEntryLkUpQueryArgs.gettEntryKey());
                ctBillEntryInfo.getBillIds().addAll(ctEntryLkUpQueryArgs.gettBillIds());
                ctBillEntryInfo.getEntryIds().addAll(ctEntryLkUpQueryArgs.gettEntryIds());
            } else {
                CtBillEntryInfo ctBillEntryInfo = new CtBillEntryInfo(ctEntryLkUpQueryArgs.gettMainEntityKey(), ctEntryLkUpQueryArgs.gettEntryKey(), ctEntryLkUpQueryArgs.gettBillIds(), ctEntryLkUpQueryArgs.gettEntryIds());
                ctBillEntryInfoMap.put(ctEntryLkUpQueryArgs.gettEntryKey(), ctBillEntryInfo);
            }
        } else {
            CtBillEntryInfo ctBillEntryInfo = new CtBillEntryInfo(ctEntryLkUpQueryArgs.gettMainEntityKey(), ctEntryLkUpQueryArgs.gettEntryKey(), ctEntryLkUpQueryArgs.gettBillIds(), ctEntryLkUpQueryArgs.gettEntryIds());
            HashMap<String, CtBillEntryInfo> ctBillEntryInfoMap = new HashMap<String, CtBillEntryInfo>();
            ctBillEntryInfoMap.put(ctEntryLkUpQueryArgs.gettEntryKey(), ctBillEntryInfo);
            currTenantBillIdMap.putIfAbsent(ctBFTable, ctBillEntryInfoMap);
        }
    }

    public static List<CtBFRow> loadEntryLinkDownDirt(CtEntryLkDownQueryArgs ctEntryLkDownQueryArgs) {
        List ctRows;
        CtBusinessFlowEntryDataService service = new CtBusinessFlowEntryDataService();
        ArrayList<CtBFRow> allRows = new ArrayList<CtBFRow>();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("botp_track_only_dirt_link", String.valueOf(true));
        List rows = service.loadLinkRowUpNodes(ctEntryLkDownQueryArgs.getsMainEntityKey(), ctEntryLkDownQueryArgs.getsEntryKey(), ctEntryLkDownQueryArgs.getsBillIds().toArray(new Long[0]), ctEntryLkDownQueryArgs.getsEntryIds().toArray(new Long[0]), operateOption);
        if (CollectionUtils.isNotEmpty((Collection)rows)) {
            allRows.addAll(rows);
        }
        if (CollectionUtils.isNotEmpty((Collection)(ctRows = service.getTenantDirtEntryLkDown(ctEntryLkDownQueryArgs)))) {
            allRows.addAll(ctRows);
        }
        List<SyncRoute> syncRoutes = CtBotpRouteManage.getBillSyncRouteDown(RequestContext.get().getTenantId(), RequestContext.get().getAccountId(), ctEntryLkDownQueryArgs.getsMainEntityKey(), ctEntryLkDownQueryArgs.getsBillIds());
        for (SyncRoute syncRoute : syncRoutes) {
            if (syncRoute.getStenantCode().equals(syncRoute.getTtenantCode()) && syncRoute.getsAccountId().equals(syncRoute.gettAccountId())) continue;
            CtEntryLkDownReq ctLkDownQueryReq = new CtEntryLkDownReq();
            ctLkDownQueryReq.setsTenantCode(syncRoute.getStenantCode());
            ctLkDownQueryReq.setsAccountId(syncRoute.getsAccountId());
            ArrayList<CtEntityEntryInfo> ctEntityEntryInfos = new ArrayList<CtEntityEntryInfo>();
            CtEntityEntryInfo ctEntityEntryInfo = new CtEntityEntryInfo(ctEntryLkDownQueryArgs.getsMainEntityKey(), ctEntryLkDownQueryArgs.getsEntryKey(), ctEntryLkDownQueryArgs.getsBillIds(), ctEntryLkDownQueryArgs.getsEntryIds());
            ctEntityEntryInfos.add(ctEntityEntryInfo);
            ctLkDownQueryReq.setCtEntityEntryInfos(ctEntityEntryInfos);
            ctLkDownQueryReq.setOnlyDirtTarget(Boolean.TRUE);
            String result = CtBotpApiUtils.post(syncRoute.getTtenantCode(), syncRoute.gettAccountId(), CtApiUrlEnum.GETCTENTRYLKDOWN, SerializationUtils.toJsonString((Object)ctLkDownQueryReq));
            if (StringUtils.isBlank((CharSequence)result)) {
                log.debug("\u6267\u884c\u4e0b\u67e5OpenApi\u65f6\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4e0b\u6e38\u79df\u6237\u7cfb\u7edf\u662f\u5426\u5f02\u5e38\u3002");
                continue;
            }
            Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
            CtEntryLkDownRes ctBillLkDownRes = (CtEntryLkDownRes)JSON.parseObject((String)JSON.toJSONString(openApiResult.get("data")), CtEntryLkDownRes.class);
            List ctBFRows = ctBillLkDownRes.getCtBFRowList();
            if (!CollectionUtils.isNotEmpty((Collection)ctBFRows)) continue;
            allRows.addAll(ctBFRows);
        }
        return allRows;
    }

    private static List<CtBFRow> getCtBillLkDownDirtForApi(String sTenantCode, String sAccountId, String entityNumber, Long[] billIds) {
        ArrayList<CtBFRow> ctBFRows = new ArrayList<CtBFRow>(8);
        CtLkDownQueryArgs args = new CtLkDownQueryArgs();
        args.setsTenantCode(sTenantCode);
        args.setsAccountId(sAccountId);
        args.setsEntityKey(entityNumber);
        args.setsBillIds(Arrays.asList(billIds));
        List ctBillLkList = CtBillLinkService.getCtDirtBillLkDown((CtLkDownQueryArgs)args);
        if (CollectionUtils.isEmpty((Collection)ctBillLkList)) {
            return ctBFRows;
        }
        for (CtBillLk ctBillLk : ctBillLkList) {
            CtBFRowId sRowId = new CtBFRowId(ctBillLk.getsTenantCode(), ctBillLk.getsAccountId(), ctBillLk.getSTableId(), ctBillLk.getSBillId(), ctBillLk.getSTableId(), ctBillLk.getSBillId());
            sRowId.setMainEntityKey(ctBillLk.getsEntityKey());
            if (sRowId.getTenantId().equals(RequestContext.get().getTenantId()) && sRowId.getAccountId().equals(RequestContext.get().getAccountId())) {
                sRowId.setMainEntityName(EntityMetadataCache.getDataEntityType((String)ctBillLk.getsEntityKey()).getDisplayName().getLocaleValue());
            }
            CtBFRowId rowId = new CtBFRowId(ctBillLk.gettTenantCode(), ctBillLk.gettAccountId(), ctBillLk.getTTableId(), ctBillLk.getTBillId(), ctBillLk.getTTableId(), ctBillLk.getTBillId());
            rowId.setMainEntityKey(ctBillLk.gettEntityKey());
            if (rowId.getTenantId().equals(RequestContext.get().getTenantId()) && rowId.getAccountId().equals(RequestContext.get().getAccountId())) {
                rowId.setMainEntityName(EntityMetadataCache.getDataEntityType((String)ctBillLk.gettEntityKey()).getDisplayName().getLocaleValue());
            }
            CtBFRow bfRow = new CtBFRow();
            bfRow.setSId(sRowId);
            bfRow.setId(rowId);
            ctBFRows.add(bfRow);
        }
        return ctBFRows;
    }

    public static CtBillLkDownRes loadBillLinkDownForApi(String sTenantCode, String sAccountId, String entityNumber, Long[] billIds, boolean onlyDirtTarget) {
        CtBillLkDownRes ctBillLkDownRes = new CtBillLkDownRes();
        List<Object> ctBFRows = new ArrayList();
        if (onlyDirtTarget) {
            ctBFRows = CtEntryLkQueryService.getCtBillLkDownDirtForApi(sTenantCode, sAccountId, entityNumber, billIds);
        }
        ctBillLkDownRes.setCtBFRowList(ctBFRows);
        ArrayList<CtTableInfoRes> ctTableInfoResList = new ArrayList<CtTableInfoRes>(16);
        CtEntryLkQueryService.addCtTableInfo(sTenantCode, sAccountId, entityNumber, ctTableInfoResList);
        HashMap<String, String> nameMap = new HashMap<String, String>(16);
        for (CtBFRow ctBFRow : ctBFRows) {
            if (MapUtils.isNotEmpty(nameMap)) break;
            if (!ctBFRow.getId().getTenantId().equals(RequestContext.get().getTenantId()) || !ctBFRow.getId().getAccountId().equals(RequestContext.get().getAccountId())) continue;
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)ctBFRow.getId().getMainEntityKey());
            String name = mainEntityType.getDisplayName().getLocaleValue();
            nameMap.put(entityNumber, name);
            CtTableInfoRes ctTableInfoRes = new CtTableInfoRes();
            ctTableInfoRes.setTenantId(ctBFRow.getId().getTenantId());
            ctTableInfoRes.setAccountId(ctBFRow.getId().getAccountId());
            ctTableInfoRes.setMainEntityKey(ctBFRow.getId().getMainEntityKey());
            ctTableInfoRes.setName(name);
            ctTableInfoResList.add(ctTableInfoRes);
        }
        ctBillLkDownRes.setCtTableInfos(ctTableInfoResList);
        return ctBillLkDownRes;
    }

    public static CtBillLkUpRes getEntityNameForApi(String tTenantCode, String tAccountId, String entityNumber) {
        CtBillLkUpRes ctBillLkUpRes = new CtBillLkUpRes();
        ArrayList<CtTableInfoRes> ctTableInfoResList = new ArrayList<CtTableInfoRes>(16);
        CtEntryLkQueryService.addCtTableInfo(tTenantCode, tAccountId, entityNumber, ctTableInfoResList);
        ctBillLkUpRes.setCtTableInfos(ctTableInfoResList);
        return ctBillLkUpRes;
    }

    public static List<CtBFRow> loadEntryLinkUpRowsFull(CtEntryLkUpQueryArgs ctEntryLkUpQueryArgs) {
        CtBusinessFlowEntryDataService service = new CtBusinessFlowEntryDataService();
        List allRows = service.loadCtEntryLinkUpRows(ctEntryLkUpQueryArgs);
        HashMap<CtBFTable, Map<String, CtBillEntryInfo>> ctBfRowMap = new HashMap<CtBFTable, Map<String, CtBillEntryInfo>>();
        CtEntryLkQueryService.collectcurrTenantBill(ctBfRowMap, ctEntryLkUpQueryArgs);
        for (CtBFRow ctBFRow : allRows) {
            CtEntryLkQueryService.collectTenantBill(ctBfRowMap, ctBFRow.getSId());
            CtEntryLkQueryService.collectTenantBill(ctBfRowMap, ctBFRow.getId());
        }
        if (MapUtils.isNotEmpty(ctBfRowMap)) {
            List<SyncRoute> syncRoutes = CtBotpRouteManage.getEntrySyncRouteUpBatch(ctBfRowMap);
            for (SyncRoute syncRoute : syncRoutes) {
                CtBFTable tCtBFTable;
                Map ctBillEntryInfoMap;
                if (syncRoute.getStenantCode().equals(syncRoute.getTtenantCode()) && syncRoute.getsAccountId().equals(syncRoute.gettAccountId()) || MapUtils.isEmpty((Map)(ctBillEntryInfoMap = (Map)ctBfRowMap.get(tCtBFTable = new CtBFTable(syncRoute.getStenantCode(), syncRoute.getsAccountId(), syncRoute.getsEntityKey()))))) continue;
                CtEntryLkUpReq ctLkUpQueryArgs = new CtEntryLkUpReq();
                ctLkUpQueryArgs.settTenantCode(syncRoute.getStenantCode());
                ctLkUpQueryArgs.settAccountId(syncRoute.getsAccountId());
                ctLkUpQueryArgs.settEntityKey(syncRoute.getsEntityKey());
                ArrayList<CtBillEntryInfo> ctBillEntryInfos = new ArrayList<CtBillEntryInfo>(ctBillEntryInfoMap.values());
                ctLkUpQueryArgs.setCtEntityEntryInfos(CtEntryLkQueryService.getCtEntityEntryInfos(ctBillEntryInfos));
                String result = CtBotpApiUtils.post(syncRoute.getStenantCode(), syncRoute.getsAccountId(), CtApiUrlEnum.GETCTENTRYLKUP, SerializationUtils.toJsonString((Object)ctLkUpQueryArgs));
                Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
                CtEntryLkUpRes ctBillLkUpRes = (CtEntryLkUpRes)JSON.parseObject((String)JSON.toJSONString(openApiResult.get("data")), CtEntryLkUpRes.class);
                List ctBFRows = ctBillLkUpRes.getCtBFRowList();
                if (!CollectionUtils.isNotEmpty((Collection)ctBFRows)) continue;
                allRows.addAll(ctBFRows);
            }
        }
        return allRows;
    }

    public static CtEntryLkUpRes loadEntryLinkUpRowsFullForApi(CtEntryLkUpReq ctEntryLkUpReq) {
        CtBusinessFlowEntryDataService service = new CtBusinessFlowEntryDataService();
        ArrayList allRows = new ArrayList();
        HashMap<CtBFTable, Map<String, CtBillEntryInfo>> ctBfRowMap = new HashMap<CtBFTable, Map<String, CtBillEntryInfo>>();
        for (CtEntityEntryInfo ctEntityEntryInfo : ctEntryLkUpReq.getCtEntityEntryInfos()) {
            CtEntryLkUpQueryArgs ctEntryLkUpQueryArgs = new CtEntryLkUpQueryArgs();
            ctEntryLkUpQueryArgs.settTenantCode(ctEntryLkUpReq.gettTenantCode());
            ctEntryLkUpQueryArgs.settAccountId(ctEntryLkUpReq.gettAccountId());
            ctEntryLkUpQueryArgs.settMainEntityKey(ctEntityEntryInfo.getMainEntityKey());
            ctEntryLkUpQueryArgs.settEntryKey(ctEntityEntryInfo.getEntryKey());
            ctEntryLkUpQueryArgs.settBillIds(ctEntityEntryInfo.getBillIds());
            ctEntryLkUpQueryArgs.settEntryIds(ctEntityEntryInfo.getEntryIds());
            List ctBFRows = service.loadCtEntryLinkUpRows(ctEntryLkUpQueryArgs);
            allRows.addAll(ctBFRows);
            CtEntryLkQueryService.collectcurrTenantBill(ctBfRowMap, ctEntryLkUpQueryArgs);
            for (CtBFRow ctBFRow : allRows) {
                CtEntryLkQueryService.collectTenantBill(ctBfRowMap, ctBFRow.getSId());
                CtEntryLkQueryService.collectTenantBill(ctBfRowMap, ctBFRow.getId());
            }
        }
        if (MapUtils.isNotEmpty(ctBfRowMap)) {
            List<SyncRoute> syncRoutes = CtBotpRouteManage.getEntrySyncRouteUpBatch(ctBfRowMap);
            for (SyncRoute syncRoute : syncRoutes) {
                CtBFTable tCtBFTable;
                Map ctBillEntryInfoMap;
                if (syncRoute.getStenantCode().equals(syncRoute.getTtenantCode()) && syncRoute.getsAccountId().equals(syncRoute.gettAccountId()) || MapUtils.isEmpty((Map)(ctBillEntryInfoMap = (Map)ctBfRowMap.get(tCtBFTable = new CtBFTable(syncRoute.getStenantCode(), syncRoute.getsAccountId(), syncRoute.getsEntityKey()))))) continue;
                CtEntryLkUpReq ctLkUpQueryArgs = new CtEntryLkUpReq();
                ctLkUpQueryArgs.settTenantCode(syncRoute.getStenantCode());
                ctLkUpQueryArgs.settAccountId(syncRoute.getsAccountId());
                ctLkUpQueryArgs.settEntityKey(syncRoute.getsEntityKey());
                ArrayList<CtBillEntryInfo> ctBillEntryInfos = new ArrayList<CtBillEntryInfo>(ctBillEntryInfoMap.values());
                ctLkUpQueryArgs.setCtEntityEntryInfos(CtEntryLkQueryService.getCtEntityEntryInfos(ctBillEntryInfos));
                String result = CtBotpApiUtils.post(syncRoute.getStenantCode(), syncRoute.getsAccountId(), CtApiUrlEnum.GETCTENTRYLKUP, SerializationUtils.toJsonString((Object)ctLkUpQueryArgs));
                Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
                CtEntryLkUpRes ctBillLkUpRes = (CtEntryLkUpRes)JSON.parseObject((String)JSON.toJSONString(openApiResult.get("data")), CtEntryLkUpRes.class);
                List ctBFRows = ctBillLkUpRes.getCtBFRowList();
                if (!CollectionUtils.isNotEmpty((Collection)ctBFRows)) continue;
                allRows.addAll(ctBFRows);
            }
        }
        CtEntryLkUpRes ctEntryLkUpRes = new CtEntryLkUpRes();
        ctEntryLkUpRes.setCtBFRowList(allRows);
        return ctEntryLkUpRes;
    }

    public static List<CtBFRow> loadEntryLinkUpRowsDirt(CtEntryLkUpQueryArgs ctEntryLkUpQueryArgs) {
        CtBusinessFlowEntryDataService service = new CtBusinessFlowEntryDataService();
        List allRows = service.loadCtEntryLinkUpDirt(ctEntryLkUpQueryArgs);
        return allRows;
    }

    private static void addCtTableInfo(String tenantCode, String accountId, String entityNumber, List<CtTableInfoRes> ctTableInfoResList) {
        CtTableInfoRes ctTableInfoRes = new CtTableInfoRes();
        ctTableInfoRes.setTenantId(tenantCode);
        ctTableInfoRes.setAccountId(accountId);
        ctTableInfoRes.setMainEntityKey(entityNumber);
        if (tenantCode.equals(RequestContext.get().getTenantId()) && accountId.equals(RequestContext.get().getAccountId())) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            ctTableInfoRes.setName(mainEntityType.getDisplayName().getLocaleValue());
            ctTableInfoResList.add(ctTableInfoRes);
        }
    }
}

