/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.sync;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ctbotp.CtDataEntity;
import kd.bos.entity.ctbotp.CtDataEntityField;
import kd.bos.entity.ctbotp.constants.SyncStatusEnum;
import kd.bos.entity.ctbotp.link.CtBillLk;
import kd.bos.entity.ctbotp.runtime.CtSyncArgs;
import kd.bos.entity.ctbotp.sync.SyncLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.sync.AbstractCtSyncEngine;
import kd.bos.service.ctbotp.utils.CtDescUtils;
import kd.bos.util.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class CtSyncEngineBatchImpl
extends AbstractCtSyncEngine {
    private static final Log log = LogFactory.getLog(CtSyncEngineBatchImpl.class);
    private Map<Long, List<Long>> firstMap = new HashMap<Long, List<Long>>();
    private Map<Long, List<Long>> lastMap = new HashMap<Long, List<Long>>();

    @Override
    public List<SyncLog> beforeAddGSyncLog(CtSyncArgs args) {
        List ctDataEntities = args.getData();
        for (CtDataEntity ctDataEntity : ctDataEntities) {
            if (ctDataEntity.isFirstBatch()) {
                this.firstMap.put(ctDataEntity.getId(), this.setSBillId(ctDataEntity));
            }
            if (!ctDataEntity.isExistNextBatch()) continue;
            this.lastMap.put(ctDataEntity.getId(), this.setSBillId(ctDataEntity));
        }
        List gSyncLogs = args.getsSyncLogs();
        ArrayList<SyncLog> filterGSyncLogs = new ArrayList<SyncLog>(16);
        for (SyncLog syncLog : gSyncLogs) {
            syncLog.setDesc(CtDescUtils.getDesc());
            if (!MapUtils.isNotEmpty(this.firstMap) || !this.firstMap.containsKey(syncLog.getTbillId())) continue;
            filterGSyncLogs.add(syncLog);
        }
        return filterGSyncLogs;
    }

    private List<Long> setSBillId(CtDataEntity ctDataEntity) {
        List ctDataEntities = ctDataEntity.getChildEntity("billhead_lk");
        ArrayList<Long> billIds = new ArrayList<Long>();
        for (CtDataEntity ctLink : ctDataEntities) {
            if (CollectionUtils.isEmpty((Collection)ctLink.getFields())) continue;
            for (CtDataEntityField ctDataEntityField : ctLink.getFields()) {
                if (!"sBillId".equals(ctDataEntityField.getName())) continue;
                Long sBillId = Long.valueOf(ctDataEntityField.getValue().getValue());
                billIds.add(sBillId);
            }
        }
        return billIds;
    }

    public List<CtBillLk> beforeAddBillLks(List<CtBillLk> ctBillLks) {
        ArrayList<CtBillLk> filterCtBillLks = new ArrayList<CtBillLk>(16);
        for (CtBillLk ctBillLk : ctBillLks) {
            if (!MapUtils.isNotEmpty(this.lastMap) || !this.lastMap.containsKey(ctBillLk.getSBillId())) continue;
            filterCtBillLks.add(ctBillLk);
        }
        return filterCtBillLks;
    }

    @Override
    public void updateSucccessStatus(SyncLog gSyncLog, DynamicObject obj) {
        if (MapUtils.isNotEmpty(this.lastMap) && this.lastMap.containsKey(gSyncLog)) {
            obj.set("status", (Object)SyncStatusEnum.S.getStatus());
        }
    }
}

