/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.synclog;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.ctbotp.sync.SSyncLogService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.apiparam.CtQuerySyncResultReq;
import kd.bos.entity.ctbotp.apiresponse.CtQuerySyncResultRes;
import kd.bos.entity.ctbotp.constants.CtApiUrlEnum;
import kd.bos.entity.ctbotp.constants.CtSyncLogConst;
import kd.bos.entity.ctbotp.result.CtSyncLogResultItem;
import kd.bos.entity.ctbotp.runtime.CtTenantTable;
import kd.bos.entity.ctbotp.sync.SyncLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.utils.CtBotpApiUtils;
import kd.bos.servicehelper.CtSyncLogServiceHelper;
import kd.bos.util.CollectionUtils;

public class CtBotpQueryRstService {
    private static Log log = LogFactory.getLog(CtBotpQueryRstService.class);

    public static CtQuerySyncResultRes getCtSyncLogResult(CtQuerySyncResultReq ctQuerySyncResultReq) {
        CtQuerySyncResultRes ctSyncLogResult = new CtQuerySyncResultRes();
        ArrayList<CtSyncLogResultItem> ctSyncLogResultItems = new ArrayList<CtSyncLogResultItem>(16);
        List syncLogs = CtSyncLogServiceHelper.getTSyncLogsByUniqueKeys((List)ctQuerySyncResultReq.getUniqueKeys());
        for (SyncLog syncLog : syncLogs) {
            CtSyncLogResultItem ctSyncLogResultItem = new CtSyncLogResultItem();
            ctSyncLogResultItem.setId(syncLog.getId());
            ctSyncLogResultItem.setDesc(syncLog.getDesc());
            ctSyncLogResultItem.setStatus(syncLog.getStatus());
            ctSyncLogResultItem.setTbillId(syncLog.getTbillId());
            ctSyncLogResultItem.setTbillNo(syncLog.getTbillNo());
            ctSyncLogResultItem.setUniqueKey(syncLog.getUniqueKey());
            ctSyncLogResultItems.add(ctSyncLogResultItem);
        }
        ctSyncLogResult.setCtSyncResultItems(ctSyncLogResultItems);
        return ctSyncLogResult;
    }

    public static void updateCtSSyncLogResult(List<SyncLog> syncLogs) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(syncLogs)) {
            return;
        }
        HashMap ctTenantTableListMap = new HashMap(16);
        HashMap<String, SyncLog> syncLogMap = new HashMap<String, SyncLog>(16);
        for (SyncLog syncLog : syncLogs) {
            syncLogMap.put(syncLog.getUniqueKey(), syncLog);
            CtTenantTable ctTenantTable = new CtTenantTable(syncLog.getTtenantCode(), syncLog.gettAccountId());
            List syncLogList = ctTenantTableListMap.containsKey(ctTenantTable) ? (List)ctTenantTableListMap.get(ctTenantTable) : new ArrayList();
            syncLogList.add(syncLog);
            ctTenantTableListMap.put(ctTenantTable, syncLogList);
        }
        for (Map.Entry entry : ctTenantTableListMap.entrySet()) {
            List syncLogList = (List)entry.getValue();
            CtTenantTable ctTenantTable = (CtTenantTable)entry.getKey();
            List uniqueKeyList = syncLogList.stream().map(a -> a.getUniqueKey()).collect(Collectors.toList());
            CtQuerySyncResultReq ctQuerySyncResultReq = new CtQuerySyncResultReq();
            ctQuerySyncResultReq.setUniqueKeys(uniqueKeyList);
            CtQuerySyncResultRes ctQuerySyncResultRes = null;
            try {
                String result = CtBotpApiUtils.post(ctTenantTable.getTenantId(), ctTenantTable.getAccountId(), CtApiUrlEnum.QUERYSYNCRESULT, SerializationUtils.toJsonString((Object)ctQuerySyncResultReq));
                Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
                ctQuerySyncResultRes = (CtQuerySyncResultRes)JSON.parseObject((String)JSON.toJSONString(openApiResult.get("data")), CtQuerySyncResultRes.class);
            }
            catch (Exception e) {
                log.error("ctTenantTable IS " + SerializationUtils.toJsonString((Object)ctTenantTable));
                log.error((Throwable)e);
            }
            if (ctQuerySyncResultRes == null || !org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)ctQuerySyncResultRes.getCtSyncResultItems())) continue;
            for (CtSyncLogResultItem ctSyncLogResultItem : ctQuerySyncResultRes.getCtSyncResultItems()) {
                SyncLog syncLog = (SyncLog)syncLogMap.get(ctSyncLogResultItem.getUniqueKey());
                syncLog.setStatus(ctSyncLogResultItem.getStatus());
                syncLog.setDesc(ctSyncLogResultItem.getDesc());
                syncLog.setTbillId(ctSyncLogResultItem.getTbillId());
                syncLog.setTbillNo(ctSyncLogResultItem.getTbillNo());
            }
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)CtSyncLogConst.SYNC_FORMID_S);
        ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>(16);
        Date now = new Date();
        for (SyncLog sSyncLog : syncLogs) {
            DynamicObject obj = new DynamicObject((DynamicObjectType)mainType);
            obj.set("id", (Object)sSyncLog.getId());
            obj.set("updatetime", (Object)now);
            obj.set("tbillId", (Object)sSyncLog.getTbillId());
            obj.set("tbillno", (Object)sSyncLog.getTbillNo());
            obj.set("status", (Object)sSyncLog.getStatus());
            if (StringUtils.isNotBlank((CharSequence)sSyncLog.getDesc())) {
                obj.set("desc_tag", (Object)sSyncLog.getDesc());
            }
            obj.set("updatestatuscount", (Object)(sSyncLog.getUpdateStatusCount() + 1));
            arrayList.add(obj);
        }
        if (CollectionUtils.isNotEmpty(arrayList)) {
            SSyncLogService.create().update(arrayList);
        }
    }
}

