/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.CtLinkSetItemElement;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.ctbotp.link.CtBillLk;
import kd.bos.entity.ctbotp.log.CtBOTPLog;
import kd.bos.entity.param.CustomParam;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.param.impl.ParameterReaderServiceImpl;
import kd.bos.service.ctbotp.track.CtBFTrackerBatchContext;
import kd.bos.service.ctbotp.track.CtBFTrackerBatchResult;
import kd.bos.service.ctbotp.track.CtBFTrackerContext;
import kd.bos.service.ctbotp.track.CtBFTrackerOpContext;
import kd.bos.service.ctbotp.track.CtBFTrackerResult;
import kd.bos.service.ctbotp.track.CtLinkItemContext;
import kd.bos.service.ctbotp.track.actions.CtBFTrackBatchExecuter;
import kd.bos.service.ctbotp.track.bizentity.CtAED;
import kd.bos.service.ctbotp.track.helper.CtBFTrackerDbService;
import kd.bos.service.ctbotp.track.helper.CtBillTrackerBuilder;
import kd.bos.service.ctbotp.track.opcontroller.ICtOpController;
import kd.bos.servicehelper.CtConvertMetaServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

class CtBFTracker {
    private static final String BFTRACKER_EXECUTE_LINK_ITEM = "BFTracker.executeLinkItem(linkItemContext)";
    protected CtBFTrackerContext trackerContext;
    protected CtBFTrackerOpContext trackerOpContext;
    protected String targetEntityNumber;
    protected CtBFTrackerResult trackerResult;
    protected CtBFTrackerDbService dbService;
    protected CtBillTrackerBuilder billTrackerHelper;
    private static final String CUSTOM_PARAM_KEY_APPEND_ENTRYROW = "botpAppendEntryRowCtr";
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"BFTracker", (int)32);

    public CtBFTracker(CtBFTrackerContext trackerContext, CtBFTrackerResult trackerResult, ICtOpController opController, CtBFTrackerDbService dbService) {
        this.trackerContext = trackerContext;
        this.trackerResult = trackerResult;
        this.dbService = dbService;
        this.trackerOpContext = new CtBFTrackerOpContext(trackerContext, opController);
        if (this.trackerContext == null || opController == null || this.dbService == null) {
            return;
        }
        this.trackerOpContext.getOpController().setContext(this.trackerContext, this.dbService);
        this.targetEntityNumber = this.trackerContext.getTargetMainType().getName();
        this.billTrackerHelper = new CtBillTrackerBuilder(this.dbService);
    }

    public void execute(DynamicObject[] dataEntities) {
        this.trackerContext.getOperateLog().beginMothed("BFTracker.execute(dataEntities)", null);
        Long[] billIds = new Long[dataEntities.length];
        int i = 0;
        for (DynamicObject dataEntity : dataEntities) {
            billIds[i] = (Long)dataEntity.getPkValue();
            ++i;
        }
        this.trackerOpContext.setBillIds(billIds);
        this.trackerOpContext.setDataEntities(dataEntities);
        this.trackerOpContext.setHasSnapshot(false);
        for (CtLinkSetItemElement linkSetItem : this.trackerContext.getLinkSet().getItems()) {
            CtLinkItemContext ctLinkItemContext = CtLinkItemContext.create(this.trackerContext, this.trackerOpContext, linkSetItem);
            this.trackerContext.getPlugInProxy().setContext(this.trackerContext.getTargetSubMainType(), this.trackerContext.getOpType().name(), linkSetItem);
            this.executeLinkItem(ctLinkItemContext);
        }
        if (this.trackerOpContext.isHasSnapshot() || this.getCustomParamAppendEntryRow() && this.isAppendEntryRow()) {
            TableDefine mainTableDefine = CtConvertMetaServiceHelper.loadTableDefine((String)this.targetEntityNumber, (String)this.targetEntityNumber);
            Long mainTableId = mainTableDefine.getTableId();
            HashSet<Long> sMainTableIds = new HashSet<Long>(this.trackerOpContext.getHistSrcMainTableIds());
            HashSet<Long> sBillIds = new HashSet<Long>(this.trackerOpContext.getHistSrcBillIds());
            List<Object> histBillTrackerObjs = this.dbService.readBillTracker(sMainTableIds, sBillIds, mainTableId, billIds);
            this.billTrackerHelper.buildHistBillTracker(histBillTrackerObjs);
        }
        CtAED<CtBillLk> aedBillTracker = this.billTrackerHelper.sync();
        this.applyBillTracker(aedBillTracker);
        this.trackerContext.getOperateLog().endMothed("BFTracker.execute(dataEntities)", null);
    }

    public void retry(CtBOTPLog[] wbLogs) {
    }

    private void executeLinkItem(CtLinkItemContext ctLinkItemContext) {
        if (this.trackerContext.getOperateLog().isWriteLog()) {
            String msg = String.format("BFTracker.executeLinkItem(linkItemContext): opControler =%s, linkSetItem = %s, billids(%s) = %s", this.trackerOpContext.getOpController().getClass().getSimpleName(), ctLinkItemContext.getLinkSetItem().getCtParentEntityKey(), this.trackerOpContext.getBillIds().length, this.trackerOpContext.getBillIds()[0]) + (this.trackerOpContext.getBillIds().length > 0 ? "..." : "");
            this.trackerContext.getOperateLog().beginMothed(BFTRACKER_EXECUTE_LINK_ITEM, msg);
        }
        ctLinkItemContext.splitPage(this.trackerOpContext.getDataEntities());
        if (ctLinkItemContext.isEmpty()) {
            this.trackerContext.getOperateLog().endMothed(BFTRACKER_EXECUTE_LINK_ITEM, "BFTracker.executeLinkItem(linkItemContext) return beacuse of entityIds is empty");
            return;
        }
        this.batchExecuteSync(ctLinkItemContext);
        this.trackerContext.getOperateLog().endMothed(BFTRACKER_EXECUTE_LINK_ITEM, null);
    }

    private void batchExecuteSync(CtLinkItemContext ctLinkItemContext) {
        ArrayList<CtBFTrackBatchExecuter> executers = new ArrayList<CtBFTrackBatchExecuter>(2);
        int batchCount = 1;
        CtBFTrackerBatchContext batchContext1 = new CtBFTrackerBatchContext(batchCount, null);
        CtBFTrackBatchExecuter batchExecuter1 = new CtBFTrackBatchExecuter(RequestContext.get(), this.trackerContext, this.trackerOpContext, ctLinkItemContext, batchContext1, this.trackerResult, this.billTrackerHelper);
        batchExecuter1.setSyncExecute(true);
        executers.add(batchExecuter1);
        Set<Long> entryIds = ctLinkItemContext.getNextPageEntryIds();
        while (!entryIds.isEmpty()) {
            CtBFTrackerBatchContext batchContext2 = new CtBFTrackerBatchContext(++batchCount, entryIds);
            CtBFTrackBatchExecuter batchExecuter2 = new CtBFTrackBatchExecuter(RequestContext.get(), this.trackerContext, this.trackerOpContext, ctLinkItemContext, batchContext2, this.trackerResult, this.billTrackerHelper);
            batchExecuter2.setSyncExecute(true);
            executers.add(batchExecuter2);
            entryIds = ctLinkItemContext.getNextPageEntryIds();
        }
        int finishBatchCount = 0;
        for (CtBFTrackBatchExecuter executer : executers) {
            CtBFTrackerBatchResult batchResult = executer.doActions();
            this.trackerContext.setProgressTip(String.format(ResManager.loadKDString((String)"\u5206\u6279\u53cd\u5199\uff0c\u5df2\u5b8c\u6210\u7b2c %1$s/%2$s \u6279", (String)"BFTracker_0", (String)"bos-mservice-botp", (Object[])new Object[0]), ++finishBatchCount, batchCount));
        }
    }

    private void batchExecuteAnsy(CtLinkItemContext ctLinkItemContext) {
        ArrayList<Future> results = new ArrayList<Future>(10);
        int batchCount = 1;
        CtBFTrackerBatchContext batchContext1 = new CtBFTrackerBatchContext(batchCount, null);
        CtBFTrackBatchExecuter batchExecuter1 = new CtBFTrackBatchExecuter(RequestContext.get(), this.trackerContext, this.trackerOpContext, ctLinkItemContext, batchContext1, this.trackerResult, this.billTrackerHelper);
        Future ret1 = threadPool.submit((Callable)batchExecuter1);
        results.add(ret1);
        Set<Long> entryIds = ctLinkItemContext.getNextPageEntryIds();
        while (!entryIds.isEmpty()) {
            CtBFTrackerBatchContext batchContext2 = new CtBFTrackerBatchContext(++batchCount, entryIds);
            CtBFTrackBatchExecuter batchExecuter2 = new CtBFTrackBatchExecuter(RequestContext.get(), this.trackerContext, this.trackerOpContext, ctLinkItemContext, batchContext2, this.trackerResult, this.billTrackerHelper);
            Future ret2 = threadPool.submit((Callable)batchExecuter2);
            results.add(ret2);
            entryIds = ctLinkItemContext.getNextPageEntryIds();
        }
        int finishBatchCount = 0;
        ArrayList<CtBFTrackerBatchResult> realResults = new ArrayList<CtBFTrackerBatchResult>(results.size());
        for (Future result : results) {
            CtBFTrackerBatchResult batchResult = null;
            try {
                batchResult = (CtBFTrackerBatchResult)result.get();
            }
            catch (InterruptedException ex) {
                batchResult = new CtBFTrackerBatchResult();
                batchResult.setException(ex);
            }
            catch (Throwable ex) {
                batchResult = new CtBFTrackerBatchResult();
                batchResult.setException(ex);
            }
            realResults.add(batchResult);
            this.trackerContext.setProgressTip(String.format(ResManager.loadKDString((String)"\u5206\u6279\u53cd\u5199\uff0c\u5df2\u5b8c\u6210\u7b2c %1$s/%2$s \u6279", (String)"BFTracker_0", (String)"bos-mservice-botp", (Object[])new Object[0]), ++finishBatchCount, batchCount));
        }
        for (CtBFTrackerBatchResult realResult : realResults) {
            if (realResult.getException() instanceof KDBizException) {
                throw new KDBizException(realResult.getException().getMessage());
            }
            if (realResult.getException() == null) continue;
            throw new KDException(realResult.getException(), BosErrorCode.executeBatch, new Object[]{realResult.getException().getMessage()});
        }
    }

    private void applyBillTracker(CtAED<CtBillLk> aed) {
    }

    private boolean isAppendEntryRow() {
        boolean appendEntryRow = false;
        if (this.trackerContext.getOption() != null) {
            appendEntryRow = Boolean.parseBoolean(this.trackerContext.getOption().getVariableValue("bos_save_appendentryrows", String.valueOf(false)));
        }
        return appendEntryRow;
    }

    private boolean getCustomParamAppendEntryRow() {
        boolean checkParamFlag = true;
        ParameterReaderServiceImpl service = new ParameterReaderServiceImpl();
        HashSet<String> set = new HashSet<String>(1);
        set.add(CUSTOM_PARAM_KEY_APPEND_ENTRYROW);
        CustomParam customParam = new CustomParam(set);
        Map map = service.loadCustomParameterFromCache(customParam);
        if (map != null && map.get(CUSTOM_PARAM_KEY_APPEND_ENTRYROW) != null) {
            checkParamFlag = Boolean.parseBoolean((String)map.get(CUSTOM_PARAM_KEY_APPEND_ENTRYROW));
        }
        return checkParamFlag;
    }
}

