/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.ctbotp.CtBOTPLogService;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.ctbotp.log.CtBOTPLog;
import kd.bos.entity.ctbotp.log.CtWBLogDetailInfo;
import kd.bos.entity.operate.OperationContext;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.botp.BFTrackerService;
import kd.bos.service.botp.track.BFTrackerOpType;
import kd.bos.service.ctbotp.track.CtBFTrackerEngine;

public class CtBFTrackerServiceImpl
implements BFTrackerService {
    private static final Log LOG = LogFactory.getLog(CtBFTrackerServiceImpl.class);

    public void draft(String entityNumber, DynamicObject[] dataEntities) {
        this.execute(entityNumber, dataEntities, BFTrackerOpType.Draft);
    }

    public void submit(String entityNumber, DynamicObject[] dataEntities) {
        this.execute(entityNumber, dataEntities, BFTrackerOpType.Save);
    }

    public void audit(String entityNumber, DynamicObject[] dataEntities) {
        this.execute(entityNumber, dataEntities, BFTrackerOpType.Audit);
    }

    public void unAudit(String entityNumber, DynamicObject[] dataEntities) {
        this.execute(entityNumber, dataEntities, BFTrackerOpType.UnAudit);
    }

    public void cancel(String entityNumber, DynamicObject[] dataEntities) {
        this.execute(entityNumber, dataEntities, BFTrackerOpType.Cancel);
    }

    public void delete(String entityNumber, DynamicObject[] dataEntities) {
        this.execute(entityNumber, dataEntities, BFTrackerOpType.Delete);
    }

    public void invokeWriteBack(String operationKey, String entityNumber, DynamicObject[] dataEntities) {
        BillEntityType mainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (mainType == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u4f20\u5165\u5355\u636e(%s)\u7684\u5143\u6570\u636e\u5bf9\u8c61", (String)"BFTrackerServiceImpl_0", (String)"bos-mservice-botp", (Object[])new Object[0]), entityNumber));
        }
        Map opMeta = EntityMetadataCache.getProvider().getDataEntityOperate(entityNumber, operationKey);
        if (opMeta == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e(%1$s)\u6ca1\u6709\u914d\u7f6e\u64cd\u4f5c(%2$s)", (String)"BFTrackerServiceImpl_1", (String)"bos-mservice-botp", (Object[])new Object[0]), mainType.getDisplayName().toString(), operationKey));
        }
        String type = (String)opMeta.get("type");
        BFTrackerOpType opType = BFTrackerOpType.Unknown;
        if ("draft".equalsIgnoreCase(type)) {
            opType = BFTrackerOpType.Draft;
        } else if ("save".equalsIgnoreCase(type) || "saveandnew".equalsIgnoreCase(type) || "submit".equalsIgnoreCase(type) || "submitandnew".equalsIgnoreCase(type)) {
            opType = BFTrackerOpType.Save;
        } else if ("audit".equalsIgnoreCase(type)) {
            opType = BFTrackerOpType.Audit;
        } else if ("unaudit".equalsIgnoreCase(type) || "unsubmit".equalsIgnoreCase(type)) {
            opType = BFTrackerOpType.UnAudit;
        } else if ("delete".equalsIgnoreCase(type)) {
            opType = BFTrackerOpType.Delete;
        } else if ("cancel".equalsIgnoreCase(type)) {
            opType = BFTrackerOpType.Cancel;
        }
        if (opType == BFTrackerOpType.Unknown) {
            return;
        }
        CtBFTrackerEngine trackerEngine = new CtBFTrackerEngine((IDataEntityType)mainType, opType, opMeta, null);
        trackerEngine.execute(dataEntities);
        trackerEngine.saveBeforeTrans();
        trackerEngine.saveTrans();
        trackerEngine.saveAfterTrans();
    }

    public String retryWriteBack(String dbRouteKey, Long[] wbLogIds, OperateOption option) {
        CtBOTPLogService botpLogService;
        CtBOTPLog[] wbLogs;
        OperationResult opResult = new OperationResult();
        opResult.setBillCount(wbLogIds.length);
        if (StringUtils.isBlank((CharSequence)dbRouteKey)) {
            OperateErrorInfo errInfo = new OperateErrorInfo("retrywriteback.dbroute_null", ErrorLevel.Error, null);
            errInfo.setMessage(ResManager.loadKDString((String)"\u91cd\u8bd5\u53cd\u5199\uff0c\u8bf7\u4f20\u5165dbRouteKey\u53c2\u6570\uff0c\u9700\u636e\u6b64\u786e\u5b9a\u6570\u636e\u5e93\u5206\u5e93\uff0c\u8bfb\u53d6\u53cd\u5199\u65e5\u5fd7\u8be6\u7ec6\u5185\u5bb9\u3002", (String)"BFTrackerServiceImpl_2", (String)"bos-mservice-botp", (Object[])new Object[0]));
            opResult.addErrorInfo(errInfo);
            return this.serializeOperationResult(opResult);
        }
        if (wbLogIds == null || wbLogIds.length == 0) {
            OperateErrorInfo errInfo = new OperateErrorInfo("retrywb.wblogids_null", ErrorLevel.Error, null);
            errInfo.setMessage(ResManager.loadKDString((String)"\u91cd\u8bd5\u53cd\u5199\uff0c\u8bf7\u4f20\u5165\u53cd\u5199\u65e5\u5fd7\u5185\u7801\uff0c\u9700\u6839\u636e\u53cd\u5199\u65e5\u5fd7\u8ffd\u67e5\u51fa\u53cd\u5199\u9700\u6c42\u3002", (String)"BFTrackerServiceImpl_3", (String)"bos-mservice-botp", (Object[])new Object[0]));
            opResult.addErrorInfo(errInfo);
            return this.serializeOperationResult(opResult);
        }
        if (option == null) {
            option = OperateOption.create();
        }
        if ((wbLogs = (botpLogService = new CtBOTPLogService()).load(dbRouteKey, wbLogIds)) == null || wbLogs.length == 0) {
            OperateErrorInfo errInfo = new OperateErrorInfo("retrywb.wblog_null", ErrorLevel.Error, null);
            errInfo.setMessage(ResManager.loadKDString((String)"\u91cd\u8bd5\u53cd\u5199\uff0c\u6839\u636e\u4f20\u5165\u7684\u65e5\u5fd7\u5185\u7801\uff0c\u6ca1\u6709\u53d6\u51fa\u53cd\u5199\u65e5\u5fd7\u8be6\u60c5\uff0c\u8bf7\u786e\u8ba4dbRouteKey, wbLogIds\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"BFTrackerServiceImpl_4", (String)"bos-mservice-botp", (Object[])new Object[0]));
            opResult.addErrorInfo(errInfo);
            return this.serializeOperationResult(opResult);
        }
        HashMap<Long, Map> wbLogsGroupByTTableId = new HashMap<Long, Map>(1);
        for (CtBOTPLog wbLog : wbLogs) {
            if (StringUtils.equalsIgnoreCase((CharSequence)"W", (CharSequence)wbLog.getLogType())) {
                CtWBLogDetailInfo wbLogDetailInfo = (CtWBLogDetailInfo)wbLog.getDetailInfo();
                String opKey = "";
                String opType = "";
                if (StringUtils.isNotBlank((CharSequence)wbLogDetailInfo.getOpKey())) {
                    opKey = wbLogDetailInfo.getOpKey();
                }
                if (wbLogDetailInfo.getOpType() != null) {
                    opType = wbLogDetailInfo.getOpType().name();
                }
                Map groupByOp = wbLogsGroupByTTableId.computeIfAbsent(wbLog.getTTableId(), s -> new HashMap(1));
                List listByOp = groupByOp.computeIfAbsent(opKey + "_" + opType, s -> new ArrayList(wbLogs.length));
                listByOp.add(wbLog);
                continue;
            }
            OperateErrorInfo errorInfo = new OperateErrorInfo("retrywb.logtype_error", ErrorLevel.Error, (Object)wbLog.getId());
            errorInfo.setMessage(ResManager.loadKDString((String)"\u91cd\u8bd5\u53cd\u5199\uff0c\u4f20\u5165\u7684\u65e5\u5fd7\uff0c\u4e0d\u662f\u53cd\u5199\u9700\u6c42\u65e5\u5fd7\uff0c\u4e0d\u80fd\u636e\u6b64\u6293\u53d6\u53cd\u5199\u9700\u6c42\u91cd\u65b0\u53cd\u5199\u3002", (String)"BFTrackerServiceImpl_5", (String)"bos-mservice-botp", (Object[])new Object[0]));
            opResult.addErrorInfo(errorInfo);
        }
        for (Map.Entry entry : wbLogsGroupByTTableId.entrySet()) {
            TableDefine tableDefine = EntityMetadataCache.loadTableDefine((Long)((Long)entry.getKey()));
            String targetEntityNumber = tableDefine.getEntityNumber();
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)targetEntityNumber);
            for (Map.Entry groupByOp : ((Map)entry.getValue()).entrySet()) {
                OperationResult opResult2 = this.doRetry(mainType, (List)groupByOp.getValue(), option);
                opResult.getSuccessPkIds().addAll(opResult2.getSuccessPkIds());
                opResult.getAllErrorInfo().addAll(opResult2.getAllErrorInfo());
            }
        }
        return this.serializeOperationResult(opResult);
    }

    private void execute(String entityNumber, DynamicObject[] dataEntities, BFTrackerOpType opType) {
        BillEntityType mainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber);
        CtBFTrackerEngine trackerEngine = new CtBFTrackerEngine((IDataEntityType)mainType, opType, null, null);
        trackerEngine.execute(dataEntities);
        trackerEngine.saveBeforeTrans();
        trackerEngine.saveTrans();
        trackerEngine.saveAfterTrans();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult doRetry(MainEntityType mainType, List<CtBOTPLog> wbLogs, OperateOption option) {
        CtBFTrackerEngine bfTrackerEngine = null;
        try {
            if (option == null) {
                option = OperateOption.create();
            }
            option.setVariableValue("botp_writeback_retry", "true");
            CtWBLogDetailInfo wbLogDetailInfo = (CtWBLogDetailInfo)wbLogs.get(0).getDetailInfo();
            String opKey = wbLogDetailInfo.getOpKey();
            Map opMeta = null;
            if (StringUtils.isNotBlank((CharSequence)opKey)) {
                opMeta = EntityMetadataCache.getDataEntityOperate((String)mainType.getName(), (String)opKey);
            }
            BFTrackerOpType opType = wbLogDetailInfo.getOpType();
            bfTrackerEngine = new CtBFTrackerEngine((IDataEntityType)mainType, opType, opMeta, new OperationContext(), option);
            OperationResult operationResult = bfTrackerEngine.retry(wbLogs.toArray(new CtBOTPLog[0]));
            return operationResult;
        }
        catch (KDBizException exp) {
            LOG.warn((Throwable)exp);
            String errCode = "retrywb.bizexception";
            if (exp.getErrorCode() != null && StringUtils.isNotBlank((CharSequence)exp.getErrorCode().getCode())) {
                errCode = exp.getErrorCode().getCode();
            }
            OperateErrorInfo errInfo = new OperateErrorInfo(errCode, ErrorLevel.Error, null);
            errInfo.setMessage(exp.getMessage());
            OperationResult opResult = new OperationResult();
            opResult.addErrorInfo(errInfo);
            OperationResult operationResult = opResult;
            return operationResult;
        }
        finally {
            if (bfTrackerEngine != null) {
                bfTrackerEngine.release();
            }
        }
    }

    private String serializeOperationResult(OperationResult operationResult) {
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        String serialResult = DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option);
        return serialResult;
    }
}

