/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.ctbotp.CtBOTPLogService;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.CtLinkSetItemElement;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.ctbotp.log.CtBOTPLog;
import kd.bos.entity.ctbotp.log.CtWBLogDetailInfo;
import kd.bos.entity.ctbotp.log.CtWFLogDetailInfo;
import kd.bos.entity.ctbotp.runtime.CtWriteBackRuleCache;
import kd.bos.entity.ctbotp.runtime.CtWriteBackRuleElement;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.service.ctbotp.track.CtBFTrackerContext;
import kd.bos.service.ctbotp.track.CtBFTrackerResult;
import kd.bos.service.ctbotp.track.CtLinkItemContext;
import kd.bos.service.ctbotp.track.CtWriteBackContext;
import kd.bos.service.ctbotp.track.CtWriteBackEngine;
import kd.bos.service.ctbotp.track.CtWriteBacker;
import kd.bos.service.ctbotp.track.bizentity.CtAED;
import kd.bos.service.ctbotp.track.bizentity.CtRow;
import kd.bos.service.ctbotp.track.bizentity.CtSheet;
import kd.bos.service.ctbotp.track.bizentity.CtSheets;
import kd.bos.service.ctbotp.track.bizentity.CtWRule;
import kd.bos.service.ctbotp.track.helper.CtBFTrackerDbService;
import kd.bos.service.ctbotp.track.helper.CtSheetSync;
import kd.bos.service.ctbotp.track.helper.CtWRuleCompiler;
import kd.bos.service.ctbotp.track.helper.CtWbLogBuilder;
import kd.bos.service.ctbotp.track.opcontroller.ICtOpController;
import kd.bos.servicehelper.TimeServiceHelper;

public class CtWriteBackRetryer
extends CtWriteBacker {
    private static final Log LOG = LogFactory.getLog(CtWriteBackRetryer.class);
    private static final String BOS_MSERVICE_BOTP = "bos-mservice-botp";
    private static final long OVER_TIME = 600000L;
    private Map<Long, CtWRuleCompiler> allRuleVers = new HashMap<Long, CtWRuleCompiler>();
    private Map<String, Map<Long, CtWRuleCompiler>> dctRuleBySrcBill = new HashMap<String, Map<Long, CtWRuleCompiler>>();
    private OperationResult opResult = new OperationResult();
    private Set<String> mutexDataIds = new HashSet<String>();
    private Set<Long> failWbLogIds = new HashSet<Long>();

    public CtWriteBackRetryer(CtBFTrackerContext trackerContext, CtBFTrackerResult trackerResult, ICtOpController opController, CtBFTrackerDbService dbService) {
        super(trackerContext, trackerResult, opController, dbService);
    }

    public OperationResult getOpResult() {
        return this.opResult;
    }

    public Set<Long> getFailWbLogIds() {
        return this.failWbLogIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retry(CtBOTPLog[] wbLogs) {
        super.retry(wbLogs);
        try {
            HashMap<Long, CtBOTPLog> tcLogs = new HashMap<Long, CtBOTPLog>(wbLogs.length);
            List<CtBOTPLog> canRetryLogs = this.checkLogStatus(wbLogs, tcLogs);
            if (canRetryLogs.isEmpty()) {
                return;
            }
            List<CtBOTPLog> mutexSuccessLogs = this.doStartNetworkCtrl(canRetryLogs);
            if (mutexSuccessLogs.isEmpty()) {
                return;
            }
            this.doRetry(mutexSuccessLogs, tcLogs);
        }
        finally {
            this.doReleaseDataMutex();
        }
    }

    private void doRetry(List<CtBOTPLog> wbLogs, Map<Long, CtBOTPLog> tcLogs) {
        CtWbLogBuilder wbLogBuilder = new CtWbLogBuilder();
        for (CtBOTPLog wbLog : wbLogs) {
            CtWBLogDetailInfo wbDetails = (CtWBLogDetailInfo)wbLog.getDetailInfo();
            CtLinkSetItemElement linkSetItem = this.loadLinkSetItem(wbDetails.getEntityKey());
            if (linkSetItem == null) {
                this.addFailWbLog(wbLog.getId(), "retrywb.linksetitem_null", String.format(ResManager.loadKDString((String)"\u91cd\u8bd5\u53cd\u5199\uff0c\u8bfb\u53d6\u3010%\u3011\u7684\u5173\u8054\u4e3b\u5b9e\u4f53\u5c5e\u6027\u914d\u7f6e\u5931\u8d25\uff0c\u65e0\u6cd5\u91cd\u65b0\u53cd\u5199\uff0c\u8bf7\u6253\u5f00\u5355\u636e\u8bbe\u8ba1\u5668\uff0c\u68c0\u67e5\u5173\u8054\u914d\u7f6e\u5c5e\u6027\u3002", (String)"WriteBackRetryer_4", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.trackerContext.getTargetMainType().getDisplayName().toString()));
                continue;
            }
            CtBOTPLog tcLog = tcLogs.get(wbLog.getParentId());
            CtSheets snapshot = wbLogBuilder.createSnapshot(tcLog, wbLog);
            CtSheets sheets = wbLogBuilder.createSheets(tcLog, wbLog);
            this.loadRuleVers(snapshot, sheets);
            CtAED<CtRow> aedRows = CtSheetSync.syncRows(sheets, snapshot);
            List<CtWRule> lstWRules = this.mergeWRuleWithHistory(aedRows);
            CtSheetSync.calcRealAmount(this.allRuleVers, lstWRules);
            CtLinkItemContext ctLinkItemContext = CtLinkItemContext.create(this.trackerContext, this.trackerOpContext, linkSetItem);
            this.execWriteLogicUnit(ctLinkItemContext, wbLog.getSentityNumber(), lstWRules);
            this.trackerResult.getTrackerLog().addRetryWriteBackLogs(ctLinkItemContext, snapshot, sheets, new CtBOTPLog[]{wbLog});
        }
    }

    private void execWriteLogicUnit(CtLinkItemContext ctLinkItemContext, String srcEntityNumber, List<CtWRule> wRules) {
        CtWriteBackContext ctWriteBackContext = new CtWriteBackContext(this.trackerContext, ctLinkItemContext, this.trackerResult, this.trackerContext.getDbService());
        CtWriteBackEngine ctWriteBackEngine = new CtWriteBackEngine(ctWriteBackContext);
        Map<Long, CtWRuleCompiler> rules = this.dctRuleBySrcBill.get(srcEntityNumber);
        ctWriteBackEngine.doWriteBack(rules, wRules);
    }

    private List<CtWRule> mergeWRuleWithHistory(CtAED<CtRow> aedRows) {
        CtWRule wRule;
        CtAED<CtWRule> aedWRule = CtSheetSync.syncWRules(aedRows);
        int size = aedWRule.getDeleteList().size() + aedWRule.getEditList().size() + aedWRule.getAddList().size();
        ArrayList<CtWRule> wrules = new ArrayList<CtWRule>(size);
        for (CtWRule ctWRule : aedWRule.getDeleteList()) {
            wRule = CtWRule.mergeHistoryRow(null, ctWRule);
            wrules.add(wRule);
        }
        for (Tuple tuple : aedWRule.getEditList()) {
            CtWRule currWRule = (CtWRule)tuple.item1;
            CtWRule snapWRule = (CtWRule)tuple.item2;
            CtWRule wRule2 = CtWRule.mergeHistoryRow(currWRule, snapWRule);
            wrules.add(wRule2);
        }
        for (CtWRule ctWRule : aedWRule.getAddList()) {
            wRule = CtWRule.mergeHistoryRow(ctWRule, null);
            wrules.add(wRule);
        }
        return wrules;
    }

    private List<CtBOTPLog> checkLogStatus(CtBOTPLog[] wbLogs, Map<Long, CtBOTPLog> tcLogs) {
        HashSet<Long> tcLogIds = new HashSet<Long>(wbLogs.length);
        HashMap<Long, Set> wbLogIdGroupByST = new HashMap<Long, Set>(wbLogs.length);
        Date currTime = TimeServiceHelper.now();
        for (CtBOTPLog wbLog : wbLogs) {
            if (wbLog.getDetailInfo() instanceof CtWBLogDetailInfo) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)wbLog.getStatus(), (CharSequence)"0") && !StringUtils.equalsIgnoreCase((CharSequence)wbLog.getStatus(), (CharSequence)"2")) {
                    this.addFailWbLog(wbLog.getId(), "retrywb.wblog_finish", ResManager.loadKDString((String)"\u91cd\u8bd5\u53cd\u5199\uff0c\u4f20\u5165\u7684\u53cd\u5199\u9700\u6c42\u5df2\u7ecf\u5b8c\u6210\uff0c\u4e0d\u9700\u8981\u91cd\u65b0\u53cd\u5199\u3002", (String)"WriteBackRetryer_1", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
                    continue;
                }
                if (wbLog.getStartTime().getTime() + 600000L > currTime.getTime()) {
                    this.addFailWbLog(wbLog.getId(), "retrywb.wblog_overtime", ResManager.loadKDString((String)"\u91cd\u8bd5\u53cd\u5199\uff0c\u4f20\u5165\u7684\u53cd\u5199\u9700\u6c42\u8fd8\u672a\u8d85\u65f6\uff0c\u53ef\u80fd\u8fd8\u5728\u6267\u884c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"WriteBackRetryer_2", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
                    continue;
                }
                tcLogIds.add(wbLog.getParentId());
                wbLogIdGroupByST.computeIfAbsent(wbLog.getSTableId(), s -> new HashSet()).add(wbLog.getId());
                continue;
            }
            this.addFailWbLog(wbLog.getId(), "retrywb.wblog_isnot", ResManager.loadKDString((String)"\u91cd\u8bd5\u53cd\u5199\uff0c\u4f20\u5165\u7684\u65e5\u5fd7\uff0c\u4e0d\u662f\u53cd\u5199\u9700\u6c42\u65e5\u5fd7\uff0c\u4e0d\u80fd\u636e\u6b64\u6293\u53d6\u53cd\u5199\u9700\u6c42\u91cd\u65b0\u53cd\u5199\u3002", (String)"WriteBackRetryer_5", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
        }
        CtBOTPLogService service = new CtBOTPLogService();
        if (!tcLogIds.isEmpty()) {
            CtBOTPLog[] logs;
            for (CtBOTPLog log : logs = service.load(this.trackerContext.getTargetMainType().getDBRouteKey(), tcLogIds.toArray(new Long[0]))) {
                tcLogs.put(log.getId(), log);
            }
        }
        HashMap<Long, CtBOTPLog> wfLogs = new HashMap<Long, CtBOTPLog>(wbLogs.length);
        for (Map.Entry wbLogIdOneST : wbLogIdGroupByST.entrySet()) {
            CtBOTPLog[] logs;
            Long sTableId = (Long)wbLogIdOneST.getKey();
            TableDefine sTableDefine = EntityMetadataCache.loadTableDefine((Long)sTableId);
            MainEntityType sMainType = EntityMetadataCache.getDataEntityType((String)sTableDefine.getEntityNumber());
            for (CtBOTPLog log : logs = service.loadByParentIds(sMainType.getDBRouteKey(), ((Set)wbLogIdOneST.getValue()).toArray(new Long[0]))) {
                if (!(log.getDetailInfo() instanceof CtWFLogDetailInfo)) continue;
                Long wbLogId = log.getParentId();
                wfLogs.put(wbLogId, log);
            }
        }
        ArrayList<CtBOTPLog> passLogs = new ArrayList<CtBOTPLog>(wbLogs.length);
        for (CtBOTPLog wbLog : wbLogs) {
            if (this.failWbLogIds.contains(wbLog.getId())) continue;
            if (!tcLogs.containsKey(wbLog.getParentId())) {
                this.addFailWbLog(wbLog.getId(), "retrywb.tclog_null", ResManager.loadKDString((String)"\u91cd\u8bd5\u53cd\u5199\uff0c\u4f20\u5165\u7684\u53cd\u5199\u9700\u6c42\u672a\u627e\u5230\u5173\u8054\u7684\u884c\u5173\u8054\u5173\u7cfb\u65e5\u5fd7\uff0c\u6570\u636e\u7f3a\u5931\uff0c\u65e0\u6cd5\u91cd\u65b0\u53cd\u5199\u3002", (String)"WriteBackRetryer_3", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
                continue;
            }
            if (wfLogs.containsKey(wbLog.getId())) {
                this.addFailWbLog(wbLog.getId(), "retrywb.wblog_finish", ResManager.loadKDString((String)"\u91cd\u8bd5\u53cd\u5199\uff0c\u4f20\u5165\u7684\u53cd\u5199\u9700\u6c42\u5df2\u7ecf\u5b8c\u6210\uff0c\u4e0d\u9700\u8981\u91cd\u65b0\u53cd\u5199\u3002", (String)"WriteBackRetryer_1", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
                continue;
            }
            passLogs.add(wbLog);
        }
        return passLogs;
    }

    private void addFailWbLog(Long wbLogId, String errCode, String message) {
        this.failWbLogIds.add(wbLogId);
        OperateErrorInfo errorInfo = new OperateErrorInfo(errCode, ErrorLevel.Error, (Object)wbLogId);
        errorInfo.setMessage(message);
        this.opResult.addErrorInfo(errorInfo);
    }

    private CtLinkSetItemElement loadLinkSetItem(String parentEntityKey) {
        CtLinkSetItemElement linkSetItem = null;
        for (CtLinkSetItemElement item : this.trackerContext.getLinkSet().getItems()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)item.getCtParentEntityKey(), (CharSequence)parentEntityKey)) continue;
            linkSetItem = item;
            break;
        }
        return linkSetItem;
    }

    private void loadRuleVers(CtSheets snapshot, CtSheets sheets) {
        HashSet<Long> verIds = new HashSet<Long>();
        if (snapshot != null) {
            for (CtSheet sheet : snapshot.values()) {
                for (CtRow row : sheet.getCtRows().values()) {
                    for (CtWRule wRule : row.getWrules().values()) {
                        verIds.add(wRule.getRuleVerId());
                    }
                }
            }
        }
        if (sheets != null) {
            for (CtSheet sheet : sheets.values()) {
                for (CtRow row : sheet.getCtRows().values()) {
                    for (CtWRule wRule : row.getWrules().values()) {
                        verIds.add(wRule.getRuleVerId());
                    }
                }
            }
        }
        Iterator<Object> iterator = verIds.iterator();
        while (iterator.hasNext()) {
            long verId = (Long)iterator.next();
            CtWriteBackRuleElement rule = CtWriteBackRuleCache.loadRuleVer((long)verId);
            if (rule == null) continue;
            CtWRuleCompiler wRuleCompiler = new CtWRuleCompiler(this.trackerContext, verId, rule);
            this.allRuleVers.put(verId, wRuleCompiler);
            Map<Long, CtWRuleCompiler> map = this.dctRuleBySrcBill.get(rule.getSourceEntityNumber());
            if (map == null) {
                map = new HashMap<Long, CtWRuleCompiler>(1);
                this.dctRuleBySrcBill.put(rule.getSourceEntityNumber(), map);
            }
            map.put(verId, wRuleCompiler);
        }
    }

    private List<CtBOTPLog> doStartNetworkCtrl(List<CtBOTPLog> wbLogs) {
        ArrayList<Map<String, Object>> mutexRequireList = new ArrayList<Map<String, Object>>(wbLogs.size());
        for (CtBOTPLog wbLog : wbLogs) {
            String objId = String.valueOf(wbLog.getId());
            if (this.mutexDataIds.contains(objId)) continue;
            Map<String, Object> requireParam = this.createDataMutexParam(objId);
            mutexRequireList.add(requireParam);
        }
        ArrayList<CtBOTPLog> successLogs = new ArrayList<CtBOTPLog>(wbLogs.size());
        try (TXHandle h = TX.notSupported();){
            try (DataMutex dataMutex = DataMutex.create();){
                Map mutexResult = dataMutex.batchrequire(mutexRequireList);
                for (CtBOTPLog wbLog : wbLogs) {
                    String objId = String.valueOf(wbLog.getId());
                    Boolean ret = (Boolean)mutexResult.get(objId);
                    if (ret.booleanValue()) {
                        this.mutexDataIds.add(objId);
                        successLogs.add(wbLog);
                        continue;
                    }
                    OperateErrorInfo errorInfo = new OperateErrorInfo("retrywb.mutex_fail", ErrorLevel.Error, (Object)wbLog.getId());
                    errorInfo.setMessage(ResManager.loadKDString((String)"\u5e76\u53d1\u51b2\u7a81\uff0c\u91cd\u8bd5\u53cd\u5199\uff0c\u7533\u8bf7\u4e92\u65a5\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"WriteBackRetryer_0", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
                    this.opResult.addErrorInfo(errorInfo);
                }
            }
            catch (IOException e) {
                ErrorCode ec = new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519;err:%s", (String)"WriteBackRetryer_6", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), e.getMessage()));
                throw new KDException((Throwable)e, ec, new Object[0]);
            }
        }
        return successLogs;
    }

    private boolean doReleaseDataMutex() {
        if (this.mutexDataIds.isEmpty()) {
            return true;
        }
        ArrayList<Map<String, Object>> mutexRequireList = new ArrayList<Map<String, Object>>(this.mutexDataIds.size());
        for (String billId : this.mutexDataIds) {
            Map<String, Object> requireParam = this.createDataMutexParam(billId);
            mutexRequireList.add(requireParam);
        }
        try (DataMutex dataMutex = DataMutex.create();){
            dataMutex.batchRelease(mutexRequireList);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return false;
        }
        this.mutexDataIds.clear();
        return true;
    }

    private Map<String, Object> createDataMutexParam(String billId) {
        HashMap<String, Object> requireParam = new HashMap<String, Object>();
        requireParam.put("dataObjId", billId);
        requireParam.put("groupId", "default_netctrl");
        requireParam.put("entityKey", "botp_log");
        requireParam.put("operationKey", "retry");
        requireParam.put("isStrict", true);
        return requireParam;
    }
}

