/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.track.CtBFTrackerBatchContext;
import kd.bos.service.ctbotp.track.CtBFTrackerBatchResult;
import kd.bos.service.ctbotp.track.CtBFTrackerContext;
import kd.bos.service.ctbotp.track.CtBFTrackerOpContext;
import kd.bos.service.ctbotp.track.CtBFTrackerResult;
import kd.bos.service.ctbotp.track.CtLinkItemContext;
import kd.bos.service.ctbotp.track.actions.AbstractCtTrackAction;
import kd.bos.service.ctbotp.track.actions.CtBuildCurrBillTrackerAction;
import kd.bos.service.ctbotp.track.actions.CtBuildLinkUpNodesAction;
import kd.bos.service.ctbotp.track.actions.CtBuildSheetAction;
import kd.bos.service.ctbotp.track.actions.CtBuildWRulesAction;
import kd.bos.service.ctbotp.track.actions.CtCalcRealAmountAction;
import kd.bos.service.ctbotp.track.actions.CtExecuteWriteLogicAction;
import kd.bos.service.ctbotp.track.actions.CtLoadCurrRuleVersAction;
import kd.bos.service.ctbotp.track.actions.CtLoadSnapRuleVersAction;
import kd.bos.service.ctbotp.track.actions.CtOutputSnapshotLogAction;
import kd.bos.service.ctbotp.track.actions.CtSyncEntryTrackerAction;
import kd.bos.service.ctbotp.track.helper.CtBillTrackerBuilder;

public class CtBFTrackBatchExecuter
implements Callable<CtBFTrackerBatchResult> {
    private RequestContext rc;
    private static Log log = LogFactory.getLog(CtBFTrackBatchExecuter.class);
    private CtBFTrackerContext trackerContext;
    private CtBFTrackerOpContext trackerOpContext;
    private CtLinkItemContext linkItemContext;
    private CtBillTrackerBuilder billTrackerHelper;
    private CtBFTrackerResult trackerResult;
    private CtBFTrackerBatchContext batchContext;
    private List<AbstractCtTrackAction> actions = new ArrayList<AbstractCtTrackAction>(0);
    private boolean syncExecute = false;

    public boolean isSyncExecute() {
        return this.syncExecute;
    }

    public void setSyncExecute(boolean syncExecute) {
        this.syncExecute = syncExecute;
    }

    public CtBFTrackBatchExecuter(RequestContext rc, CtBFTrackerContext trackerContext, CtBFTrackerOpContext trackerOpContext, CtLinkItemContext linkItemContext, CtBFTrackerBatchContext batchContext, CtBFTrackerResult trackerResult, CtBillTrackerBuilder billTrackerHelper) {
        this.rc = rc;
        this.trackerContext = trackerContext;
        this.trackerOpContext = trackerOpContext;
        this.linkItemContext = linkItemContext;
        this.batchContext = batchContext;
        this.trackerResult = trackerResult;
        this.billTrackerHelper = billTrackerHelper;
        this.actions = this.createActions();
    }

    @Override
    public CtBFTrackerBatchResult call() throws Exception {
        if (!this.isSyncExecute()) {
            RequestContext.copyAndSet((RequestContext)this.rc);
        }
        CtBFTrackerBatchResult batchResult = new CtBFTrackerBatchResult();
        try {
            batchResult = this.doActions();
        }
        catch (KDBizException ex) {
            batchResult.setException(ex);
            this.trackerOpContext.setSkipNextBatch(true);
        }
        catch (Throwable ex) {
            batchResult.setException(ex);
            this.trackerOpContext.setSkipNextBatch(true);
            log.error(ex);
        }
        return batchResult;
    }

    public CtBFTrackerBatchResult doActions() {
        if (this.trackerContext.getOperateLog().isWriteLog()) {
            String logMsg = String.format("BFTrackBatchExecuter.doActions() begin: entity = %s, batch = %s, entryIds = %s, entryOids = %s,  other page entryIds count = %s", this.linkItemContext.getLinkSetItem().getCtParentEntityKey(), this.batchContext.getBatchIndex(), this.linkItemContext.getCurrPageEntryIds().size(), this.linkItemContext.getCurrPageEntryOids().size(), this.batchContext.getEntryIds() == null ? 0 : this.batchContext.getEntryIds().size());
            this.trackerContext.getOperateLog().beginMothed("BFTrackBatchExecuter.doActions()", logMsg);
        }
        CtBFTrackerBatchResult batchResult = new CtBFTrackerBatchResult();
        for (AbstractCtTrackAction action : this.actions) {
            action.action(this.batchContext, batchResult);
        }
        batchResult.setSuccess(true);
        batchResult.clearMemory();
        if (this.trackerContext.getOperateLog().isWriteLog()) {
            this.trackerContext.getOperateLog().endMothed("BFTrackBatchExecuter.doActions()", null);
        }
        return batchResult;
    }

    private List<AbstractCtTrackAction> createActions() {
        ArrayList<AbstractCtTrackAction> list = new ArrayList<AbstractCtTrackAction>();
        list.add(new CtBuildSheetAction(this.trackerContext, this.trackerOpContext, this.linkItemContext, this.trackerResult, this.billTrackerHelper));
        list.add(new CtBuildCurrBillTrackerAction(this.trackerContext, this.trackerOpContext, this.linkItemContext, this.trackerResult, this.billTrackerHelper));
        list.add(new CtSyncEntryTrackerAction(this.trackerContext, this.trackerOpContext, this.linkItemContext, this.trackerResult, this.billTrackerHelper));
        list.add(new CtBuildLinkUpNodesAction(this.trackerContext, this.trackerOpContext, this.linkItemContext, this.trackerResult, this.billTrackerHelper));
        list.add(new CtLoadCurrRuleVersAction(this.trackerContext, this.trackerOpContext, this.linkItemContext, this.trackerResult, this.billTrackerHelper));
        list.add(new CtBuildWRulesAction(this.trackerContext, this.trackerOpContext, this.linkItemContext, this.trackerResult, this.billTrackerHelper));
        list.add(new CtLoadSnapRuleVersAction(this.trackerContext, this.trackerOpContext, this.linkItemContext, this.trackerResult, this.billTrackerHelper));
        list.add(new CtCalcRealAmountAction(this.trackerContext, this.trackerOpContext, this.linkItemContext, this.trackerResult, this.billTrackerHelper));
        list.add(new CtExecuteWriteLogicAction(this.trackerContext, this.trackerOpContext, this.linkItemContext, this.trackerResult, this.billTrackerHelper));
        list.add(new CtOutputSnapshotLogAction(this.trackerContext, this.trackerOpContext, this.linkItemContext, this.trackerResult, this.billTrackerHelper));
        return list;
    }
}

