/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.ctbotp.runtime.CtAllBusEntityCountInfo;
import kd.bos.entity.ctbotp.runtime.CtBFRowId;
import kd.bos.entity.ctbotp.runtime.CtBFRowLinkUpNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.track.CtBFTrackerContext;
import kd.bos.service.ctbotp.track.CtBFTrackerOpContext;
import kd.bos.service.ctbotp.track.CtBFTrackerResult;
import kd.bos.service.ctbotp.track.CtLinkItemContext;
import kd.bos.service.ctbotp.track.actions.AbstractCtTrackAction;
import kd.bos.service.ctbotp.track.bizentity.CtAED;
import kd.bos.service.ctbotp.track.bizentity.CtRow;
import kd.bos.service.ctbotp.track.bizentity.CtRowId;
import kd.bos.service.ctbotp.track.helper.CtBillTrackerBuilder;

public class CtBuildLinkUpNodesAction
extends AbstractCtTrackAction {
    private static final Log log = LogFactory.getLog(CtBuildLinkUpNodesAction.class);

    public CtBuildLinkUpNodesAction(CtBFTrackerContext trackerContext, CtBFTrackerOpContext trackerOpContext, CtLinkItemContext linkItemContext, CtBFTrackerResult trackerResult, CtBillTrackerBuilder billTrackerBuilder) {
        super(trackerContext, trackerOpContext, linkItemContext, trackerResult, billTrackerBuilder);
    }

    @Override
    protected void doAction() {
        this.buildLinkUpNodesByHead();
    }

    private void buildLinkUpNodesByHead() {
        CtAED<CtRow> aedRows = this.batchResult.getAEDRows();
        ArrayList<CtRowId> sRowIds = new ArrayList<CtRowId>(aedRows.getAddList().size() + aedRows.getEditList().size());
        HashMap<Long, Set<Long>> mainTableInfo4SbillId = new HashMap<Long, Set<Long>>();
        for (CtRow ctRow : aedRows.getAddList()) {
            if (ctRow.getSId() != null && ctRow.getSId().getMainTableId() != null) {
                this.trackerContext.getAllBusEntityCountInfo().getAllBusEntityCountInfo().add(ctRow.getSId().getMainTableId());
            }
            sRowIds.add(ctRow.getSId());
            this.addSTableInfo(mainTableInfo4SbillId, ctRow.getSId().getMainTableId(), ctRow.getSId().getBillId());
        }
        for (Tuple tuple : aedRows.getEditList()) {
            CtRow row = (CtRow)tuple.item1;
            sRowIds.add(row.getSId());
            if (row != null && row.getSId() != null && row.getSId().getMainTableId() != null) {
                this.trackerContext.getAllBusEntityCountInfo().getAllBusEntityCountInfo().add(row.getSId().getMainTableId());
            }
            this.addSTableInfo(mainTableInfo4SbillId, row.getSId().getMainTableId(), row.getSId().getBillId());
        }
        Map<CtBFRowId, CtBFRowLinkUpNode> allNodesByBill = this.trackerContext.getDbService().readSourceRowIds(mainTableInfo4SbillId, this.trackerContext.getAllBusEntityCountInfo());
        HashMap<CtRowId, CtBFRowLinkUpNode> hashMap = new HashMap<CtRowId, CtBFRowLinkUpNode>(sRowIds.size());
        for (CtBFRowId ctBFRowId : sRowIds) {
            CtBFRowLinkUpNode sNode = allNodesByBill.get(ctBFRowId);
            if (sNode == null) {
                sNode = new CtBFRowLinkUpNode(ctBFRowId);
            }
            hashMap.put((CtRowId)ctBFRowId, sNode);
        }
        this.batchResult.setRowLinkUpNodes(hashMap);
        this.collectSourceEntityNumbers();
    }

    private void buildLinkUpNodesByEntry() {
        CtAED<CtRow> aedRows = this.batchResult.getAEDRows();
        ArrayList<CtRowId> sRowIds = new ArrayList<CtRowId>(aedRows.getAddList().size() + aedRows.getEditList().size());
        HashMap<Long, Set<Long>> tableInfo4SbillId = new HashMap<Long, Set<Long>>();
        HashMap<Long, Set<Long>> tableInfo4Sid = new HashMap<Long, Set<Long>>();
        for (CtRow ctRow : aedRows.getAddList()) {
            if (ctRow.getSId() != null && ctRow.getSId().getMainTableId() != null) {
                this.trackerContext.getAllBusEntityCountInfo().getAllBusEntityCountInfo().add(ctRow.getSId().getMainTableId());
            }
            sRowIds.add(ctRow.getSId());
            this.addSTableInfo(tableInfo4SbillId, ctRow.getSId().getTableId(), ctRow.getSId().getBillId());
            this.addSTableInfo(tableInfo4Sid, ctRow.getSId().getTableId(), ctRow.getSId().getEntryId());
        }
        for (Tuple tuple : aedRows.getEditList()) {
            CtRow row = (CtRow)tuple.item1;
            sRowIds.add(row.getSId());
            if (row != null && row.getSId() != null && row.getSId().getMainTableId() != null) {
                this.trackerContext.getAllBusEntityCountInfo().getAllBusEntityCountInfo().add(row.getSId().getMainTableId());
            }
            this.addSTableInfo(tableInfo4SbillId, row.getSId().getTableId(), row.getSId().getBillId());
            this.addSTableInfo(tableInfo4Sid, row.getSId().getTableId(), row.getSId().getEntryId());
        }
        Map<CtBFRowId, CtBFRowLinkUpNode> allNodesByEntry = this.trackerContext.getDbService().readSourceRowIds(tableInfo4Sid, tableInfo4SbillId, this.trackerContext.getAllBusEntityCountInfo());
        HashMap<CtRowId, CtBFRowLinkUpNode> hashMap = new HashMap<CtRowId, CtBFRowLinkUpNode>(sRowIds.size());
        for (CtBFRowId ctBFRowId : sRowIds) {
            CtBFRowLinkUpNode sNode = allNodesByEntry.get(ctBFRowId);
            if (sNode == null) {
                sNode = new CtBFRowLinkUpNode(ctBFRowId);
            }
            hashMap.put((CtRowId)ctBFRowId, sNode);
        }
        this.batchResult.setRowLinkUpNodes(hashMap);
        this.collectSourceEntityNumbers();
    }

    private void addSTableInfo(Map<Long, Set<Long>> tableInfo, Long tableId, Long sid) {
        if (!tableInfo.containsKey(tableId)) {
            tableInfo.put(tableId, new HashSet());
        }
        tableInfo.get(tableId).add(sid);
    }

    private void collectSourceEntityNumbers() {
        try {
            CtAllBusEntityCountInfo allBusEntityCountInfo = this.trackerContext.getAllBusEntityCountInfo();
            for (Long id : allBusEntityCountInfo.getAllBusEntityCountInfo()) {
                TableDefine tableDefine = EntityMetadataCache.loadTableDefine((Long)id);
                this.trackerContext.bfSourceEntityNumbers.add(tableDefine.getEntityNumber());
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }
}

