/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.actions;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ctbotp.runtime.CtWriteBackType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.service.ctbotp.track.CtBFTrackerContext;
import kd.bos.service.ctbotp.track.CtBFTrackerOpContext;
import kd.bos.service.ctbotp.track.CtBFTrackerResult;
import kd.bos.service.ctbotp.track.CtLinkItemContext;
import kd.bos.service.ctbotp.track.CtWriteBackContext;
import kd.bos.service.ctbotp.track.CtWriteBackEngine;
import kd.bos.service.ctbotp.track.actions.AbstractCtTrackAction;
import kd.bos.service.ctbotp.track.bizentity.CtRow;
import kd.bos.service.ctbotp.track.bizentity.CtWRule;
import kd.bos.service.ctbotp.track.bizentity.CtWSRow;
import kd.bos.service.ctbotp.track.helper.CtBillTrackerBuilder;
import kd.bos.service.ctbotp.track.helper.CtTrackerTypes;
import kd.bos.service.ctbotp.track.helper.CtWRuleCompiler;
import kd.bos.service.ctbotp.track.helper.CtWRuleItemCompiler;
import kd.bos.servicehelper.DBServiceHelper;

public class CtExecuteWriteLogicAction
extends AbstractCtTrackAction {
    private static Log log = LogFactory.getLog(CtExecuteWriteLogicAction.class);
    private Map<Long, CtWRuleCompiler> allRuleVers = new HashMap<Long, CtWRuleCompiler>();
    private Map<String, Map<Long, CtWRuleCompiler>> dctRuleBySrcBill = new HashMap<String, Map<Long, CtWRuleCompiler>>();

    public CtExecuteWriteLogicAction(CtBFTrackerContext trackerContext, CtBFTrackerOpContext trackerOpContext, CtLinkItemContext linkItemContext, CtBFTrackerResult trackerResult, CtBillTrackerBuilder billTrackerBuilder) {
        super(trackerContext, trackerOpContext, linkItemContext, trackerResult, billTrackerBuilder);
    }

    @Override
    protected void doAction() {
        this.allRuleVers = this.trackerOpContext.getAllRuleVers();
        this.dctRuleBySrcBill = this.trackerOpContext.getRuleBySrcBill();
        Map<String, List<CtWRule>> dctWRules = this.splitBySourceBill(this.batchResult.getWRules());
        this.execWriteLogicUnit(this.linkItemContext, dctWRules);
    }

    private Map<String, List<CtWRule>> splitBySourceBill(List<CtWRule> lstWRules) {
        BigDecimal zero = new BigDecimal(0);
        HashMap<String, List<CtWRule>> dctWRules = new HashMap<String, List<CtWRule>>();
        for (CtWRule wRule : lstWRules) {
            CtWRuleCompiler ruleCompiler = this.allRuleVers.get(wRule.getRuleVerId());
            CtWRuleItemCompiler itemCompiler = ruleCompiler.getItems().get(wRule.getRuleItemId());
            if (wRule.getExecuteSourceRows().isEmpty() || itemCompiler.getItem().getWriteBackType() != CtWriteBackType.Cover && wRule.getExecuteSourceRows().size() == 1 && wRule.getExecuteSourceRows().getTotalVal() != null && wRule.getExecuteSourceRows().getTotalVal().compareTo(zero) == 0) continue;
            String srcEntityNumber = ruleCompiler.getSourceEntityNumber();
            if (!dctWRules.containsKey(srcEntityNumber)) {
                ArrayList list = new ArrayList();
                dctWRules.put(srcEntityNumber, list);
            }
            ((List)dctWRules.get(srcEntityNumber)).add(wRule);
        }
        return dctWRules;
    }

    private void execWriteLogicUnit(CtLinkItemContext linkItemContext, Map<String, List<CtWRule>> dctWRules) {
        CtWriteBackContext writeBackContext = new CtWriteBackContext(this.trackerContext, linkItemContext, this.trackerResult, this.trackerContext.getDbService());
        CtWriteBackEngine writeBackEngine = new CtWriteBackEngine(writeBackContext);
        for (Map.Entry<String, List<CtWRule>> entry : dctWRules.entrySet()) {
            String srcEntityNumber = entry.getKey();
            List<CtWRule> wRules = entry.getValue();
            Map<Long, CtWRuleCompiler> rules = this.dctRuleBySrcBill.get(srcEntityNumber);
            writeBackEngine.doWriteBack(rules, wRules);
            this.applyWBSnap(wRules);
            if (!Boolean.parseBoolean(this.trackerContext.getOption().getVariableValue("isopenintentlocks", "false"))) continue;
            for (CtWRule wRule : wRules) {
                CtRow parent = wRule.getParent();
                Long pkId = parent.getSId().getEntryId();
                try {
                    DataMutex dataMutex = DataMutex.create();
                    Throwable throwable = null;
                    try {
                        dataMutex.releaseIntent(srcEntityNumber, String.valueOf(pkId));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (dataMutex == null) continue;
                        if (throwable != null) {
                            try {
                                dataMutex.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        dataMutex.close();
                    }
                }
                catch (IOException e) {
                    log.info(e.getMessage());
                }
            }
        }
    }

    private void applyWBSnap(List<CtWRule> lstWRules) {
        for (CtWRule wRule : lstWRules) {
            if (wRule.getExecuteSourceRows().size() == 0) continue;
            ArrayList<Long> ids = new ArrayList<Long>(wRule.getHistorySourceRows().values().size());
            for (CtWSRow wsRow : wRule.getHistorySourceRows().values()) {
                ids.add(wsRow.getWBEntryId());
            }
            this.batchResult.getDelWBIds().addAll(ids);
            this.trackerResult.addDelWBSnapIds(ids);
            ArrayList<DynamicObject> wbSnapRows = new ArrayList<DynamicObject>(wRule.getResultSourceRows().values().size());
            for (CtWSRow wsRow : wRule.getResultSourceRows().values()) {
                DynamicObject wbSnapRow = this.buildWBSnapRow(wsRow);
                wbSnapRows.add(wbSnapRow);
            }
            this.batchResult.getNewWBItems().addAll(wbSnapRows);
            this.trackerResult.addNewWBSnaps(wbSnapRows);
        }
    }

    private DynamicObject buildWBSnapRow(CtWSRow wsRow) {
        CtTrackerTypes trackerTypes = this.trackerContext.getTrackerTypes();
        BillEntityType wbSnapType = trackerTypes.getWbItemType();
        DynamicObject wbSnapRow = new DynamicObject((DynamicObjectType)wbSnapType);
        long wbEntryId = DBServiceHelper.genGlobalLongId();
        wsRow.setWBEntryId(wbEntryId);
        trackerTypes.getWB_idProp().setValueFast((Object)wbSnapRow, (Object)wbEntryId);
        trackerTypes.getWB_fid().setValueFast((Object)wbSnapRow, (Object)wsRow.getParent().getParent().getEntryTrackerId());
        trackerTypes.getWB_ruleVerIdProp().setValueFast((Object)wbSnapRow, (Object)wsRow.getParent().getRuleVerId());
        trackerTypes.getWB_ruleItemIdProp().setValueFast((Object)wbSnapRow, (Object)wsRow.getParent().getRuleItemId());
        trackerTypes.getWB_sBillIdProp().setValueFast((Object)wbSnapRow, (Object)wsRow.getSId().getBillId());
        trackerTypes.getWB_sTableIdProp().setValueFast((Object)wbSnapRow, (Object)wsRow.getSId().getTableId());
        trackerTypes.getWB_sIdProp().setValueFast((Object)wbSnapRow, (Object)wsRow.getSId().getEntryId());
        trackerTypes.getWB_valueProp().setValueFast((Object)wbSnapRow, (Object)wsRow.getVal());
        return wbSnapRow;
    }
}

