/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.actions;

import java.util.HashSet;
import kd.bos.dataentity.Tuple;
import kd.bos.service.ctbotp.track.CtBFTrackerContext;
import kd.bos.service.ctbotp.track.CtBFTrackerOpContext;
import kd.bos.service.ctbotp.track.CtBFTrackerResult;
import kd.bos.service.ctbotp.track.CtLinkItemContext;
import kd.bos.service.ctbotp.track.actions.AbstractCtTrackAction;
import kd.bos.service.ctbotp.track.bizentity.CtAED;
import kd.bos.service.ctbotp.track.bizentity.CtRow;
import kd.bos.service.ctbotp.track.bizentity.CtWRule;
import kd.bos.service.ctbotp.track.helper.CtBillTrackerBuilder;

public class CtLoadSnapRuleVersAction
extends AbstractCtTrackAction {
    public CtLoadSnapRuleVersAction(CtBFTrackerContext trackerContext, CtBFTrackerOpContext trackerOpContext, CtLinkItemContext linkItemContext, CtBFTrackerResult trackerResult, CtBillTrackerBuilder billTrackerBuilder) {
        super(trackerContext, trackerOpContext, linkItemContext, trackerResult, billTrackerBuilder);
    }

    @Override
    protected void doAction() {
        this.loadSnapRuleVers(this.batchResult.getAEDRows());
    }

    private void loadSnapRuleVers(CtAED<CtRow> aedRows) {
        HashSet<Long> ruleVerIds = new HashSet<Long>();
        for (Tuple<CtRow, CtRow> tuple : aedRows.getEditList()) {
            CtRow snapRow = (CtRow)tuple.item2;
            for (CtWRule wRule : snapRow.getWrules().values()) {
                Long verId = wRule.getRuleVerId();
                if (ruleVerIds.contains(verId)) continue;
                ruleVerIds.add(verId);
            }
        }
        for (CtRow snapRow : aedRows.getDeleteList()) {
            for (CtWRule wRule : snapRow.getWrules().values()) {
                Long verId = wRule.getRuleVerId();
                if (ruleVerIds.contains(verId)) continue;
                ruleVerIds.add(verId);
            }
        }
        for (Long verId : ruleVerIds) {
            this.trackerOpContext.addSnapRuleVer(verId);
        }
    }
}

