/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.actions;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.BillEntityType;
import kd.bos.service.ctbotp.track.CtBFTrackerContext;
import kd.bos.service.ctbotp.track.CtBFTrackerOpContext;
import kd.bos.service.ctbotp.track.CtBFTrackerResult;
import kd.bos.service.ctbotp.track.CtLinkItemContext;
import kd.bos.service.ctbotp.track.actions.AbstractCtTrackAction;
import kd.bos.service.ctbotp.track.bizentity.CtAED;
import kd.bos.service.ctbotp.track.bizentity.CtRow;
import kd.bos.service.ctbotp.track.helper.CtBillTrackerBuilder;
import kd.bos.service.ctbotp.track.helper.CtSheetSync;
import kd.bos.service.ctbotp.track.helper.CtTrackerTypes;
import kd.bos.servicehelper.DBServiceHelper;

public class CtSyncEntryTrackerAction
extends AbstractCtTrackAction {
    public CtSyncEntryTrackerAction(CtBFTrackerContext trackerContext, CtBFTrackerOpContext trackerOpContext, CtLinkItemContext linkItemContext, CtBFTrackerResult trackerResult, CtBillTrackerBuilder billTrackerBuilder) {
        super(trackerContext, trackerOpContext, linkItemContext, trackerResult, billTrackerBuilder);
    }

    @Override
    protected void doAction() {
        CtAED<CtRow> aedRows = CtSheetSync.syncRows(this.batchResult.getSheets(), this.batchResult.getSnapshot());
        this.applyEntryTracker(aedRows);
        this.batchResult.setAEDRows(aedRows);
        if (this.trackerContext.getOperateLog().isWriteLog()) {
            String logMsg = String.format("SyncEntryTrackerAction.doAction(), batch = %s, add %s rows, modify %s rows, delete %s rows", this.batchContext.getBatchIndex(), aedRows.getAddList().size(), aedRows.getEditList().size(), aedRows.getDeleteList().size());
            this.trackerContext.getOperateLog().info(logMsg);
        }
    }

    private void applyEntryTracker(CtAED<CtRow> aed) {
        ArrayList<DynamicObject> trackerObjs = new ArrayList<DynamicObject>(aed.getAddList().size());
        for (CtRow row : aed.getAddList()) {
            DynamicObject trackerObj = this.buildNewEntryTracker(row);
            trackerObjs.add(trackerObj);
        }
        this.batchResult.getNewEntryTrackers().addAll(trackerObjs);
        this.trackerResult.addNewEntryTrackers(trackerObjs);
        ArrayList<Long> delIds = new ArrayList<Long>(aed.getDeleteList().size());
        ArrayList<DynamicObject> delTrackerObjs = new ArrayList<DynamicObject>(aed.getDeleteList().size());
        for (CtRow row : aed.getDeleteList()) {
            delIds.add(row.getEntryTrackerId());
            DynamicObject trackerObj = this.buildEntryTracker(row);
            delTrackerObjs.add(trackerObj);
        }
        this.batchResult.getDelEntryTrackerIds().addAll(delIds);
        this.trackerResult.addDelEntryTrackerIds(delIds);
        this.trackerResult.addDelEntryTrackers(delTrackerObjs);
    }

    private DynamicObject buildNewEntryTracker(CtRow row) {
        CtTrackerTypes trackerTypes = this.trackerContext.getTrackerTypes();
        BillEntityType trackerType = trackerTypes.getEntryTrackerType();
        DynamicObject trackerObj = new DynamicObject((DynamicObjectType)trackerType);
        long trackerId = DBServiceHelper.genGlobalLongId();
        row.setEntryTrackerId(trackerId);
        trackerTypes.getTC_idProp().setValueFast((Object)trackerObj, (Object)trackerId);
        trackerTypes.getTC_tBillIdProp().setValueFast((Object)trackerObj, (Object)row.getId().getBillId());
        trackerTypes.getTC_tTableIdProp().setValueFast((Object)trackerObj, (Object)row.getId().getTableId());
        trackerTypes.getTC_tIdProp().setValueFast((Object)trackerObj, (Object)row.getId().getEntryId());
        trackerTypes.getTC_sBillIdProp().setValueFast((Object)trackerObj, (Object)row.getSId().getBillId());
        trackerTypes.getTC_sTableIdProp().setValueFast((Object)trackerObj, (Object)row.getSId().getTableId());
        trackerTypes.getTC_sIdProp().setValueFast((Object)trackerObj, (Object)row.getSId().getEntryId());
        return trackerObj;
    }

    private DynamicObject buildEntryTracker(CtRow row) {
        CtTrackerTypes trackerTypes = this.trackerContext.getTrackerTypes();
        BillEntityType trackerType = trackerTypes.getEntryTrackerType();
        DynamicObject trackerObj = new DynamicObject((DynamicObjectType)trackerType);
        trackerTypes.getTC_idProp().setValueFast((Object)trackerObj, (Object)row.getEntryTrackerId());
        trackerTypes.getTC_tBillIdProp().setValueFast((Object)trackerObj, (Object)row.getId().getBillId());
        trackerTypes.getTC_tTableIdProp().setValueFast((Object)trackerObj, (Object)row.getId().getTableId());
        trackerTypes.getTC_tIdProp().setValueFast((Object)trackerObj, (Object)row.getId().getEntryId());
        trackerTypes.getTC_sBillIdProp().setValueFast((Object)trackerObj, (Object)row.getSId().getBillId());
        trackerTypes.getTC_sTableIdProp().setValueFast((Object)trackerObj, (Object)row.getSId().getTableId());
        trackerTypes.getTC_sIdProp().setValueFast((Object)trackerObj, (Object)row.getSId().getEntryId());
        return trackerObj;
    }
}

