/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.bizentity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheLoader;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.ctbotp.log.CtBOTPLog;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.service.ctbotp.track.bizentity.CtBillCloseItem;
import kd.bos.service.ctbotp.track.bizentity.CtSourceBillMutexInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;

public class CtSourceBillInfo {
    private static final Log log = LogFactory.getLog(CtSourceBillInfo.class);
    private static final String BOS_MSERVICE_BOTP = "bos-mservice-botp";
    private BillEntityType mainType;
    private BillEntityType subMainType;
    private List<String> selectFields;
    private Map<Long, DynamicObject> headObjs = new HashMap<Long, DynamicObject>(1);
    private Map<Long, String> headObjStrs = new HashMap<Long, String>(1);
    private Map<EntityType, Map<Long, DynamicObject>> entryRowObjs = new HashMap<EntityType, Map<Long, DynamicObject>>();
    private Map<EntityType, Map<Long, String>> entryRowStrs = new HashMap<EntityType, Map<Long, String>>();
    private List<CtBOTPLog> wbLogs = new ArrayList<CtBOTPLog>();
    private Set<CtBillCloseItem> ctBillCloseItems = new HashSet<CtBillCloseItem>(1);
    private String mutexGroupId = "default_netctrl";
    private boolean mutexStrict = false;
    private boolean isOpenIntentClocks = false;
    private Set<String> mutexDataIds = new HashSet<String>();
    private Object lockMutex = new Object();
    private boolean saveByNewThread = false;
    private IRefrencedataProvider refrencedataProvider;
    private static final int INT_ROWCOUNT = 5000;
    private static final String MUTEX_OP_KEY_WRITEBACK = "writeback";
    public static final String MUTEX_GROUP_WRITEBACK = "writeback";
    private static final String MUTEX_ERROR_CODE = "writeback_datamutex";
    private int MUTEX_TRY_AGAIN = 30000;
    private static final int SLEEP_MS = 10;
    private int MAX_SAME_COUNT_MUTEX_ID = 10000;
    private int MAX_SAME_COUNT_BLANK = 500;
    private String thread_mutex_id = null;
    private Map<String, CtSourceBillMutexInfo> thread_mutex_infos = new HashMap<String, CtSourceBillMutexInfo>();

    public CtSourceBillInfo(BillEntityType mainType, BillEntityType subMainType, List<String> selectFields) {
        this.mainType = mainType;
        this.subMainType = subMainType;
        this.selectFields = selectFields;
    }

    public int getMUTEX_TRY_AGAIN() {
        return this.MUTEX_TRY_AGAIN;
    }

    public void setMUTEX_TRY_AGAIN(int MUTEX_TRY_AGAIN) {
        this.MUTEX_TRY_AGAIN = MUTEX_TRY_AGAIN;
    }

    public int getMAX_SAME_COUNT_MUTEX_ID() {
        return this.MAX_SAME_COUNT_MUTEX_ID;
    }

    public void setMAX_SAME_COUNT_MUTEX_ID(int MAX_SAME_COUNT_MUTEX_ID) {
        this.MAX_SAME_COUNT_MUTEX_ID = MAX_SAME_COUNT_MUTEX_ID;
    }

    public BillEntityType getMainType() {
        return this.mainType;
    }

    public BillEntityType getSubMainType() {
        return this.subMainType;
    }

    public List<String> getSelectFields() {
        return this.selectFields;
    }

    public synchronized DynamicObject[] getHeadObjs() {
        ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>(this.headObjs.values());
        if (!this.headObjStrs.isEmpty()) {
            for (Map.Entry<Long, String> headItem : this.headObjStrs.entrySet()) {
                if (this.headObjs.containsKey(headItem.getKey())) continue;
                DynamicObject headObj = this.deserObj((EntityType)this.subMainType, headItem.getValue());
                objs.add(headObj);
            }
        }
        return objs.toArray(new DynamicObject[0]);
    }

    public synchronized DynamicObject getHeadObj(Long billId) {
        DynamicObject dynamicObject = this.headObjs.get(billId);
        if (dynamicObject != null) {
            return dynamicObject;
        }
        String str = this.headObjStrs.get(billId);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return this.deserObj((EntityType)this.subMainType, str);
    }

    public synchronized void addHeadObjs(DynamicObject[] headObjs, boolean serObj) {
        if (headObjs == null) {
            return;
        }
        DataEntitySerializerOption headSerializerOption = this.getHeadSerializerOption();
        for (DynamicObject headObj : headObjs) {
            Long billId = (Long)headObj.getPkValue();
            if (!serObj) {
                this.headObjs.put(billId, headObj);
                continue;
            }
            String str = this.serObj(headObj, headSerializerOption);
            this.headObjStrs.put(billId, str);
            this.headObjs.remove(billId);
        }
    }

    public synchronized Map<EntityType, Map<Long, DynamicObject>> getEntryRowObjs() {
        return this.entryRowObjs;
    }

    public DynamicObject getEntryRowObj(EntityType entityType, Long entryId) {
        DynamicObject dynamicObject;
        Map<Long, DynamicObject> longDynamicObjectMap = this.entryRowObjs.get(entityType);
        if (longDynamicObjectMap != null && (dynamicObject = longDynamicObjectMap.get(entryId)) != null) {
            return dynamicObject;
        }
        Map<Long, String> longStringMap = this.entryRowStrs.get(entityType);
        if (longStringMap == null || !longStringMap.containsKey(entryId)) {
            return null;
        }
        String rowStr = longStringMap.get(entryId);
        DynamicObject rowObj = this.deserObj(entityType, rowStr);
        this.getRefrencedataProvider().fillReferenceData(new Object[]{rowObj}, (IDataEntityType)entityType);
        return rowObj;
    }

    public synchronized void addEntryRowObjs(EntityType entityType, DynamicObject[] rows, boolean serObj) {
        if (rows == null) {
            return;
        }
        if (!serObj) {
            if (!this.entryRowObjs.containsKey(entityType)) {
                this.entryRowObjs.put(entityType, new HashMap());
            }
            for (DynamicObject row : rows) {
                this.entryRowObjs.get(entityType).put((Long)row.getPkValue(), row);
            }
        } else {
            DataEntitySerializerOption rowSerializerOption = this.getRowSerializerOption();
            Map<Long, String> rowStrs = this.entryRowStrs.get(entityType);
            if (rowStrs == null) {
                rowStrs = new HashMap<Long, String>(rows.length);
                this.entryRowStrs.put(entityType, rowStrs);
            }
            for (DynamicObject row : rows) {
                String str = this.serObj(row, rowSerializerOption);
                rowStrs.put((Long)row.getPkValue(), str);
            }
        }
    }

    public synchronized Map<EntityType, List<DynamicObject>> nextPageEntryRowObjs() {
        int i;
        ArrayList<Long> entryIds;
        EntityType entityType = null;
        ArrayList<Object> rows = new ArrayList<Object>();
        for (Map.Entry<EntityType, Map<Long, DynamicObject>> entry : this.entryRowObjs.entrySet()) {
            entityType = entry.getKey();
            if (entry.getValue().isEmpty()) continue;
            if (entry.getValue().size() < 5000) {
                rows.addAll(entry.getValue().values());
                entry.getValue().clear();
                break;
            }
            entryIds = new ArrayList<Long>(entry.getValue().size());
            i = 0;
            for (Map.Entry<Long, Object> rowItem : entry.getValue().entrySet()) {
                entryIds.add(rowItem.getKey());
                rows.add(rowItem.getValue());
                if (++i < 5000) continue;
                break;
            }
            for (Long entryId : entryIds) {
                entry.getValue().remove(entryId);
            }
        }
        if (rows.isEmpty()) {
            for (Map.Entry<EntityType, Map<Long, Object>> entry : this.entryRowStrs.entrySet()) {
                entityType = entry.getKey();
                if (entry.getValue().isEmpty()) continue;
                entryIds = new ArrayList(entry.getValue().size());
                i = 0;
                for (Map.Entry<Long, Object> rowItem : entry.getValue().entrySet()) {
                    entryIds.add(rowItem.getKey());
                    DynamicObject rowObj = this.deserObj(entry.getKey(), (String)rowItem.getValue());
                    rows.add(rowObj);
                    if (++i < 5000) continue;
                    break;
                }
                for (Long entryId : entryIds) {
                    entry.getValue().remove(entryId);
                }
            }
        }
        if (rows.isEmpty()) {
            return null;
        }
        HashMap<EntityType, List<DynamicObject>> map = new HashMap<EntityType, List<DynamicObject>>();
        map.put(entityType, rows);
        return map;
    }

    public synchronized void serObjs() {
        DataEntitySerializerOption headSerializerOption = this.getHeadSerializerOption();
        for (Map.Entry<Long, DynamicObject> head : this.headObjs.entrySet()) {
            DynamicObject headObj = head.getValue();
            for (Map.Entry<EntityType, Map<Long, DynamicObject>> entry : this.entryRowObjs.entrySet()) {
                DynamicObjectCollection rows = headObj.getDynamicObjectCollection(entry.getKey().getName());
                rows.clear();
                rows.getDeleteRows().clear();
            }
            String str = this.serObj(head.getValue(), headSerializerOption);
            this.headObjStrs.put(head.getKey(), str);
        }
        this.headObjs.clear();
        this.headObjs = new HashMap<Long, DynamicObject>(1);
        DataEntitySerializerOption rowSerializerOption = this.getRowSerializerOption();
        for (Map.Entry<EntityType, Map<Long, DynamicObject>> mapItem : this.entryRowObjs.entrySet()) {
            if (!this.entryRowStrs.containsKey(mapItem.getKey())) {
                this.entryRowStrs.put(mapItem.getKey(), new HashMap());
            }
            Map<Long, String> rowStrs = this.entryRowStrs.get(mapItem.getKey());
            for (Map.Entry<Long, DynamicObject> rowItem : mapItem.getValue().entrySet()) {
                String str = this.serObj(rowItem.getValue(), rowSerializerOption);
                rowStrs.put(rowItem.getKey(), str);
            }
            mapItem.getValue().clear();
        }
        this.entryRowObjs.clear();
        this.entryRowObjs = new HashMap<EntityType, Map<Long, DynamicObject>>();
    }

    private String serObj(DynamicObject obj, DataEntitySerializerOption option) {
        return DataEntitySerializer.serializerToString((Object)obj, (DataEntitySerializerOption)option);
    }

    public synchronized void deserEntryRows() {
        for (Map.Entry<EntityType, Map<Long, String>> mapItem : this.entryRowStrs.entrySet()) {
            if (!this.entryRowObjs.containsKey(mapItem.getKey())) {
                this.entryRowObjs.put(mapItem.getKey(), new HashMap());
            }
            Map<Long, DynamicObject> rowObjs = this.entryRowObjs.get(mapItem.getKey());
            for (Map.Entry<Long, String> rowItem : mapItem.getValue().entrySet()) {
                DynamicObject rowObj = this.deserObj(mapItem.getKey(), rowItem.getValue());
                rowObjs.put(rowItem.getKey(), rowObj);
            }
            mapItem.getValue().clear();
        }
    }

    private DynamicObject deserObj(EntityType entityType, String str) {
        return (DynamicObject)DataEntitySerializer.deSerializerFromString((String)str, (IDataEntityType)entityType);
    }

    private DataEntitySerializerOption getHeadSerializerOption() {
        DataEntitySerializerOption headSerializerOption = new DataEntitySerializerOption();
        headSerializerOption.setIncludeDataEntityState(true);
        headSerializerOption.setIncludeComplexProperty(false);
        headSerializerOption.setIncludeCollectionProperty(true);
        headSerializerOption.setIncludeType(false);
        return headSerializerOption;
    }

    private DataEntitySerializerOption getRowSerializerOption() {
        DataEntitySerializerOption rowSerializerOption = new DataEntitySerializerOption();
        rowSerializerOption.setIncludeDataEntityState(true);
        rowSerializerOption.setIncludeComplexProperty(false);
        rowSerializerOption.setIncludeCollectionProperty(true);
        rowSerializerOption.setIncludeType(false);
        return rowSerializerOption;
    }

    public Set<CtBillCloseItem> getCtBillCloseItems() {
        return this.ctBillCloseItems;
    }

    public synchronized void addBillCloseItem(CtBillCloseItem ctBillCloseItem) {
        this.ctBillCloseItems.add(ctBillCloseItem);
    }

    public List<CtBOTPLog> getWbLogs() {
        return this.wbLogs;
    }

    public String getMutexGroupId() {
        return this.mutexGroupId;
    }

    public void setMutexGroupId(String mutexGroupId) {
        this.mutexGroupId = mutexGroupId;
    }

    public boolean isMutexStrict() {
        return this.mutexStrict;
    }

    public void setMutexStrict(boolean mutexStrict) {
        this.mutexStrict = mutexStrict;
    }

    public Set<String> getMutexDataIds() {
        return this.mutexDataIds;
    }

    public void addMutexDataIds(String billId) {
        this.mutexDataIds.add(billId);
    }

    private String getThread_mutex_id() {
        if (this.thread_mutex_id != null) {
            return this.thread_mutex_id;
        }
        this.thread_mutex_id = (String)ThreadCache.get((Object)"botp_sourcebillinfo_thread_mutex_id", (CacheLoader)new CacheLoader<String>(){

            public String load() {
                return DBServiceHelper.genStringId();
            }
        });
        return this.thread_mutex_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startNetworkCtrl(Set<String> srcBillIds) {
        if (srcBillIds.isEmpty()) {
            log.info("return, srcBillIds.isEmpty");
            return;
        }
        Object object = this.lockMutex;
        synchronized (object) {
            int try_again = 1;
            this.doStartNetworkCtrlNoRec(srcBillIds, try_again);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseDataMutex(StringBuilder errMsg) {
        Object object = this.lockMutex;
        synchronized (object) {
            return this.doReleaseDataMutex(errMsg);
        }
    }

    private void doStartNetworkCtrl(Set<String> srcBillIds, int try_again) {
        ArrayList<Map<String, Object>> mutexRequireList = new ArrayList<Map<String, Object>>(srcBillIds.size());
        for (String objId : srcBillIds) {
            if (this.mutexDataIds.contains(objId)) continue;
            Map<String, Object> requireParam = this.createDataMutexParam(objId);
            mutexRequireList.add(requireParam);
        }
        HashSet<String> failIds = new HashSet<String>();
        HashSet<String> successIds = new HashSet<String>();
        try (TXHandle h = TX.notSupported();){
            try (DataMutex dataMutex = DataMutex.create();){
                Map mutexResult = dataMutex.batchrequire(mutexRequireList);
                log.info(this.buildRequireMutexLog(srcBillIds, mutexResult));
                for (Map.Entry mutexItem : mutexResult.entrySet()) {
                    String objId = (String)mutexItem.getKey();
                    Boolean ret = (Boolean)mutexItem.getValue();
                    if (ret.booleanValue()) {
                        successIds.add(objId);
                        this.addMutexDataIds(objId);
                        continue;
                    }
                    if (this.mutexDataIds.contains(objId)) continue;
                    failIds.add(objId);
                }
                if (!successIds.isEmpty()) {
                    CtSourceBillMutexInfo.putSourceBillMutexCache(this.getThread_mutex_id(), this.getSubMainType().getName(), successIds.toArray(new String[0]));
                }
            }
            catch (IOException e) {
                ErrorCode ec = new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519;err:%s", (String)"SourceBillInfo_1", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), e.getMessage()));
                throw new KDException((Throwable)e, ec, new Object[0]);
            }
        }
        if (!failIds.isEmpty()) {
            if (try_again < this.MUTEX_TRY_AGAIN) {
                this.doStartNetworkCtrlAgain(failIds, try_again);
            } else {
                String msg = String.format(ResManager.loadKDString((String)"\u5e76\u53d1\u51b2\u7a81\uff0c\u53cd\u5199\u3010%s\u3011\u7533\u8bf7\u4e92\u65a5\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"SourceBillInfo_0", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.subMainType.getDisplayName().toString());
                throw new KDBizException(new ErrorCode(MUTEX_ERROR_CODE, msg), new Object[0]);
            }
        }
    }

    private void doStartNetworkCtrlNoRec(Set<String> srcBillIds, int try_again) {
        Set<Object> failIds = new HashSet();
        while (try_again < this.MUTEX_TRY_AGAIN && !(failIds = this.batchRequireMutex(srcBillIds)).isEmpty()) {
            ++try_again;
            this.sleep();
            Map<String, CtSourceBillMutexInfo> mutexInfos = this.refreshMutexInfos(failIds);
            if (mutexInfos.isEmpty()) {
                return;
            }
            int sameCount = this.getSameCount(mutexInfos);
            if (this.isBlankLastThreadMutexId(mutexInfos)) {
                if (sameCount < this.MAX_SAME_COUNT_BLANK) continue;
                if (sameCount == this.MAX_SAME_COUNT_BLANK) {
                    this.clearOverTimeMutex(mutexInfos);
                    continue;
                }
                log.info("SourceBillInfo.doStartNetworkCtrl() failed: curr_thread_mutex_id is null, try again " + String.valueOf(try_again));
                String msg = String.format(ResManager.loadKDString((String)"\u5e76\u53d1\u51b2\u7a81\uff0c\u53cd\u5199\u3010%s\u3011\u7533\u8bf7\u4e92\u65a5\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"SourceBillInfo_0", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.subMainType.getDisplayName().toString());
                throw new KDBizException(new ErrorCode(MUTEX_ERROR_CODE, msg), new Object[0]);
            }
            if (sameCount == this.MAX_SAME_COUNT_MUTEX_ID) continue;
            if (sameCount > this.MAX_SAME_COUNT_MUTEX_ID) {
                log.info("SourceBillInfo.doStartNetworkCtrl() failed: curr_thread_mutex_id is not null, try again " + String.valueOf(try_again));
                String msg = String.format(ResManager.loadKDString((String)"\u5e76\u53d1\u51b2\u7a81\uff0c\u53cd\u5199\u3010%s\u3011\u7533\u8bf7\u4e92\u65a5\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"SourceBillInfo_0", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.subMainType.getDisplayName().toString());
                throw new KDBizException(new ErrorCode(MUTEX_ERROR_CODE, msg), new Object[0]);
            }
            if (try_again >= this.MUTEX_TRY_AGAIN) {
                String msg = String.format(ResManager.loadKDString((String)"\u5e76\u53d1\u51b2\u7a81\uff0c\u53cd\u5199\u3010%s\u3011\u7533\u8bf7\u4e92\u65a5\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"SourceBillInfo_0", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.subMainType.getDisplayName().toString());
                throw new KDBizException(new ErrorCode(MUTEX_ERROR_CODE, msg), new Object[0]);
            }
            this.clearOverTimeMutex(mutexInfos);
        }
    }

    private Set<String> batchRequireMutex(Set<String> srcBillIds) {
        ArrayList<Map<String, Object>> mutexRequireList = new ArrayList<Map<String, Object>>(srcBillIds.size());
        for (String objId : srcBillIds) {
            if (this.mutexDataIds.contains(objId)) continue;
            Map<String, Object> requireParam = this.createDataMutexParam(objId);
            mutexRequireList.add(requireParam);
        }
        HashSet<String> failIds = new HashSet<String>();
        HashSet<String> successIds = new HashSet<String>();
        try (TXHandle h = TX.notSupported();){
            try (DataMutex dataMutex = DataMutex.create();){
                Map mutexResult = dataMutex.batchrequire(mutexRequireList);
                log.info(this.buildRequireMutexLog(srcBillIds, mutexResult));
                for (Map.Entry mutexItem : mutexResult.entrySet()) {
                    String objId = (String)mutexItem.getKey();
                    Boolean ret = (Boolean)mutexItem.getValue();
                    if (ret.booleanValue()) {
                        successIds.add(objId);
                        this.addMutexDataIds(objId);
                        continue;
                    }
                    if (this.mutexDataIds.contains(objId)) continue;
                    failIds.add(objId);
                }
                if (!successIds.isEmpty()) {
                    CtSourceBillMutexInfo.putSourceBillMutexCache(this.getThread_mutex_id(), this.getSubMainType().getName(), successIds.toArray(new String[0]));
                }
            }
            catch (IOException e) {
                ErrorCode ec = new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519;err:%s", (String)"SourceBillInfo_1", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), e.getMessage()));
                throw new KDException((Throwable)e, ec, new Object[0]);
            }
        }
        return failIds;
    }

    private void doStartNetworkCtrlAgain(Set<String> srcBillIds, int try_again) {
        while (try_again < this.MUTEX_TRY_AGAIN) {
            ++try_again;
            this.sleep();
            Map<String, CtSourceBillMutexInfo> mutexInfos = this.refreshMutexInfos(srcBillIds);
            if (mutexInfos.isEmpty()) {
                return;
            }
            int sameCount = this.getSameCount(mutexInfos);
            if (this.isBlankLastThreadMutexId(mutexInfos)) {
                if (sameCount < this.MAX_SAME_COUNT_BLANK) {
                    this.doStartNetworkCtrl(mutexInfos.keySet(), try_again);
                    break;
                }
                if (sameCount == this.MAX_SAME_COUNT_BLANK) {
                    this.clearOverTimeMutex(mutexInfos);
                    this.doStartNetworkCtrl(mutexInfos.keySet(), try_again);
                    break;
                }
                log.info("SourceBillInfo.doStartNetworkCtrl() failed: curr_thread_mutex_id is null, try again " + String.valueOf(try_again));
                String msg = String.format(ResManager.loadKDString((String)"\u5e76\u53d1\u51b2\u7a81\uff0c\u53cd\u5199\u3010%s\u3011\u7533\u8bf7\u4e92\u65a5\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"SourceBillInfo_0", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.subMainType.getDisplayName().toString());
                throw new KDBizException(new ErrorCode(MUTEX_ERROR_CODE, msg), new Object[0]);
            }
            if (sameCount == this.MAX_SAME_COUNT_MUTEX_ID) {
                this.doStartNetworkCtrl(mutexInfos.keySet(), try_again);
                break;
            }
            if (sameCount > this.MAX_SAME_COUNT_MUTEX_ID) {
                log.info("SourceBillInfo.doStartNetworkCtrl() failed: curr_thread_mutex_id is not null, try again " + String.valueOf(try_again));
                String msg = String.format(ResManager.loadKDString((String)"\u5e76\u53d1\u51b2\u7a81\uff0c\u53cd\u5199\u3010%s\u3011\u7533\u8bf7\u4e92\u65a5\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"SourceBillInfo_0", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.subMainType.getDisplayName().toString());
                throw new KDBizException(new ErrorCode(MUTEX_ERROR_CODE, msg), new Object[0]);
            }
            if (try_again >= this.MUTEX_TRY_AGAIN) {
                this.doStartNetworkCtrl(mutexInfos.keySet(), try_again);
                break;
            }
            this.clearOverTimeMutex(mutexInfos);
        }
    }

    private Map<String, CtSourceBillMutexInfo> refreshMutexInfos(Set<String> srcBillIds) {
        HashMap<String, CtSourceBillMutexInfo> mutexInfos = new HashMap<String, CtSourceBillMutexInfo>(srcBillIds.size());
        ArrayList<String> requireAgainBillIds = new ArrayList<String>(srcBillIds.size());
        for (String srcBillId : srcBillIds) {
            CtSourceBillMutexInfo ctSourceBillMutexInfo = this.thread_mutex_infos.get(srcBillId);
            if (ctSourceBillMutexInfo == null) {
                ctSourceBillMutexInfo = new CtSourceBillMutexInfo();
                this.thread_mutex_infos.put(srcBillId, ctSourceBillMutexInfo);
            }
            ctSourceBillMutexInfo.getSourceBillMutexCache(this.getSubMainType().getName(), srcBillId);
            if (!StringUtils.equals((CharSequence)ctSourceBillMutexInfo.getLastThreadMutexId(), (CharSequence)this.getThread_mutex_id())) {
                mutexInfos.put(srcBillId, ctSourceBillMutexInfo);
                continue;
            }
            requireAgainBillIds.add(srcBillId);
        }
        if (!requireAgainBillIds.isEmpty()) {
            log.warn(String.format("\u5728\u540c\u4e00\u4e2a\u4e8b\u52a1\u4e2d\uff0c\u91cd\u590d\u7533\u8bf7%s(%s)\u5355\u7684\u53cd\u5199\u7f51\u63a7\uff0c\u8bf4\u660e\u5728\u4e8b\u52a1\u4e2d\u5148\u540e\u91cd\u590d\u53cd\u5199\u540c\u4e00\u6e90\u5355\uff0c\u524d\u9762\u7684\u53cd\u5199\u7ed3\u679c\u53ef\u80fd\u4f1a\u88ab\u8986\u76d6\uff1b\u95ee\u9898\u5355\u636e\u5171%s\u5f20\uff0c\u5355\u636e\u5185\u7801\uff1a%s", this.getMainType().getDisplayName() != null ? this.getMainType().getDisplayName().toString() : this.getMainType().getName(), this.getMainType().getName(), requireAgainBillIds.size(), StringUtils.join((Object[])requireAgainBillIds.toArray(), (String)",")));
        }
        return mutexInfos;
    }

    private boolean isBlankLastThreadMutexId(Map<String, CtSourceBillMutexInfo> mutexInfos) {
        for (CtSourceBillMutexInfo mutexInfo : mutexInfos.values()) {
            if (!StringUtils.isNotBlank((CharSequence)mutexInfo.getLastThreadMutexId())) continue;
            return false;
        }
        return true;
    }

    private int getSameCount(Map<String, CtSourceBillMutexInfo> mutexInfos) {
        int sameCount = 0;
        if (!mutexInfos.isEmpty()) {
            sameCount = mutexInfos.entrySet().iterator().next().getValue().getSameCount();
        }
        for (CtSourceBillMutexInfo mutexInfo : mutexInfos.values()) {
            if (sameCount <= mutexInfo.getSameCount()) continue;
            sameCount = mutexInfo.getSameCount();
        }
        return sameCount;
    }

    private void clearOverTimeMutex(Map<String, CtSourceBillMutexInfo> mutexInfos) {
        try (DataMutex dataMutex = DataMutex.create();){
            for (Map.Entry<String, CtSourceBillMutexInfo> mutexInfo : mutexInfos.entrySet()) {
                String srcBillId;
                boolean success;
                if (!mutexInfo.getValue().isOverMaxTime() && (!StringUtils.isBlank((CharSequence)mutexInfo.getValue().getLastThreadMutexId()) || mutexInfo.getValue().getSameCount() < this.MAX_SAME_COUNT_BLANK) || !(success = dataMutex.forcerelease(srcBillId = mutexInfo.getKey(), this.getMainType().getName(), "writeback"))) continue;
                CtSourceBillMutexInfo.removeSourceBillMutexCache(this.getSubMainType().getName(), new String[]{srcBillId});
                log.info(String.format("\u67d0\u4e00\u56fa\u5b9a\u7ebf\u7a0b\u957f\u65f6\u95f4\u6301\u6709\u53cd\u5199\u7f51\u63a7\uff0c\u5bfc\u81f4\u5176\u4ed6\u7ebf\u7a0b\u88ab\u963b\u585e\uff0c\u5f3a\u5236\u91ca\u653e\uff1a%s, %s", this.getMainType().getName(), srcBillId));
            }
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
    }

    private void sleep() {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Map<String, Object> createDataMutexParam(String billId) {
        HashMap<String, Object> requireParam = new HashMap<String, Object>();
        requireParam.put("dataObjId", billId);
        requireParam.put("groupId", this.getMutexGroupId());
        requireParam.put("entityKey", this.getMainType().getName());
        requireParam.put("operationKey", "writeback");
        requireParam.put("isStrict", this.isMutexStrict());
        requireParam.put("isOpenIntentLocks", this.isOpenIntentClocks());
        return requireParam;
    }

    private String buildRequireMutexLog(Set<String> srcBillIds, Map<String, Boolean> mutexResult) {
        StringBuilder logMsg = new StringBuilder();
        logMsg.append("dataMutex.batchrequire(");
        logMsg.append(this.getSubMainType().getName()).append(",");
        logMsg.append(this.getMutexGroupId()).append(",");
        logMsg.append("writeback").append(",");
        logMsg.append(srcBillIds.size()).append(",");
        logMsg.append(srcBillIds.iterator().next());
        logMsg.append("), ");
        if (mutexResult == null) {
            logMsg.append("return null");
        } else {
            logMsg.append("return ");
            logMsg.append(SerializationUtils.toJsonString(mutexResult));
        }
        return logMsg.toString();
    }

    private String buildReleaseMutexLog() {
        StringBuilder logMsg = new StringBuilder();
        logMsg.append("dataMutex.batchRelease(");
        logMsg.append(this.getSubMainType().getName()).append(",");
        logMsg.append(this.getMutexGroupId()).append(",");
        logMsg.append("writeback").append(",");
        logMsg.append(this.getMutexDataIds().size()).append(",");
        logMsg.append(this.getMutexDataIds().iterator().next());
        logMsg.append(")");
        return logMsg.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doReleaseDataMutex(StringBuilder errMsg) {
        if (this.getMutexDataIds().isEmpty()) {
            return true;
        }
        ArrayList<Map<String, Object>> mutexRequireList = new ArrayList<Map<String, Object>>(this.getMutexDataIds().size());
        for (String billId : this.getMutexDataIds()) {
            Map<String, Object> requireParam = this.createDataMutexParam(billId);
            mutexRequireList.add(requireParam);
        }
        try (DataMutex dataMutex = DataMutex.create();){
            dataMutex.batchRelease(mutexRequireList);
        }
        catch (IOException e) {
            errMsg.append(ResManager.loadKDString((String)"\u91ca\u653e\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u51fa\u9519: ", (String)"SourceBillInfo_2", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0])).append(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            CtSourceBillMutexInfo.removeSourceBillMutexCache(this.getSubMainType().getName(), this.getMutexDataIds().toArray(new String[0]));
            log.info(this.buildReleaseMutexLog());
        }
        this.getMutexDataIds().clear();
        return true;
    }

    private IRefrencedataProvider getRefrencedataProvider() {
        if (this.refrencedataProvider == null) {
            this.refrencedataProvider = new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                    BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
                }
            };
        }
        return this.refrencedataProvider;
    }

    public boolean isOpenIntentClocks() {
        return this.isOpenIntentClocks;
    }

    public void setOpenIntentClocks(boolean openIntentClocks) {
        this.isOpenIntentClocks = openIntentClocks;
    }

    public boolean isSaveByNewThread() {
        return this.saveByNewThread;
    }

    public void setSaveByNewThread(boolean saveByNewThread) {
        this.saveByNewThread = saveByNewThread;
    }
}

