/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.bizentity;

import java.util.HashMap;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.servicehelper.TimeServiceHelper;

class CtSourceBillMutexInfo {
    private String last_thread_mutex_id = null;
    private long last_mutex_time = TimeServiceHelper.getTimeStamp();
    private int same_thread_mutex_count = 0;
    private static final String CACHE_DISTRIBUTE_WRITE_BACK_MUTEX = "BOS_WriteBack_Mutex";
    private static final String CACHE_TYPE = "BOS_WriteBack_Mutex";
    private static final long MAX_MUTEX_TIME = 600000L;

    private static DistributeSessionlessCache getDistributeCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("BOS_WriteBack_Mutex", new DistributeCacheHAPolicy(true, true));
    }

    private static String buildTypeName(String sourceEntityNumber) {
        return String.format("%s.%s.%s", CacheKeyUtil.getAcctId(), "BOS_WriteBack_Mutex", sourceEntityNumber);
    }

    public static void putSourceBillMutexCache(String thread_mutex_id, String sourceEntityNumber, String[] sourceBillIds) {
        HashMap<String, String> cacheValues = new HashMap<String, String>(sourceBillIds.length);
        long time = TimeServiceHelper.getTimeStamp();
        for (String sourceBillId : sourceBillIds) {
            String val = String.format("%s,%s", thread_mutex_id, time);
            cacheValues.put(sourceBillId, val);
        }
        String typeName = CtSourceBillMutexInfo.buildTypeName(sourceEntityNumber);
        CtSourceBillMutexInfo.getDistributeCache().put(typeName, cacheValues);
    }

    public static void removeSourceBillMutexCache(String sourceEntityNumber, String[] sourceBillIds) {
        String typeName = CtSourceBillMutexInfo.buildTypeName(sourceEntityNumber);
        CtSourceBillMutexInfo.getDistributeCache().remove(typeName, sourceBillIds);
    }

    public String getSourceBillMutexCache(String sourceEntityNumber, String sourceBillId) {
        String typeName = CtSourceBillMutexInfo.buildTypeName(sourceEntityNumber);
        String cacheValue = (String)CtSourceBillMutexInfo.getDistributeCache().get(typeName, sourceBillId);
        if (StringUtils.equals((CharSequence)cacheValue, (CharSequence)this.last_thread_mutex_id) || StringUtils.isBlank((CharSequence)cacheValue) && StringUtils.isBlank((CharSequence)this.last_thread_mutex_id)) {
            ++this.same_thread_mutex_count;
        } else {
            this.last_mutex_time = TimeServiceHelper.getTimeStamp();
            if (StringUtils.isBlank((CharSequence)cacheValue)) {
                this.same_thread_mutex_count = 0;
                this.last_thread_mutex_id = null;
            } else {
                try {
                    String[] vals = cacheValue.split(",");
                    this.same_thread_mutex_count = StringUtils.equals((CharSequence)this.last_thread_mutex_id, (CharSequence)vals[0]) ? ++this.same_thread_mutex_count : 0;
                    this.last_thread_mutex_id = vals[0];
                    if (vals.length > 1 && StringUtils.isNumeric((CharSequence)vals[1])) {
                        this.last_mutex_time = Long.parseLong(vals[1]);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return cacheValue;
    }

    public String getLastThreadMutexId() {
        return this.last_thread_mutex_id;
    }

    public int getSameCount() {
        return this.same_thread_mutex_count;
    }

    public boolean isOverMaxTime() {
        if (Long.compare(this.last_mutex_time, 0L) == 0) {
            return false;
        }
        long currTime = TimeServiceHelper.getTimeStamp();
        return Long.compare(currTime - this.last_mutex_time, 600000L) > 0;
    }
}

