/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.entity.ctbotp.link.CtBillLk;
import kd.bos.service.ctbotp.track.bizentity.CtAED;
import kd.bos.service.ctbotp.track.bizentity.CtRow;
import kd.bos.service.ctbotp.track.bizentity.CtRowLinkId;
import kd.bos.service.ctbotp.track.bizentity.CtSheet;
import kd.bos.service.ctbotp.track.helper.CtBFTrackerDbService;

public class CtBillTrackerBuilder {
    Map<CtRowLinkId, CtBillLk> currBillTrackers = new HashMap<CtRowLinkId, CtBillLk>();
    Map<CtRowLinkId, CtBillLk> histBillTrackers = new HashMap<CtRowLinkId, CtBillLk>();
    CtBFTrackerDbService dbService;

    public CtBillTrackerBuilder(CtBFTrackerDbService dbService) {
        this.dbService = dbService;
    }

    public void buildCurrBillTracker(CtSheet sheet) {
        for (CtRow row : sheet.getCtRows().values()) {
            Long sTableId = this.dbService.loadMainTableId(row.getSId().getTableId());
            Long tTableId = this.dbService.loadMainTableId(row.getId().getTableId());
            CtRowLinkId linkId = new CtRowLinkId(sTableId, row.getSId().getBillId(), tTableId, row.getId().getBillId());
            if (this.currBillTrackers.containsKey(linkId)) continue;
            CtBillLk billTracker = new CtBillLk();
            billTracker.setSTableId(sTableId);
            billTracker.setSBillId(row.getSId().getBillId());
            billTracker.setTTableId(tTableId);
            billTracker.setTBillId(row.getId().getBillId());
            this.currBillTrackers.put(linkId, billTracker);
        }
    }

    public void buildHistBillTracker(List<Object> billTrackerObjs) {
        for (Object obj : billTrackerObjs) {
            CtBillLk billTracker = (CtBillLk)obj;
            CtRowLinkId linkId = new CtRowLinkId(billTracker.getSTableId(), billTracker.getSBillId(), billTracker.getTTableId(), billTracker.getTBillId());
            if (this.histBillTrackers.containsKey(linkId)) continue;
            this.histBillTrackers.put(linkId, billTracker);
        }
    }

    public CtAED<CtBillLk> sync() {
        CtRowLinkId linkId;
        CtAED<CtBillLk> aed = new CtAED<CtBillLk>();
        for (Map.Entry<CtRowLinkId, CtBillLk> entry : this.currBillTrackers.entrySet()) {
            linkId = entry.getKey();
            CtBillLk currTracker = entry.getValue();
            CtBillLk histTracker = this.histBillTrackers.get(linkId);
            if (histTracker != null) {
                aed.getEditList().add((Tuple<CtBillLk, CtBillLk>)new Tuple((Object)currTracker, (Object)histTracker));
                continue;
            }
            aed.getAddList().add(currTracker);
        }
        for (Map.Entry<CtRowLinkId, CtBillLk> entry : this.histBillTrackers.entrySet()) {
            linkId = entry.getKey();
            CtBillLk histTracker = entry.getValue();
            CtBillLk currTracker = this.currBillTrackers.get(linkId);
            if (currTracker != null) continue;
            aed.getDeleteList().add(histTracker);
        }
        return aed;
    }
}

