/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.ctbotp.log.CtBOTPLog;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.service.ctbotp.track.CtBFTrackerContext;
import kd.bos.service.ctbotp.track.CtBFTrackerResult;
import kd.bos.service.ctbotp.track.bizentity.CtSourceBillInfo;
import kd.bos.service.ctbotp.track.helper.CtBFTrackerDbService;
import kd.bos.service.ctbotp.track.helper.CtSaveTrackerAnsyResult;
import kd.bos.service.ctbotp.track.helper.CtSaveTrackerRunnable;
import kd.bos.service.ctbotp.track.helper.ICtSaveTracker;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

class CtSaveTrackerAnsy
implements ICtSaveTracker {
    private static Boolean isSaveTrackerAnsy = Boolean.valueOf(System.getProperty("botp_save_tracker_ansy_model", String.valueOf(Boolean.FALSE)));
    private static Integer trackerPoolNum = Integer.parseInt(System.getProperty("botp_save_tracker_pool_num", "16"));
    private static ThreadPool threadPool = isSaveTrackerAnsy != false ? ThreadPools.newFixedThreadPool((String)"SaveTrackerAnsy", (int)trackerPoolNum) : null;

    CtSaveTrackerAnsy() {
    }

    private boolean equalsDatabase(String dbRouteKey1, String dbRouteKey2) {
        return StringUtils.equalsIgnoreCase((CharSequence)dbRouteKey1, (CharSequence)dbRouteKey2);
    }

    @Override
    public void saveBeforeTrans(CtBFTrackerContext trackerContext, CtBFTrackerResult trackerResult, CtBFTrackerDbService dbService) {
    }

    @Override
    public void saveBeginTrans(CtBFTrackerContext trackerContext, CtBFTrackerResult trackerResult, CtBFTrackerDbService dbService) {
        trackerContext.setBotpLinkLog(trackerResult.saveBotpLinkLog.isBotpLinkLogOpen());
        ICtSaveTracker.deleteEntryTrackers(trackerContext, trackerResult, dbService);
    }

    @Override
    public void saveTrans(CtBFTrackerContext trackerContext, CtBFTrackerResult trackerResult, CtBFTrackerDbService dbService) {
        String dbRouteKey = trackerContext.getTrackerTypes().getEntryTrackerType().getDBRouteKey();
        ICtSaveTracker.saveEntryTrackers(trackerContext, trackerResult, dbService);
        String dbRouteBillTracker = trackerContext.getTrackerTypes().getBillTrackerType().getDBRouteKey();
        if (this.equalsDatabase(dbRouteKey, dbRouteBillTracker)) {
            ICtSaveTracker.saveBillTrackers(trackerContext, trackerResult, dbService);
        }
        HashSet<String> srcEntityNumbers = new HashSet<String>(trackerResult.getSrcBillInfos().size());
        for (CtSourceBillInfo sourceBillInfo : trackerResult.getSrcBillInfos().values()) {
            BillEntityType srcMainType;
            if (!srcEntityNumbers.contains(sourceBillInfo.getMainType().getName())) {
                srcEntityNumbers.add(sourceBillInfo.getMainType().getName());
                List<CtBOTPLog> toSourceLogs = trackerResult.getTrackerLog().getToSourceLogs(sourceBillInfo.getMainType().getName());
                sourceBillInfo.getWbLogs().clear();
                sourceBillInfo.getWbLogs().addAll(toSourceLogs);
            }
            if (this.equalsDatabase(dbRouteKey, (srcMainType = sourceBillInfo.getSubMainType()).getDBRouteKey())) {
                ICtSaveTracker.saveSourceBill(trackerContext, sourceBillInfo);
                ICtSaveTracker.saveWriteBackLogs(trackerContext, sourceBillInfo);
                ICtSaveTracker.updateWBLogFinishStatus(trackerContext, sourceBillInfo);
                continue;
            }
            if (!this.saveInTransDiffDB()) continue;
            this.saveSourceBillDiffDB(trackerContext, trackerResult, sourceBillInfo, dbService);
        }
    }

    @Override
    public void saveAfterTrans(CtBFTrackerContext trackerContext, CtBFTrackerResult trackerResult, CtBFTrackerDbService dbService) {
        String dbRouteBillTracker;
        String dbRouteKey = trackerContext.getTrackerTypes().getEntryTrackerType().getDBRouteKey();
        if (!this.equalsDatabase(dbRouteKey, dbRouteBillTracker = trackerContext.getTrackerTypes().getBillTrackerType().getDBRouteKey())) {
            this.saveBillTrackerDiffDB(trackerContext, trackerResult, dbService);
        }
        for (CtSourceBillInfo sourceBillInfo : trackerResult.getSrcBillInfos().values()) {
            BillEntityType srcMainType = sourceBillInfo.getSubMainType();
            if (this.equalsDatabase(dbRouteKey, srcMainType.getDBRouteKey()) || this.saveInTransDiffDB()) continue;
            this.saveSourceBillDiffDB(trackerContext, trackerResult, sourceBillInfo, dbService);
        }
    }

    @Override
    public void saveFinally(CtBFTrackerContext trackerContext, CtBFTrackerResult trackerResult, CtBFTrackerDbService dbService) {
    }

    protected boolean saveInTransDiffDB() {
        return false;
    }

    protected void saveBillTrackerDiffDB(CtBFTrackerContext trackerContext, CtBFTrackerResult trackerResult, CtBFTrackerDbService dbService) {
        if (!trackerResult.getNewBillTrackers().isEmpty() || !trackerResult.getDelBillTrackerIds().isEmpty()) {
            CtSaveTrackerRunnable task = new CtSaveTrackerRunnable();
            task.saveBillTracker(RequestContext.get(), trackerContext, trackerResult.getNewBillTrackers(), trackerResult.getDelBillTrackerIds(), trackerResult, dbService, RequestContext.get().getTraceId());
            CtSaveTrackerAnsyResult saveResult = null;
            try {
                if (isSaveTrackerAnsy.booleanValue()) {
                    Future ansyResult = threadPool.submit((Callable)task);
                    saveResult = (CtSaveTrackerAnsyResult)ansyResult.get();
                } else {
                    saveResult = task.call();
                }
            }
            catch (Exception e) {
                saveResult = new CtSaveTrackerAnsyResult();
                saveResult.setException(e);
            }
            if (saveResult.getException() instanceof KDBizException) {
                throw new KDBizException(saveResult.getException().getMessage());
            }
            if (saveResult.getException() != null) {
                throw new KDException(saveResult.getException(), new ErrorCode("saveBillTrackerDiffDB", "%s"), new Object[]{saveResult.getException().getMessage()});
            }
        }
    }

    protected void saveSourceBillDiffDB(CtBFTrackerContext trackerContext, CtBFTrackerResult trackerResult, CtSourceBillInfo sourceBillInfo, CtBFTrackerDbService dbService) {
        sourceBillInfo.setSaveByNewThread(true);
        CtSaveTrackerRunnable task = new CtSaveTrackerRunnable();
        task.setSourceBillInfo(sourceBillInfo);
        sourceBillInfo.deserEntryRows();
        DynamicObject[] srcBillObjs = sourceBillInfo.getHeadObjs();
        HashMap<EntityType, DynamicObject[]> srcEntryRows = new HashMap<EntityType, DynamicObject[]>(sourceBillInfo.getEntryRowObjs().size());
        for (Map.Entry<EntityType, Map<Long, DynamicObject>> entry : sourceBillInfo.getEntryRowObjs().entrySet()) {
            srcEntryRows.put(entry.getKey(), entry.getValue().values().toArray(new DynamicObject[0]));
        }
        task.saveSrcBill(RequestContext.get(), trackerContext, sourceBillInfo.getSubMainType(), srcBillObjs, srcEntryRows, sourceBillInfo.getCtBillCloseItems());
        if (isSaveTrackerAnsy.booleanValue()) {
            threadPool.execute((Runnable)task);
        } else {
            task.run();
        }
    }
}

