/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.helper;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.service.ctbotp.track.bizentity.CtAED;
import kd.bos.service.ctbotp.track.bizentity.CtRow;
import kd.bos.service.ctbotp.track.bizentity.CtRowId;
import kd.bos.service.ctbotp.track.bizentity.CtRowLinkId;
import kd.bos.service.ctbotp.track.bizentity.CtSheet;
import kd.bos.service.ctbotp.track.bizentity.CtSheets;
import kd.bos.service.ctbotp.track.bizentity.CtWRule;
import kd.bos.service.ctbotp.track.bizentity.CtWRuleItemId;
import kd.bos.service.ctbotp.track.bizentity.CtWRules;
import kd.bos.service.ctbotp.track.bizentity.CtWSRow;
import kd.bos.service.ctbotp.track.bizentity.CtWSRows;
import kd.bos.service.ctbotp.track.helper.CtWRuleCompiler;
import kd.bos.service.ctbotp.track.helper.CtWRuleItemCompiler;

public class CtSheetSync {
    private CtSheetSync() {
        throw new IllegalStateException(ResManager.loadKDString((String)"\u4e0d\u53ef\u5b9e\u4f8b\u5316\u7684\u7c7b", (String)"SheetSync_0", (String)"bos-mservice-botp", (Object[])new Object[0]));
    }

    public static CtAED<CtRow> syncRows(CtSheets sheets, CtSheets snapshot) {
        CtAED<CtSheet> r1 = CtSheetSync.syncSheet(sheets, snapshot);
        CtAED<CtRow> r2 = new CtAED<CtRow>();
        for (CtSheet ctSheet : r1.getAddList()) {
            r2.getAddList().addAll(ctSheet.getCtRows().values());
        }
        for (Tuple tuple : r1.getEditList()) {
            CtSheetSync.syncRow((CtSheet)tuple.item1, (CtSheet)tuple.item2, r2);
        }
        for (CtSheet ctSheet : r1.getDeleteList()) {
            r2.getDeleteList().addAll(ctSheet.getCtRows().values());
        }
        return r2;
    }

    private static CtAED<CtSheet> syncSheet(CtSheets sheets, CtSheets snapshot) {
        CtAED<CtSheet> aed = new CtAED<CtSheet>();
        for (CtSheet sheet : sheets.values()) {
            CtSheet sheetSnap = (CtSheet)snapshot.get(sheet.getBillId());
            if (sheetSnap != null) {
                aed.getEditList().add((Tuple<CtSheet, CtSheet>)new Tuple((Object)sheet, (Object)sheetSnap));
                continue;
            }
            aed.getAddList().add(sheet);
        }
        for (CtSheet sheetSnap : snapshot.values()) {
            CtSheet sheet = (CtSheet)sheets.get(sheetSnap.getBillId());
            if (sheet != null) continue;
            aed.getDeleteList().add(sheetSnap);
        }
        return aed;
    }

    private static void syncRow(CtSheet sheet, CtSheet sheetSnap, CtAED<CtRow> aed) {
        CtRowLinkId linkId;
        for (Map.Entry item : sheet.getCtRows().entrySet()) {
            linkId = (CtRowLinkId)item.getKey();
            CtRow row = (CtRow)item.getValue();
            CtRow rowSnap = (CtRow)sheetSnap.getCtRows().get(linkId);
            if (rowSnap != null) {
                row.setEntryTrackerId(rowSnap.getEntryTrackerId());
                rowSnap.setEntityRow(row.getEntityRow());
                rowSnap.setLinkEntryRow(row.getLinkEntryRow());
                aed.getEditList().add((Tuple<CtRow, CtRow>)new Tuple((Object)row, (Object)rowSnap));
                continue;
            }
            aed.getAddList().add(row);
        }
        for (Map.Entry item : sheetSnap.getCtRows().entrySet()) {
            linkId = (CtRowLinkId)item.getKey();
            CtRow rowSnap = (CtRow)item.getValue();
            CtRow row = (CtRow)sheet.getCtRows().get(linkId);
            if (row != null) continue;
            aed.getDeleteList().add(rowSnap);
        }
    }

    public static CtAED<CtWRule> syncWRules(CtAED<CtRow> aedRows) {
        CtAED<CtWRule> r = new CtAED<CtWRule>();
        for (CtRow ctRow : aedRows.getAddList()) {
            r.getAddList().addAll(ctRow.getWrules().values());
        }
        for (CtRow ctRow : aedRows.getDeleteList()) {
            r.getDeleteList().addAll(ctRow.getWrules().values());
        }
        for (Tuple tuple : aedRows.getEditList()) {
            CtRow currRow = (CtRow)tuple.item1;
            CtRow snapRow = (CtRow)tuple.item2;
            CtSheetSync.syncWRule(currRow.getWrules(), snapRow.getWrules(), r);
        }
        return r;
    }

    private static void syncWRule(CtWRules currWRules, CtWRules snapWRules, CtAED<CtWRule> r) {
        CtWRuleItemId ruleItemId;
        for (Map.Entry item : currWRules.entrySet()) {
            ruleItemId = (CtWRuleItemId)item.getKey();
            CtWRule currWRule = (CtWRule)item.getValue();
            CtWRule snapWRule = (CtWRule)snapWRules.get(ruleItemId);
            if (snapWRule != null) {
                r.getEditList().add((Tuple<CtWRule, CtWRule>)new Tuple((Object)currWRule, (Object)snapWRule));
                continue;
            }
            r.getAddList().add(currWRule);
        }
        for (Map.Entry item : snapWRules.entrySet()) {
            ruleItemId = (CtWRuleItemId)item.getKey();
            CtWRule snapWRule = (CtWRule)item.getValue();
            CtWRule currWRule = (CtWRule)currWRules.get(ruleItemId);
            if (currWRule != null) continue;
            r.getDeleteList().add(snapWRule);
        }
    }

    public static void calcRealAmount(Map<Long, CtWRuleCompiler> rules, List<CtWRule> lstWRules) {
        BigDecimal rollBack = new BigDecimal(-1);
        for (CtWRule wRule : lstWRules) {
            CtWSRow execRow;
            wRule.getResultSourceRows().clear();
            wRule.getResultSourceRows().putAll(wRule.getCurrSourceRows());
            CtAED<CtWSRow> aed = CtSheetSync.syncWSRow(wRule.getCurrSourceRows(), wRule.getHistorySourceRows());
            for (CtWSRow ctWSRow : aed.getDeleteList()) {
                execRow = new CtWSRow(ctWSRow);
                execRow.setVal(execRow.getVal().multiply(rollBack));
                CtWRuleCompiler rule = rules.get(wRule.getRuleVerId());
                CtWRuleItemCompiler ruleItem = rule.getItems().get(wRule.getRuleItemId());
                execRow.setCVal(IFieldHandle.getFieldDefaultValue(null, (DynamicProperty)ruleItem.getSourceField()));
                wRule.getExecuteSourceRows().put(execRow.getSId(), execRow);
            }
            for (Tuple tuple : aed.getEditList()) {
                CtWSRow currRow = (CtWSRow)tuple.item1;
                CtWSRow snapRow = (CtWSRow)tuple.item2;
                BigDecimal val = currRow.getVal().subtract(snapRow.getVal());
                CtWSRow execRow2 = new CtWSRow(currRow);
                execRow2.setVal(val);
                wRule.getExecuteSourceRows().put(execRow2.getSId(), execRow2);
            }
            for (CtWSRow ctWSRow : aed.getAddList()) {
                execRow = new CtWSRow(ctWSRow);
                wRule.getExecuteSourceRows().put(execRow.getSId(), execRow);
            }
        }
    }

    private static CtAED<CtWSRow> syncWSRow(CtWSRows currWSRows, CtWSRows snapWSRows) {
        CtRowId sId;
        CtAED<CtWSRow> aed = new CtAED<CtWSRow>();
        for (Map.Entry item : currWSRows.entrySet()) {
            sId = (CtRowId)((Object)item.getKey());
            CtWSRow currRow = (CtWSRow)item.getValue();
            CtWSRow snapRow = (CtWSRow)snapWSRows.get((Object)sId);
            if (snapRow != null) {
                aed.getEditList().add((Tuple<CtWSRow, CtWSRow>)new Tuple((Object)currRow, (Object)snapRow));
                continue;
            }
            aed.getAddList().add(currRow);
        }
        for (Map.Entry item : snapWSRows.entrySet()) {
            sId = (CtRowId)((Object)item.getKey());
            CtWSRow snapRow = (CtWSRow)item.getValue();
            CtWSRow currRow = (CtWSRow)currWSRows.get((Object)sId);
            if (currRow != null) continue;
            aed.getDeleteList().add(snapRow);
        }
        return aed;
    }
}

