/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.helper;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.runtime.CtCRBizRuleAction;
import kd.bos.entity.ctbotp.runtime.CtCRBizRuleContext;
import kd.bos.entity.ctbotp.runtime.CtCRBizRuleElement;
import kd.bos.entity.ctbotp.runtime.CtWriteBackBizRule;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.service.ctbotp.track.CtBFTrackerContext;
import kd.bos.service.ctbotp.track.getvaluemode.CtFieldVariable;
import kd.bos.service.ctbotp.track.getvaluemode.CtGetConstValue;
import kd.bos.service.ctbotp.track.getvaluemode.CtGetFormulaValue;
import kd.bos.service.ctbotp.track.getvaluemode.ICtGetValueMode;
import kd.bos.service.ctbotp.track.helper.CtCRBizRuleDoNothing;
import kd.bos.service.ctbotp.track.helper.CtWRuleCompiler;

public class CtWBizRuleCompiler {
    private CtBFTrackerContext trackerContext;
    private CtWRuleCompiler ruleCompiler;
    private CtWriteBackBizRule bizRule;
    private ICtGetValueMode preConditionExecuter;
    private CtCRBizRuleAction actionTrue;
    private CtCRBizRuleAction actionFalse;
    private Map<String, IDataEntityProperty> sourceFields = new HashMap<String, IDataEntityProperty>();

    public CtWBizRuleCompiler(CtBFTrackerContext trackerContext, CtWRuleCompiler ruleCompiler, CtWriteBackBizRule bizRule) {
        this.trackerContext = trackerContext;
        this.ruleCompiler = ruleCompiler;
        this.bizRule = bizRule;
        this.compile();
    }

    public CtBFTrackerContext getTrackerContext() {
        return this.trackerContext;
    }

    public CtWRuleCompiler getRuleCompiler() {
        return this.ruleCompiler;
    }

    public CtWriteBackBizRule getBizRule() {
        return this.bizRule;
    }

    public Map<String, IDataEntityProperty> getSourceFields() {
        return this.sourceFields;
    }

    public void doAction(RowDataModel rowDataModel, DynamicObject activeRow) {
        boolean pass = (Boolean)this.preConditionExecuter.getValue(rowDataModel);
        if (pass) {
            this.actionTrue.doAction(rowDataModel, activeRow);
        } else {
            this.actionFalse.doAction(rowDataModel, activeRow);
        }
    }

    private void compile() {
        this.compileCondition();
        this.compileBizRuleAction();
    }

    private void compileCondition() {
        String preCondition;
        this.preConditionExecuter = this.bizRule.getPreCondition() == null ? new CtGetConstValue(Boolean.TRUE) : (StringUtils.isBlank((CharSequence)(preCondition = this.bizRule.getPreCondition().buildFullFormula((MainEntityType)this.ruleCompiler.getSourceMainType()))) ? new CtGetConstValue(Boolean.TRUE) : new CtGetFormulaValue(this.ruleCompiler.getSourceMainType(), preCondition, this.trackerContext.getFuncLib()));
        for (CtFieldVariable var : this.preConditionExecuter.getVars()) {
            this.sourceFields.put(var.getFieldProp().getName(), var.getFieldProp());
        }
    }

    private void compileBizRuleAction() {
        this.actionTrue = this.createBizRuleAction(this.bizRule.getBizRuleTrue());
        this.actionFalse = this.createBizRuleAction(this.bizRule.getBizRuleFalse());
        this.sourceFields.putAll(this.actionTrue.getFieldProps());
        this.sourceFields.putAll(this.actionFalse.getFieldProps());
    }

    private CtCRBizRuleAction createBizRuleAction(CtCRBizRuleElement bizRuleElement) {
        CtCRBizRuleDoNothing bizRuleAction = new CtCRBizRuleDoNothing();
        if (bizRuleElement != null && StringUtils.isNotBlank((CharSequence)bizRuleElement.getRunActionClass())) {
            bizRuleAction = (CtCRBizRuleAction)TypesContainer.createInstance((String)bizRuleElement.getRunActionClass());
        }
        CtCRBizRuleContext bizRuleContext = new CtCRBizRuleContext(this.ruleCompiler.getSourceMainType(), this.getRuleCompiler().getRule(), bizRuleElement);
        bizRuleContext.setFuncLib(this.trackerContext.getFuncLib());
        bizRuleAction.setContext(bizRuleContext);
        return bizRuleAction;
    }
}

