/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.ctbotp.log.CtBOTPLog;
import kd.bos.entity.ctbotp.log.CtTCLogDetailInfo;
import kd.bos.entity.ctbotp.log.CtTCLogRow;
import kd.bos.entity.ctbotp.log.CtWBLogDetailInfo;
import kd.bos.entity.ctbotp.log.CtWBLogRow;
import kd.bos.service.ctbotp.track.bizentity.CtRow;
import kd.bos.service.ctbotp.track.bizentity.CtRowId;
import kd.bos.service.ctbotp.track.bizentity.CtRowLinkId;
import kd.bos.service.ctbotp.track.bizentity.CtSheet;
import kd.bos.service.ctbotp.track.bizentity.CtSheets;
import kd.bos.service.ctbotp.track.bizentity.CtWRule;
import kd.bos.service.ctbotp.track.bizentity.CtWRuleItemId;
import kd.bos.service.ctbotp.track.bizentity.CtWSRow;

public class CtWbLogBuilder {
    public CtSheets createSheets(CtBOTPLog tcLog, CtBOTPLog wbLog) {
        if (tcLog == null || wbLog == null) {
            return null;
        }
        if (!(tcLog.getDetailInfo() instanceof CtTCLogDetailInfo)) {
            return null;
        }
        if (!(wbLog.getDetailInfo() instanceof CtWBLogDetailInfo)) {
            return null;
        }
        CtTCLogDetailInfo tcDetails = (CtTCLogDetailInfo)tcLog.getDetailInfo();
        CtWBLogDetailInfo wbDetails = (CtWBLogDetailInfo)wbLog.getDetailInfo();
        CtSheets sheets = new CtSheets(tcDetails.getEntityKey(), tcDetails.getLinkEntryKey());
        CtSheet sheet = new CtSheet();
        sheet.setBillId(tcLog.getTBillId());
        sheets.put(tcLog.getTBillId(), sheet);
        ArrayList allTcRows = new ArrayList();
        allTcRows.addAll(tcDetails.getHistRows());
        allTcRows.addAll(tcDetails.getAddRows());
        HashMap<Long, CtTCLogRow> tcRows = new HashMap<Long, CtTCLogRow>();
        for (CtTCLogRow tcRow : allTcRows) {
            if (tcDetails.getDelTcIds().contains(tcRow.getId())) continue;
            tcRows.put(tcRow.getId(), tcRow);
        }
        ArrayList allWbRows = new ArrayList();
        allWbRows.addAll(wbDetails.getHistWBs());
        allWbRows.addAll(wbDetails.getAddWBs());
        HashMap<Long, ArrayList<CtWBLogRow>> wbRowsByTcId = new HashMap<Long, ArrayList<CtWBLogRow>>(tcDetails.getHistRows().size());
        for (CtWBLogRow ctWBLogRow : allWbRows) {
            if (wbDetails.getDelWbIds().contains(ctWBLogRow.getId())) continue;
            ArrayList<CtWBLogRow> list = (ArrayList<CtWBLogRow>)wbRowsByTcId.get(ctWBLogRow.getTc());
            if (list == null) {
                list = new ArrayList<CtWBLogRow>();
                wbRowsByTcId.put(ctWBLogRow.getTc(), list);
            }
            list.add(ctWBLogRow);
        }
        for (Map.Entry entry : tcRows.entrySet()) {
            CtTCLogRow tcRow = (CtTCLogRow)entry.getValue();
            CtRow row = this.createRow(sheet, tcLog, tcRow);
            List wbRows = (List)wbRowsByTcId.get(tcRow.getId());
            if (wbRows == null) continue;
            for (CtWBLogRow wbRow : wbRows) {
                CtWRule wRule = this.createWRule(row, wbLog, wbRow);
                wRule.getCurrSourceRows().putAll(wRule.getHistorySourceRows());
                wRule.getHistorySourceRows().clear();
            }
        }
        return sheets;
    }

    public CtSheets createSnapshot(CtBOTPLog tcLog, CtBOTPLog wbLog) {
        if (tcLog == null || wbLog == null) {
            return null;
        }
        if (!(tcLog.getDetailInfo() instanceof CtTCLogDetailInfo)) {
            return null;
        }
        if (!(wbLog.getDetailInfo() instanceof CtWBLogDetailInfo)) {
            return null;
        }
        CtTCLogDetailInfo tcDetails = (CtTCLogDetailInfo)tcLog.getDetailInfo();
        CtWBLogDetailInfo wbDetails = (CtWBLogDetailInfo)wbLog.getDetailInfo();
        CtSheets sheets = new CtSheets(tcDetails.getEntityKey(), tcDetails.getLinkEntryKey());
        CtSheet sheet = new CtSheet();
        sheet.setBillId(tcLog.getTBillId());
        sheets.put(tcLog.getTBillId(), sheet);
        HashMap<Long, ArrayList<CtWBLogRow>> wbRowsByTcId = new HashMap<Long, ArrayList<CtWBLogRow>>(tcDetails.getHistRows().size());
        for (CtWBLogRow wbRow : wbDetails.getHistWBs()) {
            ArrayList<CtWBLogRow> list = (ArrayList<CtWBLogRow>)wbRowsByTcId.get(wbRow.getTc());
            if (list == null) {
                list = new ArrayList<CtWBLogRow>();
                wbRowsByTcId.put(wbRow.getTc(), list);
            }
            list.add(wbRow);
        }
        for (CtTCLogRow tcRow : tcDetails.getHistRows()) {
            CtRow row = this.createRow(sheet, tcLog, tcRow);
            List wbRows = (List)wbRowsByTcId.get(tcRow.getId());
            if (wbRows == null) continue;
            for (CtWBLogRow wbRow : wbRows) {
                this.createWRule(row, wbLog, wbRow);
            }
        }
        return sheets;
    }

    private CtRow createRow(CtSheet sheet, CtBOTPLog tcLog, CtTCLogRow tcRow) {
        Long sMainTableId = tcLog.getSTableId();
        Long sBillId = tcRow.getSb();
        Long sTableId = tcRow.getSt();
        Long sId = tcRow.getSi();
        Long mainTableId = tcLog.getTTableId();
        Long tableId = tcRow.getTt();
        Long tId = tcRow.getTi();
        CtRowLinkId linkId = new CtRowLinkId(sTableId, sId, tableId, tId);
        CtRow row = (CtRow)sheet.getCtRows().get(linkId);
        if (row == null) {
            row = new CtRow();
            row.setEntryTrackerId(tcRow.getId());
            CtRowId rowId = new CtRowId("", "", mainTableId, sheet.getBillId(), tableId, tId);
            row.setId(rowId);
            CtRowId sRowId = new CtRowId("", "", sMainTableId, sBillId, sTableId, sId);
            row.setSId(sRowId);
            sheet.getCtRows().put(linkId, row);
        }
        return row;
    }

    private CtWRule createWRule(CtRow row, CtBOTPLog wbLog, CtWBLogRow wbRow) {
        Long ruleVerId = wbRow.getRv();
        Long ruleItemId = wbRow.getRi();
        CtWRuleItemId itemId = new CtWRuleItemId(ruleVerId, ruleItemId);
        CtWRule wRule = (CtWRule)row.getWrules().get(itemId);
        if (wRule == null) {
            wRule = new CtWRule();
            wRule.setRuleItemId(ruleItemId);
            wRule.setRuleVerId(ruleVerId);
            row.getWrules().put(itemId, wRule);
        }
        Long wb_SBillId = wbRow.getSb();
        Long wb_STableId = wbRow.getSt();
        Long wb_SId = wbRow.getSi();
        BigDecimal wb_value = wbRow.getV();
        Long wb_SMainTableId = wbLog.getSTableId();
        CtWSRow wsRow = new CtWSRow();
        wsRow.setWBEntryId(wbRow.getId());
        CtRowId sId = new CtRowId("", "", wb_SMainTableId, wb_SBillId, wb_STableId, wb_SId);
        wsRow.setSId(sId);
        wsRow.setVal(wb_value);
        wRule.getHistorySourceRows().put(sId, wsRow);
        return wRule;
    }
}

