/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.helper;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ctbotp.link.CtBillLk;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.service.ctbotp.track.helper.CtWriteBackMessage;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CtWriteBackMQConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(CtWriteBackMQConsumer.class);

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        block5: {
            try {
                CtWriteBackMessage messageArgs = (CtWriteBackMessage)message;
                if (messageArgs.isSaveSrcBill()) {
                    this.saveSrcBill(messageArgs);
                } else if (messageArgs.isSaveBillTracker()) {
                    this.saveBillTracker(messageArgs);
                }
                acker.ack(messageId);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                if (!resend) break block5;
                acker.ack(messageId);
            }
        }
    }

    private void saveSrcBill(CtWriteBackMessage message) {
        DynamicObject[] srcBillObjs = message.getSrcDataEntities();
        if (srcBillObjs != null) {
            SaveServiceHelper.save((DynamicObject[])srcBillObjs);
        }
    }

    private void saveBillTracker(CtWriteBackMessage message) {
        IDataEntityType billTrackerType = OrmUtils.getDataEntityType(CtBillLk.class);
        try (TXHandle h = TX.beginRequired();){
            if (message.getSaveBillTrackers() != null && !message.getSaveBillTrackers().isEmpty()) {
                SaveServiceHelper.save((IDataEntityType)billTrackerType, (Object[])message.getSaveBillTrackers().toArray());
            }
            if (message.getDelBillTrackerIds() != null && !message.getDelBillTrackerIds().isEmpty()) {
                DeleteServiceHelper.delete((IDataEntityType)billTrackerType, (Object[])message.getDelBillTrackerIds().toArray());
            }
        }
    }
}

