/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.ctbotp.plugin.tracker.CtBillCloseType;
import kd.bos.entity.ctbotp.plugin.tracker.args.CtAfterSaveSourceBillEventArgs;
import kd.bos.entity.ctbotp.plugin.tracker.args.CtBeforeSaveSourceBillEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ctbotp.track.CtBFTrackerContext;
import kd.bos.service.ctbotp.track.CtBFTrackerResult;
import kd.bos.service.ctbotp.track.bizentity.CtBillCloseItem;
import kd.bos.service.ctbotp.track.bizentity.CtSourceBillInfo;
import kd.bos.service.ctbotp.track.helper.CtBFTrackerDbService;
import kd.bos.service.ctbotp.track.helper.CtSaveTrackerAnsy;
import kd.bos.xdb.hint.ShardingHintContext;

public interface ICtSaveTracker {
    public static final Log log = LogFactory.getLog(ICtSaveTracker.class);

    public static ICtSaveTracker get() {
        return new CtSaveTrackerAnsy();
    }

    public void saveBeforeTrans(CtBFTrackerContext var1, CtBFTrackerResult var2, CtBFTrackerDbService var3);

    default public void saveBeginTrans(CtBFTrackerContext trackerContext, CtBFTrackerResult trackerResult, CtBFTrackerDbService dbService) {
    }

    public void saveTrans(CtBFTrackerContext var1, CtBFTrackerResult var2, CtBFTrackerDbService var3);

    default public void saveAfterTrans(CtBFTrackerContext trackerContext, CtBFTrackerResult trackerResult, CtBFTrackerDbService dbService) {
    }

    default public void rollbackSave(CtBFTrackerContext trackerContext, CtBFTrackerResult trackerResult, CtBFTrackerDbService dbService) {
    }

    default public void saveFinally(CtBFTrackerContext trackerContext, CtBFTrackerResult trackerResult, CtBFTrackerDbService dbService) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveEntryTrackers(CtBFTrackerContext trackerContext, CtBFTrackerResult trackerResult, CtBFTrackerDbService dbService) {
        ShardingHintContext ctx;
        if (trackerContext.getOperateLog().isWriteLog()) {
            trackerContext.getOperateLog().info(String.format("saveEntryTrackers(add %s row, del %s row, del %s wb_row, add %s wb_row", trackerResult.getNewEntryTrackers().size(), trackerResult.getDelEntryTrackerIds().size(), trackerResult.getDelWBSnapIds().size(), trackerResult.getNewWBSnaps().size()));
        }
        if ((ctx = ShardingHinter.tryHint((IDataEntityType)trackerContext.getTargetMainType(), (Object[])trackerContext.getTargetBillIds().toArray())) != null) {
            try {
                ctx.set();
                dbService.saveEntryTrackers(trackerResult.getNewEntryTrackers());
                dbService.deleteEntryTrackers(trackerResult.getDelEntryTrackerIds());
                dbService.deleteWBSnap(trackerResult.getDelWBSnapIds());
                dbService.saveWBSnap(trackerResult.getNewWBSnaps());
            }
            finally {
                ctx.close();
            }
        } else {
            dbService.saveEntryTrackers(trackerResult.getNewEntryTrackers());
            dbService.deleteEntryTrackers(trackerResult.getDelEntryTrackerIds());
            dbService.deleteWBSnap(trackerResult.getDelWBSnapIds());
            dbService.saveWBSnap(trackerResult.getNewWBSnaps());
        }
        if (!trackerResult.getTrackerLog().getToTargetLogs().isEmpty()) {
            String string = trackerContext.getTrackerTypes().getEntryTrackerType().getDBRouteKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteEntryTrackers(CtBFTrackerContext trackerContext, CtBFTrackerResult trackerResult, CtBFTrackerDbService dbService) {
        ShardingHintContext ctx;
        if (trackerContext.getOperateLog().isWriteLog()) {
            trackerContext.getOperateLog().info(String.format("deleteEntryTrackers(del %s row, del %s wb_row", trackerResult.getDelEntryTrackerIds().size(), trackerResult.getDelWBSnapIds().size()));
        }
        if ((ctx = ShardingHinter.tryHint((IDataEntityType)trackerContext.getTargetMainType(), (Object[])trackerContext.getTargetBillIds().toArray())) != null) {
            try {
                ctx.set();
                dbService.deleteEntryTrackers(trackerResult.getDelEntryTrackerIds());
                dbService.deleteWBSnap(trackerResult.getDelWBSnapIds());
                trackerResult.getDelWBSnapIds().clear();
                trackerResult.getDelEntryTrackerIds().clear();
                trackerResult.getDelEntryTrackers().clear();
            }
            finally {
                ctx.close();
            }
        } else {
            dbService.deleteEntryTrackers(trackerResult.getDelEntryTrackerIds());
            dbService.deleteWBSnap(trackerResult.getDelWBSnapIds());
            trackerResult.getDelWBSnapIds().clear();
            trackerResult.getDelEntryTrackerIds().clear();
            trackerResult.getDelEntryTrackers().clear();
        }
    }

    public static void saveBillTrackers(CtBFTrackerContext trackerContext, CtBFTrackerResult trackerResult, CtBFTrackerDbService dbService) {
        if (trackerContext.getOperateLog().isWriteLog()) {
            trackerContext.getOperateLog().info(String.format("saveBillTrackers(add %s bill, del %s bill", trackerResult.getNewBillTrackers().size(), trackerResult.getDelBillTrackerIds().size()));
        }
        dbService.saveBillTrackers(trackerResult.getNewBillTrackers());
        dbService.deleteBillTrackers(trackerResult.getDelBillTrackerIds());
        trackerContext.getOperateLog().important(ResManager.loadKDString((String)"\u53cd\u5199\u5f15\u64ce\uff0c\u540c\u6b65\u4fdd\u5b58\u5173\u8054\u5173\u7cfb\u5b8c\u6bd5", (String)"ISaveTracker_0", (String)"bos-mservice-botp", (Object[])new Object[0]));
    }

    public static void saveBillTrackers(CtBFTrackerContext trackerContext, CtBFTrackerResult trackerResult, CtBFTrackerDbService dbService, String sTraceId) {
        if (trackerContext.getOperateLog().isWriteLog()) {
            trackerContext.getOperateLog().info(String.format("saveBillTrackers(add %s bill, del %s bill", trackerResult.getNewBillTrackers().size(), trackerResult.getDelBillTrackerIds().size()));
        }
        dbService.saveBillTrackers(trackerResult.getNewBillTrackers());
        dbService.deleteBillTrackers(trackerResult.getDelBillTrackerIds());
        trackerContext.getOperateLog().important(ResManager.loadKDString((String)"\u53cd\u5199\u5f15\u64ce\uff0c\u540c\u6b65\u4fdd\u5b58\u5173\u8054\u5173\u7cfb\u5b8c\u6bd5", (String)"ISaveTracker_0", (String)"bos-mservice-botp", (Object[])new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSourceBill(CtBFTrackerContext trackerContext, CtSourceBillInfo sourceBillInfo) {
        BillEntityType srcMainType = sourceBillInfo.getSubMainType();
        Object[] srcBillObjs = sourceBillInfo.getHeadObjs();
        if (trackerContext.getOperateLog().isWriteLog() && srcMainType != null && srcBillObjs != null && srcBillObjs.length > 0) {
            trackerContext.getOperateLog().info(String.format("saveSourceBill(%s, %s, %s)", srcMainType.getName(), srcBillObjs.length, srcBillObjs[0].getPkValue()));
        }
        ICtSaveTracker.fireBeforeSaveSourceBill(trackerContext, srcMainType, (DynamicObject[])srcBillObjs);
        BusinessDataWriter.save((IDataEntityType)srcMainType, (Object[])srcBillObjs);
        ShardingHintContext ctx = null;
        if (srcBillObjs != null && srcMainType != null && ShardingHinter.isSharding((String)srcMainType.getAlias())) {
            Object[] pks = new Object[srcBillObjs.length];
            for (int i = 0; i < srcBillObjs.length; ++i) {
                pks[i] = srcBillObjs[i].getPkValue();
            }
            ctx = ShardingHinter.tryHint((IDataEntityType)srcMainType, (Object[])pks);
            if (ctx != null) {
                ctx.set();
            }
        }
        try {
            int rowCount = 0;
            Map<EntityType, List<DynamicObject>> entryRows = sourceBillInfo.nextPageEntryRowObjs();
            while (entryRows != null) {
                for (Map.Entry<EntityType, List<DynamicObject>> entry : entryRows.entrySet()) {
                    Object[] rows = entry.getValue().toArray(new DynamicObject[0]);
                    rowCount += rows.length;
                    BusinessDataWriter.save((IDataEntityType)((IDataEntityType)entry.getKey()), (Object[])rows);
                }
                entryRows = sourceBillInfo.nextPageEntryRowObjs();
            }
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
        }
        ICtSaveTracker.updateBillCloseStatus(trackerContext, (MainEntityType)srcMainType, (DynamicObject[])srcBillObjs, sourceBillInfo.getCtBillCloseItems());
        ICtSaveTracker.fireAfterSaveSourceBill(trackerContext, srcMainType, (DynamicObject[])srcBillObjs);
        if (srcMainType != null && srcBillObjs != null && srcBillObjs.length > 0) {
            String msg = String.format(ResManager.loadKDString((String)"\u53cd\u5199\u5f15\u64ce\uff0c\u540c\u6b65\u4fdd\u5b58\u6e90\u5355\u5b8c\u6bd5\uff1a%1$s, %2$s(%3$s bills)", (String)"ISaveTracker_1", (String)"bos-mservice-botp", (Object[])new Object[0]), srcMainType.getName(), srcBillObjs[0].getPkValue(), srcBillObjs.length);
            trackerContext.getOperateLog().important(msg);
        }
    }

    public static void updateBillCloseStatus(CtBFTrackerContext trackerContext, MainEntityType srcSubMainType, DynamicObject[] srcBillObjs, Set<CtBillCloseItem> billCloseItems) {
        if (billCloseItems.isEmpty()) {
            return;
        }
        HashMap closeFldGroup = new HashMap();
        for (CtBillCloseItem item : billCloseItems) {
            if (!closeFldGroup.containsKey(item.getBillCloseField())) {
                closeFldGroup.put(item.getBillCloseField(), new ArrayList());
            }
            ((List)closeFldGroup.get(item.getBillCloseField())).add(item);
        }
        HashSet closeBillIds = new HashSet();
        for (Map.Entry entry : closeFldGroup.entrySet()) {
            CtBillCloseItem billCloseItem = (CtBillCloseItem)((List)entry.getValue()).get(0);
            HashSet<Long> allBillIds = new HashSet<Long>(((List)entry.getValue()).size());
            for (CtBillCloseItem item : (List)entry.getValue()) {
                allBillIds.add(item.getBillId());
            }
            QFilter qFilter = new QFilter("id", "in", (Object)allBillIds.toArray());
            IDataEntityProperty prop = srcSubMainType.findProperty(billCloseItem.getEntryCloseField());
            String propName = prop.getName();
            if (prop.getParent() instanceof SubEntryType) {
                propName = prop.getParent().getParent().getName() + "." + prop.getParent().getName() + "." + prop.getName();
            } else if (prop.getParent() instanceof EntryType) {
                propName = prop.getParent().getName() + "." + prop.getName();
            }
            if (billCloseItem.getBillCloseType() == CtBillCloseType.OneRowClosed) {
                qFilter.and(new QFilter(propName, "=", (Object)billCloseItem.getEntryCloseSuccesStatus()));
            } else {
                qFilter.and(new QFilter(propName, "!=", (Object)billCloseItem.getEntryCloseSuccesStatus()));
                closeBillIds.addAll(allBillIds);
            }
            ORM orm = ORM.create();
            try (DataSet ds = orm.queryDataSet("ISaveTracker", srcSubMainType.getName(), "id", new QFilter[]{qFilter});){
                while (ds.hasNext()) {
                    Row row = ds.next();
                    Long id = row.getLong("id");
                    if (billCloseItem.getBillCloseType() == CtBillCloseType.OneRowClosed) {
                        closeBillIds.add(id);
                        continue;
                    }
                    closeBillIds.remove(id);
                }
            }
            for (DynamicObject srcBillObj : srcBillObjs) {
                Long id = srcBillObj.getLong("id");
                if (closeBillIds.contains(id)) {
                    srcBillObj.set(billCloseItem.getBillCloseField(), (Object)billCloseItem.getBillCloseSuccesStatus());
                    continue;
                }
                srcBillObj.set(billCloseItem.getBillCloseField(), (Object)billCloseItem.getBillCloseFailStatus());
            }
            BusinessDataWriter.save((IDataEntityType)srcSubMainType, (Object[])srcBillObjs);
            closeBillIds.clear();
        }
    }

    public static void saveWriteBackLogs(CtBFTrackerContext trackerContext, CtSourceBillInfo sourceBillInfo) {
    }

    public static void updateWBLogFinishStatus(CtBFTrackerContext trackerContext, CtSourceBillInfo sourceBillInfo) {
    }

    public static CtBeforeSaveSourceBillEventArgs fireBeforeSaveSourceBill(CtBFTrackerContext trackerContext, BillEntityType srcSubMainType, DynamicObject[] srcDataEntities) {
        CtBeforeSaveSourceBillEventArgs eventArgs = new CtBeforeSaveSourceBillEventArgs(srcSubMainType, srcDataEntities);
        trackerContext.getPlugInProxy().fireBeforeSaveSourceBill(eventArgs);
        return eventArgs;
    }

    public static CtAfterSaveSourceBillEventArgs fireAfterSaveSourceBill(CtBFTrackerContext trackerContext, BillEntityType srcSubMainType, DynamicObject[] srcDataEntities) {
        CtAfterSaveSourceBillEventArgs eventArgs = new CtAfterSaveSourceBillEventArgs(srcSubMainType, srcDataEntities);
        trackerContext.getPlugInProxy().fireAfterSaveSourceBill(eventArgs);
        return eventArgs;
    }

    public static CtBeforeSaveSourceBillEventArgs ansyFireBeforeSaveSourceBill(CtBFTrackerContext trackerContext, BillEntityType srcSubMainType, DynamicObject[] srcDataEntities) {
        CtBeforeSaveSourceBillEventArgs eventArgs = new CtBeforeSaveSourceBillEventArgs(srcSubMainType, srcDataEntities);
        eventArgs.setNewThread(true);
        trackerContext.getPlugInProxy().fireBeforeSaveSourceBill(eventArgs);
        return eventArgs;
    }

    public static CtAfterSaveSourceBillEventArgs ansyFireAfterSaveSourceBill(CtBFTrackerContext trackerContext, BillEntityType srcSubMainType, DynamicObject[] srcDataEntities) {
        CtAfterSaveSourceBillEventArgs eventArgs = new CtAfterSaveSourceBillEventArgs(srcSubMainType, srcDataEntities);
        eventArgs.setNewThread(true);
        trackerContext.getPlugInProxy().fireAfterSaveSourceBill(eventArgs);
        return eventArgs;
    }
}

