/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.wblogicunit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.service.ctbotp.track.CtWriteBackContext;
import kd.bos.service.ctbotp.track.bizentity.CtRowId;
import kd.bos.service.ctbotp.track.bizentity.CtWRule;
import kd.bos.service.ctbotp.track.bizentity.CtWSRow;
import kd.bos.service.ctbotp.track.helper.CtWBizRuleCompiler;
import kd.bos.service.ctbotp.track.helper.CtWRuleCompiler;
import kd.bos.service.ctbotp.track.wblogicunit.AbstractCtCtWriteBackLogicUnit;

class CtBizRuleLogic
extends AbstractCtCtWriteBackLogicUnit {
    public CtBizRuleLogic(CtWriteBackContext writeBackContext) {
        super(writeBackContext);
    }

    @Override
    public void doWriteBack(RowDataModel rowDataModel, List<CtWRule> wRules) {
        Map<Long, Map<CtRowId, List<CtWSRow>>> dctRules = this.splitByRule(wRules);
        for (Map.Entry<Long, Map<CtRowId, List<CtWSRow>>> entryRule : dctRules.entrySet()) {
            Long ruleVerId = entryRule.getKey();
            CtWRuleCompiler ruleCompiler = this.writeBackContext.getRules().get(ruleVerId);
            Map<CtRowId, List<CtWSRow>> dctRule = entryRule.getValue();
            this.execBizRuleLogic(rowDataModel, ruleCompiler, dctRule);
        }
    }

    private Map<Long, Map<CtRowId, List<CtWSRow>>> splitByRule(List<CtWRule> wRules) {
        HashMap<Long, Map<CtRowId, List<CtWSRow>>> dctRules = new HashMap<Long, Map<CtRowId, List<CtWSRow>>>();
        for (CtWRule wRule : wRules) {
            Long ruleVerId = wRule.getRuleVerId();
            Map dctRule = dctRules.computeIfAbsent(ruleVerId, v -> new HashMap());
            for (CtWSRow wsRow : wRule.getExecuteSourceRows().values()) {
                List listRow = dctRule.computeIfAbsent(wsRow.getSId(), v -> new ArrayList());
                listRow.add(wsRow);
            }
        }
        return dctRules;
    }

    private void execBizRuleLogic(RowDataModel rowDataModel, CtWRuleCompiler ruleCompiler, Map<CtRowId, List<CtWSRow>> dctRule) {
        if (ruleCompiler.getBizRules().size() == 0) {
            return;
        }
        for (CtWBizRuleCompiler bizRuleCompiler : ruleCompiler.getBizRules()) {
            for (Map.Entry<CtRowId, List<CtWSRow>> entryRow : dctRule.entrySet()) {
                CtWSRow wsRow = entryRow.getValue().get(0);
                DynamicObject activeRow = wsRow.getSrcActiveRow();
                rowDataModel.setRowContext(activeRow);
                bizRuleCompiler.doAction(rowDataModel, activeRow);
            }
        }
    }
}

