/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.track.wblogicunit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.plugin.tracker.CtBillCloseType;
import kd.bos.entity.ctbotp.plugin.tracker.args.CtAfterCloseRowEventArgs;
import kd.bos.entity.ctbotp.plugin.tracker.args.CtBeforeCloseRowEventArgs;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.service.ctbotp.track.CtWriteBackContext;
import kd.bos.service.ctbotp.track.bizentity.CtBillCloseItem;
import kd.bos.service.ctbotp.track.bizentity.CtRowId;
import kd.bos.service.ctbotp.track.bizentity.CtSourceBillInfo;
import kd.bos.service.ctbotp.track.bizentity.CtWRule;
import kd.bos.service.ctbotp.track.bizentity.CtWSRow;
import kd.bos.service.ctbotp.track.helper.CtWRuleCompiler;
import kd.bos.service.ctbotp.track.wblogicunit.AbstractCtCtWriteBackLogicUnit;

class CtCloseRowLogic
extends AbstractCtCtWriteBackLogicUnit {
    public CtCloseRowLogic(CtWriteBackContext writeBackContext) {
        super(writeBackContext);
    }

    @Override
    public void doWriteBack(RowDataModel rowDataModel, List<CtWRule> wRules) {
        Map<Long, Map<Long, Map<CtRowId, List<CtWSRow>>>> dctRules = this.splitByRule(wRules);
        for (Map.Entry<Long, Map<Long, Map<CtRowId, List<CtWSRow>>>> entryRule : dctRules.entrySet()) {
            Long ruleVerId = entryRule.getKey();
            CtWRuleCompiler ruleCompiler = this.writeBackContext.getRules().get(ruleVerId);
            Map<Long, Map<CtRowId, List<CtWSRow>>> dctRule = entryRule.getValue();
            this.execRuleCloseLogic(rowDataModel, ruleCompiler, dctRule);
        }
    }

    private Map<Long, Map<Long, Map<CtRowId, List<CtWSRow>>>> splitByRule(List<CtWRule> wRules) {
        HashMap<Long, Map<Long, Map<CtRowId, List<CtWSRow>>>> dctRules = new HashMap<Long, Map<Long, Map<CtRowId, List<CtWSRow>>>>();
        for (CtWRule wRule : wRules) {
            Long ruleVerId = wRule.getRuleVerId();
            HashMap dctRule = (HashMap)dctRules.get(ruleVerId);
            if (dctRule == null) {
                dctRule = new HashMap();
                dctRules.put(ruleVerId, dctRule);
            }
            for (CtWSRow wsRow : wRule.getExecuteSourceRows().values()) {
                ArrayList<CtWSRow> listRow;
                Long sBillId = wsRow.getSId().getBillId();
                HashMap<CtRowId, ArrayList<CtWSRow>> dctBill = (HashMap<CtRowId, ArrayList<CtWSRow>>)dctRule.get(sBillId);
                if (dctBill == null) {
                    dctBill = new HashMap<CtRowId, ArrayList<CtWSRow>>();
                    dctRule.put(sBillId, dctBill);
                }
                if ((listRow = (ArrayList<CtWSRow>)dctBill.get((Object)wsRow.getSId())) == null) {
                    listRow = new ArrayList<CtWSRow>();
                    dctBill.put(wsRow.getSId(), listRow);
                }
                listRow.add(wsRow);
            }
        }
        return dctRules;
    }

    private void execRuleCloseLogic(RowDataModel rowDataModel, CtWRuleCompiler ruleCompiler, Map<Long, Map<CtRowId, List<CtWSRow>>> dctRule) {
        if (!ruleCompiler.isCloseSrcRow()) {
            return;
        }
        for (Map.Entry<Long, Map<CtRowId, List<CtWSRow>>> entryBill : dctRule.entrySet()) {
            Map<CtRowId, List<CtWSRow>> dctBill = entryBill.getValue();
            this.execBillCloseLogic(rowDataModel, ruleCompiler, dctBill);
        }
    }

    private void execBillCloseLogic(RowDataModel rowDataModel, CtWRuleCompiler ruleCompiler, Map<CtRowId, List<CtWSRow>> dctBill) {
        for (Map.Entry<CtRowId, List<CtWSRow>> entryRow : dctBill.entrySet()) {
            CtWSRow wsRow = entryRow.getValue().get(0);
            CtBeforeCloseRowEventArgs beforeEventArgs = this.firePlugBeforeEvent(ruleCompiler, wsRow);
            if (beforeEventArgs.isCancel()) continue;
            rowDataModel.setRowContext(wsRow.getSrcActiveRow());
            boolean closeRow = ruleCompiler.checkCloseRow(rowDataModel);
            if (closeRow) {
                rowDataModel.setValue(ruleCompiler.getRule().getEntryCloseFieldKey(), (Object)ruleCompiler.getRule().getEntryCloseFieldSuccesStatus());
            } else {
                rowDataModel.setValue(ruleCompiler.getRule().getEntryCloseFieldKey(), (Object)ruleCompiler.getRule().getEntryCloseFieldFailStatus());
            }
            CtAfterCloseRowEventArgs ctAfterCloseRowEventArgs = this.firePlugAfterEvent(ruleCompiler, wsRow, closeRow);
        }
        if (ruleCompiler.isCloseSrcBill()) {
            DynamicObject firstRow = dctBill.entrySet().iterator().next().getValue().get(0).getSrcActiveRow();
            DynamicObject billObj = this.getBillObj(firstRow);
            CtBillCloseItem billCloseItem = new CtBillCloseItem((Long)billObj.getPkValue(), ruleCompiler.getRule().getBillCloseFieldKey(), ruleCompiler.getRule().getBillCloseFieldSuccesStatus(), ruleCompiler.getRule().getBillCloseFieldFailStatus(), ruleCompiler.getRule().getBillCloseType(), ruleCompiler.getRule().getEntryCloseFieldKey(), ruleCompiler.getRule().getEntryCloseFieldSuccesStatus(), ruleCompiler.getRule().getEntryCloseFieldFailStatus());
            CtSourceBillInfo sourceBillInfo = this.writeBackContext.getTrackerResult().getSrcBillInfos().get(this.writeBackContext.buildSrcBillInfoKey());
            sourceBillInfo.addBillCloseItem(billCloseItem);
        }
    }

    private DynamicObject getBillObj(DynamicObject activeRow) {
        DynamicObject parentObj = activeRow;
        while (parentObj.getParent() != null) {
            parentObj = (DynamicObject)parentObj.getParent();
        }
        return parentObj;
    }

    private boolean checkCloseBill(CtWRuleCompiler ruleCompiler, DynamicObject billObj) {
        ExtendedDataEntitySet extDataSet = new ExtendedDataEntitySet();
        extDataSet.Parse(new DynamicObject[]{billObj}, (MainEntityType)this.writeBackContext.getSrcSubMainType());
        String fieldKey = ruleCompiler.getEntryCloseStatusProp().getName();
        String entryKey = ruleCompiler.getEntryCloseStatusProp().getParent().getName();
        String closeStatus = ruleCompiler.getRule().getEntryCloseFieldSuccesStatus();
        ExtendedDataEntity[] rows = extDataSet.FindByEntityKey(entryKey);
        if (rows.length == 0) {
            return false;
        }
        int closeRowCount = 0;
        for (ExtendedDataEntity row : rows) {
            String currRowStatus = (String)row.getValue(fieldKey);
            if (closeStatus.equalsIgnoreCase(currRowStatus)) {
                ++closeRowCount;
            }
            if (closeRowCount <= 0 || ruleCompiler.getRule().getBillCloseType() != CtBillCloseType.OneRowClosed) continue;
            return true;
        }
        return closeRowCount > 0 && ruleCompiler.getRule().getBillCloseType() == CtBillCloseType.OneRowClosed || closeRowCount == rows.length;
    }

    private CtBeforeCloseRowEventArgs firePlugBeforeEvent(CtWRuleCompiler rule, CtWSRow wsRow) {
        CtBeforeCloseRowEventArgs eventArgs = new CtBeforeCloseRowEventArgs(rule.getRule(), this.writeBackContext.getSrcSubMainType(), this.getSrcEntityType(wsRow), wsRow.getSrcActiveRow(), this.writeBackContext.getCtLinkItemContext().getEntityType(), wsRow.getParent().getParent().getEntityRow());
        this.writeBackContext.getTrackerContext().getPlugInProxy().fireBeforeCloseRow(eventArgs);
        return eventArgs;
    }

    private CtAfterCloseRowEventArgs firePlugAfterEvent(CtWRuleCompiler rule, CtWSRow wsRow, boolean closeRow) {
        CtAfterCloseRowEventArgs eventArgs = new CtAfterCloseRowEventArgs(rule.getRule(), this.writeBackContext.getSrcSubMainType(), this.getSrcEntityType(wsRow), wsRow.getSrcActiveRow(), this.writeBackContext.getCtLinkItemContext().getEntityType(), wsRow.getParent().getParent().getEntityRow());
        this.writeBackContext.getTrackerContext().getPlugInProxy().fireAfterCloseRow(eventArgs);
        return eventArgs;
    }
}

