/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.api.Probe;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.ctbotp.apiresponse.CtBotpApiRes;
import kd.bos.entity.ctbotp.apiresponse.CtBotpApiResult;
import kd.bos.entity.ctbotp.constants.CtApiUrlEnum;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.entity.param.CustomParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.form.auditlog.TokenResult;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.param.impl.ParameterReaderServiceImpl;
import kd.bos.service.ctbotp.openapi.param.CtAttachmentDownloadArgs;
import kd.bos.service.ctbotp.utils.CtBotpTenantUtils;
import kd.bos.servicehelper.ctsy.CtsyApiDispatchServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.HttpClientUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.SystemDefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

public class CtBotpApiUtils {
    private static final String CTBOTP_API_USER_PARAM_KEY = "ctbotpGetUserByRequestContext";
    private static final String CONNECTION_TIMEOUT = "CTBOTP_OPENAPI_CONNECTION_TIMEOUT";
    private static final String BOS_MSERVICE_CTBOTP = "bos-mservice-ctbotp";
    private static Log log = LogFactory.getLog(CtBotpApiUtils.class);
    private static int ctbotp_connectionTimeout = Integer.getInteger("httpclient.connectionTimeout", 120000);
    private static String TOKEN_URL = "/api/getAppToken.do";
    private static final String LOGIN_URL = "/api/login.do?language=";
    private static String format = "yyyy-MM-dd HH:mm:ss";
    private static final String CT_ACCESSTOKEN = "CtAccessToken";
    private static String SCHEME_HTTPS = "https";
    private static FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();

    public static String get(String tenantCode, String accountId, CtApiUrlEnum ctBotpApi, Map<String, Object> body) {
        log.info("param body:{},tenantCode:{},accountId:{},api:{}", new Object[]{SerializationUtils.toJsonString(body), tenantCode, accountId, ctBotpApi.getUrl()});
        return CtsyApiDispatchServiceHelper.get((String)tenantCode, (String)accountId, (String)ctBotpApi.getUrl(), body);
    }

    public static String get(String tenantCode, String accountId, String apiUrl, Map<String, Object> body) {
        return CtBotpApiUtils.get(tenantCode, accountId, apiUrl, body, CtBotpApiUtils.getConnectionTimeout(), CtBotpApiUtils.getConnectionTimeout());
    }

    public static String post(String tenantCode, String accountId, CtApiUrlEnum ctBotpApi, String body) {
        log.info("param body:{},tenantCode:{},accountId:{},api:{}", new Object[]{SerializationUtils.toJsonString((Object)body), tenantCode, accountId, ctBotpApi.getUrl()});
        return CtsyApiDispatchServiceHelper.post((String)tenantCode, (String)accountId, (String)ctBotpApi.getUrl(), (String)body);
    }

    public static CtBotpApiResult<CtBotpApiRes> ctBotpPost(String tenantCode, String accountId, CtApiUrlEnum ctApiUrlEnum, String body) {
        return CtBotpApiUtils.ctBotpPost(tenantCode, accountId, ctApiUrlEnum, body, CtBotpApiUtils.getConnectionTimeout(), CtBotpApiUtils.getConnectionTimeout());
    }

    public static String post(String tenantCode, String accountId, String apiUrl, String body) {
        return CtBotpApiUtils.post(tenantCode, accountId, apiUrl, body, CtBotpApiUtils.getConnectionTimeout(), CtBotpApiUtils.getConnectionTimeout());
    }

    public static String postForDownloadFile(String tenantCode, String accountId, CtApiUrlEnum ctBotpApi, CtAttachmentDownloadArgs downloadArgs) {
        return CtBotpApiUtils.postForDownloadFile(tenantCode, accountId, ctBotpApi.getUrl(), downloadArgs, CtBotpApiUtils.getConnectionTimeout(), CtBotpApiUtils.getConnectionTimeout());
    }

    public static String postForDownloadFile(String tenantCode, String accountId, String apiUrl, CtAttachmentDownloadArgs downloadArgs, int connectionTimeout, int readTimeout) {
        DynamicObject tenant = CtBotpTenantUtils.getTenantInfoById(tenantCode, accountId);
        String preUrl = CtBotpApiUtils.getPreUrl(tenant);
        String accessToken = CtBotpApiUtils.getAccessToken(tenant);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("accessToken", accessToken);
        header.put("Content-Type", "application/json");
        if (!preUrl.endsWith("/")) {
            preUrl = preUrl + "/";
        }
        preUrl = preUrl + "kapi/";
        String resultData = null;
        try {
            String url = preUrl + apiUrl;
            resultData = CtBotpApiUtils.postForDownloadFile(url, header, downloadArgs, connectionTimeout, readTimeout);
            log.info("postForDownloadFile result : " + resultData);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u8fde\u63a5API\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u67e5\u8be2\u65e5\u5fd7\u3002", (String)"CtBotpApiUtils_2", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]));
        }
        CtBotpApiUtils.processErrorMessage(resultData, tenant);
        return resultData;
    }

    private static String postForDownloadFile(String url, Map<String, String> header, CtAttachmentDownloadArgs downloadArgs, int connectionTimeout, int readTimeout) throws IOException {
        String resultData = "";
        String CONTENT_TYPE_TEXT_JSON = "text/json;";
        HttpClient client = null;
        HttpPost post = new HttpPost(url);
        URI uri = post.getURI();
        if (SCHEME_HTTPS.equals(uri.getScheme())) {
            client = HttpClientUtils.wrapperHttpClient((int)connectionTimeout, (int)readTimeout);
            if (client == null) {
                return resultData;
            }
        } else {
            client = CtBotpApiUtils.createHttpClient(connectionTimeout, readTimeout);
            HttpParams httpParams = client.getParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)connectionTimeout);
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)readTimeout);
        }
        Object in = null;
        try {
            if (header != null && header.size() != 0) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    post.setHeader(entry.getKey(), entry.getValue());
                }
            }
            HashMap<String, CtAttachmentDownloadArgs> param = new HashMap<String, CtAttachmentDownloadArgs>(1);
            param.put("attachmentDownloadArgs", downloadArgs);
            String requestJson = SerializationUtils.toJsonString(param);
            StringEntity se = new StringEntity(requestJson, ContentType.APPLICATION_JSON);
            se.setContentType("text/json;");
            post.setEntity((HttpEntity)se);
            Probe.touch((String)"http");
            log.info("postForDownloadFile url : " + url);
            log.info("postForDownloadFile header : " + SerializationUtils.toJsonString(header));
            log.info("postForDownloadFile param : " + requestJson);
            HttpResponse response = client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() == 200) {
                HttpEntity resEntity = response.getEntity();
                if (response.getHeaders("OpenApi-Status") != null && response.getHeaders("OpenApi-Status").length > 0) {
                    if ("true".equals(response.getHeaders("OpenApi-Status")[0].getValue())) {
                        InputStream resultIn = resEntity.getContent();
                        String path = attachmentFileService.upload(new FileItem(downloadArgs.getFileName(), downloadArgs.getUploadPath(), resultIn));
                        CustomApiResult successApiReuslt = CustomApiResult.success((Object)path);
                        successApiReuslt.setErrorCode("0");
                        resultData = SerializationUtils.toJsonString((Object)successApiReuslt);
                    } else {
                        resultData = EntityUtils.toString((HttpEntity)resEntity);
                    }
                } else {
                    throw new KDException(new ErrorCode("UNKNOWN_OPENAPI_STATUS", "can not find header \u2018OpenApi-Status\u2019 "), new Object[0]);
                }
                String string = resultData;
                return string;
            }
            try {
                throw new KDException(new ErrorCode("UPLOADFAIL", "upload status is not 200"), new Object[0]);
            }
            catch (IOException ex) {
                log.warn("Http postjson error", (Throwable)ex);
                throw ex;
            }
        }
        finally {
            post.releaseConnection();
        }
    }

    private static HttpClient createHttpClient(int connectionTimeout, int readTimeout) {
        SystemDefaultHttpClient client = new SystemDefaultHttpClient();
        HttpParams httpParams = client.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)connectionTimeout);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)readTimeout);
        return client;
    }

    public static String get(String tenantCode, String accountId, String apiUrl, Map<String, Object> body, int connectionTimeout, int readTimeout) {
        String result = null;
        DynamicObject tenant = CtBotpTenantUtils.getTenantInfoById(tenantCode, accountId);
        String preUrl = CtBotpApiUtils.getPreUrl(tenant);
        String accessToken = CtBotpApiUtils.getAccessToken(tenant);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("accessToken", accessToken);
        if (!preUrl.endsWith("/")) {
            preUrl = preUrl + "/";
        }
        preUrl = preUrl + "kapi/";
        try {
            log.info("url:" + preUrl + apiUrl);
            log.info("param:" + SerializationUtils.toJsonString(body));
            result = HttpClientUtils.get((String)(preUrl + apiUrl), header, body, (int)connectionTimeout, (int)readTimeout);
            log.info("getResult:" + result);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u8fde\u63a5API\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u67e5\u8be2\u65e5\u5fd7\u3002", (String)"CtBotpApiUtils_2", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]));
        }
        CtBotpApiUtils.processErrorMessage(result, tenant);
        return result;
    }

    public static CtBotpApiResult<CtBotpApiRes> ctBotpPost(String tenantCode, String accountId, CtApiUrlEnum ctApiUrlEnum, String body, int connectionTimeout, int readTimeout) {
        DynamicObject tenant = CtBotpTenantUtils.getTenantInfoById(tenantCode, accountId);
        String preUrl = CtBotpApiUtils.getPreUrl(tenant);
        String accessToken = CtBotpApiUtils.getAccessToken(tenant);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("accessToken", accessToken);
        header.put("Content-Type", "application/json");
        if (!preUrl.endsWith("/")) {
            preUrl = preUrl + "/";
        }
        preUrl = preUrl + "kapi/";
        String result = null;
        try {
            log.info("url:" + preUrl + ctApiUrlEnum.getUrl());
            log.info("header:" + SerializationUtils.toJsonString(header));
            log.info("param:" + body);
            result = HttpClientUtils.postjson((String)(preUrl + ctApiUrlEnum.getUrl()), header, (String)body, (int)connectionTimeout, (int)readTimeout);
            log.info("postResult:" + result);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u8fde\u63a5API\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u67e5\u8be2\u65e5\u5fd7\u3002", (String)"CtBotpApiUtils_2", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]));
        }
        if (result == null) {
            String msg = ResManager.loadKDString((String)"api\u63a5\u53e3\u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"CtBotpApiUtils_7", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]);
            return CtBotpApiResult.fail((String)"800", (String)msg);
        }
        Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
        if (MapUtils.isEmpty((Map)openApiResult)) {
            String msg = ResManager.loadKDString((String)"api\u63a5\u53e3\u8fd4\u56de\u5185\u5bb9\u5e8f\u5217\u5316\u4e3amap\u4e3a\u7a7a\u3002", (String)"CtBotpApiUtils_5", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]);
            return CtBotpApiResult.fail((String)"800", (String)msg);
        }
        if (!Boolean.parseBoolean(openApiResult.get("status").toString()) || !openApiResult.get("errorCode").equals("0")) {
            String[] lines;
            String errorCode = openApiResult.get("errorCode") == null ? "" : openApiResult.get("errorCode").toString();
            String message = ResManager.loadKDString((String)"\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u9519\u8bef\u65e5\u5fd7\u3002", (String)"CtBotpApiUtils_6", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]);
            if (StringUtils.isBlank(openApiResult.get("message")) && (lines = openApiResult.get("message").toString().split("\n")).length > 0) {
                message = lines[0];
            }
            return CtBotpApiResult.fail((String)errorCode, (String)message);
        }
        CtBotpApiRes data = (CtBotpApiRes)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(openApiResult.get("data")), (Class)ctApiUrlEnum.getRes());
        return CtBotpApiResult.success((Object)data);
    }

    public static String post(String tenantCode, String accountId, String apiUrl, String body, int connectionTimeout, int readTimeout) {
        DynamicObject tenant = CtBotpTenantUtils.getTenantInfoById(tenantCode, accountId);
        String preUrl = CtBotpApiUtils.getPreUrl(tenant);
        String accessToken = CtBotpApiUtils.getAccessToken(tenant);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("accessToken", accessToken);
        header.put("Content-Type", "application/json");
        if (!preUrl.endsWith("/")) {
            preUrl = preUrl + "/";
        }
        preUrl = preUrl + "kapi/";
        String result = null;
        try {
            log.info("url:" + preUrl + apiUrl);
            log.info("header:" + SerializationUtils.toJsonString(header));
            log.info("param:" + body);
            result = HttpClientUtils.postjson((String)(preUrl + apiUrl), header, (String)body, (int)connectionTimeout, (int)readTimeout);
            log.info("postResult:" + result);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u8fde\u63a5API\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u67e5\u8be2\u65e5\u5fd7\u3002", (String)"CtBotpApiUtils_2", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]));
        }
        CtBotpApiUtils.processErrorMessage(result, tenant);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getAccessToken(DynamicObject tenant) {
        String localeId = RequestContext.get().getLang().toString();
        String accessToken = null;
        HashMap<String, String> map = new HashMap<String, String>(6);
        map.put("appId", tenant.getString("appid"));
        map.put("appSecuret", Encrypters.decode((String)tenant.getString("appsecret")));
        map.put("tenantid", tenant.getString("tenantid"));
        map.put("accountId", tenant.getString("accountid"));
        map.put("language", localeId);
        String key = CtBotpApiUtils.getKey(tenant);
        String accessTokenStr = CtBotpApiUtils.getAccessToken(key);
        Map tokenMap = null;
        if (StringUtils.isNotBlank((CharSequence)accessTokenStr)) {
            tokenMap = (Map)SerializationUtils.fromJsonString((String)CtBotpApiUtils.getAccessToken(key), Map.class);
        }
        if (tokenMap != null && Long.parseLong(tokenMap.get("expire_time").toString()) > System.currentTimeMillis()) {
            return String.valueOf(tokenMap.get("access_token"));
        }
        log.info("url:" + CtBotpApiUtils.getPreUrl(tenant) + TOKEN_URL);
        log.info("param:" + SerializationUtils.toJsonString(map));
        String result = "";
        try {
            result = HttpClientUtils.postAppJson((String)(CtBotpApiUtils.getPreUrl(tenant) + TOKEN_URL), null, map);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"API\u8ba4\u8bc1\u5931\u8d25\uff0c\u5bfc\u81f4\u8fde\u63a5\u79df\u6237\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u67e5\u8be2\u65e5\u5fd7\u3002", (String)"CtBotpApiUtils_0", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]));
        }
        log.info("result:" + result);
        TokenResult tokenResult = (TokenResult)JSONObject.parseObject((String)result, TokenResult.class);
        if (tokenResult == null) throw new KDBizException(result);
        if (tokenResult.getData() == null) throw new KDBizException(result);
        String appToken = tokenResult.getData().getApp_token();
        map.put("apptoken", appToken);
        map.put("user", CtBotpApiUtils.getUser(tenant));
        map.put("logintype", "2");
        String loginUrl = CtBotpApiUtils.getPreUrl(tenant) + LOGIN_URL + localeId;
        log.info("accessToken url:" + loginUrl);
        String accessTokenResult = "";
        try {
            accessTokenResult = HttpClientUtils.postAppJson((String)loginUrl, null, map);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"API\u8ba4\u8bc1\u5931\u8d25\uff0c\u5bfc\u81f4\u8fde\u63a5\u79df\u6237\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u67e5\u8be2\u65e5\u5fd7\u3002", (String)"CtBotpApiUtils_0", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]));
        }
        log.info("accessTokenResult:" + accessTokenResult);
        if (!StringUtils.isNotBlank((CharSequence)accessTokenResult)) throw new KDBizException(ResManager.loadKDString((String)"API\u8ba4\u8bc1\u5931\u8d25\uff0c\u5bfc\u81f4\u8fde\u63a5\u79df\u6237\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u67e5\u8be2\u65e5\u5fd7\u3002", (String)"CtBotpApiUtils_0", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]));
        Map openApiResult = (Map)SerializationUtils.fromJsonString((String)accessTokenResult, Map.class);
        if (openApiResult.get("status") != null && !Boolean.parseBoolean(openApiResult.get("status").toString())) {
            throw new KDBizException((String)openApiResult.get("errorMsg"));
        }
        Map dataResult = (Map)openApiResult.get("data");
        CtBotpApiUtils.putAccessToken(key, SerializationUtils.toJsonString((Object)dataResult));
        return String.valueOf(dataResult.get("access_token"));
    }

    private static String getPreUrl(DynamicObject tenant) {
        if (tenant == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u79df\u6237\u4fe1\u606f\u3002", (String)"CtBotpApiUtils_1", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]));
        }
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(tenant.getString("serverip"));
        urlBuilder.append(":");
        urlBuilder.append(tenant.getString("serverport"));
        if (!StringUtils.isEmpty((CharSequence)tenant.getString("web_app"))) {
            urlBuilder.append(tenant.getString("web_app"));
        }
        return urlBuilder.toString();
    }

    public static String getUrl(DynamicObject tenant) {
        String url = CtBotpApiUtils.getPreUrl(tenant);
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        return url;
    }

    private static String getUser(DynamicObject tenant) {
        ArrayList<Long> list = new ArrayList<Long>(1);
        list.add(RequestContext.get().getCurrUserId());
        List result = UserServiceHelper.get(list);
        String phone = String.valueOf(((Map)result.get(0)).get("phone"));
        String user = StringUtils.isNotBlank((CharSequence)phone) ? phone : String.valueOf(((Map)result.get(0)).get("username"));
        return user;
    }

    private static boolean getUserByRequestContext() {
        boolean checkParamFlag = false;
        ParameterReaderServiceImpl service = new ParameterReaderServiceImpl();
        HashSet<String> set = new HashSet<String>(1);
        set.add(CTBOTP_API_USER_PARAM_KEY);
        CustomParam customParam = new CustomParam(set);
        Map map = service.loadCustomParameterFromCache(customParam);
        if (map != null && map.get(CTBOTP_API_USER_PARAM_KEY) != null) {
            checkParamFlag = Boolean.parseBoolean((String)map.get(CTBOTP_API_USER_PARAM_KEY));
        }
        return checkParamFlag;
    }

    private static Integer getConnectionTimeout() {
        Integer connectionTimeout = ctbotp_connectionTimeout;
        ParameterReaderServiceImpl service = new ParameterReaderServiceImpl();
        HashSet<String> set = new HashSet<String>(1);
        set.add(CONNECTION_TIMEOUT);
        CustomParam customParam = new CustomParam(set);
        Map map = service.loadCustomParameterFromCache(customParam);
        if (map != null && map.get(CONNECTION_TIMEOUT) != null) {
            connectionTimeout = Integer.parseInt((String)map.get(CONNECTION_TIMEOUT));
        }
        return connectionTimeout;
    }

    private static void processErrorMessage(String result, DynamicObject tenant) {
        if (StringUtils.isBlank((CharSequence)result)) {
            String msg = String.format(ResManager.loadKDString((String)"\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u6c42\u79df\u6237\uff1a%s\u76f8\u5173\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u8bd5\u6216\u8005\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CtBotpApiUtils_4", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]), tenant.getString("tenantid"));
            throw new KDBizException(msg);
        }
        if (result.contains("errorCode") && result.contains("status")) {
            Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
            if (!Boolean.parseBoolean(openApiResult.get("status").toString()) || !openApiResult.get("errorCode").equals("0")) {
                if (openApiResult.get("errorCode").equals("401")) {
                    CtBotpApiUtils.removeAccessToken(CtBotpApiUtils.getKey(tenant));
                }
                String[] lines = openApiResult.get("message").toString().split("\n");
                String message = "null";
                if (lines.length > 0) {
                    message = lines[0];
                }
                throw new KDBizException(message);
            }
        } else {
            throw new KDBizException(result);
        }
    }

    private static DistributeSessionlessCache getDistributeCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(CT_ACCESSTOKEN, new DistributeCacheHAPolicy(true, true));
    }

    private static String buildCacheType(String type) {
        String accountId = CacheKeyUtil.getAcctId();
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        if (StringUtils.isNotBlank((CharSequence)appGroup) && !"defaultGroup".equals(appGroup)) {
            return String.format("%s_%s_%s", accountId, appGroup, type);
        }
        return String.format("%s_%s", accountId, type);
    }

    public static String getAccessToken(String key) {
        String type = CtBotpApiUtils.buildCacheType(CT_ACCESSTOKEN);
        return (String)CtBotpApiUtils.getDistributeCache().get(type, key);
    }

    public static void removeAccessToken(String key) {
        String type = CtBotpApiUtils.buildCacheType(CT_ACCESSTOKEN);
        CtBotpApiUtils.getDistributeCache().remove(type, key);
    }

    public static void putAccessToken(String key, String accessTokenStr) {
        String type = CtBotpApiUtils.buildCacheType(CT_ACCESSTOKEN);
        CtBotpApiUtils.getDistributeCache().put(type, key, (Object)accessTokenStr);
    }

    private static String getKey(DynamicObject tenant) {
        String key = tenant.getString("tenantid") + "_" + tenant.getString("accountid") + "_" + CtBotpApiUtils.getUser(tenant);
        return key;
    }
}

