/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.function;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.formula.BOSExpressionContext;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateExpressionContext;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;

public class IsDraw
implements BOSUDFunction {
    private ExpressionContext expContext;

    public IsDraw() {
    }

    public IsDraw(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public BOSUDFunction getInstance(ExpressionContext expContext) {
        return new IsDraw(expContext);
    }

    public Object call(Object ... arg0) {
        BOSExpressionContext bosExpContext = (BOSExpressionContext)this.expContext;
        String entityNumber = bosExpContext.getRowDataModel().getMainEntityType().getName();
        LinkSetElement linkSet = ConvertMetaServiceHelper.loadLinkSet(entityNumber);
        if (linkSet == null || linkSet.getItems() == null || linkSet.getItems().isEmpty()) {
            return Boolean.FALSE;
        }
        String entryKey = null;
        int parentIndex = 0;
        ArrayList<Integer> rowIndex = new ArrayList<Integer>();
        if (bosExpContext instanceof ValidateExpressionContext) {
            entryKey = (String)((ValidateExpressionContext)bosExpContext).getValidateContext().getOption().getVariables().get("entrykey");
        }
        int levelId = 0;
        if (StringUtils.isNotBlank(entryKey)) {
            String levelIdStr;
            String rowIndexStr;
            String parentIndexStr = (String)((ValidateExpressionContext)bosExpContext).getValidateContext().getOption().getVariables().get("parentindex");
            if (StringUtils.isNotBlank((CharSequence)parentIndexStr)) {
                parentIndex = Integer.parseInt(parentIndexStr);
            }
            if (StringUtils.isNotBlank((CharSequence)(rowIndexStr = (String)((ValidateExpressionContext)bosExpContext).getValidateContext().getOption().getVariables().get("rowindex")))) {
                rowIndex.addAll(SerializationUtils.fromJsonStringToList((String)rowIndexStr, Integer.class));
            }
            if (StringUtils.isNotBlank((CharSequence)(levelIdStr = ((ValidateExpressionContext)bosExpContext).getValidateContext().getOption().getVariableValue("levelId")))) {
                levelId = Integer.parseInt(levelIdStr);
            }
        } else {
            if (bosExpContext.getRowDataModel().getEntityType() instanceof LinkEntryType) {
                return this.haveSourceBillId((DynamicObject)bosExpContext.getRowDataModel().getActiveRow());
            }
            entryKey = bosExpContext.getRowDataModel().getEntityType() instanceof MainEntityType ? null : bosExpContext.getRowDataModel().getEntityKey();
        }
        boolean isDraw = false;
        isDraw = StringUtils.isBlank((CharSequence)entryKey) ? this.isDrawBill(bosExpContext, linkSet) : (!rowIndex.isEmpty() ? this.isDrawEntryRow((ValidateExpressionContext)bosExpContext, entryKey, parentIndex, rowIndex, linkSet, levelId) : this.isDrawEntryRow(bosExpContext, linkSet));
        return isDraw;
    }

    private boolean isDrawEntryRow(ValidateExpressionContext bosExpContext, String entryKey, int parentIndex, List<Integer> rowIndex, LinkSetElement linkSet, int levelId) {
        DynamicObject dataEntity = (DynamicObject)bosExpContext.getRowDataModel().getActiveRow();
        for (LinkSetItemElement linkEntry : linkSet.getItems()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)linkEntry.getParentEntityKey(), (CharSequence)entryKey)) continue;
            IDataEntityProperty linktype = ((EntityType)dataEntity.getDataEntityType()).findProperty(linkEntry.getLinkEntityKey());
            EntryType linkentryparent = (EntryType)linktype.getParent();
            DynamicObjectCollection linkEntryRows = null;
            if (linkentryparent instanceof SubEntryType) {
                DynamicObjectCollection entryrows = dataEntity.getDynamicObjectCollection(linkentryparent.getParent().getName());
                if (entryrows.isEmpty() || parentIndex >= entryrows.size()) continue;
                linkEntryRows = ((DynamicObject)entryrows.get(parentIndex)).getDynamicObjectCollection(linkentryparent.getName());
            } else {
                linkEntryRows = dataEntity.getDynamicObjectCollection(linkentryparent.getName());
            }
            boolean existConvertLink = false;
            ArrayList<OperateErrorInfo> operateErrorInfos = new ArrayList<OperateErrorInfo>(10);
            for (Integer rk : rowIndex) {
                if (rk >= linkEntryRows.size() || !this.haveSourceBillId(((DynamicObject)linkEntryRows.get(rk.intValue())).getDynamicObjectCollection(linktype))) continue;
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setPkValue(dataEntity.getPkValue());
                errorInfo.setLevel(ErrorLevel.valueOf((int)levelId));
                errorInfo.setMessage(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u5b58\u5728\u5173\u8054\u5173\u7cfb\u3002", (String)"IsDraw_0", (String)"bos-botp-business", (Object[])new Object[0]), rk + 1));
                operateErrorInfos.add(errorInfo);
                if (!existConvertLink) {
                    // empty if block
                }
                existConvertLink = true;
            }
            if (!existConvertLink) continue;
            ValidateResult validateResult = new ValidateResult();
            validateResult.setSuccess(false);
            validateResult.setAllErrorInfo(operateErrorInfos);
            bosExpContext.getValidateContext().getValidateResults().addValidateError("ExistPushLink", validateResult);
            return existConvertLink;
        }
        return false;
    }

    public String getName() {
        return "IsDraw";
    }

    private boolean isDrawBill(BOSExpressionContext bosExpContext, LinkSetElement linkSet) {
        DynamicObject billObj = (DynamicObject)bosExpContext.getRowDataModel().getActiveRow();
        while (billObj.getParent() != null) {
            billObj = (DynamicObject)billObj.getParent();
        }
        if (billObj.getDataEntityState().getFromDatabase() && billObj.getDataEntityState().isSplitPage() && billObj.getPkValue() instanceof Long) {
            Long billId = (Long)billObj.getPkValue();
            Map<String, HashSet<Long>> srcBillIds = BFTrackerServiceHelper.findSourceBills(bosExpContext.getRowDataModel().getMainEntityType().getName(), new Long[]{billId});
            if (srcBillIds != null && !srcBillIds.isEmpty()) {
                return true;
            }
        }
        ExtendedDataEntitySet dataSet = new ExtendedDataEntitySet();
        dataSet.Parse(new DynamicObject[]{billObj}, (MainEntityType)billObj.getDataEntityType());
        boolean isDraw = false;
        block1: for (LinkSetItemElement linkEntry : linkSet.getItems()) {
            ExtendedDataEntity[] rows = dataSet.FindByEntityKey(linkEntry.getLinkEntityKey());
            if (rows == null || rows.length <= 0) continue;
            for (ExtendedDataEntity row : rows) {
                if (!this.haveSourceBillId(row.getDataEntity())) continue;
                isDraw = true;
                continue block1;
            }
        }
        return isDraw;
    }

    private boolean isDrawEntryRow(BOSExpressionContext bosExpContext, LinkSetElement linkSet) {
        DynamicObject entryRow = (DynamicObject)bosExpContext.getRowDataModel().getActiveRow();
        EntryType entryType = (EntryType)entryRow.getDataEntityType();
        boolean isDraw = false;
        block0: for (LinkSetItemElement linkEntry : linkSet.getItems()) {
            DynamicObjectCollection subEntryRows;
            if (StringUtils.equalsIgnoreCase((CharSequence)linkEntry.getParentEntityKey(), (CharSequence)entryType.getName())) {
                DynamicObjectCollection linkRows;
                IDataEntityProperty lkProp = (IDataEntityProperty)entryType.getProperties().get((Object)linkEntry.getLinkEntityKey());
                if (lkProp == null || !this.haveSourceBillId(linkRows = entryRow.getDynamicObjectCollection(linkEntry.getLinkEntityKey()))) continue;
                isDraw = true;
                break;
            }
            IDataEntityProperty prop = (IDataEntityProperty)entryType.getProperties().get((Object)linkEntry.getParentEntityKey());
            if (prop == null || (subEntryRows = entryRow.getDynamicObjectCollection(linkEntry.getParentEntityKey())) == null || subEntryRows.isEmpty()) continue;
            for (DynamicObject subEntryRow : subEntryRows) {
                DynamicObjectCollection linkRows;
                EntryType subEntryType = (EntryType)subEntryRow.getDataEntityType();
                IDataEntityProperty subLkProp = (IDataEntityProperty)subEntryType.getProperties().get((Object)linkEntry.getLinkEntityKey());
                if (subLkProp == null || !this.haveSourceBillId(linkRows = subEntryRow.getDynamicObjectCollection(linkEntry.getLinkEntityKey()))) continue;
                isDraw = true;
                continue block0;
            }
        }
        return isDraw;
    }

    private boolean haveSourceBillId(DynamicObjectCollection linkRows) {
        if (linkRows == null || !linkRows.iterator().hasNext()) {
            return false;
        }
        for (DynamicObject linkRow : linkRows) {
            if (!this.haveSourceBillId(linkRow)) continue;
            return true;
        }
        return false;
    }

    private boolean haveSourceBillId(DynamicObject linkRow) {
        LinkEntryType linkType = (LinkEntryType)linkRow.getDataEntityType();
        Long sBillId = (Long)linkType.getSBillIdProp().getValueFast((Object)linkRow);
        return sBillId != null && sBillId != 0L;
    }
}

