/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.function;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.formula.BOSExpressionContext;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateExpressionContext;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class IsPush
implements BOSUDFunction {
    private static final String VAR_KEY_TARGET_BILLS = "Is_Push_TargetBills";
    private ExpressionContext expContext;

    public IsPush() {
    }

    public IsPush(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public BOSUDFunction getInstance(ExpressionContext expContext) {
        return new IsPush(expContext);
    }

    public Object call(Object ... arg0) {
        DynamicObject activeRow;
        BOSExpressionContext bosExpContext = (BOSExpressionContext)this.expContext;
        ISimpleProperty pkProperty = bosExpContext.getRowDataModel().getMainEntityType().getPrimaryKey();
        if (pkProperty == null || !(pkProperty instanceof LongProp)) {
            return Boolean.FALSE;
        }
        String entryKey = null;
        int parentIndex = 0;
        ArrayList<Integer> rowIndex = new ArrayList<Integer>();
        if (bosExpContext instanceof ValidateExpressionContext) {
            entryKey = (String)((ValidateExpressionContext)bosExpContext).getValidateContext().getOption().getVariables().get("entrykey");
        }
        int levelId = 0;
        if (StringUtils.isNotBlank(entryKey)) {
            String levelIdStr;
            String rowIndexStr;
            String parentIndexStr = ((ValidateExpressionContext)bosExpContext).getValidateContext().getOption().getVariableValue("parentindex");
            if (StringUtils.isNotBlank((CharSequence)parentIndexStr)) {
                parentIndex = Integer.parseInt(parentIndexStr);
            }
            if (StringUtils.isNotBlank((CharSequence)(rowIndexStr = ((ValidateExpressionContext)bosExpContext).getValidateContext().getOption().getVariableValue("rowindex")))) {
                rowIndex.addAll(SerializationUtils.fromJsonStringToList((String)rowIndexStr, Integer.class));
            }
            if (StringUtils.isNotBlank((CharSequence)(levelIdStr = ((ValidateExpressionContext)bosExpContext).getValidateContext().getOption().getVariableValue("levelId")))) {
                levelId = Integer.parseInt(levelIdStr);
            }
        }
        String entityNumber = bosExpContext.getRowDataModel().getMainEntityType().getName();
        Long billId = null;
        for (activeRow = (DynamicObject)bosExpContext.getRowDataModel().getActiveRow(); activeRow != null && !(activeRow.getDataEntityType() instanceof MainEntityType); activeRow = (DynamicObject)activeRow.getParent()) {
        }
        if (activeRow != null) {
            billId = (Long)activeRow.getPkValue();
        }
        if (billId == null) {
            return Boolean.FALSE;
        }
        if (!rowIndex.isEmpty()) {
            return this.isRowPush((ValidateExpressionContext)bosExpContext, activeRow, entityNumber, entryKey, parentIndex, rowIndex, levelId);
        }
        return this.isPush(entityNumber, billId);
    }

    private boolean isRowPush(ValidateExpressionContext bosExpContext, DynamicObject dataEntity, String entityNumber, String entryKey, int parentIndex, List<Integer> rowIndex, int levelId) {
        IDataEntityProperty entryType = ((EntityType)dataEntity.getDataEntityType()).findProperty(entryKey);
        DynamicObjectCollection linkEntryRows = null;
        if (entryType instanceof SubEntryType) {
            DynamicObjectCollection entryrows = dataEntity.getDynamicObjectCollection(entryType.getParent().getName());
            if (entryrows.isEmpty() || parentIndex >= entryrows.size()) {
                return false;
            }
            linkEntryRows = ((DynamicObject)entryrows.get(parentIndex)).getDynamicObjectCollection(entryType);
        } else {
            linkEntryRows = dataEntity.getDynamicObjectCollection(entryType);
        }
        boolean existConvertLink = false;
        ArrayList<OperateErrorInfo> operateErrorInfos = new ArrayList<OperateErrorInfo>(10);
        for (Integer rk : rowIndex) {
            if (rk >= linkEntryRows.size() || !BFTrackerServiceHelper.isPush(entityNumber, entryKey, (Long)dataEntity.getPkValue(), (Long)((DynamicObject)linkEntryRows.get(rk.intValue())).getPkValue())) continue;
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setPkValue(dataEntity.getPkValue());
            errorInfo.setLevel(ErrorLevel.valueOf((int)levelId));
            errorInfo.setMessage(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u5b58\u5728\u5173\u8054\u5173\u7cfb\u3002", (String)"IsPush_0", (String)"bos-botp-business", (Object[])new Object[0]), rk + 1));
            operateErrorInfos.add(errorInfo);
            if (!existConvertLink) {
                // empty if block
            }
            existConvertLink = true;
        }
        if (existConvertLink) {
            ValidateResult validateResult = new ValidateResult();
            validateResult.setSuccess(false);
            validateResult.setAllErrorInfo(operateErrorInfos);
            bosExpContext.getValidateContext().getValidateResults().addValidateError("ExistPushLink", validateResult);
        }
        return existConvertLink;
    }

    public String getName() {
        return "IsPush";
    }

    private boolean isPush(String entityNumber, Long billId) {
        boolean isPush = false;
        if (this.expContext instanceof ValidateExpressionContext) {
            List list;
            ValidateExpressionContext validateExpressionContext = (ValidateExpressionContext)this.expContext;
            Map<Long, List<BFRow>> targetBills = (Map<Long, List<BFRow>>)validateExpressionContext.getLoaclVars().get(VAR_KEY_TARGET_BILLS);
            if (targetBills == null) {
                ExtendedDataEntity[] billHeads = validateExpressionContext.getValidateContext().getExtendedDataEntitySet().FindByEntityKey(entityNumber);
                Long[] billIds = new Long[billHeads.length];
                for (int i = 0; i < billHeads.length; ++i) {
                    billIds[i] = (Long)billHeads[i].getDataEntity().getPkValue();
                }
                targetBills = BFTrackerServiceHelper.findDirtTargetBills(entityNumber, billIds);
                validateExpressionContext.getLoaclVars().put(VAR_KEY_TARGET_BILLS, targetBills);
            }
            return (list = (List)targetBills.get(billId)) != null && !list.isEmpty();
        }
        isPush = BFTrackerServiceHelper.isPush(entityNumber, billId);
        return isPush;
    }
}

