/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.botp;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.botp.ctbotp.CtBotpLinkBill;
import kd.bos.entity.ctbotp.apiresponse.CtBillLkRes;
import kd.bos.entity.ctbotp.link.CtLkDownQueryArgs;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ctbotp.service.CtBillLkServiceHelper;
import kd.bos.service.ctbotp.utils.CtTenantPathUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;

public class CtTrackUpManage {
    private static final String FROMBOTPCONVERTRULE = " FROM T_CTBOTP_ConvertRule t0 ";
    private static final Log log = LogFactory.getLog(CtTrackUpManage.class);

    public static List<CtBotpLinkBill> getCtBotpLinkBill(boolean isTrackUp, String billFormId, Set<Long> billIds) {
        RequestContext ctx = RequestContext.get();
        String tenantId = ctx.getTenantId();
        String accountId = ctx.getAccountId();
        String formId = null;
        QFilter qFilter = null;
        HashSet<String> tBillMap = new HashSet<String>(16);
        if (isTrackUp) {
            formId = "bos_ctbotp_synclog_t";
            qFilter = new QFilter("tbillid", "in", billIds).and(new QFilter("ttenantcode", "=", (Object)tenantId)).and(new QFilter("taccountid", "=", (Object)accountId)).and(new QFilter("tentitykey", "=", (Object)billFormId));
        } else {
            CtLkDownQueryArgs ctLkDownQueryArgs = new CtLkDownQueryArgs();
            ctLkDownQueryArgs.setsTenantCode(tenantId);
            ctLkDownQueryArgs.setsAccountId(accountId);
            ctLkDownQueryArgs.setsEntityKey(billFormId);
            ctLkDownQueryArgs.setsBillIds(new ArrayList<Long>(billIds));
            List ctBillLkRes = CtBillLkServiceHelper.getDirtBillLkDown((CtLkDownQueryArgs)ctLkDownQueryArgs);
            if (CollectionUtils.isEmpty((Collection)ctBillLkRes)) {
                return null;
            }
            for (CtBillLkRes ctBillLk : ctBillLkRes) {
                String tKey = CtTrackUpManage.getBillKey(ctBillLk.gettTenantCode(), ctBillLk.gettAccountId(), ctBillLk.gettEntityKey(), ctBillLk.gettBillId());
                tBillMap.add(tKey);
            }
            formId = "bos_ctbotp_synclog_s";
            qFilter = new QFilter("sbillid", "in", billIds).and(new QFilter("stenantcode", "=", (Object)tenantId)).and(new QFilter("saccountid", "=", (Object)accountId)).and(new QFilter("sentitykey", "=", (Object)billFormId));
        }
        String selectPropStr = "id,sentitykey,tentitykey,sbillid,tbillid,stenantcode,saccountid,ttenantcode,taccountid,ruleid";
        DynamicObject[] billLinks = BusinessDataServiceHelper.load((String)formId, (String)selectPropStr, (QFilter[])new QFilter[]{qFilter});
        if (billLinks == null || billLinks.length == 0) {
            return null;
        }
        HashSet<String> ruleIds = new HashSet<String>(16);
        ArrayList<CtBotpLinkBill> ctBotpLinkBills = new ArrayList<CtBotpLinkBill>(16);
        HashMap<String, String> tenantNameMap = new HashMap<String, String>();
        for (DynamicObject billdata : billLinks) {
            CtBotpLinkBill ctBotpLinkBill = new CtBotpLinkBill();
            ctBotpLinkBill.setsEntityKey(billdata.getString("sentitykey"));
            ctBotpLinkBill.settEntityKey(billdata.getString("tentitykey"));
            ctBotpLinkBill.settBillId(Long.valueOf(billdata.getLong("tbillid")));
            ctBotpLinkBill.setsBillId(Long.valueOf(billdata.getLong("sbillid")));
            ctBotpLinkBill.setsAccountId(billdata.getString("saccountid"));
            ctBotpLinkBill.setsTenantCode(billdata.getString("stenantcode"));
            ctBotpLinkBill.settAccountId(billdata.getString("taccountid"));
            String tenantCode = billdata.getString("ttenantcode");
            ctBotpLinkBill.settTenantCode(tenantCode);
            ctBotpLinkBill.setId(Long.valueOf(billdata.getLong("id")));
            if (tenantNameMap.containsKey(tenantCode)) {
                ctBotpLinkBill.settTenantName((String)tenantNameMap.get(tenantCode));
            } else {
                String tenantName = CtTrackUpManage.getTenactName(tenantCode);
                tenantNameMap.put(tenantCode, tenantName);
                ctBotpLinkBill.settTenantName(tenantName);
            }
            if (isTrackUp) {
                ctBotpLinkBills.add(ctBotpLinkBill);
            } else {
                String tKey = CtTrackUpManage.getBillKey(ctBotpLinkBill.gettTenantCode(), ctBotpLinkBill.gettAccountId(), ctBotpLinkBill.gettEntityKey(), ctBotpLinkBill.gettBillId());
                if (tBillMap.contains(tKey)) {
                    ctBotpLinkBills.add(ctBotpLinkBill);
                }
            }
            ruleIds.add(billdata.getString("ruleid"));
        }
        Map<String, String> ctBillNameMap = CtTrackUpManage.getCtBillName(ruleIds);
        if (ctBillNameMap == null || ctBillNameMap.size() == 0) {
            return null;
        }
        log.info("\u67e5\u8be2\u8de8\u79df\u6237\u5173\u8054\u5173\u7cfb\uff1actBillNameMap:" + SerializationUtils.toJsonString(ctBillNameMap));
        for (CtBotpLinkBill ctBotpLinkBill : ctBotpLinkBills) {
            String sKey = ctBotpLinkBill.getsTenantCode() + ctBotpLinkBill.getsAccountId() + ctBotpLinkBill.getsEntityKey();
            String tKey = ctBotpLinkBill.gettTenantCode() + ctBotpLinkBill.gettAccountId() + ctBotpLinkBill.gettEntityKey();
            log.info("skey:" + sKey);
            log.info("tkey:" + tKey);
            ctBotpLinkBill.setsEntityName(ctBillNameMap.get(sKey));
            ctBotpLinkBill.settEntityName(ctBillNameMap.get(tKey));
            log.info("ctBotpLinkBill:" + SerializationUtils.toJsonString((Object)ctBotpLinkBill));
        }
        return ctBotpLinkBills;
    }

    private static String getBillKey(String tenantCode, String accountId, String entityKey, Long billId) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(tenantCode);
        stringBuilder.append(accountId);
        stringBuilder.append(entityKey);
        stringBuilder.append(billId);
        return stringBuilder.toString();
    }

    private static String getTenactName(String tenantId) {
        String formId = "ctsy_tenant";
        QFilter qFilter = new QFilter("tenantid", "=", (Object)tenantId);
        String selectPropStr = "name";
        Map tenantMap = BusinessDataServiceHelper.loadFromCache((String)formId, (String)selectPropStr, (QFilter[])new QFilter[]{qFilter});
        for (Map.Entry entry : tenantMap.entrySet()) {
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            ILocaleString iLocaleString = dynamicObject.getLocaleString("name");
            if (iLocaleString == null) continue;
            return iLocaleString.getLocaleValue();
        }
        return null;
    }

    private static Map<String, String> getCtBillName(Set<String> ruleIds) {
        String localeId = Lang.get().toString();
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT t0.ftenantpath AS ftenantpath,t0.fsourceentitynumber AS fsourceentitynumber, t0.ftargetentitynumber AS ftargetentitynumber, t0.FId, t0.FEnabled, t0.FTargetTenant AS FTenant, t0.fsourcetenant AS FSTenant,t0_l.FName AS FRuleName,t0.fsynctype as FSyncType,t0.fsourcedatacenter,t0.ftargetdatacenter,t0_l.fsourceentityname as fsourceentityname,t0_l.ftargetentityname as ftargetentityname");
        sBuilder.append(FROMBOTPCONVERTRULE);
        sBuilder.append("LEFT JOIN T_CTBOTP_CONVERTRULE_L t0_l ON (t0.FId = t0_l.FId and t0_l.FLocaleId = '").append(localeId).append("') ");
        sBuilder.append("WHERE ");
        sBuilder.append("t0.fid in('").append(String.join((CharSequence)"','", ruleIds)).append("') ");
        sBuilder.append("and t0.FType <> '2'");
        ResultSetHandler<Map<String, String>> action = new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws SQLException {
                HashMap<String, String> ruleMaps = new HashMap<String, String>(16);
                while (rs.next()) {
                    String fTenantPath = rs.getString("FTenantPath");
                    DynamicObject dynamicObject = CtTenantPathUtils.getTenantPath((String)fTenantPath);
                    String sTenantCode = rs.getString("FSTenant");
                    String sAccountId = rs.getString("fsourcedatacenter");
                    String tTenantCode = rs.getString("FTenant");
                    String tAccountId = rs.getString("ftargetdatacenter");
                    if (dynamicObject != null) {
                        DynamicObject targetTenant;
                        DynamicObject sourceTenant = (DynamicObject)dynamicObject.get("sourcetenant");
                        if (sourceTenant != null) {
                            sTenantCode = sourceTenant.getString("tenantid");
                            sAccountId = sourceTenant.getString("accountid");
                        }
                        if ((targetTenant = (DynamicObject)dynamicObject.get("targettenant")) != null) {
                            tTenantCode = targetTenant.getString("tenantid");
                            tAccountId = targetTenant.getString("accountid");
                        }
                    }
                    String sourceEntityNumber = rs.getString("fsourceentitynumber");
                    String targetEntityNumber = rs.getString("ftargetentitynumber");
                    String sourceEntityName = rs.getString("fsourceentityname");
                    log.info("sourceEntityName:" + sourceEntityName);
                    String targetEntityName = rs.getString("ftargetentityname");
                    log.info("targetEntityName:" + targetEntityName);
                    String sKey = sTenantCode + sAccountId + sourceEntityNumber;
                    ruleMaps.put(sKey, sourceEntityName);
                    String tKey = tTenantCode + tAccountId + targetEntityNumber;
                    ruleMaps.put(tKey, targetEntityName);
                }
                return ruleMaps;
            }
        };
        Map billNameMap = (Map)DB.query((DBRoute)DBRoute.basedata, (String)sBuilder.toString(), null, (ResultSetHandler)action);
        log.info("\u67e5\u8be2\u8de8\u79df\u6237\u5173\u8054\u5173\u7cfbqueryname_sql:" + sBuilder.toString());
        log.info("\u67e5\u8be2\u8de8\u79df\u6237\u5173\u8054\u5173\u7cfbbillNameMap:" + SerializationUtils.toJsonString((Object)billNameMap));
        return billNameMap;
    }
}

