/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.botp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

class OperateRightChecker {
    private long userId;
    private String permItemId = "47150e89000000ac";
    private Map<String, DimType> dimTypes = new HashMap<String, DimType>(8);
    private Map<String, Boolean> operateRights = new HashMap<String, Boolean>(8);
    private Map<String, Map<Object, Boolean>> dataRights = new HashMap<String, Map<Object, Boolean>>(8);

    public OperateRightChecker() {
        this.userId = Long.parseLong(RequestContext.get().getUserId());
        this.permItemId = "47150e89000000ac";
    }

    public OperateRightChecker(String permItemId) {
        this.userId = Long.parseLong(RequestContext.get().getUserId());
        this.permItemId = permItemId;
    }

    public OperateRightChecker(long userId, String permItemId) {
        this.userId = userId;
        this.permItemId = permItemId;
    }

    public Map<String, Boolean> getOperateRights() {
        return this.operateRights;
    }

    public Map<String, Map<Object, Boolean>> getDataRights() {
        return this.dataRights;
    }

    public boolean isHasRight(String entityNumber, String appId, Object billId) {
        this.checkRight(entityNumber, appId, new Object[]{billId});
        boolean hasViewRight = this.operateRights.get(entityNumber);
        if (!hasViewRight) {
            return false;
        }
        Map<Object, Boolean> billRights = this.dataRights.get(entityNumber);
        if (billRights != null && billRights.containsKey(billId)) {
            return billRights.get(billId);
        }
        return true;
    }

    public void checkRight(String entityNumber, String appId, Object[] billIds) {
        Boolean hasPerm = this.operateRights.get(entityNumber);
        if (hasPerm == null) {
            hasPerm = PermissionServiceHelper.hasSpecificPerm((long)this.userId, (String)appId, (String)entityNumber, (String)this.permItemId);
            this.operateRights.put(entityNumber, hasPerm);
        }
        if (!hasPerm.booleanValue()) {
            this.addBillRightResult(entityNumber, billIds, false);
            return;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (!mainType.getPermissionControlType().isControlFunction()) {
            this.addBillRightResult(entityNumber, billIds, true);
            return;
        }
        Map<Object, Boolean> currBillRights = this.dataRights.get(entityNumber);
        if (currBillRights == null) {
            currBillRights = new HashMap<Object, Boolean>(billIds.length);
            this.dataRights.put(entityNumber, currBillRights);
        }
        List<Object> ids = new ArrayList<Object>(billIds.length);
        for (Object billId : billIds) {
            if (currBillRights.containsKey(billId)) continue;
            ids.add(billId);
        }
        if (ids.isEmpty()) {
            return;
        }
        this.addBillRightResult(entityNumber, ids.toArray(), true);
        DimType dimType = this.getDimType(mainType);
        if (!StringUtils.equalsIgnoreCase((CharSequence)"DIM_NULL", (CharSequence)dimType.getDimType())) {
            ids = this.checkRightByDimType(appId, mainType, dimType, ids);
        }
        if (ids.isEmpty()) {
            return;
        }
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        Map permResult = permissionService.matchDataRule(this.userId, appId, entityNumber, this.permItemId, ids.toArray(), new HashMap(0));
        if (permResult != null) {
            for (Map.Entry entry : permResult.entrySet()) {
                currBillRights.put(entry.getKey(), (Boolean)entry.getValue());
            }
        }
    }

    private void addBillRightResult(String entityNumber, Object[] billIds, boolean hasRight) {
        Map<Object, Boolean> currBillRights = this.dataRights.get(entityNumber);
        if (currBillRights == null) {
            currBillRights = new HashMap<Object, Boolean>(billIds.length);
            this.dataRights.put(entityNumber, currBillRights);
        }
        for (Object billId : billIds) {
            currBillRights.put(billId, hasRight);
        }
    }

    private DimType getDimType(MainEntityType mainType) {
        DimType dimTypeInfo = this.dimTypes.get(mainType.getName());
        if (dimTypeInfo != null) {
            return dimTypeInfo;
        }
        String dimType = mainType.getPermissionControlType().getDimension();
        String dimFldKey = mainType.getPermissionControlType().getDataDimensionField();
        String dimAssitFldKey = mainType.getPermissionControlType().getDataAssistDimensionField();
        if (StringUtils.isNotBlank((CharSequence)dimFldKey) && mainType.findProperty(dimFldKey) == null) {
            dimFldKey = null;
        }
        if (StringUtils.isNotBlank((CharSequence)dimAssitFldKey) && mainType.findProperty(dimAssitFldKey) == null) {
            dimAssitFldKey = null;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)dimType, (CharSequence)"DIM_ORG") || StringUtils.isBlank((CharSequence)dimFldKey)) {
            dimType = "DIM_ORG";
            if (StringUtils.isNotBlank((CharSequence)mainType.getMainOrg())) {
                dimFldKey = mainType.getMainOrg();
            }
        }
        if (StringUtils.isBlank((CharSequence)dimFldKey)) {
            dimType = "DIM_NULL";
        }
        dimTypeInfo = new DimType(dimType, dimFldKey, dimAssitFldKey);
        this.dimTypes.put(mainType.getName(), dimTypeInfo);
        return dimTypeInfo;
    }

    private List<Object> checkRightByDimType(String appId, MainEntityType mainType, DimType dimType, List<Object> ids) {
        String dimFldKey;
        QFilter[] filters = new QFilter[]{ids.size() == 1 ? new QFilter("id", "=", ids.get(0)) : new QFilter("id", "in", (Object)ids.toArray())};
        String selectFields = "id";
        if (StringUtils.isNotBlank((CharSequence)dimType.getDimFldKey())) {
            selectFields = selectFields + "," + dimType.getDimFldKey();
        }
        if (StringUtils.isNotBlank((CharSequence)dimType.getDimAssitFldKey()) && !StringUtils.equalsIgnoreCase((CharSequence)dimType.getDimFldKey(), (CharSequence)dimType.getDimAssitFldKey())) {
            selectFields = selectFields + "," + dimType.getDimAssitFldKey();
        }
        DynamicObjectCollection rows = QueryServiceHelper.query((String)mainType.getName(), (String)selectFields, (QFilter[])filters);
        HashMap dimToIds = new HashMap();
        for (DynamicObject row : rows) {
            Object id = row.get("id");
            String dimFldValue = "";
            String dimAssistFldValue = "";
            if (StringUtils.isNotBlank((CharSequence)dimType.getDimFldKey())) {
                Object dimFldObj = row.get(dimType.getDimFldKey());
                String string = dimFldValue = dimFldObj == null ? "" : String.valueOf(dimFldObj);
            }
            if (StringUtils.isNotBlank((CharSequence)dimType.getDimAssitFldKey())) {
                Object dimAssistFldObj = row.get(dimType.getDimAssitFldKey());
                dimAssistFldValue = dimAssistFldObj == null ? "" : String.valueOf(dimAssistFldObj);
            }
            dimFldKey = dimFldValue;
            if (StringUtils.isNotBlank((CharSequence)dimAssistFldValue)) {
                dimFldKey = StringUtils.isNotBlank((CharSequence)dimFldKey) ? dimFldKey + "," + dimAssistFldValue : dimFldKey + dimAssistFldValue;
            }
            if (!dimToIds.containsKey(dimFldKey)) {
                dimToIds.put(dimFldKey, new HashSet(4));
            }
            ((Set)dimToIds.get(dimFldKey)).add(id);
        }
        Map<Object, Boolean> currBillRights = this.dataRights.get(mainType.getName());
        if (currBillRights == null) {
            currBillRights = new HashMap<Object, Boolean>(ids.size());
            this.dataRights.put(mainType.getName(), currBillRights);
        }
        ArrayList<Object> ids_hasRight = new ArrayList<Object>(ids.size());
        for (Map.Entry group : dimToIds.entrySet()) {
            ArrayList<Long> dimIds = new ArrayList<Long>();
            dimFldKey = (String)group.getKey();
            if (StringUtils.isNotBlank((CharSequence)dimFldKey) && dimFldKey.contains(",")) {
                String[] dimFldArr = dimFldKey.split(",");
                Long dimFldValue = dimFldArr.length == 0 || StringUtils.isBlank((CharSequence)dimFldArr[0]) ? 0L : Long.parseLong(dimFldArr[0]);
                dimIds.add(dimFldValue);
                if (dimFldArr.length > 1) {
                    Long dimAssistFldValue = StringUtils.isBlank((CharSequence)dimFldArr[1]) ? 0L : Long.parseLong(dimFldArr[1]);
                    dimIds.add(dimAssistFldValue);
                }
            } else {
                dimIds.add(StringUtils.isBlank((CharSequence)dimFldKey) ? 0L : Long.parseLong(dimFldKey));
            }
            int hasRight = PermissionServiceHelper.checkPermission((Long)this.userId, (String)dimType.getDimType(), dimIds, (String)appId, (String)mainType.getName(), (String)this.permItemId);
            if (hasRight != 1) {
                for (Object id : (Set)group.getValue()) {
                    this.dataRights.get(mainType.getName()).put(id, false);
                }
                continue;
            }
            ids_hasRight.addAll((Collection)group.getValue());
        }
        return ids_hasRight;
    }

    private static class DimType {
        private String dimensionType;
        private String dimFldKey;
        private String dimAssitFldKey;

        public DimType(String dimType, String dimFldKey, String dimAssitFldKey) {
            this.dimensionType = dimType;
            this.dimFldKey = dimFldKey;
            this.dimAssitFldKey = dimAssitFldKey;
        }

        public String getDimType() {
            return this.dimensionType;
        }

        public String getDimFldKey() {
            return this.dimFldKey;
        }

        public String getDimAssitFldKey() {
            return this.dimAssitFldKey;
        }
    }
}

