/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.botp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.ConvertBill;
import kd.bos.entity.botp.ConvertRuleKeyPair;
import kd.bos.entity.botp.ThirdPushArgs;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.operate.botp.Push;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.botp.ThirdPushUtil;

public class ThirdPushManage {
    private boolean thirdPush = false;
    private ThirdPushArgs thirdPushArgs;
    private Push push;

    public ThirdPushManage(Push push) {
        this.push = push;
    }

    public void setThirdPushParams() {
        this.thirdPushArgs = ThirdPushUtil.getThirdPushArgs(this.push.getOption());
        if (this.thirdPushArgs != null) {
            this.thirdPush = Boolean.TRUE;
        }
    }

    public void setThirdPushParams(FormShowParameter showParameter) {
        if (this.thirdPush) {
            String thirdPushArgs = SerializationUtils.toJsonString((Object)this.thirdPushArgs);
            showParameter.getCustomParams().put("thirdPushArgs", thirdPushArgs);
        }
    }

    public List<ConvertBill> addThirdConvertBills(List<ConvertBill> bills) {
        List<ConvertBill> thirdList = this.getThirdConvertBills();
        if (CollectionUtils.isEmpty(bills) && CollectionUtils.isEmpty(thirdList)) {
            return bills;
        }
        if (CollectionUtils.isEmpty(bills)) {
            if (!CollectionUtils.isEmpty(thirdList)) {
                bills = thirdList;
            }
        } else if (!CollectionUtils.isEmpty(thirdList)) {
            bills.addAll(thirdList);
        }
        return bills;
    }

    private List<ConvertBill> getThirdConvertBills() {
        if (!this.thirdPush || this.thirdPushArgs == null || CollectionUtils.isEmpty((Collection)this.thirdPushArgs.getPushArgsList())) {
            return null;
        }
        ArrayList<ConvertBill> convertBills = new ArrayList<ConvertBill>(8);
        for (PushArgs pushArgs : this.thirdPushArgs.getPushArgsList()) {
            List<ConvertBill> thirdBills = ConvertMetaServiceHelper.loadThirdConvertBills(pushArgs.getSourceEntityNumber(), pushArgs.getTargetEntityNumber());
            if (!CollectionUtils.isNotEmpty(thirdBills)) continue;
            convertBills.addAll(thirdBills);
        }
        return convertBills;
    }

    public ConvertRuleKeyPair getThirdConvertRuleKeyPair(ConvertBill convertBill) {
        return new ConvertRuleKeyPair(convertBill.getSourceEntityNumber(), convertBill.getEntityNumber());
    }

    public Set<Long> getTirdSrcBillTypeIds(ConvertBill bill) {
        HashSet<Long> billTypeIds = new HashSet<Long>();
        if (this.thirdPushArgs == null || CollectionUtils.isEmpty((Collection)this.thirdPushArgs.getPushArgsList())) {
            return null;
        }
        PushArgs pushArgs = ThirdPushArgs.getOneThirdPushArgs((List)this.thirdPushArgs.getPushArgsList(), (String)bill.getSourceEntityNumber(), (String)bill.getEntityNumber());
        if (pushArgs == null || CollectionUtils.isEmpty((Collection)pushArgs.getSelectedRows())) {
            return null;
        }
        for (ListSelectedRow row : pushArgs.getSelectedRows()) {
            if (row.getBillTypeID() == null || Long.compare(0L, row.getBillTypeID()) == 0) continue;
            billTypeIds.add(row.getBillTypeID());
        }
        return billTypeIds;
    }
}

