/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.botp;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowComparator;
import kd.bos.form.operate.botp.TrackUp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class TrackAll
extends TrackUp {
    private static final long serialVersionUID = -4809728095511882907L;
    private static final Log LOG = LogFactory.getLog(TrackAll.class);

    @Override
    protected String getLookUpType() {
        return "lookall";
    }

    @Override
    protected String loadAndSeriLinkNodes() {
        ArrayList<BFRow> bfRows = new ArrayList<BFRow>();
        HashSet<Long> billIds = this.getSelectedBillIds();
        List<BFRow> sourceBFRows = BFTrackerServiceHelper.loadBillLinkUp(this.getEntityId(), billIds.toArray(new Long[billIds.size()]), false);
        List<BFRow> targetBFRows = BFTrackerServiceHelper.loadBillLinkDown(this.getEntityId(), billIds.toArray(new Long[billIds.size()]), false);
        bfRows.addAll(this.sort(sourceBFRows));
        bfRows.addAll(this.sort(targetBFRows));
        if (bfRows.size() == 0) {
            return null;
        }
        String nodesJson = SerializationUtils.serializeToBase64(bfRows);
        return nodesJson;
    }

    private List<BFRow> sort(List<BFRow> rows) {
        try {
            BFRowComparator comparator = new BFRowComparator(rows);
            rows.sort((Comparator<BFRow>)comparator);
        }
        catch (IllegalArgumentException exp) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u8054\u67e5\u5355\u636e\u6392\u5e8f\u5931\u8d25\uff1a%s", (String)"TrackAll_0", (String)"bos-botp-business", (Object[])new Object[0]), rows == null ? "" : SerializationUtils.toJsonString(rows));
            LOG.error(errMsg, (Throwable)exp);
        }
        return rows;
    }
}

