/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.ctbotp;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.ctsy.api.ICtsyApiDispatchService;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ctbotp.CtConvertRuleElement;
import kd.bos.entity.ctbotp.CtConvertRuleElementDcBinder;
import kd.bos.entity.ctbotp.CtConvertRuleLocalCache;
import kd.bos.entity.ctbotp.CtConvertRuleRedisCache;
import kd.bos.entity.ctbotp.constants.CtApiUrlEnum;
import kd.bos.entity.ctbotp.syncdata.SyncRuleRecord;
import kd.bos.entity.ctbotp.tenant.TenantInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CtConvertRuleCache {
    private static final Log log = LogFactory.getLog(CtConvertRuleCache.class);
    private static final String CT_BOTP_CONVERTRULE_SYNCLOG = "ct_botp_rule_synclog";

    public static List<CtConvertRuleElement> loadRules(String[] ids) {
        long ts = System.currentTimeMillis();
        ArrayList<CtConvertRuleElement> ruleElements = new ArrayList<CtConvertRuleElement>(10);
        Map<String, CtConvertRuleElement> rules = CtConvertRuleLocalCache.getConvertRules(ids);
        List<String> convertRuleVersions = CtConvertRuleRedisCache.getConvertRuleVersions(ids);
        for (int i = 0; i < ids.length; ++i) {
            String id = ids[i];
            CtConvertRuleElement rule = rules.get(ids[i]);
            if (rule != null) {
                if (StringUtils.isBlank((CharSequence)rule.getCacheVersion()) || !StringUtils.equals((CharSequence)rule.getCacheVersion(), (CharSequence)convertRuleVersions.get(i)) || Long.compare(ts - rule.getCheckVersionTimeMillis(), 600000L) > 0) {
                    ruleElements.add(CtConvertRuleCache.getRedisCacheRule(id));
                    continue;
                }
                ruleElements.add(rule);
                continue;
            }
            ruleElements.add(CtConvertRuleCache.getRedisCacheRule(id));
        }
        return ruleElements;
    }

    private static CtConvertRuleElement getRedisCacheRule(String id) {
        String cacheVersion = null;
        String ruleXml = CtConvertRuleRedisCache.getConvertRule(id);
        if (StringUtils.isNotBlank((CharSequence)ruleXml)) {
            cacheVersion = CtConvertRuleRedisCache.getConvertRuleVersion(id);
            if (StringUtils.isBlank((CharSequence)cacheVersion)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
                cacheVersion = sdf.format(new Date());
                CtConvertRuleRedisCache.putConvertRuleVersion(id, cacheVersion);
            }
        } else {
            MetadataService service = (MetadataService)ServiceFactory.getService(MetadataService.class);
            ruleXml = service.loadCtConvertRule(id);
            if (StringUtils.isBlank((CharSequence)ruleXml)) {
                ruleXml = "";
            }
            CtConvertRuleRedisCache.putConvertRule(id, ruleXml);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            cacheVersion = sdf.format(new Date());
            CtConvertRuleRedisCache.putConvertRuleVersion(id, cacheVersion);
        }
        if (StringUtils.isNotBlank((CharSequence)ruleXml)) {
            DcJsonSerializer serializer = CtConvertRuleCache.getSerializer();
            CtConvertRuleElement rule = CtConvertRuleCache.deserializeFromString(serializer, ruleXml);
            if (rule != null) {
                rule.setCacheVersion(cacheVersion);
                rule.setCheckVersionTimeMillis(System.currentTimeMillis());
            }
            CtConvertRuleLocalCache.putConvertRule(id, rule);
            return rule;
        }
        return null;
    }

    public static CtConvertRuleElement loadRule(String id) {
        long ts = System.currentTimeMillis();
        CtConvertRuleElement rule = CtConvertRuleLocalCache.getConvertRule(id);
        if (rule != null) {
            if (StringUtils.isBlank((CharSequence)rule.getCacheVersion())) {
                rule = null;
            } else if (!StringUtils.equals((CharSequence)rule.getCacheVersion(), (CharSequence)CtConvertRuleRedisCache.getConvertRuleVersion(id))) {
                rule = null;
            } else if (Long.compare(ts - rule.getCheckVersionTimeMillis(), 600000L) > 0) {
                rule = null;
            }
        }
        if (rule != null) {
            return rule;
        }
        String cacheVersion = null;
        String ruleXml = CtConvertRuleRedisCache.getConvertRule(id);
        if (ruleXml != null) {
            cacheVersion = CtConvertRuleRedisCache.getConvertRuleVersion(id);
            if (StringUtils.isBlank((CharSequence)cacheVersion)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
                cacheVersion = sdf.format(new Date());
                CtConvertRuleRedisCache.putConvertRuleVersion(id, cacheVersion);
            }
        } else {
            MetadataService service = (MetadataService)ServiceFactory.getService(MetadataService.class);
            ruleXml = service.loadCtConvertRule(id);
            if (StringUtils.isBlank((CharSequence)ruleXml)) {
                ruleXml = "";
            }
            CtConvertRuleRedisCache.putConvertRule(id, ruleXml);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            cacheVersion = sdf.format(new Date());
            CtConvertRuleRedisCache.putConvertRuleVersion(id, cacheVersion);
        }
        if (StringUtils.isNotBlank((CharSequence)ruleXml)) {
            DcJsonSerializer serializer = CtConvertRuleCache.getSerializer();
            rule = CtConvertRuleCache.deserializeFromString(serializer, ruleXml);
            if (rule == null) {
                return null;
            }
            rule.setCacheVersion(cacheVersion);
            rule.setCheckVersionTimeMillis(System.currentTimeMillis());
            CtConvertRuleLocalCache.putConvertRule(id, rule);
            return rule;
        }
        return null;
    }

    public static CtConvertRuleElement loadRuleByVerId(String id, String verId, String extVerId) {
        long ts = System.currentTimeMillis();
        CtConvertRuleElement rule = CtConvertRuleLocalCache.getConvertRule(id);
        if (rule != null) {
            if (StringUtils.isBlank((CharSequence)rule.getCacheVersion())) {
                rule = null;
            } else if (!StringUtils.equals((CharSequence)rule.getCacheVersion(), (CharSequence)CtConvertRuleRedisCache.getConvertRuleVersion(id))) {
                rule = null;
            } else if (Long.compare(ts - rule.getCheckVersionTimeMillis(), 600000L) > 0) {
                rule = null;
            }
        }
        if (rule != null) {
            return rule;
        }
        String cacheVersion = null;
        String ruleXml = CtConvertRuleRedisCache.getConvertRule(id);
        if (ruleXml != null) {
            cacheVersion = CtConvertRuleRedisCache.getConvertRuleVersion(id);
            if (StringUtils.isBlank((CharSequence)cacheVersion)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
                cacheVersion = sdf.format(new Date());
                CtConvertRuleRedisCache.putConvertRuleVersion(id, cacheVersion);
            }
        } else {
            MetadataService service = (MetadataService)ServiceFactory.getService(MetadataService.class);
            ruleXml = service.loadCtConvertRuleByVerId(id, verId, extVerId);
            if (StringUtils.isBlank((CharSequence)ruleXml)) {
                ruleXml = "";
            }
            CtConvertRuleRedisCache.putConvertRule(id, ruleXml);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            cacheVersion = sdf.format(new Date());
            CtConvertRuleRedisCache.putConvertRuleVersion(id, cacheVersion);
        }
        if (StringUtils.isNotBlank((CharSequence)ruleXml)) {
            DcJsonSerializer serializer = CtConvertRuleCache.getSerializer();
            rule = CtConvertRuleCache.deserializeFromString(serializer, ruleXml);
            if (rule == null) {
                return null;
            }
            rule.setCacheVersion(cacheVersion);
            rule.setCheckVersionTimeMillis(System.currentTimeMillis());
            CtConvertRuleLocalCache.putConvertRule(id, rule);
            return rule;
        }
        return null;
    }

    public static List<CtConvertRuleElement> loadRules(String sourceTenant, String sourceDataCenter, String sourceEntityNumber, String targetTenant, String targetDataCenter, String targetEntityNumber) {
        List ruleIds = null;
        String cacheRuleIds = CtConvertRuleRedisCache.getConvertRuleIds(sourceTenant, sourceDataCenter, sourceEntityNumber, targetTenant, targetDataCenter, targetEntityNumber);
        if (cacheRuleIds != null) {
            ruleIds = (List)SerializationUtils.fromJsonString((String)cacheRuleIds, List.class);
        } else {
            MetadataService service = (MetadataService)ServiceFactory.getService(MetadataService.class);
            ruleIds = service.loadCtConvertRuleIds(sourceTenant, sourceDataCenter, sourceEntityNumber, targetTenant, targetDataCenter, targetEntityNumber);
            cacheRuleIds = SerializationUtils.toJsonString((Object)ruleIds);
            CtConvertRuleRedisCache.putConvertRuleIds(sourceTenant, sourceDataCenter, sourceEntityNumber, targetTenant, targetDataCenter, targetEntityNumber, cacheRuleIds);
        }
        ArrayList<CtConvertRuleElement> rules = new ArrayList<CtConvertRuleElement>();
        for (String ruleId : ruleIds) {
            CtConvertRuleElement rule = CtConvertRuleCache.loadRule(ruleId);
            if (rule == null) continue;
            rules.add(rule);
        }
        return rules;
    }

    public static synchronized void clearAllConvertRuleCache() {
        CtConvertRuleLocalCache.clearAllConvertRuleCache();
        CtConvertRuleRedisCache.clearAllConvertRuleCache();
        log.info("clearAllConvertRuleCache");
    }

    public static void clearConvertRuleCache(String ruleId) {
        CtConvertRuleRedisCache.clearConvertRuleCache(ruleId);
    }

    public static String loadDebugRule(String id, String cacheType) {
        if (StringUtils.isBlank((CharSequence)cacheType) || StringUtils.equals((CharSequence)cacheType, (CharSequence)"local")) {
            CtConvertRuleElement rule = CtConvertRuleLocalCache.getConvertRule(id);
            if (rule == null) {
                return "null";
            }
            return SerializationUtils.toJsonString((Object)rule);
        }
        if (StringUtils.equals((CharSequence)cacheType, (CharSequence)"redis")) {
            String xml = CtConvertRuleRedisCache.getConvertRule(id);
            if (StringUtils.isBlank((CharSequence)xml)) {
                return "null";
            }
            return xml;
        }
        if (StringUtils.equals((CharSequence)cacheType, (CharSequence)"db")) {
            MetadataService service = (MetadataService)ServiceFactory.getService(MetadataService.class);
            String xml = service.loadCtConvertRule(id);
            if (StringUtils.isBlank((CharSequence)xml)) {
                return "null";
            }
            return xml;
        }
        if (StringUtils.equals((CharSequence)cacheType, (CharSequence)"clear")) {
            CtConvertRuleCache.clearAllConvertRuleCache();
            return "clear all rule cache success";
        }
        return "null";
    }

    private static DcJsonSerializer getSerializer() {
        CtConvertRuleElementDcBinder binder = new CtConvertRuleElementDcBinder();
        DcJsonSerializer serializer = new DcJsonSerializer((DcBinder)binder);
        serializer.setIsLocaleValueFull(true);
        return serializer;
    }

    private static CtConvertRuleElement deserializeFromString(DcJsonSerializer serializer, String ruleString) {
        if (StringUtils.isBlank((CharSequence)ruleString)) {
            return null;
        }
        serializer.setIsLocaleValueFull(true);
        CtConvertRuleElement ruleElement = (CtConvertRuleElement)serializer.deserializeFromString(ruleString, null);
        if (ruleElement.getName() == null) {
            serializer.setIsLocaleValueFull(false);
            ruleElement = (CtConvertRuleElement)serializer.deserializeFromString(ruleString, null);
        }
        return ruleElement;
    }

    private static TenantInfo getGroupTenantInfo() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        qFilters.add(new QFilter("tenanttype", "=", (Object)"0"));
        DynamicObject tenant = BusinessDataServiceHelper.loadSingle((String)"ctsy_tenant", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (tenant == null) {
            return null;
        }
        return TenantInfo.create(tenant.getString("tenantid"), tenant.getString("accountid"));
    }

    private static SyncRuleRecord getSyncRuleRecord(String tenantCode, String accountId, Long verId) {
        HashMap<String, Long> param = new HashMap<String, Long>(2);
        param.put("verId", verId);
        ICtsyApiDispatchService ctsyApiDispatchService = (ICtsyApiDispatchService)ServiceFactory.getService(ICtsyApiDispatchService.class);
        String result = ctsyApiDispatchService.get(tenantCode, accountId, CtApiUrlEnum.GETSYNCREC.getUrl(), param);
        Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
        SyncRuleRecord record = (SyncRuleRecord)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(openApiResult.get("data")), SyncRuleRecord.class);
        return record;
    }

    private static Boolean updateSyncStatus(String tenantCode, String accountId, Long verId) {
        HashMap<String, Long> param = new HashMap<String, Long>(2);
        param.put("verId", verId);
        ICtsyApiDispatchService ctsyApiDispatchService = (ICtsyApiDispatchService)ServiceFactory.getService(ICtsyApiDispatchService.class);
        String result = ctsyApiDispatchService.post(tenantCode, accountId, CtApiUrlEnum.UPDATESYNCSTATUS.getUrl(), SerializationUtils.toJsonString(param));
        Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
        return Boolean.parseBoolean(openApiResult.get("status").toString());
    }

    public static void updateSyncRuleRec(CtConvertRuleElement rule, Long verId) {
        Boolean updateStasus = false;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)verId, (String)CT_BOTP_CONVERTRULE_SYNCLOG);
        if (dynamicObject != null && dynamicObject.getString("sourcestatus").equals("S")) {
            return;
        }
        if (dynamicObject == null || dynamicObject.getString("sourcestatus").equals("F")) {
            TenantInfo tenantInfo = CtConvertRuleCache.getGroupTenantInfo();
            SyncRuleRecord record = null;
            if (tenantInfo != null) {
                record = CtConvertRuleCache.getSyncRuleRecord(tenantInfo.getTenantId(), tenantInfo.getAccountId(), verId);
            }
            if (record == null) {
                record = CtConvertRuleCache.getSyncRuleRecord(rule.getSourceTenant(), rule.getSourceDataCenter(), verId);
                if (record != null && !record.getSourceStatus().equals("S") && !(updateStasus = CtConvertRuleCache.updateSyncStatus(rule.getSourceTenant(), rule.getSourceDataCenter(), verId)).booleanValue()) {
                    record.setSourceStatus("F");
                }
            } else if (dynamicObject != null && !dynamicObject.getString("sourcestatus").equals("S") && !(updateStasus = CtConvertRuleCache.updateSyncStatus(tenantInfo.getTenantId(), tenantInfo.getAccountId(), verId)).booleanValue()) {
                record.setSourceStatus("F");
            }
            if (record != null) {
                if (updateStasus.booleanValue()) {
                    record.setSourceStatus("S");
                }
                try (TXHandle h = TX.requiresNew();){
                    IDataEntityType dType = OrmUtils.getDataEntityType(SyncRuleRecord.class);
                    if (dynamicObject == null) {
                        BusinessDataWriter.save((IDataEntityType)dType, (Object[])new Object[]{record});
                    } else {
                        dynamicObject.set("sourcestatus", (Object)record.getSourceStatus());
                        SaveServiceHelper.update((DynamicObject)dynamicObject);
                    }
                }
            }
        }
    }
}

