/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.ctbotp;

import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.gray.AppGroupUtils;

class CtConvertRuleRedisCache {
    private static final String CT_CR_DISTRIBUTE = "CtConvertRule";
    private static final String Type_CtConvertRule = "CtConvertRule";
    private static final String Type_CtConvertRuleVersion = "CtConvertRuleVersion";
    private static final String Type_CtConvertRuleList = "CtConvertRuleList";

    CtConvertRuleRedisCache() {
    }

    private static DistributeSessionlessCache getDistributeCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("CtConvertRule", new DistributeCacheHAPolicy(true, true));
    }

    public static void clearAllConvertRuleCache() {
        DistributeSessionlessCache cache = CtConvertRuleRedisCache.getDistributeCache();
        cache.remove(CtConvertRuleRedisCache.buildCacheType("CtConvertRule"));
        cache.remove(CtConvertRuleRedisCache.buildCacheType(Type_CtConvertRuleVersion));
        cache.remove(CtConvertRuleRedisCache.buildCacheType(Type_CtConvertRuleList));
    }

    public static void clearConvertRuleCache(String ruleId) {
        DistributeSessionlessCache cache = CtConvertRuleRedisCache.getDistributeCache();
        cache.remove(CtConvertRuleRedisCache.buildCacheType("CtConvertRule"), ruleId);
        cache.remove(CtConvertRuleRedisCache.buildCacheType(Type_CtConvertRuleVersion), ruleId);
        cache.remove(CtConvertRuleRedisCache.buildCacheType(Type_CtConvertRuleList), ruleId);
    }

    public static String getConvertRuleVersion(String ruleId) {
        String type = CtConvertRuleRedisCache.buildCacheType(Type_CtConvertRuleVersion);
        return (String)CtConvertRuleRedisCache.getDistributeCache().get(type, ruleId);
    }

    public static List<String> getConvertRuleVersions(String[] ruleIds) {
        String type = CtConvertRuleRedisCache.buildCacheType(Type_CtConvertRuleVersion);
        return CtConvertRuleRedisCache.getDistributeCache().get(type, ruleIds);
    }

    public static void putConvertRuleVersion(String ruleId, String version) {
        String type = CtConvertRuleRedisCache.buildCacheType(Type_CtConvertRuleVersion);
        CtConvertRuleRedisCache.getDistributeCache().put(type, ruleId, (Object)version);
    }

    public static String getConvertRule(String ruleId) {
        String type = CtConvertRuleRedisCache.buildCacheType("CtConvertRule");
        return (String)CtConvertRuleRedisCache.getDistributeCache().get(type, ruleId);
    }

    public static void putConvertRule(String ruleId, String ruleStr) {
        String type = CtConvertRuleRedisCache.buildCacheType("CtConvertRule");
        CtConvertRuleRedisCache.getDistributeCache().put(type, ruleId, (Object)ruleStr);
    }

    public static String getConvertRuleIds(String sourceTenant, String sourceDataCenter, String sourceEntityNumber, String targetTenant, String targetDataCenter, String targetEntityNumber) {
        String type = CtConvertRuleRedisCache.buildCacheType(Type_CtConvertRuleList);
        String key = String.format("%s_%s_%s_to_%s_%s_%s", sourceTenant, sourceDataCenter, sourceEntityNumber, targetTenant, targetDataCenter, targetEntityNumber);
        return (String)CtConvertRuleRedisCache.getDistributeCache().get(type, key);
    }

    public static List<String> batchGetConvertRuleIds(String[] keys) {
        String type = CtConvertRuleRedisCache.buildCacheType(Type_CtConvertRuleList);
        return CtConvertRuleRedisCache.getDistributeCache().get(type, keys);
    }

    public static void putConvertRuleIds(String sourceTenant, String sourceDataCenter, String sourceEntityNumber, String targetTenant, String targetDataCenter, String targetEntityNumber, String ruleIds) {
        String type = CtConvertRuleRedisCache.buildCacheType(Type_CtConvertRuleList);
        String key = String.format("%s_%s_%s_to_%s_%s_%s", sourceTenant, sourceDataCenter, sourceEntityNumber, targetTenant, targetDataCenter, targetEntityNumber);
        CtConvertRuleRedisCache.getDistributeCache().put(type, key, (Object)ruleIds);
    }

    public static void batchPutConvertRuleIds(Map<String, String> ruleIdss) {
        String type = CtConvertRuleRedisCache.buildCacheType(Type_CtConvertRuleList);
        CtConvertRuleRedisCache.getDistributeCache().put(type, ruleIdss);
    }

    private static String buildCacheType(String type) {
        String accountId = CacheKeyUtil.getAcctId();
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        if (StringUtils.isNotBlank((CharSequence)appGroup) && !"defaultGroup".equals(appGroup)) {
            return String.format("%s_%s_%s", accountId, appGroup, type);
        }
        return String.format("%s_%s", accountId, type);
    }
}

