/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.ctbotp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.CtExtendedDataEntity;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class CtExtendedDataEntitySet {
    Map<String, List<CtExtendedDataEntity>> extDataEntityMap = new HashMap<String, List<CtExtendedDataEntity>>(16);

    @Deprecated
    public void Parse(DynamicObject[] dataEntities) {
        MainEntityType mainType = null;
        if (dataEntities != null && dataEntities.length > 0) {
            mainType = (MainEntityType)dataEntities[0].getDataEntityType();
        }
        this.Parse(dataEntities, mainType);
    }

    public void Parse(DynamicObject[] dataEntities, MainEntityType dType) {
        if (dataEntities == null) {
            throw new KDException(BosErrorCode.variableNotValid, new Object[]{ResManager.loadKDString((String)"dataEntities\u4e0d\u80fd\u4e3anull", (String)"ExtendedDataEntitySet_0", (String)"bos-entity-core", (Object[])new Object[0])});
        }
        MainEntityType mainType = dType;
        if (dataEntities.length == 0 && mainType == null) {
            return;
        }
        if (mainType == null) {
            mainType = (MainEntityType)dataEntities[0].getDataEntityType();
        }
        this.extDataEntityMap = new HashMap<String, List<CtExtendedDataEntity>>(16);
        for (EntityType entity : mainType.getAllEntities().values()) {
            this.extDataEntityMap.put(entity.getName(), new ArrayList());
        }
        int dataEntityIndex = 0;
        for (DynamicObject dataEntity : dataEntities) {
            String billNo = this.getBillNo(dataEntity);
            CtExtendedDataEntity extDataEntity = new CtExtendedDataEntity(dataEntity, dataEntityIndex, 0, billNo);
            this.extDataEntityMap.get(mainType.getName()).add(extDataEntity);
            for (EntityType entityType : mainType.getAllEntities().values()) {
                if (!(entityType instanceof EntryType)) continue;
                EntryType entryType = (EntryType)entityType;
                EntryProp entryProp = (EntryProp)mainType.getProperties().get((Object)entryType.getName());
                if (entryProp == null) continue;
                this.addEntryRows(mainType, entryType, dataEntity, dataEntityIndex, billNo);
            }
            ++dataEntityIndex;
        }
    }

    private void addEntryRows(MainEntityType mainType, EntryType entryEntity, DynamicObject dataEntity, int dataEntityIndex, String billNo) {
        IDataEntityProperty entryProp = (IDataEntityProperty)mainType.getProperties().get((Object)entryEntity.getName());
        if (entryProp == null) {
            return;
        }
        DynamicObjectCollection entryRows = dataEntity.getDynamicObjectCollection(entryProp);
        int rowIndex = 0;
        List<CtExtendedDataEntity> entryExtDataEntityList = this.extDataEntityMap.get(entryProp.getName());
        for (DynamicObject entryRow : entryRows) {
            CtExtendedDataEntity entryExtDataEntity = new CtExtendedDataEntity(entryRow, dataEntityIndex, rowIndex, billNo);
            entryExtDataEntityList.add(entryExtDataEntity);
            this.parseChildEntitys(entryEntity, entryRow, dataEntityIndex, rowIndex, billNo);
            ++rowIndex;
        }
    }

    private void parseChildEntitys(EntryType parentType, DynamicObject parentRow, int dataEntityIndex, int rowIndex, String billNo) {
        for (IDataEntityProperty property : parentType.getProperties()) {
            if (!(property instanceof EntryProp)) continue;
            EntryProp childProp = (EntryProp)property;
            int subRowIndex = 0;
            DynamicObjectCollection childRows = parentRow.getDynamicObjectCollection((IDataEntityProperty)childProp);
            List<CtExtendedDataEntity> childExtDataEntityList = this.extDataEntityMap.get(childProp.getName());
            for (DynamicObject childRow : childRows) {
                CtExtendedDataEntity childExtDataEntity = new CtExtendedDataEntity(childRow, dataEntityIndex, rowIndex, subRowIndex, billNo);
                childExtDataEntityList.add(childExtDataEntity);
                EntryType childType = (EntryType)childProp.getItemType();
                this.parseChildEntitys(childType, childRow, dataEntityIndex, subRowIndex, billNo);
                ++subRowIndex;
            }
        }
    }

    public CtExtendedDataEntity[] FindByEntityKey(String entityKey) {
        if (this.extDataEntityMap.containsKey(entityKey) && Objects.nonNull(this.extDataEntityMap.get(entityKey))) {
            return this.extDataEntityMap.get(entityKey).toArray(new CtExtendedDataEntity[0]);
        }
        return new CtExtendedDataEntity[0];
    }

    public String getBillNo(DynamicObject dataEntity) {
        BasedataEntityType mainType;
        String billNo = "";
        IDataEntityProperty billNoProp = null;
        IDataEntityType dType = dataEntity.getDataEntityType();
        if (dType instanceof BasedataEntityType) {
            mainType = (BasedataEntityType)dType;
            if (StringUtils.isNotBlank((CharSequence)mainType.getNameProperty())) {
                billNoProp = mainType.findProperty(mainType.getNumberProperty());
            }
        } else if (dType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)(mainType = (BillEntityType)dType).getBillNo())) {
            billNoProp = mainType.findProperty(mainType.getBillNo());
        }
        if (billNoProp == null) {
            return billNo;
        }
        Object value = billNoProp.getValue((Object)dataEntity);
        if (value == null) {
            return billNo;
        }
        billNo = value.toString();
        return billNo;
    }

    public void AddExtendedDataEntities(String entityKey, List<CtExtendedDataEntity> rows) {
        if (this.extDataEntityMap.containsKey(entityKey) && Objects.nonNull(this.extDataEntityMap.get(entityKey))) {
            List<CtExtendedDataEntity> entityList = this.extDataEntityMap.get(entityKey);
            entityList.addAll(rows);
        } else {
            ArrayList<CtExtendedDataEntity> entityList = new ArrayList<CtExtendedDataEntity>();
            entityList.addAll(rows);
            this.extDataEntityMap.put(entityKey, entityList);
        }
    }

    public Map<String, List<CtExtendedDataEntity>> getExtDataEntityMap() {
        return this.extDataEntityMap;
    }
}

