/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.ctbotp;

import java.util.ArrayList;
import java.util.Comparator;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.ISupportInitialize;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.ctbotp.CtCRValByCondition;
import kd.bos.entity.ctbotp.CtCRValByConditions;
import kd.bos.entity.ctbotp.CtFieldConvertType;
import kd.bos.entity.ctbotp.CtFieldSumType;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class CtFieldMapItem
implements ISupportInitialize {
    private static final String BOS_ENTITY_CORE = "bos-botp-core";
    private String targetFieldKey;
    private String targetEntityKeys;
    private String targetFieldType;
    private String targetFieldBaseDataNumber;
    private CtFieldConvertType ctFieldConvertType = CtFieldConvertType.SourceField;
    private CtFieldSumType ctFieldSumType = CtFieldSumType.First;
    private String convertType2;
    private transient boolean _isInitialize;
    private String sourceFieldKey;
    private CRFormula formula;
    private CtCRValByConditions valByConditions;
    private CRFormula constant;
    private String valByCondiionsString;
    private boolean breakForNoDistribute;
    private boolean onlyTakeApprovedData;
    private boolean onlyTakeUsedData;

    public boolean isValid() {
        if (StringUtils.isBlank((CharSequence)this.targetFieldKey)) {
            return false;
        }
        if (this.ctFieldConvertType == null) {
            return false;
        }
        switch (this.ctFieldConvertType) {
            case SourceField: {
                return StringUtils.isNotBlank((CharSequence)this.sourceFieldKey);
            }
            case Formula: {
                return this.formula != null && StringUtils.isNotBlank((CharSequence)this.formula.getExpression());
            }
            case CONSTANT: {
                return this.constant != null && StringUtils.isNotBlank((CharSequence)this.constant.getExpression());
            }
            case ByCondition: {
                return this.valByConditions != null && !this.valByConditions.getItems().isEmpty();
            }
        }
        return false;
    }

    @SimplePropertyAttribute(isPrimaryKey=true)
    @KSMethod
    public String getTargetFieldKey() {
        return this.targetFieldKey;
    }

    public void setTargetFieldKey(String targetFieldKey) {
        this.targetFieldKey = targetFieldKey;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getTargetEntityKeys() {
        return this.targetEntityKeys;
    }

    public void setTargetEntityKeys(String targetEntityKeys) {
        this.targetEntityKeys = targetEntityKeys;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getTargetFieldType() {
        return this.targetFieldType;
    }

    public void setTargetFieldType(String targetFieldType) {
        this.targetFieldType = targetFieldType;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getTargetFieldBaseDataNumber() {
        return this.targetFieldBaseDataNumber;
    }

    public void setTargetFieldBaseDataNumber(String targetFieldBaseDataNumber) {
        this.targetFieldBaseDataNumber = targetFieldBaseDataNumber;
    }

    @KSMethod
    public CtFieldConvertType getCtFieldConvertType() {
        return this.ctFieldConvertType;
    }

    public void setCtFieldConvertType(CtFieldConvertType ctFieldConvertType) {
        this.ctFieldConvertType = ctFieldConvertType;
    }

    @SimplePropertyAttribute
    public String getConvertType() {
        return this.ctFieldConvertType.name();
    }

    public void setConvertType(String convertType) {
        this.ctFieldConvertType = CtFieldConvertType.valueOf(convertType);
    }

    @SimplePropertyAttribute
    public String getConvertType2() {
        Object[] strs = new String[]{this.getCtFieldConvertType().toString(), ""};
        switch (this.getCtFieldConvertType()) {
            case SourceField: {
                if (!StringUtils.isNotBlank((CharSequence)this.getSourceFieldKey())) break;
                strs[1] = this.getSourceFieldKey();
                break;
            }
            case Formula: {
                if (this.getFormula() == null || !StringUtils.isNotBlank((CharSequence)this.getFormula().getExpression())) break;
                strs[1] = this.getFormula().getExpression();
                break;
            }
            case CONSTANT: {
                if (this.getConstant() == null || !StringUtils.isNotBlank((CharSequence)this.getConstant().getExpression())) break;
                strs[1] = this.getConstant().getExpression();
                break;
            }
            case ByCondition: {
                if (this.getValByConditions() == null || this.getValByConditions().getItems().isEmpty()) break;
                ArrayList<CtCRValByCondition> conObjList = new ArrayList<CtCRValByCondition>(this.getValByConditions().getItems());
                conObjList.sort(new CRValByConditionComparator());
                ArrayList<String> conStrList = new ArrayList<String>(conObjList.size());
                for (CtCRValByCondition item : this.getValByConditions().getItems()) {
                    String conStr = String.format("%s_%s_%s_%s_%s_%s", item.getId(), item.getSelect(), item.getCtCRCondition() != null ? item.getCtCRCondition().getExpression() : "", item.getIfconstant(), item.getFormula() != null ? item.getFormula().getExpression() : "", item.hashCode());
                    conStrList.add(conStr);
                }
                strs[1] = StringUtils.join((Object[])conStrList.toArray(), (String)";");
                break;
            }
        }
        if (StringUtils.isBlank((CharSequence)strs[1])) {
            return null;
        }
        return StringUtils.join((Object[])strs, (String)",");
    }

    public void setConvertType2(String convertType2) {
        this.convertType2 = convertType2;
    }

    @KSMethod
    public CtFieldSumType getCtFieldSumType() {
        return this.ctFieldSumType;
    }

    public void setCtFieldSumType(CtFieldSumType ctFieldSumType) {
        this.ctFieldSumType = ctFieldSumType;
    }

    @SimplePropertyAttribute
    public String getSumType() {
        return this.ctFieldSumType.name();
    }

    public void setSumType(String sumType) {
        this.ctFieldSumType = CtFieldSumType.valueOf(sumType);
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getSourceFieldKey() {
        return this.sourceFieldKey;
    }

    public void setSourceFieldKey(String sourceFieldKey) {
        this.sourceFieldKey = sourceFieldKey;
    }

    @ComplexPropertyAttribute
    @KSMethod
    public CRFormula getFormula() {
        return this.formula;
    }

    public void setFormula(CRFormula formula) {
        this.formula = formula;
    }

    @ComplexPropertyAttribute
    @KSMethod
    public CtCRValByConditions getValByConditions() {
        return this.valByConditions;
    }

    public void setValByConditions(CtCRValByConditions valByConditions) {
        this.valByConditions = valByConditions;
    }

    @SimplePropertyAttribute
    public String getValByCondiionsString() {
        if (this.getValByConditions() == null) {
            return null;
        }
        return SerializationUtils.toJsonString((Object)this.getValByConditions());
    }

    public void setValByCondiionsString(String valByCondiionsString) {
        this.valByCondiionsString = valByCondiionsString;
    }

    @ComplexPropertyAttribute
    @KSMethod
    public CRFormula getConstant() {
        return this.constant;
    }

    public void setConstant(CRFormula constant) {
        this.constant = constant;
    }

    @SimplePropertyAttribute
    @KSMethod
    public boolean isBreakForNoDistribute() {
        return this.breakForNoDistribute;
    }

    public void setBreakForNoDistribute(boolean breakForNoDistribute) {
        this.breakForNoDistribute = breakForNoDistribute;
    }

    @SimplePropertyAttribute
    @KSMethod
    public boolean isOnlyTakeApprovedData() {
        return this.onlyTakeApprovedData;
    }

    public void setOnlyTakeApprovedData(boolean onlyTakeApprovedData) {
        this.onlyTakeApprovedData = onlyTakeApprovedData;
    }

    @SimplePropertyAttribute
    @KSMethod
    public boolean isOnlyTakeUsedData() {
        return this.onlyTakeUsedData;
    }

    public void setOnlyTakeUsedData(boolean onlyTakeUsedData) {
        this.onlyTakeUsedData = onlyTakeUsedData;
    }

    public void beginInit() {
        this._isInitialize = true;
    }

    public void endInit() {
        if (StringUtils.isNotBlank((CharSequence)this.convertType2)) {
            String[] strs = StringUtils.split((String)this.convertType2, (String)",");
            String fldConvType = strs[0];
            if (StringUtils.equalsIgnoreCase((CharSequence)fldConvType, (CharSequence)CtFieldConvertType.SourceField.toString())) {
                this.ctFieldConvertType = CtFieldConvertType.SourceField;
            } else if (StringUtils.equalsIgnoreCase((CharSequence)fldConvType, (CharSequence)CtFieldConvertType.Formula.toString())) {
                this.ctFieldConvertType = CtFieldConvertType.Formula;
            } else if (StringUtils.equalsIgnoreCase((CharSequence)fldConvType, (CharSequence)CtFieldConvertType.ByCondition.toString())) {
                this.ctFieldConvertType = CtFieldConvertType.ByCondition;
            } else if (StringUtils.equalsIgnoreCase((CharSequence)fldConvType, (CharSequence)CtFieldConvertType.CONSTANT.toString())) {
                this.ctFieldConvertType = CtFieldConvertType.CONSTANT;
            }
        }
        this.convertType2 = null;
        if (StringUtils.isNotBlank((CharSequence)this.valByCondiionsString)) {
            this.valByConditions = (CtCRValByConditions)SerializationUtils.fromJsonString((String)this.valByCondiionsString, CtCRValByConditions.class);
        }
        this.valByCondiionsString = null;
        this._isInitialize = false;
    }

    public boolean isInitialized() {
        return this._isInitialize;
    }

    public String toString() {
        return this.targetFieldKey;
    }

    static class CRValByConditionComparator
    implements Comparator<CtCRValByCondition> {
        CRValByConditionComparator() {
        }

        @Override
        public int compare(CtCRValByCondition o1, CtCRValByCondition o2) {
            return o1.getSeq() - o2.getSeq();
        }
    }
}

