/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.ctbotp.plugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.TypesContainer;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.CRPlugin;
import kd.bos.entity.ctbotp.plugin.ICtConvertRuleSetPlugIn;
import kd.bos.entity.ctbotp.plugin.KDCtConvertRuleSetPlugIn;
import kd.bos.entity.ctbotp.plugin.tracker.args.CtLoadFuncTypesEventArgs;
import kd.bos.script.ScriptExecutor;

public class CtConvertRuleSetPlugInProxy {
    ScriptExecutor scriptExecutor;
    protected List<ICtConvertRuleSetPlugIn> plugIns = new ArrayList<ICtConvertRuleSetPlugIn>();

    public CtConvertRuleSetPlugInProxy() {
    }

    public CtConvertRuleSetPlugInProxy(List<CRPlugin> plugins) {
        this.scriptExecutor = ScriptExecutor.getOrCreate();
        HashSet<String> plugClasses = new HashSet<String>();
        for (CRPlugin plugin : plugins) {
            if (!plugin.isEnabled()) continue;
            int type = plugin.getType();
            String className = plugin.getClassName();
            String scriptId = plugin.getScriptId();
            if (0 == type && plugClasses.add(className)) {
                this.plugIns.add((ICtConvertRuleSetPlugIn)TypesContainer.createInstance((String)className));
                continue;
            }
            if (1 != type || !plugClasses.add(scriptId)) continue;
            try {
                ICtConvertRuleSetPlugIn splugin = this.createScriptPlugin1(scriptId);
                this.plugIns.add(splugin);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public ICtConvertRuleSetPlugIn createScriptPlugin(String scriptId) {
        return this.createScriptPlugin1(scriptId);
    }

    private ICtConvertRuleSetPlugIn createScriptPlugin1(String scriptId) {
        String script = EntityMetadataCache.getPluginScripts((String)scriptId);
        this.scriptExecutor.init(ctx -> ctx.require(new String[]{KDCtConvertRuleSetPlugIn.class.getName()}));
        this.scriptExecutor.begin();
        this.scriptExecutor.exec(new String[]{script});
        return (ICtConvertRuleSetPlugIn)this.scriptExecutor.getContext().get("plugin");
    }

    public final List<ICtConvertRuleSetPlugIn> getPlugIns() {
        return this.plugIns;
    }

    public final void registerPlugins(List<ICtConvertRuleSetPlugIn> list) {
        this.plugIns.addAll(list);
    }

    public final void registerPlugin(ICtConvertRuleSetPlugIn plugin) {
        this.plugIns.add(plugin);
    }

    public final void removePlugIn(ICtConvertRuleSetPlugIn plugIn) {
        this.plugIns.remove(plugIn);
    }

    public void destory() {
        if (this.scriptExecutor != null) {
            this.scriptExecutor.end();
        }
    }

    public void setContext(BillEntityType srcMainType, BillEntityType tgtMainType) {
        for (ICtConvertRuleSetPlugIn plugIn : this.plugIns) {
            plugIn.setContext(srcMainType, tgtMainType);
        }
    }

    public void fireLoadFuncTypes(CtLoadFuncTypesEventArgs e) {
        for (ICtConvertRuleSetPlugIn plugIn : this.plugIns) {
            plugIn.loadFuncTypes(e);
        }
    }
}

