/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.ctbotp.runtime;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ctbotp.runtime.CtConvertOperationResult;

public class CtConvertOpProgressCache {
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));
    private static final String CACHE_TYPE = "ConvertExecuter";
    private static final String CACHEKEY_COMPLETE = "complete";
    private static final String CACHEKEY_FINISH = "finish";
    private static final String CACHEKEY_CANCEL = "cancel";
    private static final String CACHEKEY_ERROR = "error";
    private static final String CACHEKEY_ERRORMESSAGE = "errormessage";
    public static final String CACHEKEY_PROGRESS = "progress";
    public static final String CACHEKEY_TIP = "tip";
    public static final String CACHEKEY_CONVERTARGS = "convertargs";
    public static final String CACHEKEY_RESULT = "result";
    public static final String CACHEKEY_PUSHARGS = "pushargs";

    private static String buildCacheType(String taskId) {
        return "ConvertExecuter_" + taskId;
    }

    private static String buildParamsCacheType(String taskId) {
        return "ConvertExecuter_param_" + taskId;
    }

    public static void setParam(String taskId, String paramKey, String paramVal) {
        cache.put(CtConvertOpProgressCache.buildParamsCacheType(taskId), paramKey, paramVal, 2, TimeUnit.HOURS);
    }

    public static String getParamAndClear(String taskId, String paramKey) {
        String result = CtConvertOpProgressCache.getParam(taskId, paramKey);
        CtConvertOpProgressCache.clearParamCache(taskId, paramKey);
        return result;
    }

    private static String getParam(String taskId, String paramKey) {
        return (String)cache.get(CtConvertOpProgressCache.buildParamsCacheType(taskId), paramKey);
    }

    public static boolean isFinished(String taskId) {
        String finish = (String)cache.get(CtConvertOpProgressCache.buildCacheType(taskId), CACHEKEY_FINISH);
        if (StringUtils.isBlank((CharSequence)finish)) {
            return false;
        }
        return Boolean.parseBoolean(finish);
    }

    public static void setFinished(String taskId, boolean finisih) {
        cache.put(CtConvertOpProgressCache.buildCacheType(taskId), CACHEKEY_FINISH, (Object)String.valueOf(finisih));
    }

    public static boolean isCompleted(String taskId) {
        String finish = (String)cache.get(CtConvertOpProgressCache.buildCacheType(taskId), CACHEKEY_COMPLETE);
        if (StringUtils.isBlank((CharSequence)finish)) {
            return false;
        }
        return Boolean.parseBoolean(finish);
    }

    public static void setCompleted(String taskId, boolean complete) {
        cache.put(CtConvertOpProgressCache.buildCacheType(taskId), CACHEKEY_COMPLETE, (Object)String.valueOf(complete));
    }

    public static boolean isError(String taskId) {
        String error = (String)cache.get(CtConvertOpProgressCache.buildCacheType(taskId), CACHEKEY_ERROR);
        if (StringUtils.isBlank((CharSequence)error)) {
            return false;
        }
        return Boolean.parseBoolean(error);
    }

    public static void setError(String taskId, boolean error, String errMssage) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(CACHEKEY_ERROR, String.valueOf(error));
        values.put(CACHEKEY_ERRORMESSAGE, String.valueOf(errMssage));
        cache.put(CtConvertOpProgressCache.buildCacheType(taskId), values);
    }

    public static String getErrorMessage(String taskId) {
        return (String)cache.get(CtConvertOpProgressCache.buildCacheType(taskId), CACHEKEY_ERRORMESSAGE);
    }

    public static int getProgress(String taskId) {
        String value = (String)cache.get(CtConvertOpProgressCache.buildCacheType(taskId), CACHEKEY_PROGRESS);
        if (StringUtils.isBlank((CharSequence)value)) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    public static void setProgress(String taskId, int process, String tip) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(CACHEKEY_PROGRESS, String.valueOf(process));
        values.put(CACHEKEY_TIP, tip);
        cache.put(CtConvertOpProgressCache.buildCacheType(taskId), values);
    }

    public static String getProgressTip(String taskId) {
        return (String)cache.get(CtConvertOpProgressCache.buildCacheType(taskId), CACHEKEY_TIP);
    }

    public static String getConvertArgs(String taskId) {
        return (String)cache.get(CtConvertOpProgressCache.buildCacheType(taskId), CACHEKEY_CONVERTARGS);
    }

    public static void setConvertArgs(String taskId, String argJson) {
        cache.put(CtConvertOpProgressCache.buildCacheType(taskId), CACHEKEY_CONVERTARGS, (Object)argJson);
    }

    @Deprecated
    public static CtConvertOperationResult getCacheOperateResult(String taskId) {
        String str = (String)cache.get(CtConvertOpProgressCache.buildCacheType(taskId), CACHEKEY_RESULT);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return (CtConvertOperationResult)SerializationUtils.fromJsonString((String)str, CtConvertOperationResult.class);
    }

    @Deprecated
    public static void setOperateResult(String taskId, CtConvertOperationResult result) {
        String str = SerializationUtils.toJsonString((Object)result);
        HashMap<String, String> cacheValues = new HashMap<String, String>();
        cacheValues.put(CACHEKEY_RESULT, str);
        cacheValues.put(CACHEKEY_FINISH, String.valueOf(true));
        cache.put(CtConvertOpProgressCache.buildCacheType(taskId), cacheValues);
    }

    public static void clearCache(String taskId) {
        cache.removeType(CtConvertOpProgressCache.buildCacheType(taskId));
    }

    public static void clearParamCache(String taskId, String paramKey) {
        cache.remove(CtConvertOpProgressCache.buildParamsCacheType(taskId), paramKey);
    }
}

