/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.ctbotp.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.runtime.CtSourceRowComparator;
import kd.bos.entity.ctbotp.runtime.CtSourceRowReport;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class CtSourceBillReport
implements Serializable {
    private static final long serialVersionUID = 5252102416357098493L;
    private static final String BOS_ENTITY_CORE = "bos-botp-core";
    private Object billId;
    private String billNo;
    private String ruleId;
    private String ruleName;
    private List<String> failMessages = new ArrayList<String>(1);
    private String entryKey;
    private String entryName;
    private String subEntryKey;
    private String subEntryName;
    private String linkEntityKey;
    private String linkEntityName;
    private int rowCount;
    private int failRowCount;
    private static final int KEEPENTRYREPORTCOUNT = 5;
    private List<CtSourceRowReport> linkEntityRowReports = new ArrayList<CtSourceRowReport>(1);
    private Map<String, List<CtSourceRowReport>> dependEntityRowReports = new HashMap<String, List<CtSourceRowReport>>(0);
    private transient Map<CtSourceRowReport, CtSourceRowReport> linkRowsMap = new HashMap<CtSourceRowReport, CtSourceRowReport>(1);
    private transient Map<String, Map<CtSourceRowReport, CtSourceRowReport>> dependRowsMap = new HashMap<String, Map<CtSourceRowReport, CtSourceRowReport>>(0);

    @KSMethod
    public Object getBillId() {
        return this.billId;
    }

    @KSMethod
    public void setBillId(Object billId) {
        this.billId = billId;
    }

    @KSMethod
    public String getBillNo() {
        return this.billNo;
    }

    @KSMethod
    public void setBillNo(String billNo) {
        this.billNo = billNo;
    }

    @KSMethod
    public boolean isSuccess() {
        return this.failMessages.isEmpty() && this.failRowCount < this.rowCount && this.dependEntityRowReports.isEmpty();
    }

    public boolean isFullSuccess() {
        return this.failMessages.isEmpty() && this.rowCount > 0 && this.failRowCount == 0 && this.linkEntityRowReports.isEmpty() && this.linkRowsMap.isEmpty() && this.dependEntityRowReports.isEmpty();
    }

    @KSMethod
    public String getRuleId() {
        return this.ruleId;
    }

    @KSMethod
    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    @KSMethod
    public String getRuleName() {
        return this.ruleName;
    }

    @KSMethod
    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    @KSMethod
    public List<String> getFailMessages() {
        return this.failMessages;
    }

    @KSMethod
    public void addFailMessage(String failMessage) {
        this.failMessages.add(failMessage);
    }

    @KSMethod
    public String getEntryKey() {
        return this.entryKey;
    }

    @KSMethod
    public void setEntryKey(String entryKey) {
        this.entryKey = entryKey;
    }

    @KSMethod
    public String getEntryName() {
        return this.entryName;
    }

    @KSMethod
    public void setEntryName(String entryName) {
        this.entryName = entryName;
    }

    @KSMethod
    public String getSubEntryKey() {
        return this.subEntryKey;
    }

    @KSMethod
    public void setSubEntryKey(String subEntryKey) {
        this.subEntryKey = subEntryKey;
    }

    @KSMethod
    public String getSubEntryName() {
        return this.subEntryName;
    }

    @KSMethod
    public void setSubEntryName(String subEntryName) {
        this.subEntryName = subEntryName;
    }

    @KSMethod
    public String getLinkEntityKey() {
        return this.linkEntityKey;
    }

    @KSMethod
    public void setLinkEntityKey(String linkEntityKey) {
        this.linkEntityKey = linkEntityKey;
    }

    @KSMethod
    public String getLinkEntityName() {
        return this.linkEntityName;
    }

    @KSMethod
    public void setLinkEntityName(String linkEntityName) {
        this.linkEntityName = linkEntityName;
    }

    @KSMethod
    public int getRowCount() {
        return this.rowCount;
    }

    @KSMethod
    public void addRowCount(int count) {
        this.rowCount = count <= 0 ? ++this.rowCount : (this.rowCount += count);
    }

    @KSMethod
    public int getFailRowCount() {
        return this.failRowCount;
    }

    public void addSourceRowReport(String entityKey, CtSourceRowReport rowReport) {
        Map<CtSourceRowReport, CtSourceRowReport> rows = null;
        if (StringUtils.equalsIgnoreCase((CharSequence)entityKey, (CharSequence)this.linkEntityKey)) {
            if (StringUtils.isBlank((CharSequence)this.entryKey)) {
                this.getFailMessages().addAll(rowReport.getFailMessages());
                return;
            }
            rows = this.linkRowsMap;
        } else {
            if (!this.dependRowsMap.containsKey(entityKey)) {
                this.dependRowsMap.put(entityKey, new HashMap());
            }
            rows = this.dependRowsMap.get(entityKey);
        }
        if (rows.containsKey(rowReport) && Objects.nonNull(rows.get(rowReport))) {
            rows.get(rowReport).getFailMessages().addAll(rowReport.getFailMessages());
        } else {
            rows.put(rowReport, rowReport);
        }
    }

    @KSMethod
    public void copyReportToList() {
        this.failRowCount = this.linkRowsMap.size();
        CtSourceRowComparator rowComparator = new CtSourceRowComparator();
        this.linkEntityRowReports.clear();
        ArrayList<CtSourceRowReport> linkRows = new ArrayList<CtSourceRowReport>(this.linkRowsMap.values());
        linkRows.sort(rowComparator);
        if (linkRows.size() <= 5) {
            this.linkEntityRowReports.addAll(linkRows);
        } else {
            this.linkEntityRowReports.addAll(linkRows.subList(0, 5));
        }
        this.linkRowsMap.clear();
        this.dependEntityRowReports.clear();
        for (Map.Entry<String, Map<CtSourceRowReport, CtSourceRowReport>> entry : this.dependRowsMap.entrySet()) {
            ArrayList<CtSourceRowReport> list = new ArrayList<CtSourceRowReport>(entry.getValue().values());
            list.sort(rowComparator);
            if (list.size() <= 5) {
                this.dependEntityRowReports.put(entry.getKey(), list);
                continue;
            }
            this.dependEntityRowReports.put(entry.getKey(), list.subList(0, 5));
        }
        this.dependRowsMap.clear();
    }

    @KSMethod
    public List<CtSourceRowReport> getLinkEntityRowReports() {
        return this.linkEntityRowReports;
    }

    @KSMethod
    public Map<String, List<CtSourceRowReport>> getDependEntityRowReports() {
        return this.dependEntityRowReports;
    }

    @KSMethod
    public String getRowInfo() {
        StringBuilder sBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.billNo)) {
            sBuilder.append(String.format(ResManager.loadKDString((String)"\u5355\u636e(%s)", (String)"SourceBillReport_0", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), this.billNo));
        } else {
            sBuilder.append(String.format(ResManager.loadKDString((String)"\u5355\u636e(%s)", (String)"SourceBillReport_0", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), this.billId));
        }
        return sBuilder.toString();
    }

    @KSMethod
    public String getFailMessage() {
        String failMessage = "";
        if (!this.failMessages.isEmpty()) {
            failMessage = this.failMessages.get(0);
        } else {
            for (CtSourceRowReport ctSourceRowReport : this.linkEntityRowReports) {
                String rowMessage;
                if (ctSourceRowReport.getFailMessages().isEmpty() || StringUtils.isBlank((CharSequence)(rowMessage = ctSourceRowReport.getFailMessage()))) continue;
                failMessage = rowMessage;
                break;
            }
            if (StringUtils.isBlank((CharSequence)failMessage) && !this.dependEntityRowReports.isEmpty()) {
                for (Map.Entry entry : this.dependEntityRowReports.entrySet()) {
                    if (entry.getValue() == null) continue;
                    for (CtSourceRowReport rowReport : (List)entry.getValue()) {
                        String rowMessage = rowReport.getFailMessage();
                        if (StringUtils.isBlank((CharSequence)rowMessage)) continue;
                        failMessage = rowMessage;
                        break;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)failMessage)) continue;
                    break;
                }
            }
        }
        return failMessage;
    }

    public String buildSummary() {
        return this.buildSummary(null);
    }

    public String buildSummary(MainEntityType mainType) {
        String dependEntitySummary = "";
        if (!this.dependEntityRowReports.isEmpty()) {
            if (mainType == null) {
                dependEntitySummary = ResManager.loadKDString((String)"\u5176\u4ed6\u5355\u636e\u4f53\u6709\u5f02\u5e38", (String)"SourceBillReport_6", (String)BOS_ENTITY_CORE, (Object[])new Object[0]);
            } else {
                ArrayList<String> otherEntryNames = new ArrayList<String>(this.dependEntityRowReports.size());
                for (Map.Entry<String, List<CtSourceRowReport>> entry : this.dependEntityRowReports.entrySet()) {
                    EntityType entityType = (EntityType)mainType.getAllEntities().get(entry.getKey());
                    if (entityType == null || entityType.getDisplayName() == null) continue;
                    otherEntryNames.add(entityType.getDisplayName().toString());
                }
                if (!otherEntryNames.isEmpty()) {
                    dependEntitySummary = String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u6709\u5f02\u5e38", (String)"SourceBillReport_12", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), StringUtils.join((Object[])otherEntryNames.toArray(), (String)","));
                }
            }
        }
        if (!this.failMessages.isEmpty()) {
            return this.failMessages.get(0);
        }
        if (this.rowCount <= 0) {
            return ResManager.loadKDString((String)"\u672a\u53d6\u5230\u6e90\u5355\u5173\u8054\u4e3b\u5b9e\u4f53\u6570\u636e\u884c", (String)"SourceBillReport_7", (String)BOS_ENTITY_CORE, (Object[])new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)this.entryName) && !this.linkEntityRowReports.isEmpty()) {
            return this.linkEntityRowReports.get(0).getFailMessage();
        }
        if (this.failRowCount == 0) {
            if (StringUtils.isNotBlank((CharSequence)this.entryName)) {
                return String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u5171%2$d\u884c\uff0c\u65e0\u5f02\u5e38", (String)"SourceBillReport_16", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), this.entryName, this.rowCount) + (StringUtils.isBlank((CharSequence)dependEntitySummary) ? "" : "; ") + dependEntitySummary;
            }
            if (StringUtils.isBlank((CharSequence)dependEntitySummary)) {
                return ResManager.loadKDString((String)"\u65e0\u5f02\u5e38", (String)"SourceBillReport_11", (String)BOS_ENTITY_CORE, (Object[])new Object[0]);
            }
            return dependEntitySummary;
        }
        if (this.rowCount > this.failRowCount) {
            return String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u5171%2$d\u884c\uff0c%3$d\u884c\u65e0\u5f02\u5e38\uff0c%4$d\u884c\u6709\u5f02\u5e38", (String)"SourceBillReport_14", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), this.entryName, this.rowCount, this.rowCount - this.failRowCount, this.failRowCount) + (StringUtils.isBlank((CharSequence)dependEntitySummary) ? "" : "; ") + dependEntitySummary;
        }
        return String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u5171%2$d\u884c\uff0c\u5168\u90e8\u6709\u5f02\u5e38", (String)"SourceBillReport_15", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), this.entryName, this.failRowCount) + (StringUtils.isBlank((CharSequence)dependEntitySummary) ? "" : "; ") + dependEntitySummary;
    }

    @SdkInternal
    public int hashCode() {
        if (this.billId == null) {
            return 0;
        }
        return this.billId.hashCode();
    }

    @SdkInternal
    public boolean equals(Object obj) {
        if (!(obj instanceof CtSourceBillReport)) {
            return false;
        }
        return this.equalsValue(this.billId, ((CtSourceBillReport)obj).getBillId());
    }

    private boolean equalsValue(Object v1, Object v2) {
        if (v1 == null) {
            return v2 == null;
        }
        return v1.equals(v2);
    }

    @SdkInternal
    public String toString() {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(this.getRowInfo());
        sBuilder.append(": ");
        if (this.isFullSuccess()) {
            sBuilder.append(ResManager.loadKDString((String)"\u65e0\u5f02\u5e38", (String)"SourceBillReport_11", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
        } else {
            sBuilder.append(this.getFailMessage());
        }
        return sBuilder.toString();
    }
}

