/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.ctbotp.runtime;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ctbotp.runtime.CtWriteBackRuleElement;
import kd.bos.entity.ctbotp.runtime.CtWriteBackRuleElementSerializer;
import kd.bos.entity.ctbotp.runtime.CtWriteBackRuleLocalCache;
import kd.bos.entity.ctbotp.runtime.CtWriteBackRuleRedisCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import org.apache.commons.collections.CollectionUtils;

public class CtWriteBackRuleCache {
    private static final Log log = LogFactory.getLog(CtWriteBackRuleCache.class);

    public static synchronized void clearAllRuleCache() {
        CtWriteBackRuleLocalCache.clearAllRuleCache();
        CtWriteBackRuleRedisCache.clearAllRuleCache();
        log.info("clearAllRuleCache");
    }

    public static List<CtWriteBackRuleElement> batchLoadRule(List<String> ruleIds) {
        if (CollectionUtils.isEmpty(ruleIds)) {
            return new ArrayList<CtWriteBackRuleElement>();
        }
        List<String> cacheVersions = CtWriteBackRuleRedisCache.batchGetCacheVersion(ruleIds.toArray(new String[ruleIds.size()]));
        ArrayList<CtWriteBackRuleElement> writeBackRuleElements = new ArrayList<CtWriteBackRuleElement>(ruleIds.size());
        for (int i = 0; i < ruleIds.size(); ++i) {
            long ts = System.currentTimeMillis();
            String ruleId = ruleIds.get(i);
            CtWriteBackRuleElement rule = CtWriteBackRuleLocalCache.getRule(ruleId);
            if (rule != null) {
                if (StringUtils.isBlank((CharSequence)rule.getCacheVersion())) {
                    rule = null;
                } else if (!StringUtils.equals((CharSequence)rule.getCacheVersion(), (CharSequence)cacheVersions.get(i))) {
                    rule = null;
                } else if (Long.compare(ts - rule.getCheckVersionTimeMillis(), 600000L) > 0) {
                    rule = null;
                }
            }
            if (rule != null) {
                writeBackRuleElements.add(rule);
                continue;
            }
            String cacheVersion = null;
            String ruleXml = CtWriteBackRuleRedisCache.getRule(ruleId);
            if (ruleXml != null) {
                cacheVersion = cacheVersions.get(i);
                if (StringUtils.isBlank((CharSequence)cacheVersion)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
                    cacheVersion = sdf.format(new Date());
                    CtWriteBackRuleRedisCache.putCacheVersion(ruleId, cacheVersion);
                }
            } else {
                MetadataService service = (MetadataService)ServiceFactory.getService(MetadataService.class);
                ruleXml = service.loadWriteBackRule(ruleId);
                if (StringUtils.isBlank((CharSequence)ruleXml)) {
                    ruleXml = "";
                }
                CtWriteBackRuleRedisCache.putRule(ruleId, ruleXml);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
                cacheVersion = sdf.format(new Date());
                CtWriteBackRuleRedisCache.putCacheVersion(ruleId, cacheVersion);
            }
            if (!StringUtils.isNotBlank((CharSequence)ruleXml)) continue;
            rule = CtWriteBackRuleElementSerializer.deserializeFromString(ruleXml, null);
            rule.setCacheVersion(cacheVersion);
            rule.setCheckVersionTimeMillis(System.currentTimeMillis());
            CtWriteBackRuleLocalCache.putRule(ruleId, rule);
            writeBackRuleElements.add(rule);
        }
        return writeBackRuleElements;
    }

    public static CtWriteBackRuleElement loadRule(String ruleId) {
        long ts = System.currentTimeMillis();
        CtWriteBackRuleElement rule = CtWriteBackRuleLocalCache.getRule(ruleId);
        if (rule != null) {
            if (StringUtils.isBlank((CharSequence)rule.getCacheVersion())) {
                rule = null;
            } else if (!StringUtils.equals((CharSequence)rule.getCacheVersion(), (CharSequence)CtWriteBackRuleRedisCache.getCacheVersion(ruleId))) {
                rule = null;
            } else if (Long.compare(ts - rule.getCheckVersionTimeMillis(), 600000L) > 0) {
                rule = null;
            }
        }
        if (rule != null) {
            return rule;
        }
        String cacheVersion = null;
        String ruleXml = CtWriteBackRuleRedisCache.getRule(ruleId);
        if (ruleXml != null) {
            cacheVersion = CtWriteBackRuleRedisCache.getCacheVersion(ruleId);
            if (StringUtils.isBlank((CharSequence)cacheVersion)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
                cacheVersion = sdf.format(new Date());
                CtWriteBackRuleRedisCache.putCacheVersion(ruleId, cacheVersion);
            }
        } else {
            MetadataService service = (MetadataService)ServiceFactory.getService(MetadataService.class);
            ruleXml = service.loadWriteBackRule(ruleId);
            if (StringUtils.isBlank((CharSequence)ruleXml)) {
                ruleXml = "";
            }
            CtWriteBackRuleRedisCache.putRule(ruleId, ruleXml);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            cacheVersion = sdf.format(new Date());
            CtWriteBackRuleRedisCache.putCacheVersion(ruleId, cacheVersion);
        }
        if (StringUtils.isNotBlank((CharSequence)ruleXml)) {
            rule = CtWriteBackRuleElementSerializer.deserializeFromString(ruleXml, null);
            rule.setCacheVersion(cacheVersion);
            rule.setCheckVersionTimeMillis(System.currentTimeMillis());
            CtWriteBackRuleLocalCache.putRule(ruleId, rule);
            return rule;
        }
        return null;
    }

    public static List<CtWriteBackRuleElement> loadRules(String targetEntityNumber) {
        List ruleIds = null;
        String cacheRuleIds = CtWriteBackRuleRedisCache.getRuleIds(targetEntityNumber);
        if (cacheRuleIds == null) {
            MetadataService service = (MetadataService)ServiceFactory.getService(MetadataService.class);
            ruleIds = service.loadWriteBackRuleIds(targetEntityNumber);
            CtWriteBackRuleRedisCache.putRuleIds(targetEntityNumber, SerializationUtils.toJsonString((Object)ruleIds));
        } else {
            ruleIds = (List)SerializationUtils.fromJsonString((String)cacheRuleIds, List.class);
        }
        return CtWriteBackRuleCache.batchLoadRule(ruleIds);
    }

    public static Long loadRuleVerId(String ruleId, long oriVersion, long extVersion) {
        return CtWriteBackRuleLocalCache.loadRuleVerId(ruleId, oriVersion, extVersion);
    }

    public static void cacheRuleVerId(String ruleId, long oriVersion, long extVersion, long verId) {
        CtWriteBackRuleLocalCache.putRuleVerId(ruleId, oriVersion, extVersion, verId);
    }

    public static CtWriteBackRuleElement loadRuleVer(long verId) {
        String cacheVersion;
        long ts = System.currentTimeMillis();
        CtWriteBackRuleElement rule = CtWriteBackRuleLocalCache.getRuleVer(verId);
        if (rule != null) {
            if (StringUtils.isBlank((CharSequence)rule.getCacheVersion())) {
                rule = null;
            } else if (!StringUtils.equals((CharSequence)rule.getCacheVersion(), (CharSequence)CtWriteBackRuleRedisCache.getCacheVersion(String.valueOf(verId)))) {
                rule = null;
            } else if (Long.compare(ts - rule.getCheckVersionTimeMillis(), 600000L) > 0) {
                rule = null;
            }
        }
        if (rule != null) {
            return rule;
        }
        String ruleXml = CtWriteBackRuleRedisCache.getRuleVer(verId);
        if (ruleXml == null) {
            MetadataService service = (MetadataService)ServiceFactory.getService(MetadataService.class);
            ruleXml = service.loadWriteBackRuleVersion(verId);
            if (StringUtils.isBlank((CharSequence)ruleXml)) {
                ruleXml = "";
            }
            CtWriteBackRuleRedisCache.putRuleVer(verId, ruleXml);
        }
        if (StringUtils.isBlank((CharSequence)(cacheVersion = CtWriteBackRuleRedisCache.getCacheVersion(String.valueOf(verId))))) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            cacheVersion = sdf.format(new Date());
            CtWriteBackRuleRedisCache.putCacheVersion(String.valueOf(verId), cacheVersion);
        }
        if (StringUtils.isNotBlank((CharSequence)ruleXml)) {
            rule = CtWriteBackRuleElementSerializer.deserializeFromString(ruleXml, null);
            rule.setCacheVersion(cacheVersion);
            rule.setCheckVersionTimeMillis(ts);
            CtWriteBackRuleLocalCache.putRuleVer(verId, rule);
        }
        return rule;
    }

    public static String loadDebugRule(String id, String cacheType) {
        if (StringUtils.isBlank((CharSequence)cacheType) || StringUtils.equals((CharSequence)cacheType, (CharSequence)"local")) {
            CtWriteBackRuleElement rule = CtWriteBackRuleLocalCache.getRule(id);
            if (rule == null) {
                return "null";
            }
            return SerializationUtils.toJsonString((Object)rule);
        }
        if (StringUtils.equals((CharSequence)cacheType, (CharSequence)"redis")) {
            String xml = CtWriteBackRuleRedisCache.getRule(id);
            if (StringUtils.isBlank((CharSequence)xml)) {
                return "null";
            }
            return xml;
        }
        if (StringUtils.equals((CharSequence)cacheType, (CharSequence)"db")) {
            MetadataService service = (MetadataService)ServiceFactory.getService(MetadataService.class);
            String xml = service.loadWriteBackRule(id);
            if (StringUtils.isBlank((CharSequence)xml)) {
                return "null";
            }
            return xml;
        }
        if (StringUtils.equals((CharSequence)cacheType, (CharSequence)"clear")) {
            CtWriteBackRuleCache.clearAllRuleCache();
            return "clear all rule cache success";
        }
        return null;
    }
}

