/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.BeforeDrawArgs;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.botp.runtime.GetTargetOptionalOrgsArgs;
import kd.bos.entity.botp.runtime.GetTargetOptionalOrgsResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.args.PushArgsFactory;
import kd.bos.service.botp.ConvertService;
import kd.bos.service.botp.convert.ConvertEngine;
import kd.bos.service.botp.convert.actions.DataMutexAction;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import org.apache.commons.collections4.CollectionUtils;

public class ConvertServiceImpl
implements ConvertService {
    private static final String CONVERT_SERVICE = "ConvertService";

    public String checkRunRuleCondition(String argsJson) {
        PushArgs args = PushArgsFactory.deserialize((String)argsJson);
        try (EntityTraceSpan span = EntityTracer.create((String)CONVERT_SERVICE, (String)"ConvertServiceImpl.checkRunRuleCondition", (EntityTraceHint)new EntityTraceHint(false));){
            if (span.isRealtime()) {
                span.addTag("SourceEntityNumber", args.getSourceEntityNumber());
                span.addTag("TargetEntityNumber", args.getTargetEntityNumber());
                span.addTag("CurrentOrgId", "" + args.getCurrentOrgId());
                span.addTag("ListSelectedRow", CollectionUtils.isEmpty((Collection)args.getSelectedRows()) ? "null" : SerializationUtils.toJsonString(args.getSelectedRows().get(0)));
            }
            ConvertEngine engine = new ConvertEngine();
            List<ConvertRuleElement> result = engine.checkRunRuleCondition(args);
            String string = SerializationUtils.toJsonString(result);
            return string;
        }
    }

    public String push(String argsJson) {
        PushArgs args = PushArgsFactory.deserialize((String)argsJson);
        try (EntityTraceSpan span = EntityTracer.create((String)CONVERT_SERVICE, (String)"ConvertServiceImpl.push", (EntityTraceHint)new EntityTraceHint(false));){
            if (span.isRealtime()) {
                span.addTag("SourceEntityNumber", args.getSourceEntityNumber());
                span.addTag("TargetEntityNumber", args.getTargetEntityNumber());
                span.addTag("CurrentOrgId", "" + args.getCurrentOrgId());
                span.addTag("ListSelectedRow", CollectionUtils.isEmpty((Collection)args.getSelectedRows()) ? "null" : SerializationUtils.toJsonString(args.getSelectedRows().get(0)));
            }
            ConvertEngine engine = new ConvertEngine();
            ConvertOperationResult result = engine.push(args);
            String string = SerializationUtils.toJsonString((Object)result);
            return string;
        }
    }

    public String pushAndSave(String argsJson) {
        PushArgs args = (PushArgs)SerializationUtils.fromJsonString((String)argsJson, PushArgs.class);
        try (TraceSpan span = Tracer.create((String)CONVERT_SERVICE, (String)String.format("%s.push.%s", args.getSourceEntityNumber(), args.getTargetEntityNumber()));){
            ConvertEngine engine = new ConvertEngine();
            ConvertOperationResult result = engine.pushAndSave(args);
            String string = SerializationUtils.toJsonString((Object)result);
            return string;
        }
    }

    public String beforeDraw(String argsJson) {
        BeforeDrawArgs args = (BeforeDrawArgs)SerializationUtils.fromJsonString((String)argsJson, BeforeDrawArgs.class);
        try (TraceSpan span = Tracer.create((String)CONVERT_SERVICE, (String)String.format("%s.beforeDraw.%s", args.getSourceEntityNumber(), args.getTargetEntityNumber()));){
            ConvertEngine engine = new ConvertEngine();
            ConvertOperationResult result = engine.beforeDraw(args);
            String string = SerializationUtils.toJsonString((Object)result);
            return string;
        }
    }

    public String draw(String argsJson) {
        DrawArgs args = (DrawArgs)SerializationUtils.fromJsonString((String)argsJson, DrawArgs.class);
        try (TraceSpan span = Tracer.create((String)CONVERT_SERVICE, (String)String.format("%s.draw.%s", args.getSourceEntityNumber(), args.getTargetEntityNumber()));){
            ConvertEngine engine = new ConvertEngine();
            ConvertOperationResult result = engine.draw(args);
            String string = SerializationUtils.toJsonString((Object)result);
            return string;
        }
    }

    public String getTargetOptionalOrgs(String argsJson) {
        GetTargetOptionalOrgsArgs args = (GetTargetOptionalOrgsArgs)SerializationUtils.fromJsonString((String)argsJson, GetTargetOptionalOrgsArgs.class);
        try (TraceSpan span = Tracer.create((String)CONVERT_SERVICE, (String)String.format("%s.getTargetOptionalOrgs.%s", args.getSourceEntityNumber(), args.getTargetEntityNumber()));){
            ConvertEngine engine = new ConvertEngine();
            GetTargetOptionalOrgsResult result = engine.getTargetOptionalOrgs(args);
            String string = SerializationUtils.toJsonString((Object)result);
            return string;
        }
    }

    public Map<String, Map<String, Object>> requirePushMutex(String srcEntityNumber, Set<String> srcBillIds, boolean isStrict) {
        return DataMutexAction.requirePushMutex(srcEntityNumber, srcBillIds, isStrict);
    }

    public Map<String, Boolean> releasePushMutex(String srcEntityNumber, Set<String> srcBillIds) {
        return DataMutexAction.releasePushMutex(srcEntityNumber, srcBillIds);
    }
}

