/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.constants.ReportTypeEnum;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.BeforeDrawArgs;
import kd.bos.entity.botp.runtime.BeforeDrawOpResult;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.botp.runtime.GetTargetOptionalOrgsArgs;
import kd.bos.entity.botp.runtime.GetTargetOptionalOrgsResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.param.CustomParam;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.entity.validate.IValidatorHanlder;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.param.impl.ParameterReaderServiceImpl;
import kd.bos.service.ServiceFactory;
import kd.bos.service.botp.convert.BillAndRule;
import kd.bos.service.botp.convert.CRComparator;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertReportManager;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.SingleRuleResultManager;
import kd.bos.service.botp.convert.actions.AbstractConvertAction;
import kd.bos.service.botp.convert.actions.AttachmentPanelPushAction;
import kd.bos.service.botp.convert.actions.BigDataPushAction;
import kd.bos.service.botp.convert.actions.BuildDrawFilterAction;
import kd.bos.service.botp.convert.actions.BuildDrawLayoutAction;
import kd.bos.service.botp.convert.actions.BuildPushLayoutAction;
import kd.bos.service.botp.convert.actions.BuildQueryParameterAction;
import kd.bos.service.botp.convert.actions.CompileRuleAction;
import kd.bos.service.botp.convert.actions.CreateConvertPlugAction;
import kd.bos.service.botp.convert.actions.CreateDependEntityRowsAction;
import kd.bos.service.botp.convert.actions.CreateLinkEntityRowsAction;
import kd.bos.service.botp.convert.actions.CreateOrgCheckAction;
import kd.bos.service.botp.convert.actions.CreateTargetBillAction;
import kd.bos.service.botp.convert.actions.CreateTargetBillDrawAction;
import kd.bos.service.botp.convert.actions.DataMutexAction;
import kd.bos.service.botp.convert.actions.ExecuteBizRuleAction;
import kd.bos.service.botp.convert.actions.FillLinkInfoAction;
import kd.bos.service.botp.convert.actions.GetTargetOptionalOrgsAction;
import kd.bos.service.botp.convert.actions.GroupSourceRowsAction;
import kd.bos.service.botp.convert.actions.InitializeAction;
import kd.bos.service.botp.convert.actions.LoadDependEntityRowsAction;
import kd.bos.service.botp.convert.actions.LoadFunctionTypesAction;
import kd.bos.service.botp.convert.actions.LoadSourceDataAction;
import kd.bos.service.botp.convert.actions.MappingDependFieldAction;
import kd.bos.service.botp.convert.actions.MappingFieldAction;
import kd.bos.service.botp.convert.actions.MergePushResultAction;
import kd.bos.service.botp.convert.actions.MockSourceDataAction;
import kd.bos.service.botp.convert.actions.PushAgainCheckAction;
import kd.bos.service.botp.convert.actions.RunDataConditionAction;
import kd.bos.service.botp.convert.actions.RunRuleConditionAction;
import kd.bos.service.botp.convert.actions.RunRuleConditionForCountAction;
import kd.bos.service.botp.convert.actions.SortSourceRowsAction;
import kd.bos.service.botp.convert.report.PushReport;
import kd.bos.service.report.regist.ReportRegistService;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class ConvertEngine {
    private static final Log log = LogFactory.getLog((String)"ConvertEngine");
    private static final String BOS_MSERVICE_BOTP = "bos-mservice-botp";
    private static final String CONVERT_ENGINE = "ConvertEngine";
    private String ERROR_NOSOURCE = ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u6e90\u5355\u7c7b\u578b", (String)"ConvertEngine_0", (String)"bos-mservice-botp", (Object[])new Object[0]);
    private String ERROR_NOTARGET = ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u76ee\u6807\u5355\u7c7b\u578b", (String)"ConvertEngine_1", (String)"bos-mservice-botp", (Object[])new Object[0]);
    private String ERROR_NODATA = ResManager.loadKDString((String)"\u672a\u9009\u62e9\u9700\u8981\u4e0b\u63a8\u7684\u6570\u636e", (String)"ConvertEngine_2", (String)"bos-mservice-botp", (Object[])new Object[0]);
    private String ERROR_NORULE = ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u8f6c\u6362\u89c4\u5219", (String)"ConvertEngine_3", (String)"bos-mservice-botp", (Object[])new Object[0]);
    private String ERROR_NOPAGEID = ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u76ee\u6807\u5355PageId", (String)"ConvertEngine_4", (String)"bos-mservice-botp", (Object[])new Object[0]);
    private static final String OP_NAME_PUSH = "push";
    private static final String OP_NAME_DRAW = "draw";
    private String MSG_NOMATCHRULE = ResManager.loadKDString((String)"\u65e0\u5339\u914d\u89c4\u5219", (String)"ConvertEngine_5", (String)"bos-mservice-botp", (Object[])new Object[0]);
    private List<AbstractConvertAction> pushAndSaveActions;
    private List<AbstractConvertAction> pushActions;
    private long startTime = TimeServiceHelper.now().getTime();
    private long taskId = DB.genGlobalLongId();
    private static final String CUSTOM_PARAM_KEY = "checkBaseDataCtrl";

    public ConvertOperationResult pushAndSave(PushArgs args) {
        try (TraceSpan span = Tracer.create((String)CONVERT_ENGINE, (String)"pushAndSave");){
            ConvertOperationResult convertOperationResult = this.doPush(args, true);
            return convertOperationResult;
        }
    }

    public ConvertOperationResult push(PushArgs args) {
        try (TraceSpan span = Tracer.create((String)CONVERT_ENGINE, (String)OP_NAME_PUSH);){
            if (args.isCountUserRule()) {
                ConvertOperationResult convertOperationResult = this.doPushCountUserRule(args);
                return convertOperationResult;
            }
            ConvertOperationResult convertOperationResult = this.doPush(args, false);
            return convertOperationResult;
        }
    }

    public ConvertOperationResult doPushCountUserRule(PushArgs args) {
        ConvertOperationResult result = new ConvertOperationResult();
        result.setSourceEntityNumber(args.getSourceEntityNumber());
        result.setTargetEntityNumber(args.getTargetEntityNumber());
        result.setStartTime(new Date());
        if (args.getSelectedRows() == null || args.getSelectedRows().isEmpty()) {
            result.setSuccess(false);
            result.setMessage(this.ERROR_NODATA);
            this.writeLog(OP_NAME_PUSH, (AbstractConvertServiceArgs)args, result);
            return result;
        }
        if (StringUtils.isBlank((CharSequence)args.getSourceEntityNumber())) {
            result.setSuccess(false);
            result.setMessage(this.ERROR_NOSOURCE);
            this.writeLog(OP_NAME_PUSH, (AbstractConvertServiceArgs)args, result);
            return result;
        }
        if (StringUtils.isBlank((CharSequence)args.getTargetEntityNumber())) {
            result.setSuccess(false);
            result.setMessage(this.ERROR_NOTARGET);
            this.writeLog(OP_NAME_PUSH, (AbstractConvertServiceArgs)args, result);
            return result;
        }
        ConvertContext context = this.createContext((AbstractConvertServiceArgs)args);
        ConvertResultManager resultManager = this.createResultManager();
        this.initPushContext(context, resultManager, args);
        PushReport.setArgsReport(context, resultManager, args, false);
        try {
            for (ConvertRuleElement rule : context.getRules()) {
                if (resultManager.isSkipNextRule()) continue;
                SingleRuleContext ruleContext = this.createRuleContext(context, rule);
                ruleContext.setCreateReport(PushReport.getIsCreateReport(ruleContext));
                ruleContext.setAutoSave(false);
                List<AbstractConvertAction> runAction = null;
                runAction = this.createPushForCountActions(context, resultManager);
                SingleRuleResultManager ruleResultManager = this.createRuleResultManager(resultManager);
                for (AbstractConvertAction action : runAction) {
                    action.setRuleContext(ruleContext);
                    action.setRuleResultManager(ruleResultManager);
                    action.action();
                }
            }
            result.setBillUseRuleMap(resultManager.getBillUseRuleMap());
        }
        catch (KDBizException exp) {
            result.setSuccess(false);
            result.setMessage(exp.getMessage());
            log.warn((Throwable)exp);
        }
        catch (ArithmeticException exp) {
            if (StringUtils.equals((CharSequence)"BigInteger divide by zero", (CharSequence)exp.getMessage())) {
                result.setSuccess(false);
                result.setMessage(ResManager.loadKDString((String)"\u516c\u5f0f\u914d\u7f6e\u4e2d\u9664\u6570\u4e0d\u80fd\u4e3a0", (String)"ConvertEngine_14", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
            }
            log.warn((Throwable)exp);
        }
        catch (Throwable exp) {
            result.setSuccess(false);
            result.setMessage(String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u9047\u5230\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u901a\u77e5\u6280\u672f\u652f\u6301\u8ffd\u67e5\u540e\u53f0\u65e5\u5fd7\uff0ctrackid: %s", (String)"ConvertEngine_7", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), RequestContext.get().getTraceId()));
            log.error(exp);
            throw exp;
        }
        result.setFinishedTime(new Date());
        return result;
    }

    private ConvertOperationResult doPush(PushArgs args, boolean autoSave) {
        ConvertOperationResult result = new ConvertOperationResult();
        result.setSourceEntityNumber(args.getSourceEntityNumber());
        result.setTargetEntityNumber(args.getTargetEntityNumber());
        result.setStartTime(new Date());
        if (args.getSelectedRows() == null || args.getSelectedRows().isEmpty()) {
            result.setSuccess(false);
            result.setMessage(this.ERROR_NODATA);
            this.writeLog(OP_NAME_PUSH, (AbstractConvertServiceArgs)args, result);
            return result;
        }
        if (StringUtils.isBlank((CharSequence)args.getSourceEntityNumber())) {
            result.setSuccess(false);
            result.setMessage(this.ERROR_NOSOURCE);
            this.writeLog(OP_NAME_PUSH, (AbstractConvertServiceArgs)args, result);
            return result;
        }
        if (StringUtils.isBlank((CharSequence)args.getTargetEntityNumber())) {
            result.setSuccess(false);
            result.setMessage(this.ERROR_NOTARGET);
            this.writeLog(OP_NAME_PUSH, (AbstractConvertServiceArgs)args, result);
            return result;
        }
        ConvertContext context = this.createContext((AbstractConvertServiceArgs)args);
        ConvertResultManager resultManager = this.createResultManager();
        this.initPushContext(context, resultManager, args);
        PushReport.setArgsReport(context, resultManager, args, autoSave);
        try {
            for (ConvertRuleElement rule : context.getRules()) {
                if (resultManager.isSkipNextRule()) continue;
                boolean save = autoSave || args.isAutoSave() && rule.isAutoSave();
                SingleRuleContext ruleContext = this.createRuleContext(context, rule);
                ruleContext.setCreateReport(PushReport.getIsCreateReport(ruleContext));
                ruleContext.setAutoSave(save);
                List<AbstractConvertAction> runAction = null;
                runAction = save ? this.createPushAndSaveActions(context, resultManager) : this.createPushActions(context, resultManager);
                SingleRuleResultManager ruleResultManager = this.createRuleResultManager(resultManager);
                for (AbstractConvertAction action : runAction) {
                    action.setRuleContext(ruleContext);
                    action.setRuleResultManager(ruleResultManager);
                    action.action();
                }
                PushReport.collectPlufinInfo(resultManager, ruleContext, rule, context);
                PushReport.createReportAutoSave(ruleContext, rule, resultManager, context);
            }
            this.exportPushResult(context, resultManager, result);
        }
        catch (KDBizException exp) {
            result.setSuccess(false);
            result.setMessage(exp.getMessage());
            log.warn((Throwable)exp);
        }
        catch (ArithmeticException exp) {
            if (StringUtils.equals((CharSequence)"BigInteger divide by zero", (CharSequence)exp.getMessage())) {
                result.setSuccess(false);
                result.setMessage(ResManager.loadKDString((String)"\u516c\u5f0f\u914d\u7f6e\u4e2d\u9664\u6570\u4e0d\u80fd\u4e3a0", (String)"ConvertEngine_14", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
            }
            log.warn((Throwable)exp);
        }
        catch (Throwable exp) {
            result.setSuccess(false);
            result.setMessage(String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u9047\u5230\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u901a\u77e5\u6280\u672f\u652f\u6301\u8ffd\u67e5\u540e\u53f0\u65e5\u5fd7\uff0ctrackid: %s", (String)"ConvertEngine_7", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), RequestContext.get().getTraceId()));
            log.error(exp);
            throw exp;
        }
        finally {
            resultManager.getLogger().completeConvertHistory(context, result.getTargetBillIds(), result.isSuccess());
            this.writeLog(OP_NAME_PUSH, (AbstractConvertServiceArgs)args, result);
        }
        if (result.getCachePageIds().isEmpty()) {
            StringBuilder errMsg = new StringBuilder();
            this.releaseDataMutex(context.getSourceMainType().getName(), resultManager.getDataMutexSrcBillIds(), errMsg);
        } else {
            result.getDataMutexSrcBillIds().addAll(resultManager.getDataMutexSrcBillIds());
        }
        result.setFinishedTime(new Date());
        return result;
    }

    public ConvertOperationResult beforeDraw(BeforeDrawArgs args) {
        try (TraceSpan span = Tracer.create((String)CONVERT_ENGINE, (String)"beforeDraw");){
            ConvertOperationResult convertOperationResult = this.doBeforeDraw(args);
            return convertOperationResult;
        }
    }

    private ConvertOperationResult doBeforeDraw(BeforeDrawArgs args) {
        BeforeDrawOpResult result = new BeforeDrawOpResult();
        result.setSourceEntityNumber(args.getSourceEntityNumber());
        result.setTargetEntityNumber(args.getTargetEntityNumber());
        if (StringUtils.isBlank((CharSequence)args.getSourceEntityNumber())) {
            result.setSuccess(false);
            result.setMessage(this.ERROR_NOSOURCE);
            return result;
        }
        if (StringUtils.isBlank((CharSequence)args.getTargetEntityNumber())) {
            result.setSuccess(false);
            result.setMessage(this.ERROR_NOTARGET);
            return result;
        }
        if (StringUtils.isBlank((CharSequence)args.getRuleId())) {
            result.setSuccess(false);
            result.setMessage(this.ERROR_NORULE);
            return result;
        }
        if (StringUtils.isBlank((CharSequence)args.getTargetPageId())) {
            result.setSuccess(false);
            result.setMessage(this.ERROR_NOPAGEID);
            return result;
        }
        ConvertContext context = this.createContext((AbstractConvertServiceArgs)args);
        ConvertResultManager resultManager = this.createResultManager();
        this.initBeforeDrawContext(context);
        List<AbstractConvertAction> actions = this.createBeforeDrawActions(context, resultManager);
        try {
            SingleRuleContext ruleContext = this.createRuleContext(context, context.getRules().get(0));
            SingleRuleResultManager ruleResultManager = this.createRuleResultManager(resultManager);
            for (AbstractConvertAction action : actions) {
                action.setRuleContext(ruleContext);
                action.setRuleResultManager(ruleResultManager);
                action.action();
            }
            this.exportBeforeDrawResult(resultManager, result);
        }
        catch (KDBizException exp) {
            result.setSuccess(false);
            result.setMessage(exp.getMessage());
            log.warn((Throwable)exp);
        }
        catch (Throwable exp) {
            log.error(exp);
            throw exp;
        }
        return result;
    }

    public ConvertOperationResult draw(DrawArgs args) {
        try (TraceSpan span = Tracer.create((String)CONVERT_ENGINE, (String)OP_NAME_DRAW);){
            ConvertOperationResult convertOperationResult = this.doDraw(args);
            return convertOperationResult;
        }
    }

    private ConvertOperationResult doDraw(DrawArgs args) {
        ConvertOperationResult result = new ConvertOperationResult();
        result.setSourceEntityNumber(args.getSourceEntityNumber());
        result.setTargetEntityNumber(args.getTargetEntityNumber());
        if (args.getSelectedRows() == null || args.getSelectedRows().isEmpty()) {
            result.setSuccess(false);
            result.setMessage(this.ERROR_NODATA);
            return result;
        }
        if (StringUtils.isBlank((CharSequence)args.getSourceEntityNumber())) {
            result.setSuccess(false);
            result.setMessage(this.ERROR_NOSOURCE);
            return result;
        }
        if (StringUtils.isBlank((CharSequence)args.getTargetEntityNumber())) {
            result.setSuccess(false);
            result.setMessage(this.ERROR_NOTARGET);
            return result;
        }
        if (StringUtils.isBlank((CharSequence)args.getRuleId())) {
            result.setSuccess(false);
            result.setMessage(this.ERROR_NORULE);
            return result;
        }
        if (StringUtils.isBlank((CharSequence)args.getTargetPageId())) {
            result.setSuccess(false);
            result.setMessage(this.ERROR_NOPAGEID);
            return result;
        }
        ConvertContext context = this.createContext((AbstractConvertServiceArgs)args);
        ConvertResultManager resultManager = this.createResultManager();
        this.initDrawContext(context, resultManager, args);
        List<AbstractConvertAction> actions = this.createDrawActions(context, resultManager);
        try {
            SingleRuleContext ruleContext = this.createRuleContext(context, context.getRules().get(0));
            SingleRuleResultManager ruleResultManager = this.createRuleResultManager(resultManager);
            for (AbstractConvertAction action : actions) {
                action.setRuleContext(ruleContext);
                action.setRuleResultManager(ruleResultManager);
                action.action();
            }
            this.exportDrawResult(context, resultManager, result);
        }
        catch (KDBizException exp) {
            result.setSuccess(false);
            result.setMessage(exp.getMessage());
            log.warn((Throwable)exp);
        }
        catch (Throwable exp) {
            log.error(exp);
            throw exp;
        }
        finally {
            resultManager.getLogger().completeConvertHistory(context, result.getTargetBillIds(), result.isSuccess());
            this.writeLog(OP_NAME_DRAW, (AbstractConvertServiceArgs)args, result);
        }
        if (result.getCachePageIds().isEmpty()) {
            StringBuilder errMsg = new StringBuilder();
            this.releaseDataMutex(context.getSourceMainType().getName(), resultManager.getDataMutexSrcBillIds(), errMsg);
        } else {
            result.getDataMutexSrcBillIds().addAll(resultManager.getDataMutexSrcBillIds());
        }
        return result;
    }

    public GetTargetOptionalOrgsResult getTargetOptionalOrgs(GetTargetOptionalOrgsArgs args) {
        GetTargetOptionalOrgsResult result = new GetTargetOptionalOrgsResult();
        if (args.getSelectedRows() == null || args.getSelectedRows().isEmpty()) {
            result.setSuccess(false);
            result.setMessage(this.ERROR_NODATA);
            return result;
        }
        if (StringUtils.isBlank((CharSequence)args.getSourceEntityNumber())) {
            result.setSuccess(false);
            result.setMessage(this.ERROR_NOSOURCE);
            return result;
        }
        if (StringUtils.isBlank((CharSequence)args.getTargetEntityNumber())) {
            result.setSuccess(false);
            result.setMessage(this.ERROR_NOTARGET);
            return result;
        }
        ConvertContext context = this.createContext((AbstractConvertServiceArgs)args);
        ConvertResultManager resultManager = this.createResultManager();
        resultManager.setOptionalOrgs(result);
        this.initPushContext(context, resultManager, (PushArgs)args);
        List<AbstractConvertAction> actions = this.createGetTargetOrgsActions(context, resultManager);
        try {
            for (ConvertRuleElement rule : context.getRules()) {
                if (resultManager.isSkipNextRule()) continue;
                SingleRuleContext ruleContext = this.createRuleContext(context, rule);
                SingleRuleResultManager ruleResultManager = this.createRuleResultManager(resultManager);
                for (AbstractConvertAction action : actions) {
                    action.setRuleContext(ruleContext);
                    action.setRuleResultManager(ruleResultManager);
                    action.action();
                }
            }
        }
        catch (KDBizException exp) {
            result.setSuccess(false);
            result.setMessage(exp.getMessage());
            log.warn((Throwable)exp);
        }
        catch (ArithmeticException exp) {
            if (StringUtils.equals((CharSequence)"BigInteger divide by zero", (CharSequence)exp.getMessage())) {
                result.setSuccess(false);
                result.setMessage(ResManager.loadKDString((String)"\u516c\u5f0f\u914d\u7f6e\u4e2d\u9664\u6570\u4e0d\u80fd\u4e3a0", (String)"ConvertEngine_14", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
            }
            log.warn((Throwable)exp);
        }
        catch (Throwable exp) {
            log.error(exp);
            throw exp;
        }
        return result;
    }

    public List<ConvertRuleElement> checkRunRuleCondition(PushArgs args) {
        ArrayList<ConvertRuleElement> result = new ArrayList<ConvertRuleElement>();
        if (args.getSelectedRows() == null || args.getSelectedRows().isEmpty()) {
            return result;
        }
        if (StringUtils.isBlank((CharSequence)args.getSourceEntityNumber())) {
            return result;
        }
        if (StringUtils.isBlank((CharSequence)args.getTargetEntityNumber())) {
            return result;
        }
        ConvertContext context = this.createContext((AbstractConvertServiceArgs)args);
        try {
            for (ConvertRuleElement rule : context.getRules()) {
                ConvertResultManager resultManager = this.createResultManager();
                this.initPushContext(context, resultManager, args);
                resultManager.getReporter().getBillReports().clear();
                SingleRuleContext ruleContext = this.createRuleContext(context, rule);
                SingleRuleResultManager ruleResultManager = this.createRuleResultManager(resultManager);
                List<AbstractConvertAction> actions = this.createCheckRuleAction(context, resultManager);
                for (AbstractConvertAction action : actions) {
                    action.setRuleContext(ruleContext);
                    action.setRuleResultManager(ruleResultManager);
                    action.action();
                }
                Set bills = args.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
                if (resultManager.getReporter().getBillReports().size() != bills.size()) continue;
                result.add(rule);
            }
        }
        catch (KDBizException exp) {
            log.warn((Throwable)exp);
        }
        catch (ArithmeticException exp) {
            log.warn((Throwable)exp);
        }
        catch (Throwable exp) {
            log.error(exp);
            throw exp;
        }
        return result;
    }

    private ConvertContext createContext(AbstractConvertServiceArgs args) {
        ConvertContext context = new ConvertContext();
        context.setInputArgs(args);
        BillEntityType srcMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)args.getSourceEntityNumber());
        BillEntityType tgtMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)args.getTargetEntityNumber());
        context.setSourceMainType(srcMainType);
        context.setTargetMainType(tgtMainType);
        context.setTaskId(this.taskId);
        context.setBaseDataCtrl(BaseDataServiceHelper.checkBaseDataCtrl((String)tgtMainType.getName()));
        context.setParamCheckBaseDataCtrl(this.getParamCheckBaseDataCtr());
        if (context.isBaseDataCtrl()) {
            List list = BaseDataServiceHelper.getCreateOrgList((String)tgtMainType.getName(), (String)tgtMainType.getAppId());
            context.setTargetCreateOrgList(list);
        }
        List<ConvertRuleElement> rules = this.loadRules(context);
        if (args instanceof PushArgs && !((PushArgs)args).getRuleIds().isEmpty()) {
            for (ConvertRuleElement convertRuleElement : rules) {
                if (!((PushArgs)args).getRuleIds().contains(convertRuleElement.getId())) continue;
                context.getRules().add(convertRuleElement);
            }
        } else {
            context.getRules().addAll(rules);
        }
        if (args.getCustomParams() != null) {
            for (Map.Entry entry : args.getCustomParams().entrySet()) {
                context.getOption().setVariableValue((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return context;
    }

    private boolean getParamCheckBaseDataCtr() {
        boolean checkParamFlag = true;
        ParameterReaderServiceImpl service = new ParameterReaderServiceImpl();
        HashSet<String> set = new HashSet<String>(1);
        set.add(CUSTOM_PARAM_KEY);
        CustomParam customParam = new CustomParam(set);
        Map map = service.loadCustomParameterFromCache(customParam);
        if (map != null && map.get(CUSTOM_PARAM_KEY) != null) {
            checkParamFlag = Boolean.parseBoolean((String)map.get(CUSTOM_PARAM_KEY));
        }
        return checkParamFlag;
    }

    private void initPushContext(ConvertContext context, ConvertResultManager resultManager, PushArgs args) {
        resultManager.getReporter().initBillAndRules(args.getSelectedRows());
        context.setConvertOpType(ConvertOpType.Push);
        context.setCreateReport(ReportRegistService.getMoudleStatus((String)ReportTypeEnum.push.name()));
    }

    private void initBeforeDrawContext(ConvertContext context) {
        context.setConvertOpType(ConvertOpType.BeforeDraw);
    }

    private void initDrawContext(ConvertContext context, ConvertResultManager resultManager, DrawArgs args) {
        resultManager.getReporter().initBillAndRules(args.getSelectedRows());
        context.setConvertOpType(ConvertOpType.Draw);
    }

    private SingleRuleContext createRuleContext(ConvertContext context, ConvertRuleElement rule) {
        SingleRuleContext ruleContext = new SingleRuleContext();
        ruleContext.setContext(context);
        ruleContext.setRule(rule);
        return ruleContext;
    }

    private List<ConvertRuleElement> loadRules(ConvertContext context) {
        if (StringUtils.isNotBlank((CharSequence)context.getInputArgs().getRuleId())) {
            ConvertRuleElement rule = ConvertRuleCache.loadRule((String)context.getInputArgs().getRuleId());
            if (rule == null) {
                return new ArrayList<ConvertRuleElement>();
            }
            if (!rule.isNormual()) {
                return new ArrayList<ConvertRuleElement>();
            }
            ArrayList<ConvertRuleElement> rules = new ArrayList<ConvertRuleElement>();
            rules.add(rule);
            return rules;
        }
        String sourceEntityNumber = context.getInputArgs().getSourceEntityNumber();
        String targetEntityNumber = context.getInputArgs().getTargetEntityNumber();
        List rules = ConvertRuleCache.loadRules((String)sourceEntityNumber, (String)targetEntityNumber);
        ArrayList<ConvertRuleElement> enableRules = new ArrayList<ConvertRuleElement>();
        for (ConvertRuleElement rule : rules) {
            if (!rule.isNormual() || !rule.isVisibled()) continue;
            enableRules.add(rule);
        }
        enableRules.sort(new CRComparator());
        return enableRules;
    }

    private ConvertResultManager createResultManager() {
        return new ConvertResultManager();
    }

    private SingleRuleResultManager createRuleResultManager(ConvertResultManager resultManager) {
        SingleRuleResultManager ruleResultManager = new SingleRuleResultManager();
        ruleResultManager.setConvertResultManager(resultManager);
        return ruleResultManager;
    }

    private List<AbstractConvertAction> createPushAndSaveActions(ConvertContext context, ConvertResultManager resultManager) {
        if (this.pushAndSaveActions == null) {
            this.pushAndSaveActions = new ArrayList<AbstractConvertAction>();
            this.pushAndSaveActions.add(new CreateConvertPlugAction(context, resultManager));
            this.pushAndSaveActions.add(new LoadFunctionTypesAction(context, resultManager));
            this.pushAndSaveActions.add(new InitializeAction(context, resultManager));
            this.pushAndSaveActions.add(new RunRuleConditionAction(context, resultManager));
            this.pushAndSaveActions.add(new DataMutexAction(context, resultManager));
            this.pushAndSaveActions.add(new PushAgainCheckAction(context, resultManager));
            this.pushAndSaveActions.add(new CompileRuleAction(context, resultManager));
            this.pushAndSaveActions.add(new BuildQueryParameterAction(context, resultManager));
            this.pushAndSaveActions.add(new BigDataPushAction(context, resultManager));
        }
        return this.pushAndSaveActions;
    }

    private List<AbstractConvertAction> createPushActions(ConvertContext context, ConvertResultManager resultManager) {
        if (this.pushActions == null) {
            this.pushActions = new ArrayList<AbstractConvertAction>(32);
            this.pushActions.add(new CreateConvertPlugAction(context, resultManager));
            this.pushActions.add(new LoadFunctionTypesAction(context, resultManager));
            this.pushActions.add(new InitializeAction(context, resultManager));
            this.pushActions.add(new RunRuleConditionAction(context, resultManager));
            this.pushActions.add(new DataMutexAction(context, resultManager));
            this.pushActions.add(new PushAgainCheckAction(context, resultManager));
            this.pushActions.add(new CompileRuleAction(context, resultManager));
            this.pushActions.add(new BuildQueryParameterAction(context, resultManager));
            this.pushActions.add(new MockSourceDataAction(context, resultManager));
            this.pushActions.add(new LoadSourceDataAction(context, resultManager));
            this.pushActions.add(new LoadDependEntityRowsAction(context, resultManager));
            this.pushActions.add(new RunDataConditionAction(context, resultManager));
            this.pushActions.add(new SortSourceRowsAction(context, resultManager));
            this.pushActions.add(new GroupSourceRowsAction(context, resultManager));
            this.pushActions.add(new CreateTargetBillAction(context, resultManager));
            this.pushActions.add(new CreateLinkEntityRowsAction(context, resultManager));
            this.pushActions.add(new CreateDependEntityRowsAction(context, resultManager));
            this.pushActions.add(new MappingDependFieldAction(context, resultManager));
            this.pushActions.add(new MappingFieldAction(context, resultManager));
            this.pushActions.add(new CreateOrgCheckAction(context, resultManager));
            this.pushActions.add(new FillLinkInfoAction(context, resultManager));
            this.pushActions.add(new ExecuteBizRuleAction(context, resultManager));
            this.pushActions.add(new BuildPushLayoutAction(context, resultManager));
            this.pushActions.add(new AttachmentPanelPushAction(context, resultManager));
            this.pushActions.add(new MergePushResultAction(context, resultManager));
        }
        return this.pushActions;
    }

    private List<AbstractConvertAction> createPushForCountActions(ConvertContext context, ConvertResultManager resultManager) {
        if (this.pushActions == null) {
            this.pushActions = new ArrayList<AbstractConvertAction>(32);
            this.pushActions.add(new CreateConvertPlugAction(context, resultManager));
            this.pushActions.add(new LoadFunctionTypesAction(context, resultManager));
            this.pushActions.add(new InitializeAction(context, resultManager));
            this.pushActions.add(new RunRuleConditionForCountAction(context, resultManager));
        }
        return this.pushActions;
    }

    private List<AbstractConvertAction> createBeforeDrawActions(ConvertContext context, ConvertResultManager resultManager) {
        ArrayList<AbstractConvertAction> actions = new ArrayList<AbstractConvertAction>(10);
        actions.add(new CreateConvertPlugAction(context, resultManager));
        actions.add(new InitializeAction(context, resultManager));
        actions.add(new BuildDrawLayoutAction(context, resultManager));
        actions.add(new BuildDrawFilterAction(context, resultManager));
        return actions;
    }

    private List<AbstractConvertAction> createDrawActions(ConvertContext context, ConvertResultManager resultManager) {
        ArrayList<AbstractConvertAction> actions = new ArrayList<AbstractConvertAction>(24);
        actions.add(new CreateConvertPlugAction(context, resultManager));
        actions.add(new LoadFunctionTypesAction(context, resultManager));
        actions.add(new InitializeAction(context, resultManager));
        actions.add(new RunRuleConditionAction(context, resultManager));
        actions.add(new DataMutexAction(context, resultManager));
        actions.add(new CompileRuleAction(context, resultManager));
        actions.add(new BuildQueryParameterAction(context, resultManager));
        actions.add(new LoadSourceDataAction(context, resultManager));
        actions.add(new LoadDependEntityRowsAction(context, resultManager));
        actions.add(new RunDataConditionAction(context, resultManager));
        actions.add(new SortSourceRowsAction(context, resultManager));
        actions.add(new GroupSourceRowsAction(context, resultManager));
        actions.add(new CreateTargetBillDrawAction(context, resultManager));
        actions.add(new CreateLinkEntityRowsAction(context, resultManager));
        actions.add(new CreateDependEntityRowsAction(context, resultManager));
        actions.add(new MappingDependFieldAction(context, resultManager));
        actions.add(new MappingFieldAction(context, resultManager));
        actions.add(new FillLinkInfoAction(context, resultManager));
        actions.add(new ExecuteBizRuleAction(context, resultManager));
        actions.add(new AttachmentPanelPushAction(context, resultManager));
        actions.add(new MergePushResultAction(context, resultManager));
        return actions;
    }

    private List<AbstractConvertAction> createGetTargetOrgsActions(ConvertContext context, ConvertResultManager resultManager) {
        ArrayList<AbstractConvertAction> actions = new ArrayList<AbstractConvertAction>(10);
        actions.add(new CreateConvertPlugAction(context, resultManager));
        actions.add(new LoadFunctionTypesAction(context, resultManager));
        actions.add(new InitializeAction(context, resultManager));
        actions.add(new RunRuleConditionAction(context, resultManager));
        actions.add(new CompileRuleAction(context, resultManager));
        actions.add(new GetTargetOptionalOrgsAction(context, resultManager));
        return actions;
    }

    private List<AbstractConvertAction> createCheckRuleAction(ConvertContext context, ConvertResultManager resultManager) {
        ArrayList<AbstractConvertAction> actions = new ArrayList<AbstractConvertAction>(10);
        actions.add(new CreateConvertPlugAction(context, resultManager));
        actions.add(new LoadFunctionTypesAction(context, resultManager));
        actions.add(new InitializeAction(context, resultManager));
        actions.add(new RunRuleConditionAction(context, resultManager));
        return actions;
    }

    private void exportPushResult(ConvertContext context, ConvertResultManager resultManager, ConvertOperationResult operationResult) {
        this.updateConvertReport(resultManager.getReporter(), operationResult);
        List<DynamicObject> targetDataObjects = resultManager.getTargetDataObjects();
        if (!targetDataObjects.isEmpty()) {
            this.genTargetBillIds((MainEntityType)context.getTargetMainType(), targetDataObjects);
            operationResult.addTargetDataObjects((objs, dt) -> BusinessDataReader.loadRefence((Object[])objs, (IDataEntityType)dt), (MainEntityType)context.getTargetMainType(), targetDataObjects);
            operationResult.setSuccess(true);
            PushReport.createReportNoAutoSave(context, resultManager);
            resultManager.getLogger().updateConvertTargetInfo(context, resultManager.getExtendedDataEntities());
            this.exportPushAttachmentInfosForNotAutoSave(resultManager, operationResult);
        }
        if (!resultManager.getTargetBillIds().isEmpty()) {
            HashSet<Object> billIds = new HashSet<Object>(resultManager.getTargetBillIds());
            operationResult.getTargetBillIds().addAll(billIds);
            operationResult.setSuccess(true);
        }
        if (operationResult.getTargetBillIds().isEmpty() && operationResult.getCachePageIds().isEmpty()) {
            operationResult.setSuccess(false);
        }
        operationResult.setTargetBillFormId(resultManager.getTargetBillFormId());
        operationResult.setTargetMobFormId(resultManager.getTargetBillMobFormId());
        this.exportPushAttachmentInfos(resultManager, operationResult);
    }

    private void exportPushAttachmentInfos(ConvertResultManager resultManager, ConvertOperationResult operationResult) {
        if (resultManager.getBillAttachmentPanelInfos() == null || resultManager.getBillAttachmentPanelInfos().isEmpty()) {
            return;
        }
        operationResult.getBillAttachmentPanelInfos().putAll(resultManager.getBillAttachmentPanelInfos());
    }

    private void exportPushAttachmentInfosForNotAutoSave(ConvertResultManager resultManager, ConvertOperationResult operationResult) {
        ExtendedDataEntity[] headObjs = resultManager.getExtendedDataEntities();
        if (headObjs == null) {
            return;
        }
        for (int i = 0; i < headObjs.length; ++i) {
            ExtendedDataEntity extDataEntity = headObjs[i];
            Map attachInfoMap = (Map)extDataEntity.getValue("botp_source_attachmentpanel_infos");
            if (attachInfoMap == null || attachInfoMap.isEmpty()) continue;
            operationResult.getBillAttachmentPanelInfos().put(extDataEntity.getBillPkId(), attachInfoMap);
        }
        resultManager.setExtendedDataEntities(new ExtendedDataEntity[0]);
    }

    private void genTargetBillIds(MainEntityType mainType, List<DynamicObject> billObjs) {
        ISimpleProperty pkProp = mainType.getPrimaryKey();
        for (DynamicObject billObj : billObjs) {
            Object pkValue = billObj.getPkValue();
            if (!((IValidatorHanlder)pkProp).getValueComparator().compareValue(pkValue)) continue;
            if (pkProp instanceof LongProp) {
                pkValue = DBServiceHelper.genGlobalLongId();
            } else if (pkProp instanceof VarcharProp) {
                pkValue = DBServiceHelper.genStringId();
            }
            pkProp.setValue((Object)billObj, pkValue);
        }
    }

    private void exportBeforeDrawResult(ConvertResultManager resultManager, BeforeDrawOpResult operationResult) {
        String drawFilter = resultManager.getDrawFilter();
        operationResult.setDrawFilter(drawFilter);
        operationResult.getDrawSelectedEntity().addAll(resultManager.getDrawSelectedEntity());
        operationResult.setDrawSourceLayout(resultManager.getDrawSourceLayout());
        operationResult.setMobDrawSourceLayout(resultManager.getMobDrawSourceLayout());
        operationResult.setSrcMainOrgId(resultManager.getSrcMainOrgId());
        operationResult.setSuccess(true);
        ConvertReportManager reportManager = resultManager.getReporter();
        for (BillAndRule bill : reportManager.getBillAndRules()) {
            if (!StringUtils.isBlank((CharSequence)bill.getRuleId())) continue;
            reportManager.failBill(bill.getBillId(), this.MSG_NOMATCHRULE);
        }
        if (!reportManager.getBillReports().isEmpty()) {
            for (SourceBillReport billReport : reportManager.getBillReports()) {
                billReport.copyReportToList();
                operationResult.getBillReports().add(billReport);
            }
            operationResult.setSuccess(false);
        }
    }

    private void exportDrawResult(ConvertContext context, ConvertResultManager resultManager, ConvertOperationResult operationResult) {
        this.updateConvertReport(resultManager.getReporter(), operationResult);
        List<DynamicObject> targetDataObjects = resultManager.getTargetDataObjects();
        if (!targetDataObjects.isEmpty()) {
            operationResult.addTargetDataObjects((objs, dt) -> BusinessDataReader.loadRefence((Object[])objs, (IDataEntityType)dt), (MainEntityType)context.getTargetMainType(), targetDataObjects);
            operationResult.setSuccess(true);
        } else {
            operationResult.setSuccess(false);
        }
        resultManager.getLogger().updateConvertTargetInfo(context, resultManager.getExtendedDataEntities());
        this.exportPushAttachmentInfosForNotAutoSave(resultManager, operationResult);
    }

    private void updateConvertReport(ConvertReportManager reportManager, ConvertOperationResult operationResult) {
        boolean hasMatchRule = false;
        for (BillAndRule bill : reportManager.getBillAndRules()) {
            if (StringUtils.isBlank((CharSequence)bill.getRuleId())) {
                reportManager.failBill(bill.getBillId(), this.MSG_NOMATCHRULE);
                continue;
            }
            hasMatchRule = true;
        }
        if (!hasMatchRule) {
            operationResult.setSuccess(false);
            operationResult.setMessage(this.MSG_NOMATCHRULE);
        } else if (!reportManager.getBreakMessages().isEmpty()) {
            operationResult.setSuccess(false);
            operationResult.setMessage(reportManager.getBreakMessages().entrySet().iterator().next().getValue());
        }
        for (SourceBillReport billReport : reportManager.getBillReports()) {
            billReport.copyReportToList();
            operationResult.getBillReports().add(billReport);
        }
        if (operationResult.getBillReports().size() > 200) {
            int size = operationResult.getBillReports().size();
            for (int i = 200; i < size; ++i) {
                SourceBillReport billReport = (SourceBillReport)operationResult.getBillReports().get(i);
                billReport.getLinkEntityRowReports().clear();
                billReport.getDependEntityRowReports().clear();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean releaseDataMutex(String srcEntityNumber, Set<String> srcBillIds, StringBuilder errMsg) {
        if (srcBillIds.isEmpty()) {
            return true;
        }
        ArrayList mutexRequireList = new ArrayList(10);
        for (String billId : srcBillIds) {
            HashMap<String, String> requireParam = new HashMap<String, String>(16);
            requireParam.put("dataObjId", billId);
            requireParam.put("groupId", "default_netctrl");
            requireParam.put("entityKey", srcEntityNumber);
            requireParam.put("operationKey", "botp_convert");
            mutexRequireList.add(requireParam);
        }
        try (DataMutex dataMutex = DataMutex.create();){
            dataMutex.batchRelease(mutexRequireList);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            errMsg.append(ResManager.loadKDString((String)"\u91ca\u653e\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u51fa\u9519: ", (String)"ConvertEngine_19", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0])).append(e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeLog(String serviceName, AbstractConvertServiceArgs args, ConvertOperationResult convertResult) {
        void var9_15;
        boolean success;
        if (StringUtils.isBlank((CharSequence)serviceName) || args == null || convertResult == null || StringUtils.isBlank((CharSequence)args.getSourceEntityNumber()) || StringUtils.isBlank((CharSequence)args.getTargetEntityNumber())) {
            return;
        }
        int count = 5;
        StringBuilder sb = new StringBuilder();
        sb.append("ConvertEngine.").append(serviceName).append("(");
        sb.append(args.getSourceEntityNumber()).append("->");
        sb.append(args.getTargetEntityNumber()).append(",");
        sb.append("ruleId:").append(args.getRuleId());
        if (args instanceof PushArgs && ((PushArgs)args).getSelectedRows() != null) {
            HashSet<Object> pkIds = new HashSet<Object>(((PushArgs)args).getSelectedRows().size());
            for (Object row : ((PushArgs)args).getSelectedRows()) {
                pkIds.add(row.getPrimaryKeyValue());
            }
            sb.append(",ids:[");
            int i = 0;
            for (Object e : pkIds) {
                if (i >= count) break;
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(String.valueOf(e));
                ++i;
            }
            if (pkIds.size() > count) {
                sb.append(", total ").append(String.valueOf(pkIds.size())).append(" bills");
            }
            sb.append("]");
        }
        sb.append(") \r\n");
        sb.append("Cost ").append(TimeServiceHelper.now().getTime() - this.startTime).append(" ms,");
        int successCount = convertResult.getCachePageIds().size() + convertResult.getTargetBillIds().size();
        boolean bl = success = successCount > 0;
        if (success) {
            sb.append(" success = true, build ").append(successCount).append(" bills \r\n");
        } else {
            sb.append(" success = false, message : ").append(convertResult.getMessage()).append(" \r\n");
        }
        ArrayList<AppLogInfo> appLogInfoList = null;
        String string = "";
        String objectType = convertResult.getSourceEntityNumber();
        String opName = serviceName;
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4e0b\u63a8", "ConvertEngine_6", BOS_MSERVICE_BOTP);
        if (StringUtils.equals((CharSequence)serviceName, (CharSequence)OP_NAME_PUSH)) {
            String string2 = this.getAppId(convertResult.getSourceEntityNumber());
            objectType = convertResult.getSourceEntityNumber();
            opName = String.format("%s-%s", ResManager.loadKDString((String)"\u4e0b\u63a8", (String)"ConvertEngine_6", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.getEntityName(convertResult.getTargetEntityNumber()));
        } else if (StringUtils.equals((CharSequence)serviceName, (CharSequence)OP_NAME_DRAW)) {
            String string3 = this.getAppId(convertResult.getTargetEntityNumber());
            objectType = convertResult.getTargetEntityNumber();
            opName = String.format("%s-%s", ResManager.loadKDString((String)"\u9009\u5355", (String)"ConvertEngine_8", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.getEntityName(convertResult.getSourceEntityNumber()));
            opNameBridge = new MultiLangEnumBridge("\u9009\u5355", "ConvertEngine_8", BOS_MSERVICE_BOTP);
        }
        if (convertResult.getBillReports().isEmpty()) {
            appLogInfoList = new ArrayList<AppLogInfo>(1);
            AppLogInfo logInfo = this.buildOpLogAppInfo((String)var9_15, objectType, opName, 0L, convertResult.getMessage(), serviceName, opNameBridge);
            appLogInfoList.add(logInfo);
        } else {
            appLogInfoList = new ArrayList(convertResult.getBillReports().size());
            int i = 0;
            for (SourceBillReport billReport : convertResult.getBillReports()) {
                String opDesc = this.buildOpDescription(success, billReport);
                if (opDesc != null) {
                    AppLogInfo logInfo = this.buildOpLogAppInfo((String)var9_15, objectType, opName, 0L, opDesc, serviceName, opNameBridge);
                    appLogInfoList.add(logInfo);
                }
                if (i <= 30) {
                    sb.append(billReport.toString()).append("; ").append("ruleid:").append(billReport.getRuleId()).append(" \r\n");
                }
                ++i;
            }
            if (appLogInfoList.isEmpty()) {
                AppLogInfo logInfo = this.buildOpLogAppInfo((String)var9_15, objectType, opName, 0L, convertResult.getMessage(), serviceName, opNameBridge);
                appLogInfoList.add(logInfo);
            }
        }
        if (!appLogInfoList.isEmpty()) {
            ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
            logService.addBatchLog(appLogInfoList);
        }
        log.info(sb.toString());
    }

    @Deprecated
    protected AppLogInfo buildLogInfo(String appId, String entityNumber, String opName, Long orgId, String msg) {
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        logInfo.setBizAppID(appId);
        logInfo.setBizObjID(entityNumber);
        if (orgId != null && Long.compare(0L, orgId) != 0) {
            logInfo.setOrgID(orgId);
        } else {
            logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        }
        logInfo.setOpTime(TimeServiceHelper.now());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName(opName);
        logInfo.setOpDescription(msg);
        return logInfo;
    }

    protected AppLogInfo buildOpLogAppInfo(String appId, String entityNumber, String opName, Long orgId, String msg, String opKey, MultiLangEnumBridge opNameBridge) {
        log.debug(opName + "\uff1a" + msg);
        AppLogInfo appLogInfo = this.buildLogInfo(appId, entityNumber, opName, orgId, msg);
        if (appLogInfo instanceof OpLogAppInfo) {
            OpLogAppInfo opLogAppInfo = (OpLogAppInfo)appLogInfo;
            if (opNameBridge != null) {
                opLogAppInfo.setOpName(opKey, opNameBridge);
            }
            String traceId = RequestContext.get().getTraceId();
            MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("traceid=%s", "ConvertEngine_23", BOS_MSERVICE_BOTP);
            opLogAppInfo.setOpDesc(opDescBridge, new String[]{traceId});
            return opLogAppInfo;
        }
        return appLogInfo;
    }

    @Deprecated
    protected AppLogInfo buildLogInfo(String appId, String entityNumber, Long orgId, String msg) {
        String opName = ResManager.loadKDString((String)"\u4e0b\u63a8", (String)"ConvertEngine_6", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]);
        return this.buildLogInfo(appId, entityNumber, opName, orgId, msg);
    }

    private String buildOpDescription(boolean success, SourceBillReport billReport) {
        if (!success && billReport.isFullSuccess()) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)billReport.getRuleName())) {
            return billReport.toString();
        }
        return String.format("%s; %s(%s)", billReport.toString(), billReport.getRuleName(), billReport.getRuleId());
    }

    private String getAppId(String entityNumber) {
        String appNumber;
        String appId = "";
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String string = appNumber = mainType == null ? "" : mainType.getBizAppNumber();
        if (StringUtils.isNotBlank((CharSequence)appNumber)) {
            try {
                AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
                if (null != appInfo) {
                    appId = appInfo.getId();
                }
            }
            catch (KDException e) {
                log.error((Throwable)e);
            }
        }
        return appId;
    }

    private String getEntityName(String entityNumber) {
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return entityNumber;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (mainType.getDisplayName() == null) {
            return entityNumber;
        }
        return mainType.getDisplayName().toString();
    }
}

