/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logging.LogTags;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.log.AddNewLog;
import kd.bos.service.botp.convert.log.CompleteLog;
import kd.bos.service.botp.convert.log.ConvertLink;
import kd.bos.service.botp.convert.log.ConvertLogMessage;
import kd.bos.service.botp.convert.log.UpdateTargetLog;

public class ConvertLogger {
    private static final String MESSAGE_QUEUE_NAME = "kd.bos.botp.convertlog";
    private static Log log = LogFactory.getLog(ConvertLogger.class);
    private ConvertLogMessage convertLogMessage;

    public void info(String message) {
        log.info(message);
    }

    public void warn(String message) {
        log.warn(message);
    }

    public void error(String message) {
        log.error(message);
    }

    public void error(Throwable exp) {
        log.error(exp);
    }

    public void info(LogTags tag, String message) {
        log.info(tag, message);
    }

    public void warn(LogTags tag, String message) {
        log.warn(tag, message);
    }

    public void error(LogTags tag, String message) {
        log.error(tag, message);
    }

    public void error(LogTags tag, Throwable exp) {
        log.error(tag, exp);
    }

    public void addConvertHistory(SingleRuleContext ruleContext, ExtendedDataEntity[] extendedDataEntities) {
        try {
            ConvertLogMessage message = this.getConvertMessage();
            AddNewLog addNew = new AddNewLog();
            addNew.setTaskId(ruleContext.getContext().getTaskId());
            addNew.setRuleId(ruleContext.getRule().getId());
            addNew.setRuleName(ruleContext.getRule().getName());
            addNew.setOpInfo(ruleContext.getContext().getInputArgs().getOpInfo());
            addNew.setSentityNumber(ruleContext.getContext().getSourceMainType().getName());
            addNew.setTentityNumber(ruleContext.getContext().getTargetMainType().getName());
            addNew.setStartTime(new Date());
            addNew.setTraceId(RequestContext.get().getTraceId());
            message.setAddNew(addNew);
            Set<ConvertLink> batchLinks = addNew.getConvertLinks();
            for (ExtendedDataEntity extendedData : extendedDataEntities) {
                List convertSource = (List)extendedData.getValue("ConvertSource");
                if (convertSource == null || convertSource.isEmpty()) continue;
                for (DynamicObject source : convertSource) {
                    ConvertLink link = new ConvertLink();
                    link.setSbillid((Long)source.get("id"));
                    link.setSbillno(this.getBillno(ruleContext.getContext().getSourceMainType(), source));
                    batchLinks.add(link);
                }
            }
        }
        catch (Exception ex) {
            log.error("\u65b0\u589e\u8f6c\u6362\u89c4\u5219\u65e5\u5fd7\u5f02\u5e38\uff01", (Throwable)ex);
        }
    }

    public void updateConvertTargetInfo(ConvertContext context, ExtendedDataEntity[] extendedDataEntities) {
        try {
            ConvertLogMessage message = this.getConvertMessage();
            UpdateTargetLog update = new UpdateTargetLog();
            update.setTaskId(context.getTaskId());
            update.setSnapshotFileUrl(String.join((CharSequence)";", context.getSnapshotFileUrls()));
            message.setUpdateTargetInfo(update);
            Set<ConvertLink> batchLinks = update.getConvertLinks();
            for (ExtendedDataEntity extendedData : extendedDataEntities) {
                List convertSource = (List)extendedData.getValue("ConvertSource");
                if (convertSource == null || convertSource.isEmpty()) continue;
                Object tbillid = extendedData.getBillPkId();
                for (DynamicObject source : convertSource) {
                    ConvertLink link = new ConvertLink();
                    link.setTbillid((Long)tbillid);
                    link.setTbillno(this.getBillno((BillEntityType)extendedData.getDataEntity().getDataEntityType(), extendedData.getDataEntity()));
                    link.setSbillid((Long)source.get("id"));
                    link.setSbillno(this.getBillno(context.getSourceMainType(), source));
                    batchLinks.add(link);
                }
            }
        }
        catch (Exception ex) {
            log.error("\u66f4\u65b0\u8f6c\u6362\u89c4\u5219\u65e5\u5fd7\u7684\u76ee\u6807\u5355\u4fe1\u606f\u5f02\u5e38\uff01", (Throwable)ex);
        }
    }

    private ConvertLogMessage getConvertMessage() {
        if (this.convertLogMessage == null) {
            this.convertLogMessage = new ConvertLogMessage();
        }
        return this.convertLogMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeConvertHistory(ConvertContext context, Collection<Object> targetBillIds, boolean success) {
        MessagePublisher pub = MQFactory.get().createSimplePublisher("bos", MESSAGE_QUEUE_NAME);
        try {
            ConvertLogMessage message = this.getConvertMessage();
            CompleteLog complete = new CompleteLog(success);
            complete.setTaskId(context.getTaskId());
            complete.setEndTime(new Date());
            message.setComplete(complete);
            Set<Long> batchTargetIds = complete.getSuccessTargetBillIds();
            for (Object targetBillId : targetBillIds) {
                batchTargetIds.add((Long)targetBillId);
            }
            complete.setComplete(true);
            pub.publish(SerializationUtils.toJsonString((Object)message));
        }
        catch (Exception ex) {
            log.error("\u66f4\u65b0\u8f6c\u6362\u89c4\u5219\u65e5\u5fd7\u7684\u72b6\u6001\u4fe1\u606f\u5f02\u5e38\uff01", (Throwable)ex);
        }
        finally {
            pub.close();
            this.convertLogMessage = null;
        }
    }

    private String getBillno(BillEntityType mainType, DynamicObject obj) {
        String billnoKey = mainType.getBillNo();
        if (StringUtils.isNotBlank((CharSequence)billnoKey)) {
            return obj.getString(billnoKey);
        }
        return "";
    }
}

