/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.convert;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.PkSnapshot;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class SingleRuleResultManager {
    private ConvertResultManager convertResultManager;
    private ExtendedDataEntitySet targetExtendedDataEntities;
    private boolean skipNextAction = false;
    private Set<Object> targetBillIds = new HashSet<Object>(0);
    private Set<Object> failBillIds = new HashSet<Object>(0);
    private Map<Object, String> targetBillHeads = new HashMap<Object, String>(0);
    private DataEntitySerializerOption serializerOption;
    private IRefrencedataProvider refrencedataProvider;

    public ConvertResultManager getConvertResultManager() {
        return this.convertResultManager;
    }

    public void setConvertResultManager(ConvertResultManager convertResultManager) {
        this.convertResultManager = convertResultManager;
    }

    public ExtendedDataEntitySet getTargetExtendedDataEntities() {
        return this.targetExtendedDataEntities;
    }

    public void setTargetExtendedDataEntities(ExtendedDataEntitySet targetExtendedDataEntities) {
        this.targetExtendedDataEntities = targetExtendedDataEntities;
    }

    public boolean isSkipNextAction() {
        return this.skipNextAction;
    }

    public void setSkipNextAction(boolean skipNextAction) {
        this.skipNextAction = skipNextAction;
    }

    public Set<Object> getTargetBillIds() {
        return this.targetBillIds;
    }

    public void addTargetBillIds(Object[] billIds) {
        Collections.addAll(this.targetBillIds, billIds);
    }

    public synchronized Set<Object> getFailBillIds() {
        return this.failBillIds;
    }

    public synchronized boolean isFail(Object billId) {
        return this.failBillIds.contains(billId);
    }

    public synchronized void addFailBillIds(Object[] billIds) {
        Collections.addAll(this.failBillIds, billIds);
    }

    public synchronized void putTargetBillHeads(DynamicObject[] objs) {
        for (DynamicObject obj : objs) {
            this.clearEntryPKSnapshot(obj);
            String str = this.serDynamicObject(obj);
            this.targetBillHeads.put(obj.getPkValue(), str);
        }
    }

    public boolean isTargetBillSaved(Object pkId) {
        return this.targetBillHeads.containsKey(pkId);
    }

    public synchronized DynamicObject getTargetBillHead(BillEntityType mainType, Object billId) {
        String str = this.targetBillHeads.get(billId);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        DynamicObject obj = this.deserDynamicObject(mainType, str);
        this.getRefrencedataProvider().fillReferenceData(new Object[]{obj}, (IDataEntityType)mainType);
        return obj;
    }

    private void clearEntryPKSnapshot(DynamicObject billObj) {
        String headTable_L;
        String headTable = billObj.getDataEntityType().getAlias();
        String string = headTable_L = StringUtils.isNotBlank((CharSequence)headTable) ? headTable + "_L" : "";
        if (billObj.getDataEntityState().getPkSnapshotSet() != null && billObj.getDataEntityState().getPkSnapshotSet().Snapshots != null) {
            int snapshotCount = billObj.getDataEntityState().getPkSnapshotSet().Snapshots.size();
            for (int i = snapshotCount - 1; i >= 0; --i) {
                PkSnapshot snapshot = (PkSnapshot)billObj.getDataEntityState().getPkSnapshotSet().Snapshots.get(i);
                if (StringUtils.equalsIgnoreCase((CharSequence)snapshot.TableName, (CharSequence)headTable) || StringUtils.equalsIgnoreCase((CharSequence)snapshot.TableName, (CharSequence)headTable_L)) continue;
                snapshot.Oids = null;
            }
        }
    }

    private String serDynamicObject(DynamicObject obj) {
        return DataEntitySerializer.serializerToString((Object)obj, (DataEntitySerializerOption)this.getSerializerOption());
    }

    private DynamicObject deserDynamicObject(BillEntityType mainType, String str) {
        return (DynamicObject)DataEntitySerializer.deSerializerFromString((String)str, (IDataEntityType)mainType);
    }

    private DataEntitySerializerOption getSerializerOption() {
        if (this.serializerOption == null) {
            this.serializerOption = new DataEntitySerializerOption();
            this.serializerOption.setIncludeDataEntityState(true);
            this.serializerOption.setIncludeComplexProperty(false);
            this.serializerOption.setIncludeCollectionProperty(false);
            this.serializerOption.setIncludeType(false);
        }
        return this.serializerOption;
    }

    private IRefrencedataProvider getRefrencedataProvider() {
        if (this.refrencedataProvider == null) {
            this.refrencedataProvider = new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                    BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
                }
            };
        }
        return this.refrencedataProvider;
    }
}

